<?php
class AdminController {
    public function index() {
        if (empty($_SESSION['admin']['logged_in'])) {
            header('Location: /admin/login');
            exit;
        }
        renderAdmin('admin_dashboard', []);
    }

    public function login() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            $db = DatabaseConnect::getInstance()->getConnection();
            $stmt = $db->prepare("SELECT value FROM settings WHERE name = 'admin_username'");
            $stmt->execute();
            $adminUser = $stmt->fetchColumn();
            $stmt = $db->prepare("SELECT value FROM settings WHERE name = 'admin_password'");
            $stmt->execute();
            $adminPassHash = $stmt->fetchColumn();
            if ($username === $adminUser && password_verify($password, $adminPassHash)) {
                $_SESSION['admin']['logged_in'] = true;
                header('Location: /admin');
                exit;
            } else {
                $_SESSION['admin']['error'] = 'Invalid admin credentials!';
            }
        }
        // Pass error from admin session
        $error = !empty($_SESSION['admin']['error']) ? $_SESSION['admin']['error'] : '';
        if (isset($_SESSION['admin']['error'])) unset($_SESSION['admin']['error']);
        renderAdmin('admin_login', ['error' => $error]);
    }

    public function logout() {
        unset($_SESSION['admin']);
        session_regenerate_id(true);
        header('Location: /admin/login');
        exit;
    }

    public function password() {
        if (empty($_SESSION['admin']['logged_in'])) {
            header('Location: /admin/login');
            exit;
        }
        $error = '';
        $success = '';
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $current = $_POST['current_password'] ?? '';
            $new = $_POST['new_password'] ?? '';
            $confirm = $_POST['confirm_password'] ?? '';
            $db = DatabaseConnect::getInstance()->getConnection();
            $stmt = $db->prepare("SELECT value FROM settings WHERE name = 'admin_password'");
            $stmt->execute();
            $adminPassHash = $stmt->fetchColumn();
            if (!password_verify($current, $adminPassHash)) {
                $error = 'Current password is incorrect!';
            } elseif (strlen($new) < 6) {
                $error = 'New password must be at least 6 characters!';
            } elseif ($new !== $confirm) {
                $error = 'New passwords do not match!';
            } else {
                $newHash = password_hash($new, PASSWORD_DEFAULT);
                $stmt = $db->prepare("UPDATE settings SET value = ? WHERE name = 'admin_password'");
                $stmt->execute([$newHash]);
                $success = 'Password changed successfully!';
            }
        }
        renderAdmin('admin_password', ['error' => $error, 'success' => $success]);
    }

    public function faucetSettings() {
        if (empty($_SESSION['admin']['logged_in'])) {
            header('Location: /admin/login');
            exit;
        }
        $config = new ConfigModel();
        $error = '';
        $success = '';
        $ghz = $config->get('faucet_ghz_reward') ?: '0.01';
        $duration = $config->get('faucet_duration_minutes') ?: '10';
        $cooldown = $config->get('faucet_cooldown_seconds') ?: '5';
        $banner1 = $config->get('faucet_banner_1') ?: '';
        $banner2 = $config->get('faucet_banner_2') ?: '';
        $banner3 = $config->get('faucet_banner_3') ?: '';
        $banner4 = $config->get('faucet_banner_4') ?: '';
        $banner5 = $config->get('faucet_banner_5') ?: '';

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $ghz = $_POST['ghz_reward'] ?? $ghz;
            $duration = $_POST['duration_minutes'] ?? $duration;
            $cooldown = $_POST['cooldown_seconds'] ?? $cooldown;
            $banner1 = $_POST['faucet_banner_1'] ?? $banner1;
            $banner2 = $_POST['faucet_banner_2'] ?? $banner2;
            $banner3 = $_POST['faucet_banner_3'] ?? $banner3;
            $banner4 = $_POST['faucet_banner_4'] ?? $banner4;
            $banner5 = $_POST['faucet_banner_5'] ?? $banner5;
            if (!is_numeric($ghz) || $ghz <= 0) {
                $error = 'Invalid GHZ reward!';
            } elseif (!is_numeric($duration) || $duration <= 0) {
                $error = 'Invalid duration!';
            } elseif (!is_numeric($cooldown) || $cooldown < 1) {
                $error = 'Invalid cooldown!';
            } else {
                $config->set('faucet_ghz_reward', $ghz);
                $config->set('faucet_duration_minutes', $duration);
                $config->set('faucet_cooldown_seconds', $cooldown);
                $config->set('faucet_banner_1', $banner1);
                $config->set('faucet_banner_2', $banner2);
                $config->set('faucet_banner_3', $banner3);
                $config->set('faucet_banner_4', $banner4);
                $config->set('faucet_banner_5', $banner5);
                $success = 'Faucet settings updated!';
            }
        }
        renderAdmin('admin_faucet_settings', [
            'ghz' => $ghz,
            'duration' => $duration,
            'cooldown' => $cooldown,
            'banner1' => $banner1,
            'banner2' => $banner2,
            'banner3' => $banner3,
            'banner4' => $banner4,
            'banner5' => $banner5,
            'error' => $error,
            'success' => $success
        ]);
    }

    public function generalSettings() {
        if (empty($_SESSION['admin']['logged_in'])) {
            header('Location: /admin/login');
            exit;
        }
        $config = new ConfigModel();
        $error = '';
        $success = '';
        $rate = $config->get('mining_rate_per_ghz') ?: '0.000001';
        $dashboardBanner = $config->get('dashboard_banner_html') ?: '';
        $siteTitle = $config->get('site_title') ?: 'Cloud Mining Platform';
        $apiKey1 = $config->get('faucetpay_api_key_1') ?: '';
        $apiKey2 = $config->get('faucetpay_api_key_2') ?: '';
        $decimals = $config->get('currency_decimals') ?: 8;
        $selectedCurrency = $config->get('selected_currency');
        $currencies = ['BTC', 'DOGE', 'ETH', 'LTC', 'USDT'];
        sort($currencies, SORT_STRING | SORT_FLAG_CASE);

        // --- Rate limit settings ---
        $loginMaxAttempts = $config->get('login_rate_limit_max_attempts') ?: 5;
        $loginWindowSeconds = $config->get('login_rate_limit_window_seconds') ?: 300;
        $faucetMaxClaims = $config->get('faucet_claim_rate_limit_max_claims') ?: 5;
        $faucetWindowSeconds = $config->get('faucet_claim_rate_limit_window_seconds') ?: 300;

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $siteTitle = $_POST['site_title'] ?? $siteTitle;
            $rate = $_POST['mining_rate'] ?? $rate;
            $dashboardBanner = $_POST['dashboard_banner_html'] ?? $dashboardBanner;
            $apiKey1 = $_POST['faucetpay_api_key_1'] ?? $apiKey1;
            $apiKey2 = $_POST['faucetpay_api_key_2'] ?? $apiKey2;
            $decimals = isset($_POST['currency_decimals']) ? (int)$_POST['currency_decimals'] : $decimals;
            $selectedCurrency = $_POST['selected_currency'] ?? $selectedCurrency;
            $loginMaxAttempts = isset($_POST['login_rate_limit_max_attempts']) ? (int)$_POST['login_rate_limit_max_attempts'] : $loginMaxAttempts;
            $loginWindowSeconds = isset($_POST['login_rate_limit_window_seconds']) ? (int)$_POST['login_rate_limit_window_seconds'] : $loginWindowSeconds;
            $faucetMaxClaims = isset($_POST['faucet_claim_rate_limit_max_claims']) ? (int)$_POST['faucet_claim_rate_limit_max_claims'] : $faucetMaxClaims;
            $faucetWindowSeconds = isset($_POST['faucet_claim_rate_limit_window_seconds']) ? (int)$_POST['faucet_claim_rate_limit_window_seconds'] : $faucetWindowSeconds;
            if (!in_array($selectedCurrency, $currencies)) {
                $error = 'Invalid currency selected!';
            } elseif (!in_array($decimals, [8,10,12])) {
                $error = 'Invalid decimals!';
            } elseif (!is_numeric($rate) || $rate <= 0) {
                $error = 'Invalid mining rate!';
            } elseif (empty($siteTitle)) {
                $error = 'Site title is required!';
            } elseif (empty($apiKey1) || empty($apiKey2)) {
                $error = 'Both FaucetPay API keys are required!';
            } elseif ($loginMaxAttempts < 1 || $loginWindowSeconds < 60 || $faucetMaxClaims < 1 || $faucetWindowSeconds < 60) {
                $error = 'Rate limit values are too low!';
            } else {
                $config->set('site_title', $siteTitle);
                $config->set('mining_rate_per_ghz', $rate);
                $config->set('dashboard_banner_html', $dashboardBanner);
                $config->set('faucetpay_api_key_1', $apiKey1);
                $config->set('faucetpay_api_key_2', $apiKey2);
                $config->set('currency_decimals', $decimals);
                // Save rate limit settings
                $config->set('login_rate_limit_max_attempts', $loginMaxAttempts);
                $config->set('login_rate_limit_window_seconds', $loginWindowSeconds);
                $config->set('faucet_claim_rate_limit_max_claims', $faucetMaxClaims);
                $config->set('faucet_claim_rate_limit_window_seconds', $faucetWindowSeconds);
                $success = 'General settings updated!';
            }
        }
        renderAdmin('admin_general_settings', [
            'rate' => $rate,
            'dashboardBanner' => $dashboardBanner,
            'siteTitle' => $siteTitle,
            'apiKey1' => $apiKey1,
            'apiKey2' => $apiKey2,
            'decimals' => $decimals,
            'selectedCurrency' => $selectedCurrency,
            'currencies' => $currencies,
            'loginMaxAttempts' => $loginMaxAttempts,
            'loginWindowSeconds' => $loginWindowSeconds,
            'faucetMaxClaims' => $faucetMaxClaims,
            'faucetWindowSeconds' => $faucetWindowSeconds,
            'error' => $error,
            'success' => $success
        ]);
    }

    public function currencySettings() {
        if (empty($_SESSION['admin']['logged_in'])) {
            header('Location: /admin/login');
            exit;
        }
        // Only currency codes, no icons
        $currencies = [
            'ADA', 'BCH', 'BNB', 'BTC', 'DASH', 'DGB', 'DOGE', 'ETH', 'FEY', 'FLT', 'LTC', 'PEPE',
            'POL', 'SOL', 'TARA', 'TON', 'TRON', 'TRUMP', 'USDC', 'USDT', 'XLM', 'XMR', 'XRP', 'ZEC'
        ];
        // The order above is already alphabetical (A-Z)
        $selectedCurrency = (new ConfigModel())->get('selected_currency');
        $success = '';
        $error = '';
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $cur = $_POST['currency'] ?? '';
            if (!in_array($cur, $currencies)) {
                $error = 'Invalid currency selected!';
            } else {
                (new ConfigModel())->set('selected_currency', $cur);
                $selectedCurrency = $cur;
                $success = 'Currency updated!';
            }
        }
        renderAdmin('admin_currency_settings', [
            'currencies' => $currencies,
            'selectedCurrency' => $selectedCurrency,
            'success' => $success,
            'error' => $error
        ]);
    }

    public function manualReklam() {
        if (empty($_SESSION['admin']['logged_in'])) {
            header('Location: /admin/login');
            exit;
        }
        $config = new ConfigModel();
        $db = DatabaseConnect::getInstance()->getConnection();
        $error = '';
        $success = '';
        $currencies = [
            'BTC', 'DOGE', 'ETH', 'LTC', 'USDT', 'BNB', 'TRX', 'XRP', 'BCH', 'DASH', 'XMR', 'ZEC', 'SOL', 'ADA'
        ];
        sort($currencies, SORT_STRING | SORT_FLAG_CASE);

        // Default values
        $apiKey = '';
        $amount = '';
        $currency = 'USDT';

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $apiKey = trim($_POST['reklam_api_key'] ?? '');
            $amount = trim($_POST['reklam_amount'] ?? '');
            $currency = $_POST['reklam_currency'] ?? 'USDT';

            if (!$apiKey) {
                $error = 'API key is required!';
            } elseif (!is_numeric($amount) || $amount <= 0) {
                $error = 'Invalid amount!';
            } elseif (!in_array($currency, $currencies)) {
                $error = 'Invalid currency!';
            } else {
                // Get all users where reklam_sent = 0
                $stmt = $db->prepare("SELECT id, email FROM users WHERE reklam_sent = 0");
                $stmt->execute();
                $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

                $sentCount = 0;
                foreach ($users as $user) {
                    // FaucetPay API call
                    $data = [
                        'api_key' => $apiKey,
                        'amount' => (int)round($amount * 100000000), // satoshi
                        'to' => $user['email'],
                        'currency' => $currency
                    ];
                    $opts = [
                        'http' => [
                            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
                            'method' => 'POST',
                            'content' => http_build_query($data),
                            'timeout' => 10
                        ]
                    ];
                    $context = stream_context_create($opts);
                    $result = @file_get_contents('https://faucetpay.io/api/v1/send', false, $context);

                    $ok = false;
                    if ($result !== false) {
                        $json = json_decode($result, true);
                        if (isset($json['status']) && $json['status'] == 200) {
                            $ok = true;
                        }
                    }
                    if ($ok) {
                        // Mark as sent
                        $upd = $db->prepare("UPDATE users SET reklam_sent = 1 WHERE id = ?");
                        $upd->execute([$user['id']]);
                        $sentCount++;
                    }
                    // (If not ok, skip marking, so admin can retry later)
                }
                $success = "Ad sent to {$sentCount} users.";
            }
        }

        // List users where reklam_sent = 0
        $stmt = $db->prepare("SELECT id, email, last_login_at, created_at FROM users WHERE reklam_sent = 0 ORDER BY id ASC");
        $stmt->execute();
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

        renderAdmin('admin_manual_reklam', [
            'error' => $error,
            'success' => $success,
            'apiKey' => $apiKey,
            'amount' => $amount,
            'currency' => $currency,
            'currencies' => $currencies,
            'users' => $users
        ]);
    }

    public function bannedUsers() {
        if (empty($_SESSION['admin']['logged_in'])) {
            header('Location: /admin/login');
            exit;
        }
        $db = DatabaseConnect::getInstance()->getConnection();
        $banSuccess = '';
        $banError = '';
        // Unban action
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'], $_POST['user_id']) && $_POST['action'] === 'unban') {
            $userId = (int)$_POST['user_id'];
            $stmt = $db->prepare("UPDATE users SET banned = 0, banned_at = NULL WHERE id = ?");
            if ($stmt->execute([$userId])) {
                $banSuccess = 'User unbanned successfully.';
            } else {
                $banError = 'Failed to unban user.';
            }
        }
        $stmt = $db->prepare("SELECT id, email, last_ip, banned_at FROM users WHERE banned = 1 ORDER BY banned_at DESC");
        $stmt->execute();
        $bannedUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);
        renderAdmin('admin_banned_users', [
            'bannedUsers' => $bannedUsers,
            'banSuccess' => $banSuccess,
            'banError' => $banError
        ]);
    }

    public function userList() {
        if (empty($_SESSION['admin']['logged_in'])) {
            header('Location: /admin/login');
            exit;
        }
        $db = DatabaseConnect::getInstance()->getConnection();

        // Ban/unban logic
        $banSuccess = '';
        $banError = '';
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'], $_POST['user_id'])) {
            $userId = (int)$_POST['user_id'];
            if ($_POST['action'] === 'ban') {
                $stmt = $db->prepare("UPDATE users SET banned = 1, banned_at = NOW() WHERE id = ?");
                if ($stmt->execute([$userId])) {
                    $banSuccess = 'User banned successfully.';
                } else {
                    $banError = 'Failed to ban user.';
                }
            } elseif ($_POST['action'] === 'unban') {
                $stmt = $db->prepare("UPDATE users SET banned = 0, banned_at = NULL WHERE id = ?");
                if ($stmt->execute([$userId])) {
                    $banSuccess = 'User unbanned successfully.';
                } else {
                    $banError = 'Failed to unban user.';
                }
            }
        }

        // Search/filter
        $search = trim($_GET['search'] ?? '');
        $page = max(1, (int)($_GET['page'] ?? 1));
        $perPage = 50;
        $params = [];
        $where = [];
        if ($search !== '') {
            $where[] = '(email LIKE :search OR last_ip LIKE :search)';
            $params[':search'] = '%' . $search . '%';
        }
        $whereSql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

        // Count total
        $stmt = $db->prepare("SELECT COUNT(*) FROM users $whereSql");
        $stmt->execute($params);
        $total = (int)$stmt->fetchColumn();
        $pages = max(1, ceil($total / $perPage));
        $offset = ($page - 1) * $perPage;

        // Fetch users
        $sql = "SELECT * FROM users $whereSql ORDER BY id DESC LIMIT :limit OFFSET :offset";
        $stmt = $db->prepare($sql);
        foreach ($params as $k => $v) $stmt->bindValue($k, $v);
        $stmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
        $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
        $stmt->execute();
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Deletion logic
        $deleteId = isset($_GET['delete']) ? (int)$_GET['delete'] : null;
        $confirmDelete = isset($_POST['confirm_delete']) ? (int)$_POST['confirm_delete'] : null;
        $deleted = false;
        $deleteError = '';
        $deleteSuccess = '';
        if ($confirmDelete && $_SERVER['REQUEST_METHOD'] === 'POST') {
            try {
                $db->beginTransaction();
                // Delete from faucet_claims
                $stmt = $db->prepare("DELETE FROM faucet_claims WHERE user_id = ?");
                $stmt->execute([$confirmDelete]);
                // Delete from payout_history
                $stmt = $db->prepare("DELETE FROM payout_history WHERE user_id = ?");
                $stmt->execute([$confirmDelete]);
                // Delete from referral_earnings (as referrer)
                $stmt = $db->prepare("DELETE FROM referral_earnings WHERE user_id = ?");
                $stmt->execute([$confirmDelete]);
                // Delete from referral_earnings (as referred)
                $stmt = $db->prepare("DELETE FROM referral_earnings WHERE from_user_id = ?");
                $stmt->execute([$confirmDelete]);
                // Finally, delete user
                $stmt = $db->prepare("DELETE FROM users WHERE id = ?");
                $deleted = $stmt->execute([$confirmDelete]);
                if ($deleted) {
                    $db->commit();
                    $deleteSuccess = 'User deleted successfully.';
                } else {
                    $db->rollBack();
                    $deleteError = 'Delete failed: user not found or could not be deleted.';
                }
            } catch (Exception $e) {
                $db->rollBack();
                $deleteError = 'Delete failed: ' . $e->getMessage();
            }
            // After delete, redirect to avoid resubmission, pass result as GET param
            $redirectUrl = '/admin/user-list?search=' . urlencode($search) . '&page=' . $page;
            if ($deleteSuccess) $redirectUrl .= '&delete_success=1';
            if ($deleteError) $redirectUrl .= '&delete_error=' . urlencode($deleteError);
            header('Location: ' . $redirectUrl);
            exit;
        }

        // Show delete result message if redirected
        if (isset($_GET['delete_success'])) {
            $deleteSuccess = 'User deleted successfully.';
        }
        if (isset($_GET['delete_error'])) {
            $deleteError = $_GET['delete_error'];
        }

        renderAdmin('admin_user_list', [
            'users' => $users,
            'total' => $total,
            'page' => $page,
            'pages' => $pages,
            'search' => $search,
            'deleteId' => $deleteId,
            'deleteError' => $deleteError,
            'deleteSuccess' => $deleteSuccess,
            'banSuccess' => $banSuccess,
            'banError' => $banError
        ]);
    }

    public function duplicateIpUsers() {
        if (empty($_SESSION['admin']['logged_in'])) {
            header('Location: /admin/login');
            exit;
        }
        $db = DatabaseConnect::getInstance()->getConnection();
        
        // Remove bannedUsers logic from here!

        // Find IPs used by more than one user
        $stmt = $db->query("
            SELECT last_ip, COUNT(*) as cnt
            FROM users
            WHERE last_ip IS NOT NULL AND last_ip != ''
            GROUP BY last_ip
            HAVING cnt > 1
            ORDER BY cnt DESC
        ");
        $ips = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $usersByIp = [];
        foreach ($ips as $row) {
            $ip = $row['last_ip'];
            $stmt2 = $db->prepare("SELECT id, email, last_login_at, created_at, last_ip, banned FROM users WHERE last_ip = ? ORDER BY last_login_at DESC");
            $stmt2->execute([$ip]);
            $usersByIp[$ip] = $stmt2->fetchAll(PDO::FETCH_ASSOC);
        }

        renderAdmin('admin_duplicate_ip_users', [
            'usersByIp' => $usersByIp
        ]);
    }
}
