<?php
class FaucetController {
    public function index() {
        if (!isset($_SESSION['user_id'])) {
            header('Location: /');
            exit;
        }
        $config = new ConfigModel();
        $ghz = $config->get('faucet_ghz_reward') ?: '0.01';
        $minutes = $config->get('faucet_duration_minutes') ?: '10';
        $rate = $config->get('mining_rate_per_ghz') ?: '0.000001';
        $cooldown = $config->get('faucet_cooldown_seconds') ?: '5';
        $siteTitle = $config->get('site_title') ?: 'Cloud Mining Platform';
        $currency = $config->get('selected_currency');
        $banner1 = $config->get('faucet_banner_1') ?: '';
        $banner2 = $config->get('faucet_banner_2') ?: '';
        $banner3 = $config->get('faucet_banner_3') ?: '';
        $banner4 = $config->get('faucet_banner_4') ?: '';
        $banner5 = $config->get('faucet_banner_5') ?: '';

        renderUser('faucet', [
            'ghz' => $ghz,
            'minutes' => $minutes,
            'rate' => $rate,
            'cooldown' => $cooldown,
            'siteTitle' => $siteTitle,
            'currency' => $currency,
            'banner1' => $banner1,
            'banner2' => $banner2,
            'banner3' => $banner3,
            'banner4' => $banner4,
            'banner5' => $banner5
        ]);
    }
    public function claim() {
        if (!isset($_SESSION['user_id'])) {
            header('Location: /');
            exit;
        }
        // --- Rate limiting: configurable via settings ---
        $config = new ConfigModel();
        $maxClaims = (int)($config->get('faucet_claim_rate_limit_max_claims') ?: 5);
        $windowSeconds = (int)($config->get('faucet_claim_rate_limit_window_seconds') ?: 300);
        $userId = $_SESSION['user_id'];
        $now = time();
        if (!isset($_SESSION['faucet_claim_rate_limit'])) {
            $_SESSION['faucet_claim_rate_limit'] = [];
        }
        // Clean up old attempts
        $_SESSION['faucet_claim_rate_limit'] = array_filter(
            $_SESSION['faucet_claim_rate_limit'],
            function($entry) use ($now, $windowSeconds) { return $entry['ts'] > $now - $windowSeconds; }
        );
        // Count attempts from this user
        $attempts = 0;
        foreach ($_SESSION['faucet_claim_rate_limit'] as $entry) {
            if ($entry['user_id'] === $userId) $attempts++;
        }
        if ($attempts >= $maxClaims) {
            $_SESSION['error'] = 'Too many faucet claims. Please wait ' . floor($windowSeconds/60) . ' minutes and try again.';
            header('Location: /faucet');
            exit;
        }
        $_SESSION['faucet_claim_rate_limit'][] = ['user_id' => $userId, 'ts' => $now];
        // Adblock check (server-side fallback)
        if (!empty($_POST['adblock_detected']) && $_POST['adblock_detected'] === '1') {
            $_SESSION['error'] = 'Please disable your adblocker to claim the faucet!';
            header('Location: /faucet');
            exit;
        }
        // CAPTCHA check
        if (
            !isset($_POST['captcha_answer']) ||
            !isset($_SESSION['faucet_captcha']) ||
            (int)$_POST['captcha_answer'] !== (int)$_SESSION['faucet_captcha']
        ) {
            $_SESSION['error'] = 'Incorrect anti-bot answer!';
            header('Location: /faucet');
            exit;
        }
        unset($_SESSION['faucet_captcha']);
        $userModel = new UserModel();
        $userId = $_SESSION['user_id'];
        $config = new ConfigModel();
        $ghz = $config->get('faucet_ghz_reward') ?: '0.01';
        $minutes = $config->get('faucet_duration_minutes') ?: '10';
        $userModel->addFaucetClaim($userId, $ghz, $minutes);
        $_SESSION['success'] = 'Faucet claimed! +' . number_format($ghz, 4) . ' GHZ for ' . (int)$minutes . ' minutes.';
        header('Location: /faucet');
        exit;
    }
}
