<?php
class HomeController {
    public function index() {
        if (isset($_SESSION['user_id'])) {
            header('Location: /dashboard');
            exit;
        }
        $userModel = new UserModel();
        $stats = [
            'users' => $userModel->getTotalUserCount(),
            'deposit' => 0, // No deposit table
            'withdrawn' => $userModel->getTotalWithdrawn()
        ];
        // Get last 10 payouts
        $db = DatabaseConnect::getInstance()->getConnection();
        $stmt = $db->prepare("SELECT p.amount_usdt, u.email, p.created_at FROM payout_history p JOIN users u ON p.user_id = u.id WHERE p.status = 'success' ORDER BY p.id DESC LIMIT 10");
        $stmt->execute();
        $lastPayouts = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $config = new ConfigModel();
        $siteTitle = $config->get('site_title') ?: 'Cloud Mining Platform';
        $currency = $config->get('selected_currency');

        renderPublic('home', [
            'stats' => $stats,
            'lastPayouts' => $lastPayouts,
            'siteTitle' => $siteTitle,
            'currency' => $currency
        ]);
    }
}
