<?php
class ConfigModel {
    private $db;
    public function __construct() {
        $this->db = DatabaseConnect::getInstance()->getConnection();
    }
    public function get($name) {
        $stmt = $this->db->prepare("SELECT value FROM settings WHERE name = ?");
        $stmt->execute([$name]);
        return $stmt->fetchColumn();
    }
    public function set($name, $value) {
        // Only update, do not insert if not exists
        $stmt = $this->db->prepare("UPDATE settings SET value = ? WHERE name = ?");
        $stmt->execute([$value, $name]);
        return $stmt->rowCount() > 0;
    }
}
