<?php
class Router {
    private $routes = [];
    public function add($method, $path, $handler) {
        $this->routes[] = ['method' => $method, 'path' => $path, 'handler' => $handler];
    }
    public function dispatch() {
        $method = $_SERVER['REQUEST_METHOD'];
        $path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        foreach ($this->routes as $route) {
            if ($route['method'] === $method && $route['path'] === $path) {
                list($controller, $action) = explode('@', $route['handler']);
                $controllerInstance = new $controller();
                return $controllerInstance->$action();
            }
        }
        // FaucetPay callback fallback (POST only)
        if ($method === 'POST' && $path === '/faucetpay-callback') {
            $controllerInstance = new FaucetPayController();
            return $controllerInstance->callback();
        }
        // Deposit init endpoint
        if ($method === 'POST' && $path === '/deposit-init') {
            $controllerInstance = new DepositController();
            return $controllerInstance->init();
        }
        // FaucetPay route
        if ($method === 'GET' && $path === '/faucetpay') {
            $controllerInstance = new FaucetPayController();
            return $controllerInstance->index();
        }
        // --- Admin routes ---
        if ($path === '/admin' && $method === 'GET') {
            $controllerInstance = new AdminController();
            return $controllerInstance->index();
        }
        if ($path === '/admin/login') {
            $controllerInstance = new AdminController();
            return $controllerInstance->login();
        }
        if ($path === '/admin/logout') {
            $controllerInstance = new AdminController();
            return $controllerInstance->logout();
        }
        if ($path === '/admin/password') {
            $controllerInstance = new AdminController();
            return $controllerInstance->password();
        }
        if ($path === '/admin/faucet-settings') {
            $controllerInstance = new AdminController();
            return $controllerInstance->faucetSettings();
        }
        if ($path === '/admin/general-settings') {
            $controllerInstance = new AdminController();
            return $controllerInstance->generalSettings();
        }
        if ($path === '/admin/currency-settings') {
            $controllerInstance = new AdminController();
            return $controllerInstance->currencySettings();
        }
        if ($path === '/admin/manual-reklam') {
            $controllerInstance = new AdminController();
            return $controllerInstance->manualReklam();
        }
        if ($path === '/admin/duplicate-ip-users') {
            $controllerInstance = new AdminController();
            return $controllerInstance->duplicateIpUsers();
        }
        if ($path === '/admin/user-list') {
            $controllerInstance = new AdminController();
            return $controllerInstance->userList();
        }
        if ($path === '/admin/banned-users') {
            $controllerInstance = new AdminController();
            return $controllerInstance->bannedUsers();
        }
        http_response_code(404);
        echo "Page not found";
    }
}
