<?php
function renderPublic($view, $data = []) {
    extract($data);
    require dirname(__DIR__) . '/views/' . $view . '.php';
}

function renderUser($view, $data = []) {
    extract($data);
    ob_start();
    require dirname(__DIR__) . '/views/user/' . $view . '.php';
    $content = ob_get_clean();
    require dirname(__DIR__) . '/views/user/header.php';
}

function renderAdmin($view, $data = []) {
    extract($data);
    ob_start();
    require dirname(__DIR__) . '/views/admin/' . $view . '.php';
    $content = ob_get_clean();
    require dirname(__DIR__) . '/views/admin/admin_header.php';
}

// Backward compatible main render function
function render($view, $data = []) {
    if ($view === 'home') {
        renderPublic($view, $data);
        return;
    }
    if (strpos($view, 'admin_') === 0) {
        renderAdmin($view, $data);
        return;
    }
    renderUser($view, $data);
}
