CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(255) NOT NULL UNIQUE,
    balance DECIMAL(18,8) NOT NULL DEFAULT 0,
    ghz DECIMAL(4,1) NOT NULL DEFAULT 0.1,
    mining_started_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    last_collected_at DATETIME NULL,
    last_login_at DATETIME NULL DEFAULT NULL,
    last_ip VARCHAR(64) DEFAULT NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    referral_code VARCHAR(16) UNIQUE DEFAULT NULL,
    referrer_id INT DEFAULT NULL,
    reklam_sent TINYINT(1) NOT NULL DEFAULT 0,
    banned TINYINT(1) DEFAULT 0,
    banned_at TIMESTAMP NULL DEFAULT NULL,
    FOREIGN KEY (referrer_id) REFERENCES users(id)
);

CREATE TABLE IF NOT EXISTS faucet_claims (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    ghz DECIMAL(6,4) NOT NULL DEFAULT 0.01,
    claimed_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    expires_at DATETIME NOT NULL,
    collected_usdt DECIMAL(18,12) NOT NULL DEFAULT 0,
    FOREIGN KEY (user_id) REFERENCES users(id)
);

CREATE TABLE IF NOT EXISTS payout_history (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    amount_usdt DECIMAL(18,8) NOT NULL,
    amount_satoshi BIGINT NOT NULL,
    status VARCHAR(32) NOT NULL,
    payout_id VARCHAR(64),
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id)
);

CREATE TABLE IF NOT EXISTS referral_earnings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,           -- Meghívó fél (referrer)
    from_user_id INT NOT NULL,      -- Meghívott (aki withdraw-olt)
    amount DECIMAL(18,8) NOT NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (from_user_id) REFERENCES users(id)
);

CREATE TABLE IF NOT EXISTS `settings` (
    `id` int(32) UNSIGNED NOT NULL AUTO_INCREMENT,
    `name` varchar(50) NOT NULL,
    `value` text NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

-- Add default settings
INSERT INTO `settings` (`id`, `name`, `value`) VALUES 
('1', 'admin_username', 'admin'),
('2', 'admin_password', '$2y$10$W9hvVqLady2ivV791Nz9zOeqvjASvUTYxlcA9kW25EROz1RgjVsai'),
('3', 'faucet_ghz_reward', '0.01'),
('4', 'faucet_duration_minutes', '10'),
('5', 'mining_rate_per_ghz', '0.000001'),
('6', 'faucet_cooldown_seconds', '5'),
('7', 'dashboard_banner_html', ''),
('8', 'site_title', 'CryptoMiner'),
('9', 'faucetpay_api_key_1', ''),
('10', 'faucetpay_api_key_2', ''),
('11', 'selected_currency', 'USDT'),
('12', 'currency_decimals', '8'),
('13', 'faucet_banner_1', ''),
('14', 'faucet_banner_2', ''),
('15', 'faucet_banner_3', ''),
('16', 'faucet_banner_4', ''),
('17', 'faucet_banner_5', ''),
('18', 'login_rate_limit_max_attempts', '5'),
('19', 'login_rate_limit_window_seconds', '300'),
('20', 'faucet_claim_rate_limit_max_claims', '5'),
('21', 'faucet_claim_rate_limit_window_seconds', '300');

