<?php
session_start();
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
require_once __DIR__ . '/../autoload.php';
require_once __DIR__ . '/../config/render.php';
require_once __DIR__ . '/../config/Router.php';
require_once __DIR__ . '/../config/DatabaseConnect.php';
require_once __DIR__ . '/../config/database.php';

$router = new Router();

$router->add('GET', '/', 'HomeController@index');
$router->add('POST', '/login', 'AuthController@login');
$router->add('POST', '/register', 'AuthController@register');
$router->add('GET', '/dashboard', 'DashboardController@index');
$router->add('POST', '/dashboard', 'DashboardController@index');
$router->add('GET', '/logout', 'AuthController@logout');
$router->add('GET', '/faucet', 'FaucetController@index');
$router->add('POST', '/faucet', 'FaucetController@claim');

$router->dispatch();
