<div class="container">
    <div class="panel" style="margin:60px auto; background:#23272f; border-radius:8px; padding:32px; box-shadow:0 0 16px #4fc3f733;">
        <div class="panel-title" style="color:#ff6b6b; font-family:'Orbitron',monospace; font-size:2em; margin-bottom:18px;">
            Banned Users
        </div>
        <?php if (!empty($banSuccess)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($banSuccess); ?></div>
        <?php endif; ?>
        <?php if (!empty($banError)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($banError); ?></div>
        <?php endif; ?>
        <table class="table table-bordered" style="background:#23272f;color:#e0e0e0;">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Email</th>
                    <th>Last IP</th>
                    <th>Banned At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($bannedUsers as $user): ?>
                    <tr style="background:#330000;">
                        <td><?php echo (int)$user['id']; ?></td>
                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                        <td><?php echo htmlspecialchars($user['last_ip']); ?></td>
                        <td><?php echo htmlspecialchars($user['banned_at']); ?></td>
                        <td>
                            <form method="POST" style="display:inline;">
                                <input type="hidden" name="action" value="unban">
                                <input type="hidden" name="user_id" value="<?php echo (int)$user['id']; ?>">
                                <button type="submit" class="btn btn-xs btn-success" onclick="return confirm('Unban this user?')">Unban</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($bannedUsers)): ?>
                    <tr><td colspan="5">No banned users.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
        <a href="/admin" class="btn btn-default btn-block" style="margin-top:8px;">Back to Dashboard</a>
    </div>
</div>
</body>
</html>
