<div class="container">
    <div class="panel" style="margin:60px auto; background:#23272f; border-radius:8px; padding:32px; box-shadow:0 0 16px #4fc3f733;">
        <div class="panel-title" style="color:#4fc3f7; font-family:'Orbitron',monospace; font-size:2em; margin-bottom:18px;">Currency Settings</div>
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        <form method="POST" autocomplete="off" id="currency-form">
            <div class="row" style="display:flex;justify-content:center;gap:18px;flex-wrap:wrap;">
                <?php
                $cardCount = 0;
                foreach ($currencies as $code):
                    $cardCount++;
                ?>
                    <div style="flex:0 0 120px;max-width:120px;margin-bottom:18px;">
                        <label style="width:120px;display:block;cursor:pointer;position:relative;">
                            <input type="radio" name="currency" value="<?php echo $code; ?>" style="position:absolute;opacity:0;width:120px;height:80px;left:0;top:0;z-index:2;cursor:pointer;"
                                <?php if ($selectedCurrency === $code) echo 'checked'; ?>>
                            <div style="
                                width:120px;height:80px;line-height:80px;
                                border:2px solid <?php echo $selectedCurrency === $code ? '#4fc3f7' : '#444'; ?>;
                                border-radius:18px;
                                background:#23272f;
                                color:#e0e0e0;
                                text-align:center;
                                box-shadow:0 0 8px #4fc3f733;
                                font-family:'Orbitron',monospace;
                                font-size:1.7em;
                                font-weight:<?php echo $selectedCurrency === $code ? 'bold' : 'normal'; ?>;
                                transition: border 0.2s;
                                user-select:none;
                                cursor:pointer;
                                position:relative;
                                z-index:1;
                                ">
                                <?php echo htmlspecialchars($code); ?>
                                <?php if ($selectedCurrency === $code): ?>
                                    <span style="display:block;margin-top:-65px;color:#4fc3f7;font-size:1.2em;"><span class="glyphicon glyphicon-ok"></span></span>
                                <?php endif; ?>
                            </div>
                        </label>
                    </div>
                    <?php if ($cardCount % 8 === 0): ?>
                        </div><div class="row" style="display:flex;justify-content:center;gap:18px;flex-wrap:wrap;">
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
            <button type="submit" class="btn btn-warning btn-block" style="background:linear-gradient(90deg,#ffb700 0%,#00bfff 100%); border:none; color:#20232a; font-weight:bold;margin-top:24px;">Save Currency</button>
            <a href="/admin" class="btn btn-default btn-block" style="margin-top:8px;">Back to Dashboard</a>
        </form>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Highlight selected card on click
    var radios = document.querySelectorAll('input[type=radio][name=currency]');
    radios.forEach(function(radio) {
        radio.addEventListener('change', function() {
            radios.forEach(function(r) {
                r.parentElement.querySelector('div').style.border = '2px solid #444';
                r.parentElement.querySelector('div').style.fontWeight = 'normal';
                var ok = r.parentElement.querySelector('.glyphicon-ok');
                if (ok) ok.parentElement.style.display = 'none';
            });
            var div = this.parentElement.querySelector('div');
            div.style.border = '2px solid #4fc3f7';
            div.style.fontWeight = 'bold';
            var ok = div.querySelector('.glyphicon-ok');
            if (ok) ok.parentElement.style.display = 'block';
        });
    });
});
</script>
