<div class="container">
    <div class="panel" style="margin:60px auto; background:#23272f; border-radius:8px; padding:32px; box-shadow:0 0 16px #4fc3f733;">
        <div class="panel-title" style="color:#4fc3f7; font-family:'Orbitron',monospace; font-size:2em; margin-bottom:18px;">
            Users with Duplicate IP Addresses
        </div>
        
        <?php if (!empty($banSuccess)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($banSuccess); ?></div>
        <?php endif; ?>
        <?php if (!empty($banError)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($banError); ?></div>
        <?php endif; ?>

        <!-- Duplicate IP Users Section -->
        <?php if (empty($usersByIp)): ?>
            <div class="alert alert-success">No duplicate IPs found.</div>
        <?php else: ?>
            <?php foreach ($usersByIp as $ip => $users): ?>
                <div style="margin-bottom:24px;">
                    <div style="color:#00bfff;font-size:1.1em;margin-bottom:6px;">
                        <b>IP:</b> <?php echo htmlspecialchars($ip); ?> &mdash; <b><?php echo count($users); ?> users</b>
                    </div>
                    <table class="table table-bordered" style="background:#23272f;color:#e0e0e0;">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Email</th>
                                <th>Last Login</th>
                                <th>Registered</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                                <tr<?php if (!empty($user['banned'])) echo ' style="background:#330000;"'; ?>>
                                    <td><?php echo (int)$user['id']; ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td><?php echo htmlspecialchars($user['last_login_at']); ?></td>
                                    <td><?php echo htmlspecialchars($user['created_at']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
        <a href="/admin" class="btn btn-default btn-block" style="margin-top:8px;">Back to Dashboard</a>
    </div>
</div>
</body>
</html>
        <!-- Duplicate IP Users Section -->
        <?php if (empty($usersByIp)): ?>
            <div class="alert alert-success">No duplicate IPs found.</div>
        <?php else: ?>
            <?php foreach ($usersByIp as $ip => $users): ?>
                <div style="margin-bottom:24px;">
                    <div style="color:#00bfff;font-size:1.1em;margin-bottom:6px;">
                        <b>IP:</b> <?php echo htmlspecialchars($ip); ?> &mdash; <b><?php echo count($users); ?> users</b>
                    </div>
                    <table class="table table-bordered" style="background:#23272f;color:#e0e0e0;">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Email</th>
                                <th>Last Login</th>
                                <th>Registered</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                                <tr <?php if ($user['banned']) echo 'style="background:#330000;"'; ?>>
                                    <td><?php echo (int)$user['id']; ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td><?php echo htmlspecialchars($user['last_login_at']); ?></td>
                                    <td><?php echo htmlspecialchars($user['created_at']); ?></td>
                                    <td>
                                        <?php if ($user['banned']): ?>
                                            <span style="color:#ff6b6b;font-weight:bold;">BANNED</span>
                                        <?php else: ?>
                                            <span style="color:#4fc3f7;">Active</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($user['banned']): ?>
                                            <form method="POST" style="display:inline;">
                                                <input type="hidden" name="action" value="unban">
                                                <input type="hidden" name="user_id" value="<?php echo (int)$user['id']; ?>">
                                                <button type="submit" class="btn btn-xs btn-success" onclick="return confirm('Unban this user?')">Unban</button>
                                            </form>
                                        <?php else: ?>
                                            <form method="POST" style="display:inline;">
                                                <input type="hidden" name="action" value="ban">
                                                <input type="hidden" name="user_id" value="<?php echo (int)$user['id']; ?>">
                                                <button type="submit" class="btn btn-xs btn-danger" onclick="return confirm('Ban this user?')">Ban</button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
        <a href="/admin" class="btn btn-default btn-block" style="margin-top:8px;">Back to Dashboard</a>
    </div>
</div>
</body>
</html>
