<div class="container">
<div class="panel" style="margin:60px auto; background:#23272f; border-radius:8px; padding:32px; box-shadow:0 0 16px #00ff9933;">
    <div class="panel-title">Faucet Settings</div>
    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php endif; ?>
    <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    <form method="POST" autocomplete="off">
        <div class="form-group">
            <label>GHZ Reward per Claim:</label>
            <input type="number" step="0.0001" name="ghz_reward" class="form-control" required value="<?php echo htmlspecialchars($ghz); ?>">
        </div>
        <div class="form-group">
            <label>GHZ Duration (minutes):</label>
            <input type="number" step="1" name="duration_minutes" class="form-control" required value="<?php echo htmlspecialchars($duration); ?>">
        </div>
        <div class="form-group">
            <label>Cooldown (seconds):</label>
            <input type="number" step="1" min="1" name="cooldown_seconds" class="form-control" required value="<?php echo htmlspecialchars($cooldown); ?>">
        </div>
        <div class="form-group">
            <label>Faucet Banner 1 (top left 300x250, HTML):</label>
            <textarea name="faucet_banner_1" class="form-control" rows="4"><?php echo htmlspecialchars($banner1 ?? ''); ?></textarea>
        </div>
        <div class="form-group">
            <label>Faucet Banner 2 (top center 300x250, HTML):</label>
            <textarea name="faucet_banner_2" class="form-control" rows="4"><?php echo htmlspecialchars($banner2 ?? ''); ?></textarea>
        </div>
        <div class="form-group">
            <label>Faucet Banner 3 (top right 300x250, HTML):</label>
            <textarea name="faucet_banner_3" class="form-control" rows="4"><?php echo htmlspecialchars($banner3 ?? ''); ?></textarea>
        </div>
        <div class="form-group">
            <label>Faucet Banner 4 (bottom 728x90, HTML):</label>
            <textarea name="faucet_banner_4" class="form-control" rows="4"><?php echo htmlspecialchars($banner4 ?? ''); ?></textarea>
        </div>
        <div class="form-group">
            <label>Faucet Banner 5 (bottom 468x60, HTML):</label>
            <textarea name="faucet_banner_5" class="form-control" rows="4"><?php echo htmlspecialchars($banner5 ?? ''); ?></textarea>
        </div>
        <button type="submit" class="btn btn-success btn-block">Save Faucet Settings</button>
        <a href="/admin" class="btn btn-default btn-block" style="margin-top:8px;">Back to Dashboard</a>
    </form>
</div>
</div>
</body>
</html>
