<div class="container">
<div class="panel" style="margin:60px auto; background:#23272f; border-radius:8px; padding:32px; box-shadow:0 0 16px #4fc3f733;">
    <div class="panel-title" style="color:#4fc3f7; font-family:'Orbitron',monospace; font-size:2em; margin-bottom:18px;">General Settings</div>
    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php endif; ?>
    <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    <form method="POST" autocomplete="off">
        <div class="form-group">
            <label>Site Title:</label>
            <input type="text" name="site_title" class="form-control" required value="<?php echo htmlspecialchars($siteTitle ?? ''); ?>">
        </div>
        <div class="form-group">
            <label>Mining Rate per GHZ per Second:</label>
            <input type="number" step="0.0000000001" name="mining_rate" class="form-control" required value="<?php echo htmlspecialchars($rate); ?>">
        </div>
        <div class="form-group">
            <label>FaucetPay API Key #1 (for login/register and first withdrawal):</label>
            <input type="text" name="faucetpay_api_key_1" class="form-control" required value="<?php echo htmlspecialchars($apiKey1 ?? ''); ?>">
        </div>
        <div class="form-group">
            <label>FaucetPay API Key #2 (reserve for withdrawals only, optional):</label>
            <input type="text" name="faucetpay_api_key_2" class="form-control" value="<?php echo htmlspecialchars($apiKey2 ?? ''); ?>">
        </div>
        <div class="form-group">
            <label>Dashboard Banner HTML:</label>
            <textarea name="dashboard_banner_html" class="form-control" rows="4" style="font-family:monospace;"><?php echo htmlspecialchars($dashboardBanner); ?></textarea>
            <small style="color:#b2fff2;">You can use HTML (e.g. iframe) for the dashboard banner.</small>
        </div>
        <div class="form-group">
            <label>Decimals (for currency):</label>
            <select name="currency_decimals" class="form-control" required>
                <option value="8" <?php if($decimals==8) echo 'selected'; ?>>8</option>
                <option value="10" <?php if($decimals==10) echo 'selected'; ?>>10</option>
                <option value="12" <?php if($decimals==12) echo 'selected'; ?>>12</option>
            </select>
            <small style="color:#b2fff2;">How many decimals to show/store for balances and mining.</small>
        </div>
        <div class="form-group">
            <label>Login Rate Limit (max attempts):</label>
            <input type="number" min="1" name="login_rate_limit_max_attempts" class="form-control" required value="<?php echo htmlspecialchars($loginMaxAttempts ?? 5); ?>">
            <small style="color:#b2fff2;">How many login attempts are allowed per window (per IP).</small>
        </div>
        <div class="form-group">
            <label>Login Rate Limit Window (seconds):</label>
            <input type="number" min="60" name="login_rate_limit_window_seconds" class="form-control" required value="<?php echo htmlspecialchars($loginWindowSeconds ?? 300); ?>">
            <small style="color:#b2fff2;">Time window for login attempts (e.g. 300 = 5 minutes).</small>
        </div>
        <div class="form-group">
            <label>Faucet Claim Rate Limit (max claims):</label>
            <input type="number" min="1" name="faucet_claim_rate_limit_max_claims" class="form-control" required value="<?php echo htmlspecialchars($faucetMaxClaims ?? 5); ?>">
            <small style="color:#b2fff2;">How many faucet claims are allowed per window (per user).</small>
        </div>
        <div class="form-group">
            <label>Faucet Claim Rate Limit Window (seconds):</label>
            <input type="number" min="60" name="faucet_claim_rate_limit_window_seconds" class="form-control" required value="<?php echo htmlspecialchars($faucetWindowSeconds ?? 300); ?>">
            <small style="color:#b2fff2;">Time window for faucet claims (e.g. 300 = 5 minutes).</small>
        </div>
        <button type="submit" class="btn btn-warning btn-block" style="background:linear-gradient(90deg,#ffb700 0%,#00bfff 100%); border:none; color:#20232a; font-weight:bold;">Save General Settings</button>
        <a href="/admin" class="btn btn-default btn-block" style="margin-top:8px;">Back to Dashboard</a>
    </form>
</div>
</div>
</body>
</html>

