<!DOCTYPE html>
<html>
<head>
    <title><?php echo htmlspecialchars($siteTitle ?? 'Admin'); ?> Admin Panel</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css?family=Orbitron:700&display=swap" rel="stylesheet">
    <style>
        body { background: #20232a; color: #e0e0e0; }
        .navbar-admin {
            background: #23272f;
            border: none;
            border-bottom: 2px solid #4fc3f7;
            box-shadow: 0 2px 8px #4fc3f733;
        }
        .navbar-brand, .navbar-nav>li>a {
            color: #4fc3f7 !important;
            font-family: 'Orbitron', monospace;
            font-size: 1.2em;
            text-shadow: 0 0 4px #4fc3f7;
        }
        .navbar-nav>li>a.active {
            font-weight: bold;
            color: #ffb700 !important;
        }
    </style>
</head>
<body>
<?php if (!empty($_SESSION['admin']['logged_in'])): ?>
<nav class="navbar navbar-admin">
    <div class="container-fluid">
        <div class="navbar-header">
            <a class="navbar-brand" href="/admin"><span class="glyphicon glyphicon-cloud"></span> Admin</a>
        </div>
        <ul class="nav navbar-nav navbar-right">
            <li><a href="/admin" class="<?php echo ($_SERVER['REQUEST_URI'] == '/admin') ? 'active' : ''; ?>"><span class="glyphicon glyphicon-dashboard"></span> Dashboard</a></li>
            <li><a href="/admin/faucet-settings" class="<?php echo (strpos($_SERVER['REQUEST_URI'], '/admin/faucet-settings') !== false) ? 'active' : ''; ?>"><span class="glyphicon glyphicon-tint"></span> Faucet</a></li>
            <li><a href="/admin/general-settings" class="<?php echo (strpos($_SERVER['REQUEST_URI'], '/admin/general-settings') !== false) ? 'active' : ''; ?>"><span class="glyphicon glyphicon-cog"></span> General</a></li>
            <li><a href="/admin/currency-settings" class="<?php echo (strpos($_SERVER['REQUEST_URI'], '/admin/currency-settings') !== false) ? 'active' : ''; ?>"><span class="glyphicon glyphicon-bitcoin"></span> Currency</a></li>
            <li><a href="/admin/manual-reklam" class="<?php echo (strpos($_SERVER['REQUEST_URI'], '/admin/manual-reklam') !== false) ? 'active' : ''; ?>"><span class="glyphicon glyphicon-bullhorn"></span> Manual Ad</a></li>
            <li><a href="/admin/duplicate-ip-users" class="<?php echo (strpos($_SERVER['REQUEST_URI'], '/admin/duplicate-ip-users') !== false) ? 'active' : ''; ?>"><span class="glyphicon glyphicon-duplicate"></span> Duplicate IPs</a></li>
            <li><a href="/admin/password" class="<?php echo (strpos($_SERVER['REQUEST_URI'], '/admin/password') !== false) ? 'active' : ''; ?>"><span class="glyphicon glyphicon-lock"></span> Change Password</a></li>
            <li><a href="/admin/user-list" class="<?php echo (strpos($_SERVER['REQUEST_URI'], '/admin/user-list') !== false) ? 'active' : ''; ?>"><span class="glyphicon glyphicon-user"></span> Users</a></li>
            <li><a href="/admin/banned-users" class="<?php echo (strpos($_SERVER['REQUEST_URI'], '/admin/banned-users') !== false) ? 'active' : ''; ?>"><span class="glyphicon glyphicon-ban-circle"></span> Banned Users</a></li>
            <li><a href="/admin/logout"><span class="glyphicon glyphicon-off"></span> Logout</a></li>
        </ul>
    </div>
</nav>
<?php endif; ?>
<?php if (isset($content)) echo $content; ?>
</body>
</html>
