<div class="container">
<div class="panel" style="margin:60px auto; background:#23272f; border-radius:8px; padding:32px; box-shadow:0 0 16px #00ff9933;">
    <div class="panel-title" style="color:#4fc3f7; font-family:'Orbitron',monospace; font-size:2em; margin-bottom:18px;">Manual Ad</div>
    <div style="color:#b2fff2; margin-bottom:18px;">
        <b>What is this page?</b><br>
        This page allows the admin to manually send a one-time FaucetPay payout (ad/reward) to all users who have not yet received it. 
        Enter the FaucetPay API key, the amount, and the currency, then click "Send Ad" to distribute the reward to all eligible users. 
        The table below lists users who have not yet received the ad.
    </div>
    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php endif; ?>
    <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    <form method="POST" autocomplete="off" style="margin-bottom:32px;">
        <div class="form-group">
            <label>FaucetPay API Key:</label>
            <input type="text" name="reklam_api_key" class="form-control" required value="<?php echo htmlspecialchars($apiKey ?? ''); ?>">
        </div>
        <div class="form-group">
            <label>Amount (in selected currency):</label>
            <input type="number" step="0.00000001" name="reklam_amount" class="form-control" required value="<?php echo htmlspecialchars($amount ?? ''); ?>">
        </div>
        <div class="form-group">
            <label>Currency:</label>
            <select name="reklam_currency" class="form-control" required>
                <?php foreach ($currencies as $cur): ?>
                    <option value="<?php echo htmlspecialchars($cur); ?>" <?php if ($currency === $cur) echo 'selected'; ?>><?php echo htmlspecialchars($cur); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="btn btn-warning btn-block" style="background:linear-gradient(90deg,#ffb700 0%,#00bfff 100%); border:none; color:#20232a; font-weight:bold;">Send Ad</button>
        <a href="/admin" class="btn btn-default btn-block" style="margin-top:8px;">Back to Dashboard</a>
    </form>
    <div>
        <h4 style="color:#00ff99;font-family:'Orbitron',monospace;">Users who have not received the ad yet (<?php echo count($users); ?>):</h4>
        <table class="table table-bordered" style="background:#23272f;color:#e0e0e0;">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Email</th>
                    <th>Last Login</th>
                    <th>Registered</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($users)): foreach ($users as $user): ?>
                    <tr>
                        <td><?php echo (int)$user['id']; ?></td>
                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                        <td><?php echo htmlspecialchars($user['last_login_at']); ?></td>
                        <td><?php echo htmlspecialchars($user['created_at']); ?></td>
                    </tr>
                <?php endforeach; else: ?>
                    <tr><td colspan="4">No users found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
</div>
</body>
</html>
