<div class="container">
    <div class="panel" style="margin:60px auto; background:#23272f; border-radius:8px; padding:32px; box-shadow:0 0 16px #4fc3f733;">
        <div class="panel-title" style="color:#4fc3f7; font-family:'Orbitron',monospace; font-size:2em; margin-bottom:18px;">
            User List (<?php echo (int)$total; ?>)
        </div>
        <form method="get" action="/admin/user-list" class="form-inline" style="margin-bottom:18px;">
            <input type="text" name="search" class="form-control" placeholder="Search email or IP" value="<?php echo htmlspecialchars($search); ?>">
            <button type="submit" class="btn btn-info">Search</button>
        </form>
        <?php if (!empty($deleteSuccess)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($deleteSuccess); ?></div>
        <?php endif; ?>
        <?php if (!empty($deleteError)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($deleteError); ?></div>
        <?php endif; ?>
        <?php if (!empty($banSuccess)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($banSuccess); ?></div>
        <?php endif; ?>
        <?php if (!empty($banError)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($banError); ?></div>
        <?php endif; ?>
        <?php if ($deleteId): ?>
            <form method="post" action="/admin/user-list?search=<?php echo urlencode($search); ?>&page=<?php echo (int)$page; ?>">
                <input type="hidden" name="confirm_delete" value="<?php echo (int)$deleteId; ?>">
                <div class="alert alert-danger" style="font-weight:bold;">
                    Are you sure you want to delete user ID <?php echo (int)$deleteId; ?>? This cannot be undone.<br>
                    <button type="submit" class="btn btn-danger" style="margin-top:8px;">Yes, delete user</button>
                    <a href="/admin/user-list?search=<?php echo urlencode($search); ?>&page=<?php echo (int)$page; ?>" class="btn btn-default" style="margin-top:8px;">Cancel</a>
                </div>
            </form>
        <?php endif; ?>
        <table class="table table-bordered" style="background:#23272f;color:#e0e0e0;">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Email</th>
                    <th>Last IP</th>
                    <th>Last Login</th>
                    <th>Registered</th>
                    <th>Balance</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($users)): foreach ($users as $user): ?>
                    <tr<?php if (!empty($user['banned'])) echo ' style="background:#330000;"'; ?>>
                        <td><?php echo (int)$user['id']; ?></td>
                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                        <td><?php echo htmlspecialchars($user['last_ip']); ?></td>
                        <td><?php echo htmlspecialchars($user['last_login_at']); ?></td>
                        <td><?php echo htmlspecialchars($user['created_at']); ?></td>
                        <td><?php echo number_format($user['balance'], 8); ?></td>
                        <td>
                            <a href="/admin/user-list?search=<?php echo urlencode($search); ?>&page=<?php echo (int)$page; ?>&delete=<?php echo (int)$user['id']; ?>" class="btn btn-xs btn-danger">Delete</a>
                            <?php if (empty($user['banned'])): ?>
                                <form method="POST" style="display:inline;">
                                    <input type="hidden" name="action" value="ban">
                                    <input type="hidden" name="user_id" value="<?php echo (int)$user['id']; ?>">
                                    <button type="submit" class="btn btn-xs btn-warning" onclick="return confirm('Ban this user?')">Ban</button>
                                </form>
                            <?php else: ?>
                                <form method="POST" style="display:inline;">
                                    <input type="hidden" name="action" value="unban">
                                    <input type="hidden" name="user_id" value="<?php echo (int)$user['id']; ?>">
                                    <button type="submit" class="btn btn-xs btn-success" onclick="return confirm('Unban this user?')">Unban</button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; else: ?>
                    <tr><td colspan="7">No users found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
        <!-- Pagination -->
        <nav>
            <ul class="pagination">
                <?php for ($i = 1; $i <= $pages; $i++): ?>
                    <li<?php if ($i == $page) echo ' class="active"'; ?>>
                        <a href="/admin/user-list?search=<?php echo urlencode($search); ?>&page=<?php echo $i; ?>"><?php echo $i; ?></a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>
        <a href="/admin" class="btn btn-default btn-block" style="margin-top:8px;">Back to Dashboard</a>
    </div>
</div>
</body>
</html>
