<!DOCTYPE html>
<html>
<head>
    <title><?php echo htmlspecialchars($siteTitle); ?> - Home</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <style>
        body {
            background: #20232a;
            color: #e0e0e0;
        }
        .hero-section {
            background: linear-gradient(90deg,#23272f 60%,#4fc3f7 100%);
            border-radius: 12px;
            margin-top: 40px;
            padding: 40px 30px 30px 30px;
            box-shadow: 0 0 32px #4fc3f733;
            text-align: center;
        }
        .hero-title {
            color: #4fc3f7;
            font-family: 'Orbitron', monospace;
            font-size: 2.5em;
            letter-spacing: 2px;
            margin-bottom: 10px;
            text-shadow: 0 0 10px #4fc3f7, 0 0 2px #4fc3f7;
        }
        .hero-subtitle {
            color: #b2fff2;
            font-size: 1.3em;
            margin-bottom: 24px;
            font-family: 'Orbitron', monospace;
        }
        .trust-badges {
            margin: 24px 0 16px 0;
            display: flex;
            justify-content: center;
            gap: 32px;
        }
        .trust-badge {
            background: #23272f;
            border: 1px solid #4fc3f7;
            border-radius: 8px;
            padding: 12px 24px;
            color: #4fc3f7;
            font-family: 'Orbitron', monospace;
            font-size: 1.1em;
            box-shadow: 0 0 8px #4fc3f733;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .features-section {
            margin: 40px 0 24px 0;
            text-align: center;
        }
        .feature {
            display: inline-block;
            background: #23272f;
            border: 1px solid #4fc3f7;
            border-radius: 8px;
            margin: 10px;
            padding: 18px 28px;
            color: #e0e0e0;
            min-width: 220px;
            vertical-align: top;
            box-shadow: 0 0 8px #4fc3f733;
        }
        .feature-title {
            color: #4fc3f7;
            font-family: 'Orbitron', monospace;
            font-size: 1.15em;
            margin-bottom: 8px;
        }
        .footer {
            margin-top: 40px;
            padding: 18px 0 8px 0;
            text-align: center;
            color: #b2fff2;
            font-size: 1em;
            font-family: 'Orbitron', monospace;
            border-top: 1px solid #4fc3f7;
            background: #20232a;
        }
        .miner-panel {
            background: #23272f;
            border: 1px solid #4fc3f7;
            border-radius: 8px;
            box-shadow: 0 0 16px #4fc3f733;
            margin: 40px auto 0 auto;
            padding: 30px 30px 20px 30px;
            max-width: 600px;
        }
        .miner-title {
            color: #4fc3f7;
            font-family: 'Orbitron', monospace;
            font-size: 2.2em;
            letter-spacing: 2px;
            margin-bottom: 10px;
            text-shadow: 0 0 10px #4fc3f7, 0 0 2px #4fc3f7;
        }
        .panel-primary {
            border: none;
            background: transparent;
            box-shadow: none;
        }
        .panel-heading {
            background: transparent !important;
            border: none !important;
            color: #4fc3f7 !important;
            font-size: 1.3em;
            font-family: 'Orbitron', monospace;
            text-shadow: 0 0 4px #4fc3f7;
        }
        .form-control {
            background: #23272f;
            border: 1px solid #4fc3f7;
            color: #e0e0e0;
        }
        .btn-primary {
            background: linear-gradient(90deg,#4fc3f7 0%,#00bfff 100%);
            border: none;
            color: #20232a;
            font-weight: bold;
            box-shadow: 0 0 8px #4fc3f788;
        }
        .alert-danger, .alert-success {
            border-radius: 4px;
            border: none;
            font-weight: bold;
        }
        @media (max-width: 800px) {
            .features-section .feature { min-width: 140px; padding: 12px 8px; }
            .miner-panel { padding: 18px 8px 12px 8px; }
            .hero-section { padding: 24px 8px 18px 8px; }
        }
    </style>
    <link href="https://fonts.googleapis.com/css?family=Orbitron:700&display=swap" rel="stylesheet">
    <link rel="icon" href="/favicon.ico">
</head>
<body>
<div class="container">
    <div class="hero-section">
        <div class="hero-title">
            <a href="/" target="_blank" style="color:#4fc3f7;text-decoration:none;">
                <span class="glyphicon glyphicon-cloud"></span> <?php echo htmlspecialchars($siteTitle); ?>
            </a>
        </div>
        <div class="hero-subtitle">
            Multi-currency cloud mining platform.<br>
            Earn daily, securely and transparently.
        </div>
        <div class="trust-badges">
            <div class="trust-badge">
                <span class="glyphicon glyphicon-lock"></span> Secure &amp; Encrypted
            </div>
            <div class="trust-badge">
                <span class="glyphicon glyphicon-time"></span> Fast Payouts
            </div>
        </div>
        <!-- Statistics Section -->
        <div style="margin:32px 0 0 0;display:flex;justify-content:center;gap:32px;flex-wrap:wrap;">
            <div style="background:#23272f;border:1px solid #4fc3f7;border-radius:8px;padding:18px 32px;min-width:180px;box-shadow:0 0 8px #4fc3f733;">
                <div style="color:#4fc3f7;font-family:'Orbitron',monospace;font-size:1.2em;">
                    <span class="glyphicon glyphicon-user"></span>
                    Registered users
                </div>
                <div style="font-size:1.5em;font-weight:bold;margin-top:6px;">
                    <?php echo isset($stats['users']) ? (int)$stats['users'] : '-'; ?>
                </div>
            </div>
            <!-- Hide or comment out deposit stat box since there is no deposit table -->
            <!--
            <div style="background:#23272f;border:1px solid #4fc3f7;border-radius:8px;padding:18px 32px;min-width:180px;box-shadow:0 0 8px #4fc3f733;">
                <div style="color:#4fc3f7;font-family:'Orbitron',monospace;font-size:1.2em;">
                    <span class="glyphicon glyphicon-credit-card"></span>
                    Total deposit
                </div>
                <div style="font-size:1.5em;font-weight:bold;margin-top:6px;">
                    <?php echo isset($stats['deposit']) ? number_format($stats['deposit'], 0) : '-'; ?> <?php echo htmlspecialchars($currency); ?>
                </div>
            </div>
            -->
            <div style="background:#23272f;border:1px solid #4fc3f7;border-radius:8px;padding:18px 32px;min-width:180px;box-shadow:0 0 8px #4fc3f733;">
                <div style="color:#4fc3f7;font-family:'Orbitron',monospace;font-size:1.2em;">
                    <span class="glyphicon glyphicon-export"></span>
                    Total withdrawn
                </div>
                <div style="font-size:1.5em;font-weight:bold;margin-top:6px;">
                    <?php echo isset($stats['withdrawn']) ? number_format($stats['withdrawn'], 8) : '-'; ?> <?php echo htmlspecialchars($currency); ?>
                </div>
            </div>
        </div>
        <!-- End Statistics Section -->
    </div>
    <div id="login-panel" class="miner-panel text-center">
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
        <?php endif; ?>
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
        <?php endif; ?>
        <div class="panel panel-primary">
            <div class="panel-heading">Login / Register</div>
            <div class="panel-body">
                <form method="POST" action="/login<?php if (isset($_GET['ref'])) echo '?ref=' . urlencode($_GET['ref']); ?>" autocomplete="off">
                    <div style="display:none;">
                        <input type="text" name="website" value="">
                    </div>
                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token'] ?? ''); ?>">
                    <div class="form-group">
                        <label>FaucetPay email address:</label>
                        <input type="email" class="form-control" name="email" required pattern="^[^@]+@gmail\.com$">
                    </div>
                    <button type="submit" class="btn btn-primary btn-block">Login / Register</button>
                </form>
            </div>
        </div>
    </div>
    <!-- Last 10 payouts section -->
    <div class="miner-panel" style="margin-top:32px;">
        <div class="miner-title" style="font-size:1.3em;margin-bottom:18px;">Last 10 Payouts</div>
        <table class="table table-bordered" style="background:#23272f;color:#e0e0e0;">
            <thead>
                <tr>
                    <th>Email</th>
                    <th><?php echo htmlspecialchars($currency); ?></th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
            <?php
            function mask_email($email) {
                $parts = explode('@', $email);
                $local = $parts[0];
                $masked = '';
                for ($i = 0; $i < strlen($local); $i++) {
                    $masked .= ($i % 2 === 1) ? '*' : $local[$i];
                }
                return $masked . '@' . $parts[1];
            }
            if (!empty($lastPayouts)): foreach ($lastPayouts as $row): ?>
                <tr>
                    <td><?php echo htmlspecialchars(mask_email($row['email'])); ?></td>
                    <td><?php echo number_format($row['amount_usdt'], 8); ?></td>
                    <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                </tr>
            <?php endforeach; else: ?>
                <tr><td colspan="3">No payouts yet.</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
    <!-- End Last 10 payouts section -->
    <div class="features-section">
        <div class="feature">
            <div class="feature-title"><span class="glyphicon glyphicon-cog"></span> Easy to Use</div>
            <div>Start mining with just your FaucetPay Gmail address. No technical skills required.</div>
        </div>
        <div class="feature">
            <div class="feature-title"><span class="glyphicon glyphicon-stats"></span> Transparent Earnings</div>
            <div>Track your mining rewards and payouts in real time. No hidden fees.</div>
        </div>
        <div class="feature">
            <div class="feature-title"><span class="glyphicon glyphicon-link"></span> Referral Rewards</div>
            <div>Invite friends and earn 10% rewards.</div>
        </div>
        <div class="feature">
            <div class="feature-title"><span class="glyphicon glyphicon-send"></span> Fast Withdrawals</div>
            <div>Withdraw your <?php echo htmlspecialchars($currency); ?> instantly to your FaucetPay account.</div>
        </div>
    </div>
    <div class="footer">
        &copy; <?php echo date('Y'); ?> <?php echo htmlspecialchars($siteTitle); ?> &mdash; Trusted Cloud Mining Platform.<br>
        <span style="font-size:0.95em;">No investment advice. Crypto involves risk. All rights reserved.</span>
    </div>
</div>
</body>
</html>