<div class="container">
    <div class="miner-panel text-center">
        <div class="miner-icon">
            <span class="glyphicon glyphicon-cloud"></span>
        </div>
        <div class="miner-title"><?php echo htmlspecialchars($siteTitle); ?> Dashboard</div>
        <div style="margin-bottom:18px;">
            <span style="color:#00ff99;font-family:'Orbitron',monospace;font-size:1.1em;">
                1 GHZ = <?php echo htmlspecialchars($dashboard['mining_rate']); ?> <?php echo htmlspecialchars($currency); ?> / sec
            </span>
        </div>
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
        <?php endif; ?>
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
        <?php endif; ?>
        <div class="row">
            <div class="col-md-6">
                <table class="table table-bordered">
                    <tr>
                        <th><?php echo htmlspecialchars($currency); ?> Balance</th>
                        <td><?php echo number_format($dashboard['balance'], 8); ?></td>
                    </tr>
                    <tr>
                        <th>GHZ (active faucet claims)</th>
                        <td>
                            <?php echo number_format($dashboard['ghz'], 4); ?>
                        </td>
                    </tr>
                    <tr>
                        <th>Referral Earnings</th>
                        <td>
                            <b><?php echo isset($referralEarnings) ? number_format($referralEarnings, 8) : '0.00000000'; ?> <?php echo htmlspecialchars($currency); ?></b>
                        </td>
                    </tr>
                    <tr><th>Last Collection</th><td><?php echo $dashboard['last_collected_at'] ?? '-'; ?></td></tr>
                    <tr>
                        <th>Collectable <?php echo htmlspecialchars($currency); ?></th>
                        <td>
                            <b id="collectable-usdt"><?php
                                $decimals = isset($decimals) ? (int)$decimals : 8;
                                $val = number_format($dashboard['mined'], $decimals, '.', '');
                                if ($decimals > 8) {
                                    $parts = explode('.', $val);
                                    if (isset($parts[1])) {
                                        $main = substr($parts[1], 0, 8);
                                        $extra = substr($parts[1], 8);
                                        echo $parts[0] . '.';
                                        echo '<span class="main-decimals">' . $main . '</span>';
                                        if ($extra !== '') {
                                            echo '<span class="extra-decimals" style="font-size:75%;">' . $extra . '</span>';
                                        }
                                    } else {
                                        echo $val;
                                    }
                                } else {
                                    echo $val;
                                }
                            ?></b>
                            <?php if (!empty($showUncollectedExpired) && $showUncollectedExpired && $uncollectedExpiredUsdt > 0): ?>
                                <div style="margin-top:8px;color:#b2fff2;font-size:0.98em;">
                                    <span style="color:#00bfff;">You have <b>
                                        <?php
                                        $val = number_format($uncollectedExpiredUsdt, $decimals, '.', '');
                                        if ($decimals > 8) {
                                            $parts = explode('.', $val);
                                            if (isset($parts[1])) {
                                                $main = substr($parts[1], 0, 8);
                                                $extra = substr($parts[1], 8);
                                                echo $parts[0] . '.';
                                                echo '<span class="main-decimals">' . $main . '</span>';
                                                if ($extra !== '') {
                                                    echo '<span class="extra-decimals" style="font-size:75%;">' . $extra . '</span>';
                                                }
                                            } else {
                                                echo $val;
                                            }
                                        } else {
                                            echo $val;
                                        }
                                        ?>
                                        <?php echo htmlspecialchars($currency); ?></b> from expired faucet claims that can still be collected.</span>
                                </div>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
                <form method="POST">
                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
                    <button type="submit" name="collect" class="btn btn-success btn-block" id="collect-btn" disabled>
                        <span class="glyphicon glyphicon-flash"></span> Collect <?php echo htmlspecialchars($currency); ?>
                    </button>
                </form>
                <form method="POST" style="margin-top:10px;">
                    <button type="submit" name="withdraw" class="btn btn-warning btn-block" <?php if($dashboard['balance'] <= 0) echo 'disabled'; ?>>
                        <span class="glyphicon glyphicon-export"></span> Withdraw <?php echo htmlspecialchars($currency); ?>
                    </button>
                </form>
            </div>
            <div class="col-md-6 text-left">
                <!-- Banner section moved here -->
                <div class="text-center" style="margin-bottom:24px;">
                    <div style="width:300px;height:250px;background:#23272f;border:1px solid #00ff99;border-radius:8px;display:flex;align-items:center;justify-content:center;margin:0 auto;">
                        <?php echo $dashboardBanner; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="row" style="margin-top:30px;">
            <!-- Left: Referral, Right: Payout History -->
            <div class="col-md-6 text-left">
                <div style="margin-bottom:18px;">
                    <b>Your referral URL:</b>
                    <input type="text" class="form-control" readonly value="<?php
                        echo htmlspecialchars($referralUrl);
                    ?>" onclick="this.select();" style="margin-top:5px;">
                </div>
                <div style="margin-bottom:18px;">
                    <b>Your referrals (last 10):</b>
                    <ul style="margin-top:5px;">
                        <?php if (!empty($referrals)): foreach ($referrals as $ref): ?>
                            <li><?php echo htmlspecialchars($ref['email']); ?> (joined: <?php echo htmlspecialchars($ref['created_at']); ?>)</li>
                        <?php endforeach; else: ?>
                            <li>No referrals yet.</li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <h4 style="color:#00ff99;font-family:'Orbitron',monospace;">Payout History</h4>
                <table class="table table-bordered" style="font-size:0.95em;">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th><?php echo htmlspecialchars($currency); ?></th>
                            <th>Status</th>
                            <th>Payout ID</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    // Show only last 10 payouts
                    $history = !empty($payoutHistory) ? array_slice($payoutHistory, 0, 10) : [];
                    if (!empty($history)): foreach ($history as $row): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                            <td><?php echo number_format($row['amount_usdt'], 8); ?></td>
                            <td><?php echo htmlspecialchars($row['status']); ?></td>
                            <td><?php echo htmlspecialchars($row['payout_id']); ?></td>
                        </tr>
                    <?php endforeach; else: ?>
                        <tr><td colspan="5">No payouts yet.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Add Bootstrap JS for modal functionality -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<script>
(function() {
    // --- Prepare faucet claims for live calculation ---
    var ratePerGhz = <?php echo json_encode($dashboard['mining_rate']); ?>;
    var initialMined = parseFloat('<?php echo $dashboard['mined']; ?>');
    var decimals = <?php echo isset($decimals) ? (int)$decimals : 8; ?>;
    var claims = <?php
        $userModel = new UserModel();
        $activeClaims = [];
        foreach ($userModel->getFaucetClaimsForUser($_SESSION['user_id']) as $claim) {
            $expiresAt = strtotime($claim['expires_at']);
            $now = time();
            if ($expiresAt > $now) {
                $activeClaims[] = [
                    'ghz' => (float)$claim['ghz'],
                    'claimed_at' => strtotime($claim['claimed_at']),
                    'expires_at' => $expiresAt,
                    'collected_usdt' => (float)$claim['collected_usdt']
                ];
            }
        }
        echo json_encode($activeClaims);
    ?>;

    function hasCollectable8Decimals(val) {
        // val: float or string, e.g. "0.000000004232" or 0.000000004232
        var str = typeof val === 'number' ? val.toFixed(decimals) : val;
        var parts = str.split('.');
        if (!parts[1]) return false;
        // Check if at least one of the first 8 decimals is non-zero
        var first8 = parts[1].substring(0, 8);
        return /^[0-9]*[1-9][0-9]*$/.test(first8);
    }

    function updateCollectableUsdt() {
        var nowTs = Math.floor(Date.now() / 1000);
        var total = 0;
        for (var i = 0; i < claims.length; i++) {
            var claim = claims[i];
            var endTs = Math.min(nowTs, claim.expires_at);
            var seconds = Math.max(0, endTs - claim.claimed_at);
            var maxUsdt = seconds * claim.ghz * ratePerGhz;
            var uncollected = maxUsdt - claim.collected_usdt;
            if (uncollected > 0) total += uncollected;
        }
        var displayValue = total > 0 ? total : initialMined;
        var decimals = <?php echo isset($decimals) ? (int)$decimals : 8; ?>;
        var val = displayValue.toFixed(decimals);
        var html;
        if (decimals > 8) {
            var parts = val.split('.');
            var main = parts[1] ? parts[1].substring(0,8) : '';
            var extra = parts[1] ? parts[1].substring(8) : '';
            html = parts[0] + '.<span class="main-decimals">' + main + '</span>';
            if (extra) {
                html += '<span class="extra-decimals" style="font-size:75%;">' + extra + '</span>';
            }
        } else {
            html = val;
        }
        document.getElementById('collectable-usdt').innerHTML = html;
        var btn = document.getElementById('collect-btn');
        // Enable only if at least one of the first 8 decimals is non-zero
        btn.disabled = !hasCollectable8Decimals(val);
    }
    setInterval(updateCollectableUsdt, 1000);
    updateCollectableUsdt();
})();
</script>
</body>
</html>
