<div class="container-fluid" style="padding:0;">
    <div style="margin:40px auto 0 auto; max-width:1200px; padding:0;">
        <div class="row" style="display:flex;justify-content:center;gap:32px;">
            <div class="col-xs-12 col-sm-4 text-center" style="margin-bottom:18px;padding:0;">
                <div style="width:300px;height:250px;display:flex;align-items:center;justify-content:center;margin:0 auto;">
                    <!-- Banner 1 -->
                    <?php echo $banner1; ?>
                </div>
            </div>
            <div class="col-xs-12 col-sm-4 text-center" style="margin-bottom:18px;padding:0;">
                <div style="width:300px;height:250px;display:flex;align-items:center;justify-content:center;margin:0 auto;">
                    <!-- Banner 2 -->
                    <?php echo $banner2; ?>
                </div>
            </div>
            <div class="col-xs-12 col-sm-4 text-center" style="margin-bottom:18px;padding:0;">
                <div style="width:300px;height:250px;display:flex;align-items:center;justify-content:center;margin:0 auto;">
                    <!-- Banner 3 -->
                    <?php echo $banner3; ?>
                </div>
            </div>
        </div>
        <div class="row" style="margin-top:32px;display:flex;justify-content:center;">
            <div class="col-xs-12 col-sm-12" style="max-width:420px;margin:0 auto;">
                <!-- Faucet Claim section, no border, no icon -->
                <div class="text-center" style="margin:0 auto;max-width:420px;">
                    <div class="miner-title" style="font-size:2em;margin-bottom:18px;"><?php echo htmlspecialchars($siteTitle); ?> Faucet Claim</div>
                    <div style="margin-bottom:12px;color:#4fc3f7;font-family:'Orbitron',monospace;font-size:1.1em;">
                        1 GHZ = <?php echo htmlspecialchars($rate); ?> <?php echo htmlspecialchars($currency); ?> / sec
                    </div>
                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger" style="margin-bottom:18px;"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
                    <?php endif; ?>
                    <?php if (isset($_SESSION['success'])): ?>
                        <div class="alert alert-success" style="margin-bottom:18px;"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
                    <?php endif; ?>
                    <div id="cooldown-section" style="margin-bottom:18px;">
                        <div style="color:#00bfff;font-size:1.15em;">
                            Please wait <span id="cooldown-timer" style="font-weight:bold;">0</span> seconds before you can claim.
                        </div>
                    </div>
                    <form method="POST" action="/faucet" autocomplete="off" style="margin-top:18px;display:none;" id="faucet-claim-form">
                        <input type="hidden" name="adblock_detected" id="adblock_detected" value="0">
                        <input type="hidden" name="popup_blocked" id="popup_blocked" value="0">
                        <!-- Custom CAPTCHA -->
                        <div class="form-group" style="margin-bottom:18px;" id="captcha-group">
                            <?php
                            $a = random_int(10, 99);
                            $b = random_int(1, 9);
                            $_SESSION['faucet_captcha'] = $a + $b;
                            ?>
                            <label for="captcha_answer" style="color:#00ff99;font-size:1.1em;">Anti-bot: What is <?php echo $a; ?> + <?php echo $b; ?>?</label>
                            <input type="number" class="form-control" name="captcha_answer" id="captcha_answer" required autocomplete="off" style="max-width:120px;margin:0 auto;font-size:1.15em;">
                        </div>
                        <button type="submit" class="btn btn-success btn-block" style="font-size:1.25em;font-family:'Orbitron',monospace;" id="claim-btn">
                            Claim <?php echo htmlspecialchars(number_format($ghz, 4)); ?> GHZ (<?php echo (int)$minutes; ?> min)
                        </button>
                    </form>
                    <div style="margin-top:8px;color:#b2fff2;font-size:0.98em;">
                        Each claim gives you <b><?php echo htmlspecialchars(number_format($ghz, 4)); ?> GHZ</b> mining power for <b><?php echo (int)$minutes; ?> minutes</b>.
                        <br>
                        Mining rate: <b>1 GHZ = <?php echo htmlspecialchars($rate); ?> <?php echo htmlspecialchars($currency); ?>/sec</b>
                    </div>
                </div>
            </div>
        </div>
        <!-- Bottom banners stacked vertically, no margin/padding between, no border/box-shadow -->
        <div class="row" style="margin-top:24px;">
            <div class="col-xs-12 text-center" style="padding:0;">
                <div style="width:728px;height:90px;display:flex;align-items:center;justify-content:center;margin:0 auto;">
                    <!-- Banner 728x90 -->
                    <?php echo $banner4; ?>
                </div>
            </div>
        </div>
        <div class="row" style="margin-top:0;">
            <div class="col-xs-12 text-center" style="padding:0;">
                <div style="width:468px;height:60px;display:flex;align-items:center;justify-content:center;margin:0 auto;">
                    <!-- Banner 468x60 -->
                    <?php echo $banner5; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
window.addEventListener('DOMContentLoaded', function() {
    // --- Popup blocker detection ---
    var popupBlocked = false;
    try {
        var popup = window.open('about:blank', '_blank', 'width=100,height=100');
        if (!popup || popup.closed || typeof popup.closed === 'undefined') {
            popupBlocked = true;
        } else {
            popup.close();
        }
    } catch (e) {
        popupBlocked = true;
    }
    var form = document.getElementById('faucet-claim-form');
    var captchaGroup = document.getElementById('captcha-group');
    var claimBtn = document.getElementById('claim-btn');
    if (popupBlocked) {
        if (form) form.style.display = 'none';
        if (captchaGroup) captchaGroup.style.display = 'none';
        if (claimBtn) claimBtn.style.display = 'none';
        // Set hidden field so server can check
        var popupField = document.getElementById('popup_blocked');
        if (popupField) popupField.value = '1';
        var cdSection = document.getElementById('cooldown-section');
        if (cdSection) {
            cdSection.style.display = 'none';
        }
        var msg = document.createElement('div');
        msg.className = 'alert alert-danger';
        msg.style.margin = '18px 0';
        msg.innerHTML = 'Please enable popups for this site to use the faucet!';
        var parent = document.querySelector('.miner-title');
        if (parent) {
            parent.parentNode.insertBefore(msg, parent.nextSibling);
        }
    } else {
        // If not blocked, ensure hidden field is 0 and show form/captcha/button
        var popupField = document.getElementById('popup_blocked');
        if (popupField) popupField.value = '0';
        if (form) form.style.display = '';
        if (captchaGroup) captchaGroup.style.display = '';
        if (claimBtn) claimBtn.style.display = '';
    }

    var bait = document.createElement('div');
    bait.className = 'adsbox';
    bait.style.position = 'absolute';
    bait.style.left = '-9999px';
    bait.style.height = '10px';
    bait.style.width = '10px';
    bait.style.background = '#fff';
    document.body.appendChild(bait);
    setTimeout(function() {
        var detected = false;
        if (
            bait.offsetParent === null ||
            bait.offsetHeight === 0 ||
            bait.offsetWidth === 0 ||
            window.getComputedStyle(bait).display === 'none' ||
            window.getComputedStyle(bait).visibility === 'hidden'
        ) {
            detected = true;
        }
        document.getElementById('adblock_detected').value = detected ? '1' : '0';
        bait.remove();
    }, 200);

    // --- Faucet cooldown logic ---
    var cooldownSeconds = <?php echo isset($cooldown) ? (int)$cooldown : 5; ?>;
    var claimBtn = document.getElementById('claim-btn');
    var timerSpan = document.getElementById('cooldown-timer');
    var cooldownSection = document.getElementById('cooldown-section');
    var claimForm = document.getElementById('faucet-claim-form');
    function updateCooldown() {
        var lastClaim = parseInt(localStorage.getItem('faucet_last_claim') || '0', 10);
        var now = Math.floor(Date.now() / 1000);
        var diff = now - lastClaim;
        var left = cooldownSeconds - diff;
        if (left > 0) {
            if (claimForm) claimForm.style.display = 'none';
            if (cooldownSection) cooldownSection.style.display = '';
            timerSpan.textContent = left;
        } else {
            if (cooldownSection) cooldownSection.style.display = 'none';
            if (claimForm) claimForm.style.display = '';
        }
    }
    updateCooldown();
    var cooldownInterval = setInterval(updateCooldown, 500);

    // On submit, set last claim time if not in cooldown
    if (claimForm) {
        claimForm.addEventListener('submit', function(e) {
            var lastClaim = parseInt(localStorage.getItem('faucet_last_claim') || '0', 10);
            var now = Math.floor(Date.now() / 1000);
            if (now - lastClaim < cooldownSeconds) {
                e.preventDefault();
                updateCooldown();
                return false;
            }
            localStorage.setItem('faucet_last_claim', now);
        });
    }
});
</script>

