<!DOCTYPE html>
<html>
<head>
    <title><?php echo htmlspecialchars($siteTitle); ?></title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css?family=Orbitron:700&display=swap" rel="stylesheet">
    <style>
        body { background: #20232a; color: #e0e0e0; }
        .navbar-default {
            background: #23272f;
            border: none;
            border-bottom: 2px solid #4fc3f7;
            box-shadow: 0 2px 8px #4fc3f733;
        }
        .navbar-brand, .navbar-nav>li>a {
            color: #4fc3f7 !important;
            font-family: 'Orbitron', monospace;
            font-size: 1.2em;
            text-shadow: 0 0 4px #4fc3f7;
        }
        .miner-panel {
            background: #23272f;
            border: 1px solid #4fc3f7;
            border-radius: 8px;
            box-shadow: 0 0 16px #4fc3f733;
            margin-top: 40px;
            padding: 30px 30px 20px 30px;
        }
        .miner-title {
            color: #4fc3f7;
            font-family: 'Orbitron', monospace;
            font-size: 2em;
            letter-spacing: 2px;
            margin-bottom: 10px;
            text-shadow: 0 0 10px #4fc3f7, 0 0 2px #4fc3f7;
        }
        .miner-icon {
            font-size: 40px;
            color: #4fc3f7;
            text-shadow: 0 0 10px #4fc3f7;
            margin-bottom: 10px;
        }
        .alert-danger, .alert-success {
            border-radius: 4px;
            border: none;
            font-weight: bold;
        }
        .footer-bar {
            margin-top: 40px;
            padding: 16px 0 8px 0;
            text-align: center;
            color: #b2fff2;
            font-size: 1em;
            font-family: 'Orbitron', monospace;
            border-top: 1px solid #4fc3f7;
            background: #20232a;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-default">
    <div class="container">
        <div class="navbar-header">
            <a class="navbar-brand" href="/dashboard"><span class="glyphicon glyphicon-cloud"></span> <?php echo htmlspecialchars($siteTitle); ?></a>
        </div>
        <ul class="nav navbar-nav navbar-right">
            <li><a href="/dashboard"><span class="glyphicon glyphicon-dashboard"></span> Dashboard</a></li>
            <li><a href="/faucet"><span class="glyphicon glyphicon-tint"></span> Faucet</a></li>
            <li><a href="/logout"><span class="glyphicon glyphicon-off"></span> Logout</a></li>
        </ul>
    </div>
</nav>
<?php if (isset($content)) echo $content; ?>
<div class="footer-bar">
    Crypto Miner &bull; Platform version: <b>1.00</b>
</div>
</body>
</html>
