<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="msapplication-TileColor" content="#0e041f">
    <meta name="theme-color" content="#0e041f">
    <link rel="apple-touch-icon" href="{{ asset('assets/images/' . site('favicon')) }}">
    <link rel="icon" href="{{ asset('assets/images/' . site('favicon')) }}">
    <title>{{ $page_title }} | {{ site('name') }}</title>
    <meta name="author" content="support@rescron.com">
    <meta name="description" content="{{ site('seo_description') }}">
    <meta property="og:url" content="{{ request()->url }}">
    <meta property="og:title" content="{{ $page_title }} | {{ site('name') }}">
    <meta property="og:description" content="{{ site('seo_description') }}">
    <meta property="og:image" content="{{ asset('assets/images/' . site('cover')) }}">
    <meta name="robots" content="noindex">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.14.8/dist/cdn.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    {{-- plus jakarta sans font  --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap"
        rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/5.0.0/normalize.min.css">
    {{-- sweet alert css --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.min.css">



    <link rel="shortcut icon" href="{{ asset('/assets/images/' . site('favicon')) }}" type="image/x-icon">
    <link rel="apple-touch-icon" href="{{ asset('/assets/images/' . site('favicon')) }}" type="image/x-icon">

    {{-- @vite(['public/assets/templates/zyphor/css/main.css']) --}}
    <link rel="stylesheet" href="{{ asset('/assets/templates/zyphor/css/main.css') }}">




    <style>
        .button-spinner {
            border: 4px solid #f3f3f3;
            /* Light grey background */
            border-top: 4px solid #ea2a97b6;
            /* Blue color for the spinner */
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 1s linear infinite;
            /* Spinning animation */
            position: absolute;
            /* display: inline-block; */
            top: 50%;
            left: 50%;


        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .not-allowed-cursor {
            cursor: not-allowed;
        }

        .disabled {
            background-color: #1d1c1c !important;
            cursor: not-allowed !important;
            color: transparent !important;
            font-weight: bold;
            pointer-events: none !important;
            cursor: not-allowed;
            padding: 15px;
        }

        .otp-input::-webkit-outer-spin-button,
        .otp-input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        @layer base {

            /* Webkit-based browsers (Chrome, Safari) */
            input[type="number"]::-webkit-outer-spin-button,
            input[type="number"]::-webkit-inner-spin-button {
                -webkit-appearance: none;
                margin: 0;
            }

            /* Firefox */
            input[type="number"] {
                -moz-appearance: textfield;
            }
        }
    </style>

</head>

<body class="bg-[#0e041f]">
    {{-- preloader  --}}
    @if (site('preloader') == 1)
        @include('templates.' . site('template') . '.loaders.preloader')
    @endif
    {{-- preloader ends  --}}
    <!-- template-->
    <div class="w-full h-screen">

        @yield('contents')

    </div>


    {{-- Include SweetAlert2 JavaScript file --}}
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.all.min.js"></script>

    <script src="{{ asset('/assets/templates/solin/scripts/contact.js') }}"></script>

    @yield('scripts')

    @stack('scripts')

    {{-- livechat --}}
    {!! json_decode(site('livechat')) !!}
</body>

</html>
