<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="msapplication-TileColor" content="#0e041f">
    <meta name="theme-color" content="#0e041f">

    <title> {{ $page_title }} | {{ site('name') }}</title>

    <meta name="author" content="support@rescron.com">
    <meta name="description" content="{{ $short_description }}">
    <meta property="og:url" content="{{ request()->url }}">
    <meta property="og:title" content="{{ $page_title }} | {{ site('name') }}">
    <meta property="og:description" content="{{ $short_description }}">
    <meta property="og:image" content="{{ asset('assets/images/' . site('cover')) }}">
    <meta name="robots" content="{{ site('robot') }}">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.14.8/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@glidejs/glide"></script>





    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@glidejs/glide/dist/css/glide.core.min.css">
    <link href="https://cdn.jsdelivr.net/npm/@splidejs/splide@3.6.1/dist/css/splide.min.css" rel="stylesheet">

    <link rel="shortcut icon" href="{{ asset('/assets/images/' . site('favicon')) }}" type="image/x-icon">
    <link rel="apple-touch-icon" href="{{ asset('/assets/images/' . site('favicon')) }}" type="image/x-icon">
    {{-- plus jakarta sans font  --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('/assets/templates/zyphor/css/main.css') }}">


    @yield('css')
    {{-- @vite(['public/assets/templates/zyphor/css/main.css']) --}}


</head>

<body class="bg-[#0e041f]">

    {{-- preloader  --}}
    @if (site('preloader') == 1)
        @include('templates.' . site('template') . '.loaders.preloader')
    @endif
    {{-- preloader ends  --}}



    <div class="lg:min-h-10"></div>
    <div class="relative max-w-[90rem] mx-auto">
        <nav class="p-4 text-[#fbfbfb] lg:absolute top-0 left-0 w-full z-50">
            <div class="container mx-auto flex justify-between items-center  lg:pb-2">
                <!-- Logo -->
                <div class="text-2xl font-bold cursor-pointer"> <a href="{{ route('home') }}"><img
                            src="{{ asset('/assets/images/' . site('logo_rec')) }}" alt="logo"
                            class="lg:h-20 h-12"></a></div>

                <!-- Menu -->
                <div x-data="{ open: false }" class="relative">
                    <!-- Hamburger Button -->
                    <button @click="open = !open" class="lg:hidden focus:outline-none">
                        <!-- Hamburger Icon -->
                        <img src="{{ asset('assets/templates/zyphor/images/menu-icon-open.png') }}" alt=""
                            class="h-8 w-8 filter invert" />
                    </button>

                    <!-- Mobile/Tablet Menu -->
                    <div x-show="open" x-transition:enter="transition ease-out duration-300"
                        x-transition:enter-start="opacity-0 transform translate-x-full"
                        x-transition:enter-end="opacity-100 transform translate-x-0"
                        x-transition:leave="transition ease-in duration-300"
                        x-transition:leave-start="opacity-100 transform translate-x-0"
                        x-transition:leave-end="opacity-0 transform translate-x-full"
                        class="fixed inset-0 z-50 lg:hidden flex flex-col bg-[#1e0336] text-white"
                        style="display: none">

                        <!-- Backdrop -->
                        <div @click="open = false" class="fixed inset-0 bg-black/50 backdrop-blur-sm"></div>

                        <!-- Menu Container -->
                        <div class="relative z-10 w-full max-w-xs bg-[#1e0336] h-full p-6 shadow-xl">
                            <!-- Close Button -->
                            <button @click="open = false" class="absolute top-4 right-4 text-white">
                                <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                            </button>

                            <!-- Menu Items -->
                            <ul class="flex flex-col space-y-6 mt-16 text-lg font-medium">
                                <li>
                                    <a href="{{ route('about') }}" class="block hover:text-[#6366f1]">About Us</a>
                                </li>
                                <li>
                                    <a href="{{ route('pricing') }}" class="block hover:text-[#6366f1]">AI Bots</a>
                                </li>
                                <li>
                                    <a href="{{ route('trades') }}" class="block hover:text-[#6366f1]">Live AI
                                        Trades</a>
                                </li>
                                <li>
                                    <a href="{{ route('tos') }}" class="block hover:text-[#6366f1]">TOS</a>
                                </li>
                                <li>
                                    <a href="{{ route('contact') }}" class="block hover:text-[#6366f1]">Contact</a>
                                </li>
                                <li>
                                    <a href="{{ route('faqs') }}" class="block hover:text-[#6366f1]">FAQ</a>
                                </li>
                            </ul>

                            <!-- Auth Button -->
                            <div class="mt-10">
                                @if (user())
                                    <a href="{{ route('user.dashboard') }}"
                                        class="block text-center bg-white/90 text-[#1e0336] font-semibold py-3 rounded-lg shadow-md hover:scale-105 transition">
                                        Dashboard
                                    </a>
                                @else
                                    <a href="{{ route('user.login') }}"
                                        class="block text-center bg-white/90 text-[#1e0336] font-semibold py-3 rounded-lg shadow-md hover:scale-105 transition">
                                        Log in
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>


                    <!-- Desktop Menu -->
                    <div class="hidden lg:flex lg:items-center lg:space-x-6">
                        <ul class="flex space-x-2">
                            <li>
                                <a href="{{ route('about') }}"
                                    class="bg-[#87818f] hover:bg-[#190735] px-2 py-1 rounded-xl transition duration-300 ease-in-out {{ request()->routeIs('about') ? 'bg-[#190735]' : '' }}">About
                                    Us</a>
                            </li>
                            <li>
                                <a href="{{ route('pricing') }}"
                                    class="bg-[#87818f] hover:bg-[#190735] px-2 py-1 rounded-xl transition duration-300 ease-in-out {{ request()->routeIs('pricing') ? 'bg-[#190735]' : '' }}">AI
                                    Bots</a>
                            </li>
                            <li>
                                <a href="{{ route('trades') }}"
                                    class="bg-[#87818f] hover:bg-[#190735] px-2 py-1 rounded-xl transition duration-300 ease-in-out  {{ request()->routeIs('trades') ? 'bg-[#190735]' : '' }}">Live
                                    AI
                                    Trades</a>
                            </li>
                            <li>
                                <a href="{{ route('tos') }}"
                                    class="bg-[#87818f] hover:bg-[#190735] px-2 py-1 rounded-xl transition duration-300 ease-in-out  {{ request()->routeIs('tos') ? 'bg-[#190735]' : '' }}">TOS</a>
                            </li>
                            <li>
                                <a href="{{ route('contact') }}"
                                    class="bg-[#87818f] hover:bg-[#190735] px-2 py-1 rounded-xl transition duration-300 ease-in-out  {{ request()->routeIs('contact') ? 'bg-[#190735]' : '' }}">Contact</a>
                            </li>
                            <li>
                                <a href="{{ route('faqs') }}"
                                    class="bg-[#87818f] hover:bg-[#190735] px-2 py-1 rounded-xl transition duration-300 ease-in-out  {{ request()->routeIs('faqs') ? 'bg-[#190735]' : '' }}">FAQ</a>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Buttons (Desktop) -->
                <div class="hidden lg:flex space-x-4">
                    @if (user())
                        <a href="{{ route('user.dashboard') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-[#ebd1f3] text-[#250a4f] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs hover:shadow-pink-500 inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Dashboard</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                    @else
                        <a href="{{ route('user.login') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-[#ebd1f3] text-[#250a4f] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs hover:shadow-pink-500 inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Log in</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                    @endif
                </div>
            </div>
        </nav>
    </div>

    {{-- main content  --}}
    @yield('contents')
    {{-- <div class="min-h-[80vh]"> --}}

    </div>





    <footer class="w-full bg-[#190735]">

        <div class="w-full ">
            <div class="w-[90%] mx-auto py-10 px-3">
                <div class="lg:flex gap-3">
                    <div class="w-full mb-6">
                        <div class="mb-4">
                            <a href="{{ route('home') }}"><img
                                    src="{{ asset('/assets/images/' . site('logo_rec')) }}" alt="logo"
                                    class="lg:h-20 h-12 mb-4"></a>
                            <p class="text-[#fbfbfb] px-6">All Servers Operational</p>
                        </div>
                        <div class="lg:px-6 py-2 lg:max-w-xs">
                            <ul class="grid grid-cols-5 gap-2 lg:gap-4">
                                @php
                                    $socialMedia = [
                                        'instagram',
                                        'facebook',
                                        'pinterest',
                                        'twitter',
                                        'youtube',
                                        'linkedin',
                                        'snapchat',
                                        'tiktok',
                                        'reddit',
                                        'whatsapp',
                                    ];
                                @endphp
                                @foreach ($socialMedia as $media)
                                    @if (site($media))
                                        <li>
                                            <div
                                                class="p-1 w-10 h-10 bg-gradient-to-r from-[#fbfbfb]/5 to-[#fbfbfb]/10 rounded-lg  flex justify-center items-center">
                                                <a href="{{ site($media) }}" aria-label="{{ $media }}">
                                                    <img src="{{ asset('/assets/templates/zyphor/images/social_media/' . $media . '.svg') }}"
                                                        alt="{{ $media }} icon" class="h-4 w-4">
                                                </a>
                                            </div>
                                        </li>
                                    @endif
                                @endforeach
                            </ul>
                        </div>

                    </div>

                    <div class="w-full grid lg:grid-cols-3 grid-cols-2">
                        <div class="col-span-1">
                            <p
                                class="text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] text-lg font-medium w-fit">
                                Company</p>
                            <ul class="py-4 space-y-4">
                                <li><a href="{{ route('about') }}" class="text-[#fbfbfb]">About
                                        Us</a>
                                </li>
                                <li><a href="{{ route('about') }}" class="text-[#fbfbfb]">Our
                                        Vision</a>
                                </li>
                                <li><a href="{{ route('about') }}" class="text-[#fbfbfb]">Our
                                        Mission</a>
                                </li>
                                <li><a href="{{ route('contact') }}" class="text-[#fbfbfb]">Contact
                                        Us</a></li>
                            </ul>
                        </div>

                        <div class="col-span-1">
                            <p
                                class="text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] text-lg font-medium w-fit">
                                Resources</p>
                            <ul class="py-4 space-y-4">
                                <li><a href="{{ route('tos') }}" class="text-[#fbfbfb]">TOS</a>
                                </li>
                                <li><a href="{{ route('privacy') }}" class="text-[#fbfbfb]">Privacy
                                        Policy</a></li>
                                <li><a href="{{ route('about') }}" class="text-[#fbfbfb]">Community</a>
                                </li>
                                <li><a href="{{ route('faqs') }}" class="text-[#fbfbfb]">FAQ</a>
                                </li>
                            </ul>
                        </div>

                        <div class="lg:col-span-1 col-span-2">
                            <p
                                class="text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] text-lg font-medium w-fit">
                                Contact Us</p>
                            <ul class="py-4 space-y-4">
                                <li>
                                    <div class="flex gap-4">
                                        <img src="{{ asset('/assets/templates/zyphor/images/location-icon.svg') }}"
                                            alt="icon">
                                        <p class="text-[#fbfbfb]"> {{ site('address') }},
                                            {{ site('city') }},{{ site('state') }}, {{ site('country') }}</p>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex gap-4">
                                        <img src="{{ asset('/assets/templates/zyphor/images/phone-icon.svg') }}"
                                            alt="icon">
                                        <p class="text-[#fbfbfb]">{{ site('phone') }}</p>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex gap-4">
                                        <img src="{{ asset('/assets/templates/zyphor/images/email-icon.svg') }}"
                                            alt="icon">
                                        <p class="text-[#fbfbfb]">{{ site('email') }}</p>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>


    {{-- cookie consent --}}
    <div id="cookie-consent" class="hidden"
        style="width: 100%; position: fixed; z-index: 50; bottom: 0; left: 0; background-color: #120f1b50; background-opacity: 15%; backdrop-filter: blur(10px);">
        <div style="width: 100%; padding: 20px;">
            <div
                style="width: 100%;  gap: 12px; display: flex; flex-direction:column; justify-content: center; align-items: center; color: white;">
                <p style="text-align: center;">We use cookies to tailor your experience on {{ site('name') }}. Learn
                    more
                    in our <a href="{{ route('privacy') }}"
                        style="border-bottom: 1px solid white; color: inherit;">privacy policy</a>
                </p>
                <div style="text-align: center; padding-top: 24px; padding-bottom: 24px;">
                    <a id="consented" role="button"
                        style="border: 1px solid transparent; border-radius: 9999px; padding: 16px 40px; display: block; text-align: center; color: white; font-size: 1.125rem; background: #250a4f; width: 400px; margin: 0 auto; text-decoration: none;">
                        <span>Accept Cookies</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="{{ asset('/assets/templates/zyphor/scripts/contact.js') }}"></script>


    <script>
        //cookies
        window.onload = function() {
            // Check if the "cookie-consent" cookie exists
            if (!document.cookie.includes('cookie-consent')) {
                $('#cookie-consent').removeClass('hidden');
            }
        };

        function setCookie(cookieName, cookieValue) {
            var expirationDate = new Date();
            expirationDate.setFullYear(expirationDate.getFullYear() + 10); // Set expiration date to 10 years from now

            var cookieString = cookieName + '=' + cookieValue + '; expires=' + expirationDate.toUTCString() + '; path=/';

            document.cookie = cookieString;
        }


        $('#consented').on('click', function(e) {
            e.preventDefault();
            setCookie('cookie-consent', true);
            $('#cookie-consent').addClass('hidden');
        });
    </script>


    @yield('scripts')

    {{-- livechat --}}
    {!! json_decode(site('livechat')) !!}

</body>



</html>
