<!Doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="msapplication-TileColor" content="#0e041f">
    <meta name="theme-color" content="#0e041f">
    <title> {{ $page_title }} | {{ site('name') }}</title>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.14.8/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <!-- swiper  -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/11.0.5/swiper-bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/11.0.5/swiper-bundle.min.css" />

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    {{-- plus jakarta sans font  --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/5.0.0/normalize.min.css">
    {{-- sweet alert css --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.min.css">

    <link rel="stylesheet" href="{{ asset('/assets/templates/zyphor/css/main.css') }}">



    <link rel="shortcut icon" href="{{ asset('/assets/images/' . site('favicon')) }}" type="image/x-icon">
    <link rel="apple-touch-icon" href="{{ asset('/assets/images/' . site('favicon')) }}" type="image/x-icon">

    <style>
        .button-spinner {
            border: 4px solid #f3f3f3;
            /* Light grey background */
            border-top: 4px solid #ea2a97b6;
            /* Blue color for the spinner */
            border-radius: 50%;
            width: 25px;
            height: 25px;
            animation: spin 1s linear infinite;
            /* Spinning animation */
            position: absolute;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .not-allowed-cursor {
            cursor: not-allowed;
        }

        .disabled {
            background-color: #1d1c1c !important;
            cursor: not-allowed !important;
            color: transparent !important;
            font-weight: bold;
            pointer-events: none !important;
            cursor: not-allowed;
            /* padding: 15px; */
        }

        .otp-input::-webkit-outer-spin-button,
        .otp-input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        @layer base {

            /* Webkit-based browsers (Chrome, Safari) */
            input[type="number"]::-webkit-outer-spin-button,
            input[type="number"]::-webkit-inner-spin-button {
                -webkit-appearance: none;
                margin: 0;
            }

            /* Firefox */
            input[type="number"] {
                -moz-appearance: textfield;
            }
        }
    </style>

    <style>
        .gradient-tab {
            color: #FF59CA;
        }

        .gen-gradient {
            background: linear-gradient(315deg, #E1D2F9 0%, #FF59CA 100%);
        }

        .btn-gradient {
            background: linear-gradient(315deg, #4B149E 0%, #EA2A97 100%);
        }

        .gradient-border {
            position: relative;
            width: 100%;
            /* max-width: 800px; */
            /* padding: 30px 40px; */
            border-radius: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: transparent;
        }

        .gradient-border::before {
            content: "";
            position: absolute;
            inset: 0;
            border-radius: 12px;
            padding: 2px;
            /* Border width */
            background: linear-gradient(90deg, #EA2A97, #4B149E, #4B149E);
            -webkit-mask: linear-gradient(#fff 0 0) content-box,
                linear-gradient(#fff 0 0);
            -webkit-mask-composite: xor;
            mask-composite: exclude;
            pointer-events: none;
        }
    </style>

    <style>
        .sidebar-transition {
            transition: width 0.3s ease, transform 0.3s ease;
        }

        /* @media (max-width: 768px) {
            .sidebar-closed {
                transform: translateX(-100%);
            }
        } */
    </style>

    @yield('css')
    {{-- @vite(['public/assets/templates/zyphor/css/main.css']) --}}
</head>

<body class="bg-[#0e041f]">
    {{-- preloader  --}}
    @if (site('preloader') == 1)
        @include('templates.' . site('template') . '.loaders.preloader')
    @endif
    {{-- preloader ends  --}}

    <div id="app" class="flex h-screen overflow-hidden relative">

        {{-- sidebar --}}
        <div id="sidebar"
            class="bg-[#250A4F] text-white w-64 sidebar-transition lg:block hidden z-50 min-h-screen lg:relative absolute">
            <div class="p-4 flex justify-end items-center">
                <button id="closeSidebar" class="lg:hidden block">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 transition-transform duration-300"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>


            <nav class="flex-1 flex flex-col lg:py-20">
                <div class="space-y-2" id="navigation-items">
                    <!-- Navigation items will be inserted here by jQuery -->
                </div>

                <div class="text-center w-full py-20 px-5">
                    <a role="button" class="text-red-500 flex gap-2 items-center cursor-pointer logout">
                        <img src="{{ asset('assets/templates/zyphor/images/logout_icon.svg') }}" alt="">
                        <span class="">Logout</span>
                    </a>
                </div>
            </nav>
        </div>


        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Navbar -->
            <header class="block shadow-sm">
                {{-- desktop --}}
                <div class="hidden lg:flex justify-between items-center">
                    <div class="flex items-center p-4 justify-start">
                        <img id="sidebar-logo" src="{{ asset('assets/images/' . site('logo_rec')) }}" alt="Logo"
                            class="w-60" />
                    </div>

                    <div class="relative p-4" x-data="{ open: false }">
                        <!-- Profile Button -->
                        <button @click="open = !open"
                            class="rounded-full focus:outline-none focus:ring-offset-2 focus:ring-none flex gap-10 items-center bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)] hover:bg-[linear-gradient(315deg,_#f272d5_0%,_#cb9ff0_100%)] py-2 px-4 cursor-pointer">
                            <img src="{{ asset('storage/profile/' . user()->photo) }}" alt="Profile Icon"
                                class="h-8 w-8 rounded-full" />
                            <p hidden class="text-black text-sm ">{{ user()->name ?? 'Not Set' }}</p>
                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="8" viewBox="0 0 12 8"
                                fill="none">
                                <path d="M11 1.50004C11 1.50004 7.31756 6.49999 5.99996 6.5C4.68237 6.50001 1 1.5 1 1.5"
                                    stroke="#0F0420" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round" />
                            </svg>
                        </button>

                        <!-- Dropdown Menu -->
                        <div x-show="open" @click.away="open = false"
                            class="absolute right-0 mt-2 w-48 bg-[#250A4F] backdrop-blur-sm shadow-lg rounded-lg overflow-hidden z-50">
                            <a href="{{ route('user.profile.index') }}"
                                class="block px-4 py-3 text-gray-200 hover:text-[#bd7fee]">My
                                Profile</a>
                            <a href="{{ route('user.profile.edit') }}"
                                class="block px-4 py-3 text-gray-200 hover:text-[#bd7fee]">Edit
                                Profile</a>
                            <a href="{{ route('user.kyc.index') }}"
                                class="block px-4 py-3 text-gray-200 hover:text-[#bd7fee]">KYC</a>
                            <button type="button"
                                class="w-full text-left px-4 py-2 text-gray-200 bg-[#ea0a0e] cursor-pointer logout">
                                Logout
                            </button>
                        </div>
                    </div>
                </div>

                {{-- mobile --}}
                <div class="flex lg:hidden justify-between items-center">
                    <div class="flex items-center"> <a href="{{ route('user.dashboard') }}"> <img
                                src="{{ asset('assets/images/' . site('logo_rec')) }}" alt="Logo"
                                class="w-32 md:w-40" /></a>

                    </div>

                    <div class="flex items-center">
                        <div x-data="{ open: false }" class="relative">
                            <!-- Profile Button mobile and tablet -->

                            <button class="rounded-full focus:outline-none  focus:ring-offset-2 flex items-center"
                                @click="open = !open">
                                <img src="{{ asset('storage/profile/' . user()->photo) }}" alt="Profile Icon"
                                    class="h-8 w-8 rounded-full" />
                            </button>
                            <!-- Dropdown Menu -->
                            <div x-show="open" @click.away="open = false"
                                class="absolute -right-10 mt-2 w-48 z-50 bg-[#250A4F]  shadow-lg rounded-lg overflow-hidden">
                                <a href="{{ route('user.profile.index') }}"
                                    class="block px-4 py-3 text-gray-200 hover:text-[#bd7fee]">My
                                    Profile</a>
                                <a href="{{ route('user.profile.edit') }}"
                                    class="block px-4 py-3 text-gray-200 hover:text-[#bd7fee]">Edit Profile</a>
                                <a href="{{ route('user.kyc.index') }}"
                                    class="block px-4 py-3 text-gray-200 hover:text-[#bd7fee]">KYC</a>
                                <button type="button"
                                    class="w-full text-left px-4 py-2 text-gray-200 bg-[#ea0a0e] logout">
                                    Logout
                                </button>
                            </div>

                        </div>

                        <button id="openSidebar" class="text-gray-300">
                            <!-- Hamburger Icon -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 transition-transform duration-300"
                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                        </button>
                    </div>
                </div>
            </header>
            <!-- Content Area -->
            <main class="flex-1 overflow-y-auto p-4">

                @yield('contents')



                {{-- logout modal --}}
                <div id="logOutModal"
                    class="fixed inset-0 bg-opacity-50 flex items-center justify-end lg:px-6 px-2 backdrop-blur-xs hidden"
                    style="z-index: 50;">
                    <div
                        class="bg-[#0F0420] rounded-lg w-full lg:w-[35vw]  lg:p-14 p-4 relative z-10  mx-auto backdrop-blur-lg max-h-[90vh] overflow-y-auto">

                        <div class="flex justify-between items-center lg:mb-10 mb-4">
                            <h2 class="text-xl font-semibold mb-4 text-white">Confirm Logout</h2>

                            <button id="closeLogOutModal" class="text-gray-400 hover:text-gray-600">
                                <img src="{{ asset('/assets/templates/zyphor/images/cancel-circle.svg') }}"
                                    alt="icon">
                            </button>
                        </div>

                        <!-- Modal Content -->
                        <div class="block bg-[#372E45] rounded-2xl p-6">

                            <p class="text-center text-white text-lg mb-4">
                                Are you sure you want to
                                <span class="text-red-500"> logout</span>?
                            </p>

                            <form method="POST" action="{{ route('user.logout') }}" class="gen-form"
                                data-action="redirect" data-url="{{ url('/') }}">
                                @csrf
                                <center>
                                    <button type="submit"
                                        class="text-center rounded-lg px-4 py-2 text-gray-200 bg-[#ea0a0e] hover:bg-red-800 cursor-pointer ">
                                        Logout
                                    </button>
                                </center>
                            </form>
                        </div>

                    </div>
                </div>

            </main>
        </div>


    </div>



    {{-- sidebar script  --}}
    <script>
        $(document).ready(function() {
            // Navigation items data
            const navigationItems = [{
                    name: 'Dashboard',
                    icon: "{{ asset('assets/templates/zyphor/images/dashboard-icon.svg') }}",
                    hasDropdown: false,
                    link: "{{ route('user.dashboard') }}",
                    active: "{{ request()->routeIs('user.dashboard') }}"
                },
                {
                    name: 'Deposit',
                    icon: "{{ asset('assets/templates/zyphor/images/deposit-icon.svg') }}",
                    hasDropdown: false,
                    link: "{{ route('user.deposits.index') }}",
                    active: "{{ request()->routeIs('user.deposits.index') }}"
                },
                {
                    name: 'Withdraw',
                    icon: "{{ asset('assets/templates/zyphor/images/withdrawal-icon.svg') }}",
                    hasDropdown: false,
                    link: "{{ route('user.withdrawals.index') }}",
                    active: "{{ request()->routeIs('user.withdrawals.index') }}"

                },
                {
                    name: 'AI Bots',
                    icon: "{{ asset('assets/templates/zyphor/images/ai-bots-icon.svg') }}",
                    hasDropdown: false,
                    link: "{{ route('user.bots.index') }}",
                    active: "{{ request()->routeIs('user.bots.index') }}"

                },

                {
                    name: 'P2p',
                    icon: "{{ asset('assets/templates/zyphor/images/peer-to-peer-icon.svg') }}",
                    hasDropdown: false,
                    link: "{{ route('user.transfers.index') }}",
                    active: "{{ request()->routeIs('user.transfers.index') }}"

                },
                {
                    name: 'My Referrals',
                    icon: "{{ asset('assets/templates/zyphor/images/referrals-icon.svg') }}",
                    hasDropdown: false,
                    link: "{{ route('user.referrals') }}",
                    active: "{{ request()->routeIs('user.referrals') }}"


                },
                {
                    name: 'My Transactions',
                    icon: "{{ asset('assets/templates/zyphor/images/transaction-icon.svg') }}",
                    hasDropdown: false,
                    link: "{{ route('user.transactions.index') }}",
                    active: "{{ request()->routeIs('user.transactions.index') }}"

                }
            ];



            // Set active menu item based on current URL
            const currentPath = window.location.href;
            navigationItems.forEach(item => {
                if (currentPath === item.link) {
                    item.active = true;
                }
            });

            // Variables for tracking state
            let isSidebarOpen = false;

            // Render navigation items
            function renderNavigationItems() {
                $('#navigation-items').empty();

                navigationItems.forEach((item, index) => {
                    const navItem = $(`
                <div class="relative">
                    <a href="${item.link}" 
                        class="flex items-center gap-1 px-1 transition-all duration-300 rounded-lg  ${item.active ? ' text-white gen-gradient'  : 'text-white/50 hover:text-gray-600'}" 
                        data-index="${index}">
                        <div class="relative w-10 h-10 flex items-center justify-center rounded-full ${item.active ? 'text-white' : 'bg-transparent'}">
                            <img src="${item.icon}" class="h-5 w-5" alt="${item.name}" />
                        </div>
                        <span class="text-sm text-center">${item.name}</span>
                    </a>
                </div>
            `);

                    $('#navigation-items').append(navItem);
                });
            }



            // Initial render
            renderNavigationItems();
        });
    </script>


    {{-- toggle --}}
    <script>
        $(document).ready(function() {
            // Toggle sidebar on mobile only
            $('#openSidebar').on('click', function() {
                $('#sidebar').removeClass('hidden').removeClass('sidebar-closed');
            });

            $('#closeSidebar').on('click', function() {
                $('#sidebar').addClass('hidden').addClass('sidebar-closed');
            });
        });
    </script>


    {{-- logout modal --}}
    <script>
        // log out
        $(document).on("click", ".logout", function() {
            $("#logOutModal").removeClass("hidden");
        });

        // Close Logout Modal  
        $(document).on("click", "#closeLogOutModal", function() {
            $("#logOutModal").addClass("hidden");
        });
    </script>

    {{-- qrcode --}}
    <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>

    {{-- Include SweetAlert2 JavaScript file --}}
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.all.min.js"></script>
    <script src="{{ asset('/assets/templates/zyphor/scripts/dashboard.js') }}"></script>

    @yield('scripts')
    @stack('scripts')



    {{-- livechat --}}
    {!! json_decode(site('livechat')) !!}



</body>

</html>
