@php

    $page_title = 'About ' . site('name');
    $short_description =
        site('name') .
        ' uses advanced Ai robots trained on extensive trading data and algorithms to analyze market trends and execute profitable trades with high precision.';

@endphp

{{-- layout --}}
@extends('templates.' . site('template') . '.layouts.front')

@section('css')
@endsection


@section('contents')
    {{-- hero section  --}}
    <section class="pt-8 px-6  bg-cover bg-center max-w-[90rem] mx-auto rounded-3xl"
        style="background-image: url('{{ asset('/assets/templates/zyphor/images/hero-background.png') }}');">

        <div class=" min-h-[600px] lg:min-h-[800px]  flex flex-col lg:flex-row items-center relative overflow-y-hidden">


            <!-- Text Content -->
            <div class="lg:w-1/2 flex flex-col justify-center text-start md:text-center lg:text-start h-full">
                <h1
                    class="text-3xl md:text-5xl font-[1000] text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] py-1.5">

                    Welcome To <span class="md:block">{{ site('name') }}</span>
                </h1>
                <p class="text-[#fbfbfb] my-8 text-sm md:text-base max-w-lg mx-auto lg:mx-0 ">
                    At {{ site('name') }}, we revolutionize trading with an intuitive, AI-powered platform. Our advanced
                    robots, trained on vast market data, simplify trading and maximize efficiency—delivering a seamless,
                    intelligent experience.
                </p>

                <div class="flex justify-start md:justify-center lg:justify-start space-x-4 md:gap-8">
                    @if (user())
                        <a href="{{ route('user.dashboard') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-gradient-to-r from-[#4b149e] to-[#ea2a97] hover:bg-gradient-to-l text-[#fbfbfb] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs  inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Dashboard</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                    @else
                        <a href="{{ route('user.register') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-gradient-to-r from-[#4b149e] to-[#ea2a97] hover:bg-gradient-to-l text-[#fbfbfb] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs  inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Sign Up</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                        <a href="{{ route('user.login') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-[#ebd1f3] text-[#250a4f] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:bg-gradient-to-r from-[#4b149e] to-[#ea2a97]  inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Log in</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                    @endif
                </div>
            </div>

            <!-- Image Content -->
            <div class="lg:w-1/2 flex justify-end items-center mt-6 md:mt-0 py-4 lg:py-0">
                <img src="{{ asset('/assets/templates/zyphor/images/about-hero.png') }}" alt="AI Robot"
                    class="max-w-full h-auto max-h-[200px] md:max-h-[300px] lg:max-h-full mx-auto z-10" />
            </div>
        </div>
    </section>

    {{-- users deposits withdrawals countries section  --}}
    <section class="max-w-[90rem] mx-auto px-6">
        <div
            class="bg-[#372e45] rounded-3xl flex flex-col md:flex-row justify-between items-center text-center text-white px-6 py-6 gap-6 md:gap-0">
            <!-- Users -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">3.5k+</h2>
                <p class="text-sm text-gray-300">Users</p>
            </div>

            <!-- Deposits -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 5.5M+</h2>
                <p class="text-sm text-gray-300">Deposits</p>
            </div>

            <!-- Withdrawals -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 10.2M+</h2>
                <p class="text-sm text-gray-300">Withdrawals</p>
            </div>

            <!-- Countries -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">200+</h2>
                <p class="text-sm text-gray-300">Countries Supported</p>
            </div>
        </div>
    </section>


    {{-- about section  --}}
    <section class="pt-8 px-6 md:pt-12">
        <div class="max-w-5xl mx-auto min-h-[40vh] flex flex-col justify-center items-center relative bg-no-repeat bg-center bg-contain"
            style="background-image: url('{{ asset('/assets/templates/zyphor/images/about-globe-image.png') }}');">
            <img class="absolute right-20 md:right-40 lg:right-20 top-0 -z-10"
                src="{{ asset('/assets/templates/zyphor/images/circle-group.svg') }}">
            <div
                class="absolute right-20 md:right-60 lg:right-96 top-0 p-16 md:p-32 bg-[#ea2a97]/25 rounded-full blur-3xl  -z-10">
            </div>
            <h4 class="text-white text-center text-sm  font-semibold 
                ">
                About {{ site('name') }}
            </h4>

            <h2
                class="text-xl md:text-3xl font-semibold  mt-2  p-2 text-center text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] w-fit mx-auto mb-2">
                Discover {{ site('name') }}
            </h2>
            <p class="text-sm md:text-base text-white p-1 md:leading-relaxed text-center">
                {{ site('name') }} uses advanced AI robots trained o extensive trading data and algorithms to nalayze
                market trends and xecute profitable trades with high precision.
            </p>
        </div>
    </section>

    {{-- leading with innovation section  --}}
    <section class="pt-8 md:pt-20 px-6  text-[#4b5563] relative">


        <div class=" mx-auto flex flex-col md:flex-row-reverse items-center justify-between max-w-7xl lg:gap-20">
            <div class="w-full md:w-1/2 relative ">
                <div class="relative max-w-32 md:max-w-60 mx-auto">
                    <img src="{{ asset('/assets/templates/zyphor/images/leading-with-innovation-image.png') }}"
                        alt="AI Robot" class="w-full rounded-lg relative">

                    <div
                        class="absolute inset-0 p-32 md:p-40 bg-gradient-to-l from-[#4b149e]/30 to-[#ea2a97]/30 rounded-full blur-3xl -z-10">
                    </div>
                </div>


            </div>
            <div class="w-full md:w-1/2 mb-8 md:mb-0 ">
                <h2
                    class="text-2xl md:text-3xl lg:text-4xl font-bold mb-6 text-transparent bg-clip-text bg-gradient-to-r  from-[#e1d2f9] to-[#fad1e8] w-fit mx-start py-1">
                    Leading with Innovation</h2>
                <p class=" text-sm md:text-base leading-relaxed text-[#fbfbfb]">
                    Innovation drives us. We have harnessed the power
                    of artificial intelligence and machine learning to
                    create a trading ecosystem that adapts and evolves
                    in real-time. Our AI robots analyze market trends
                    with high precision, ensuring that every trade
                    executed is strategically aligned for profitability.
                </p>
            </div>


        </div>
    </section>

    {{-- the technology behind section  --}}
    <section class="pt-4 md:pt-20 px-6  text-[#4b5563] relative">


        <div class="mx-auto flex flex-col md:flex-row items-center justify-between max-w-7xl lg:gap-20">
            <div class="w-full md:w-1/2 relative ">
                <div class="relative w-60 h-60 mx-auto">
                    <img src="{{ asset('/assets/templates/zyphor/images/technology-behind-img.png') }}" alt="AI Robot"
                        class="w-full rounded-lg relative">

                    <div
                        class="absolute inset-0 p-32 md:p-40 bg-gradient-to-l from-[#4b149e]/15 to-[#ea2a97]/15 rounded-full blur-3xl -z-10">
                    </div>
                </div>


            </div>
            <div class="w-full md:w-1/2 mb-8 md:mb-0 ">
                <h2
                    class="text-2xl md:text-3xl lg:text-4xl font-bold mb-6 text-transparent bg-clip-text bg-gradient-to-r  from-[#e1d2f9] to-[#fad1e8] w-fit mx-start py-1">
                    The Technology Behind {{ site('name') }}</h2>
                <p class=" text-sm md:text-base leading-relaxed text-[#fbfbfb]">
                    Our technology is the backbone of {{ site('name') }}. We have invested extensively in building a
                    sophisticated
                    platform that can handle the intricacies of today's financial markets. Our AI robots are at the heart of
                    this technology, constantly learning and evolving to stay ahead of market shifts.
                </p>
            </div>


        </div>
    </section>

    {{-- the team section  --}}
    <section class="pt-4 md:pt-20 px-6  text-[#4b5563] relative">

        <img class="absolute right-20 md:right-40 lg:right-96 top-0 lg:top-20 -z-10"
            src="{{ asset('/assets/templates/zyphor/images/circle-group.svg') }}">
        <div class=" mx-auto items-center justify-between max-w-7xl">

            <div class="w-full mb-6 ">
                <h2
                    class="text-2xl md:text-3xl lg:text-4xl font-bold mb-6 text-center  text-transparent bg-clip-text bg-gradient-to-r  from-[#e1d2f9] to-[#fad1e8] w-fit mx-auto py-1">
                    The {{ site('name') }} Team</h2>
                <p class=" text-sm md:text-base leading-relaxed text-center text-[#fbfbfb]">
                    Behind every groundbreaking technology stands a team of passionate experts. At {{ site('name') }}, our
                    team is a
                    dynamic blend of seasoned traders, data scientists, and cutting-edge technologists, each bringing deep
                    industry knowledge and expertise. United by a shared vision, we continuously refine and innovate our
                    platform, ensuring {{ site('name') }} stays ahead of market trends and remains a leader in AI-driven
                    trading
                    solutions. Our commitment to excellence drives us to push boundaries, optimize strategies, and deliver
                    an unparalleled trading experience.
                </p>
            </div>
            <div class="w-full relative ">
                <div class="relative max-w-4xl mx-auto">
                    <img src="{{ asset('/assets/templates/zyphor/images/the-team-img.png') }}" alt="AI Robot"
                        class="w-full rounded-lg relative">

                    <div
                        class="absolute inset-0 p-32 md:p-40 bg-gradient-to-l from-[#4b149e]/15 to-[#ea2a97]/15 rounded-full blur-3xl -z-10">
                    </div>
                </div>


            </div>
        </div>
    </section>

    {{-- upholding values section  --}}
    <section class="pt-8 md:pt-20 px-6  text-[#4b5563] relative">


        <div class=" mx-auto flex flex-col md:flex-row-reverse items-center justify-between max-w-7xl lg:gap-20">
            <div class="w-full md:w-1/2 relative ">
                <div class="relative max-w-32 md:max-w-60 mx-auto">
                    <img src="{{ asset('/assets/templates/zyphor/images/upholding-values-image.png') }}" alt="AI Robot"
                        class="w-full rounded-lg relative">

                    <div
                        class="absolute inset-0 p-32 md:p-40 bg-gradient-to-l from-[#4b149e]/30 to-[#ea2a97]/30 rounded-full blur-3xl -z-10">
                    </div>
                </div>


            </div>
            <div class="w-full md:w-1/2 mb-8 md:mb-0 ">
                <h2
                    class="text-2xl md:text-3xl lg:text-4xl font-bold mb-6 text-transparent bg-clip-text bg-gradient-to-r  from-[#e1d2f9] to-[#fad1e8] w-fit mx-start py-1">
                    Upholding Values of Integrity and Transparency</h2>
                <p class=" text-sm md:text-base leading-relaxed text-[#fbfbfb]">
                    At {{ site('name') }}, integrity and transparency are non-negotiable values. We prioritize your
                    security and satisfaction above all else. We've created a secure and user-friendly trading environment
                    where you can confidently pursue your financial goals.

                </p>
            </div>


        </div>
    </section>

    {{-- connecting with us  --}}
    <section class="pt-8 px-6 md:pt-12 bg-no-repeat bg-center bg-cover"
        style="background-image: url('{{ asset('/assets/templates/zyphor/images/connecting-with-img.png') }}');">
        <div class="max-w-7xl mx-auto min-h-[40vh] flex flex-col justify-center items-center relative ">

            <div
                class="absolute right-20 md:right-60 lg:right-96 top-0 p-16 md:p-32 bg-[#ea2a97]/25 rounded-full blur-3xl  -z-10">
            </div>


            <h2
                class="text-2xl md:text-3xl lg:text-4xl font-bold  mt-2  p-2 text-center text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] w-fit mx-auto mb-4">
                Connecting With {{ site('name') }}
            </h2>
            <p class="text-sm md:text-base text-white p-1 md:leading-relaxed text-center max-w-5xl">
                With {{ site('name') }}, you're not just trading; you're part of a revolutionary movement in the world of
                finance. Join us today and experience the future of trading - where innovation, technology, and your success
                converge.

            </p>


            <div class="flex justify-center space-x-4 md:gap-8 mt-4 md:mt-8">
                @if (user())
                    <a href="{{ route('user.dashboard') }}"
                        class="relative px-9 py-2 rounded-3xl text-base bg-gradient-to-r from-[#4b149e] to-[#ea2a97] hover:bg-gradient-to-l text-[#fbfbfb] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs  inline-flex items-center cursor-pointer">
                        <span class="mr-2  font-semibold">Dashboard</span>
                        <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                            class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                    </a>
                @else
                    <a href="{{ route('user.register') }}"
                        class="relative px-9 py-2 rounded-3xl text-base bg-gradient-to-r from-[#4b149e] to-[#ea2a97] hover:bg-gradient-to-l text-[#fbfbfb] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs  inline-flex items-center cursor-pointer">
                        <span class="mr-2  font-semibold">Sign Up</span>
                        <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                            class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                    </a>
                    <a href="{{ route('user.login') }}"
                        class="relative px-9 py-2 rounded-3xl text-base bg-[#ebd1f3] text-[#250a4f] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:bg-gradient-to-r from-[#4b149e] to-[#ea2a97]  inline-flex items-center cursor-pointer">
                        <span class="mr-2  font-semibold">Log in</span>
                        <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                            class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                    </a>
                @endif
            </div>
        </div>
    </section>
@endsection

@section('scripts')
@endsection
