@php

    use App\Models\Bot;

    $page_title = 'Contact Us';
    $short_description = 'We are available 24/7. You can reach us via any of the means below.';

@endphp

{{-- layout --}}
@extends('templates.' . site('template') . '.layouts.front')

@push('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.min.css">
@endpush


@section('css')
@endsection


@section('contents')
    {{-- hero section  --}}
    <section class="pt-8 px-6 bg-cover bg-center max-w-[90rem] mx-auto rounded-3xl"
        style="background-image: url('{{ asset('/assets/templates/zyphor/images/hero-background-2.png') }}');">

        <div class="min-h-[600px] lg:min-h-[800px] flex justify-center items-center text-center relative overflow-y-hidden">
            <!-- Text Content -->
            <div class="flex flex-col justify-center items-center">
                <h1
                    class="text-3xl md:text-5xl font-[1000] text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] py-1.5">
                    Contact Us
                </h1>
                <p class="text-[#fbfbfb] my-8 text-sm md:text-base max-w-3xl">
                    Our team is available at any time, day or night, to assist you. You can reach out to us 24/7 through any
                    of the contact methods listed below.
                </p>
            </div>
        </div>
    </section>


    {{-- contact elements section  --}}
    <section class="pt-8 px-6 md:pt-12">
        <div class="max-w-5xl mx-auto min-h-[40vh] flex flex-col justify-center items-center relative bg-no-repeat bg-center bg-contain"
            style="background-image: url('{{ asset('/assets/templates/zyphor/images/about-globe-image.png') }}');">
            <img class="absolute right-20 md:right-40 lg:right-20 top-0 -z-10"
                src="{{ asset('/assets/templates/zyphor/images/circle-group.svg') }}">
            <div
                class="absolute right-20 md:right-60 lg:right-96 top-0 p-16 md:p-32 bg-[#ea2a97]/25 rounded-full blur-3xl  -z-10">
            </div>
            <div class="flex flex-col md:flex-row gap-6 justify-between items-center p-6 w-full">
                <!-- Call Card -->
                <div
                    class="w-64 p-6 rounded-2xl bg-[#250a4f]/70 border border-[#ea2a97]/20 text-center text-white shadow-lg">
                    <div class="flex justify-center items-center mb-4">
                        <div class="w-12 h-12   flex items-center justify-center">
                            <img src="{{ asset('/assets/templates/zyphor/images/phone-icon.png') }}" alt="">
                        </div>
                    </div>
                    <p class="text-lg font-semibold">Call</p>
                    <p class="text-sm text-gray-300">{{ site('phone') }}</p>
                </div>

                <!-- Email Card -->
                <div
                    class="w-64 p-6 rounded-2xl bg-[#250a4f]/70 border border-[#ea2a97]/20 text-center text-white shadow-lg">
                    <div class="flex justify-center items-center mb-4">
                        <div class="w-12 h-12  flex items-center justify-center">
                            <img src="{{ asset('/assets/templates/zyphor/images/email-icon.png') }}" alt="">
                        </div>
                    </div>
                    <p class="text-lg font-semibold">Email</p>
                    <p class="text-sm text-gray-300">{{ site('email') }}</p>
                </div>

                <!-- Office Card -->
                <div
                    class="w-64 p-6 rounded-2xl bg-[#250a4f]/70 border border-[#ea2a97]/20 text-center text-white shadow-lg">
                    <div class="flex justify-center items-center mb-4">
                        <div class="w-12 h-12  flex items-center justify-center">
                            <img src="{{ asset('/assets/templates/zyphor/images/location-icon.png') }}" alt="">
                        </div>
                    </div>
                    <p class="text-lg font-semibold">Office</p>
                    <p class="text-sm text-gray-300">{{ site('address') }}</p>
                </div>
            </div>

        </div>
    </section>

    {{-- contact form section  --}}
    <section class="pt-8 md:pt-20 px-6 mb-10 relative">
        <div class="max-w-5xl mx-auto">
            <div class="bg-[#190735] rounded-2xl p-6 md:p-10 relative overflow-hidden shadow-md">

                <h2
                    class="text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] text-2xl md:text-3xl font-bold w-fit mx-auto mb-4">
                    Got a message for us?</h2>

                <p class="text-[#fbfbfb] text-sm md:text-base text-center mb-4">Let's hear from you.</p>

                <form action="{{ route('contact-validate') }}" method="post" enctype="multipart/form-data"
                    class="text-[#fbfbfb] gen-form" data-action="reset">
                    @csrf
                    <div class="space-y-6">
                        <input type="email" name="email" id="email"
                            class="w-full p-4  border border-[#ea2a97]/30 rounded-3xl focus:outline-none  transition-colors"
                            placeholder="Email Address*" required>

                        <input type="text" name="subject" id="subject"
                            class="w-full p-4  border border-[#ea2a97]/30 rounded-3xl focus:outline-none  transition-colors"
                            placeholder="Subject" required>

                        <textarea name="message" id="message" rows="6"
                            class="w-full p-4  border border-[#ea2a97]/30 rounded-3xl focus:outline-none  transition-colors"
                            placeholder="Message" required></textarea>

                        <div class="flex justify-center md:justify-end">
                            <button type="submit"
                                class="px-12 py-3 rounded-3xl bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] hover:scale-105 transition duration-300 text-[#250a4f] font-medium cursor-pointer">
                                Send Message
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection

@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.6/dist/sweetalert2.all.min.js"></script>
@endsection
