@php

    use App\Models\Bot;

    $page_title = 'Frequently Asked Questions';
    $short_description =
        'Prior to availing any of our services, we kindly request that you review and acknowledge our Acceptable Use Terms of Service. Your utilization of our services constitutes your agreement to abide by the terms and conditions outlined therein. We appreciate your understanding and compliance.';

@endphp

{{-- layout --}}
@extends('templates.' . site('template') . '.layouts.front')

@section('css')
@endsection


@section('contents')
    {{-- hero section  --}}

    <section class="pt-8 px-6 bg-cover bg-center max-w-[90rem] mx-auto rounded-3xl"
        style="background-image: url('{{ asset('/assets/templates/zyphor/images/hero-background-2.png') }}');">

        <div class="min-h-[600px] lg:min-h-[800px] flex justify-center items-center text-center relative overflow-y-hidden">
            <!-- Text Content -->
            <div class="flex flex-col justify-center items-center">
                <h1
                    class="text-3xl md:text-5xl font-[1000] text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] py-1.5">
                    Frequently Asked Questions
                </h1>
                <p class="text-[#fbfbfb] my-8 text-sm md:text-base max-w-3xl">
                    Here are some of the most common questions our users ask, along with detailed answers to help you find
                    the information you need quickly and easily.
                </p>
            </div>
        </div>
    </section>

    {{-- faq section  --}}
    <section class="w-full mb-10 relative">
        <div class="w-[90%] mx-auto py-10 relative">

            <img class="absolute right-20 md:right-40 lg:right-20 top-0 -z-10"
                src="{{ asset('/assets/templates/zyphor/images/circle-group.svg') }}">
            <div
                class="absolute right-20 md:right-60 lg:right-96 top-0 p-16 md:p-32 bg-[#ea2a97]/25 rounded-full blur-3xl  -z-10">
            </div>
            <div class="max-w-screen-lg mx-auto relative" x-data="{
                faqs: [{
                        question: 'What is {{ site('name') }}?',
                        answer: '{{ site('name') }} is an advanced trading platform that utilizes AI technology to analyze market trends and execute trades with high precision.'
                    },
                    {
                        question: 'How can I get started with {{ site('name') }}?',
                        answer: 'Getting started is simple. Sign up for an account, complete the verification process, and you can begin trading.'
                    },
                    {
                        question: 'Is my personal information secure with {{ site('name') }}?',
                        answer: 'Yes, we take data security seriously. We employ industry-standard measures to protect your information.'
                    },
                    {
                        question: 'Can I trade on {{ site('name') }} from anywhere?',
                        answer: 'Absolutely. {{ site('name') }} allows you to trade from anywhere with an internet connection.'
                    },
                    {
                        question: 'Do I need prior trading experience to use {{ site('name') }}?',
                        answer: 'No, {{ site('name') }} is designed for both beginners and experienced traders. We offer educational resources to help you get started.'
                    },
                    {
                        question: 'What fees are associated with using {{ site('name') }}?',
                        answer: 'We charge competitive fees, which are transparently displayed on our platform. There are no hidden charges.'
                    },
                    {
                        question: 'Can I withdraw my profits easily?',
                        answer: 'Yes, withdrawing your profits is straightforward. You can initiate withdrawals through your account.'
                    },
                    {
                        question: 'Is customer support available?',
                        answer: 'Absolutely. Our customer support team is here to assist you with any questions or issues you may have.'
                    },
                    {
                        question: 'How often are trading signals generated?',
                        answer: '{{ site('name') }} generates trading signals continuously, ensuring you have access to up-to-date market information.'
                    }
                ]
            }">
                <ul class="w-full ">
                    <template x-for="(faq, index) in faqs" :key="index">
                        <li class="mb-5">
                            <div x-data="{ open: false }">
                                <button @click="open = !open"
                                    class="flex justify-between items-center w-full px-4 py-3 bg-white/5 rounded-xl text-left border border-[#ea2a97]/20">
                                    <span class="text-[#fbfbfb] text-lg font-semibold" x-text="faq.question"></span>
                                    <span class="text-[#fbfbfb] text-xl transition-transform duration-300"
                                        :class="{ 'rotate-45': open }">+</span>
                                </button>
                                <div x-show="open" x-collapse>
                                    <div class="w-full px-4 py-4 bg-white/10 rounded-b-xl">
                                        <p class="text-[#fbfbfb]" x-text="faq.answer"></p>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </template>
                </ul>
            </div>
        </div>
    </section>
@endsection

@section('scripts')
@endsection
