@php
    use App\Models\DepositCoin;
    use App\Models\Bot;
    use Faker\Factory as Faker;

    $page_title = 'Home';
    $faker = Faker::create();
    $logos = DepositCoin::inRandomOrder()->take(20)->get('logo_url');

    $bots = Bot::get();

    // $deposit_methods = ['usdttrc20'];
    // $methods = DepositCoin::where('status', 1)->get();
    // foreach ($methods as $method) {
    //     array_push($deposit_methods, $method->code);
    // }

    // // Check if the count is less than 20
    // while (count($deposit_methods) < 20) {
    //     $deposit_methods[] = 'usdttrc20';
    // }

    $actions = [
        'deposited',
        'withdrew',
        'withdrew',
        'deposited',
        'withdrew',
        'deposited',
        'withdrew',
        'withdrew',
        'withdrew',
        'withdrew',
        'withdrew',
        'withdrew',
    ];

    $whys = [
        'Cutting-Edge Precision',
        'Trendsetter Advantage',
        'Adaptive Excellence',
        'Seamless Profits',
        'Data-Driven Triumph',
        'Strategic Partner',
        'Constant Success',
        'Market Pioneer',
        'Automated Mastery',
    ];
    $reviews = [
        [
            'image' => 'review-image-1.jpg',
            'name' => 'Adrian',
            'country' => 'UK',
            'testimony' =>
                site('name') .
                "'s precision trading is a game-changer, consistently delivering impressive profits. I trust it for my financial success.",
            'date' => '5/03/2023',
        ],
        [
            'image' => 'review-image-2.jpg',
            'name' => 'Madison',
            'country' => 'USA',
            'testimony' =>
                'Effortless trading with ' .
                site('name') .
                '. Its adaptability and data-driven approach make it a standout choice. Highly recommended!',
            'date' => '7/02/2024',
        ],
        [
            'image' => 'review-image-3.jpg',
            'name' => 'Schneider',
            'country' => 'Germany',
            'testimony' =>
                'Seamless trades, constant profits - ' .
                site('name') .
                " simplifies trading. It's a must-have for anyone in the market.",
            'date' => '5/04/2024',
        ],
        [
            'image' => 'review-image-4.jpg',
            'name' => 'Tommy',
            'country' => 'South Africa',
            'testimony' =>
                site('name') .
                "'s innovative strategies and consistent returns have transformed my trading experience. It's a valuable asset to any trader.",
            'date' => '2/05/2024',
        ],
        [
            'image' => 'review-image-5.jpg',
            'name' => 'Jannet',
            'country' => 'USA',
            'testimony' =>
                'I rely on ' .
                site('name') .
                " for its adaptability in fluctuating markets. It's a proven partner in achieving financial goals.",
            'date' => '13/06/2024',
        ],
        [
            'image' => 'review-image-6.jpg',
            'name' => 'Thomas',
            'country' => 'England',
            'testimony' =>
                site('name') .
                "'s automated precision is remarkable. It's a powerful tool for navigating today's complex trading landscape.",
            'date' => '27/08/2024',
        ],
        [
            'image' => 'review-image-7.jpg',
            'name' => 'Atlan',
            'country' => 'Germany',
            'testimony' =>
                'Maximized profits with ' .
                site('name') .
                '. Its results speak volumes. A reliable and intelligent trading companion.',
            'date' => '1/10/2024',
        ],
        [
            'image' => 'review-image-8.jpg',
            'name' => 'Kelvin',
            'country' => 'UK',
            'testimony' =>
                'Trading with ' .
                site('name') .
                ' is effortless and rewarding. It adapts to market changes seamlessly. Truly impressive!',
            'date' => '15/10/2024',
        ],
        [
            'image' => 'review-image-9.jpg',
            'name' => 'Jude',
            'country' => 'Canada',
            'testimony' =>
                site('name') .
                ' has changed my trading game. Its data-driven approach delivers consistent gains. An invaluable tool for success.',
            'date' => '7/11/2024',
        ],
        [
            'image' => 'review-image-10.jpg',
            'name' => 'Jude',
            'country' => 'Australia',
            'testimony' =>
                'Effortless trading made possible by ' .
                site('name') .
                ' .  Its strategic prowess sets it apart. A game-changer for traders.',
            'date' => '23/1/2025',
        ],
    ];

    $short_description = site('seo_description');

@endphp

@extends('templates.' . site('template') . '.layouts.front')

@section('css')
@endsection


@section('contents')
    {{-- <div class="absolute right-0 top-0 p-40 md:p-48 lg:p-68 bg-[#7dd3fc]/40 rounded-full blur-3xl  -z-10"></div> --}}

    {{-- hero section  --}}
    <section class="pt-8 px-6  bg-cover bg-center max-w-[90rem] mx-auto rounded-3xl"
        style="background-image: url('{{ asset('/assets/templates/zyphor/images/hero-background.png') }}');">

        <div class=" min-h-[600px] lg:min-h-[800px]  flex flex-col lg:flex-row items-center relative overflow-y-hidden">


            <!-- Text Content -->
            <div class="lg:w-1/2 flex flex-col justify-center text-start md:text-center lg:text-start h-full">
                <h1
                    class="text-3xl md:text-5xl font-[1000] text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] py-1.5">

                    Simplified Trading, Steady Profits- Powered by AI Excellence
                </h1>
                <p class="text-[#fbfbfb] my-8 text-sm md:text-base max-w-lg mx-auto lg:mx-0 ">
                    {{ site('name') }} uses advanced Ai robots trained on extensive trading data and algorithms to analyze
                    market trends and execute profitable trades with high precision. Our AI bots maintain an average 5%
                    daily PNL.
                </p>

                <div class="flex justify-start md:justify-center lg:justify-start space-x-4 md:gap-8">
                    @if (user())
                        <a href="{{ route('user.dashboard') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-gradient-to-r from-[#4b149e] to-[#ea2a97] hover:bg-gradient-to-l text-[#fbfbfb] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs  inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Dashboard</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                    @else
                        <a href="{{ route('user.register') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-gradient-to-r from-[#4b149e] to-[#ea2a97] hover:bg-gradient-to-l text-[#fbfbfb] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs  inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Sign Up</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                        <a href="{{ route('user.login') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-[#ebd1f3] text-[#250a4f] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:bg-gradient-to-r from-[#4b149e] to-[#ea2a97]  inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Log in</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                    @endif
                </div>
            </div>

            <!-- Image Content -->
            <div class="lg:w-1/2 flex justify-end items-center mt-6 md:mt-0 py-4 lg:py-0">
                <img src="{{ asset('/assets/templates/zyphor/images/index-hero-image.png') }}" alt="AI Robot"
                    class="max-w-full h-auto max-h-[200px] md:max-h-[300px] lg:max-h-full mx-auto z-10" />
            </div>
        </div>
    </section>

    {{-- users deposits withdrawals countries section  --}}
    <section class="max-w-[90rem] mx-auto px-6">
        <div
            class="bg-[#372e45] rounded-3xl flex flex-col md:flex-row justify-between items-center text-center text-white px-6 py-6 gap-6 md:gap-0">
            <!-- Users -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">3.5k+</h2>
                <p class="text-sm text-gray-300">Users</p>
            </div>

            <!-- Deposits -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 5.5M+</h2>
                <p class="text-sm text-gray-300">Deposits</p>
            </div>

            <!-- Withdrawals -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 10.2M+</h2>
                <p class="text-sm text-gray-300">Withdrawals</p>
            </div>

            <!-- Countries -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">200+</h2>
                <p class="text-sm text-gray-300">Countries Supported</p>
            </div>
        </div>
    </section>


    {{-- unlocking markets section  --}}
    <section class="pt-8 md:pt-20 px-6 relative">


        <div class="max-w-6xl mx-auto text-center">
            <div class="relative">
                <div
                    class="absolute right-20 md:right-60 lg:right-96 top-0 p-20 bg-gradient-to-r from-[#4b149e]/50 to-[#ea2a97]/50 rounded-full blur-3xl  -z-10">
                </div>
                <h2
                    class="text-2xl md:text-4xl text-center font-semibold text-transparent bg-clip-text bg-gradient-to-r  from-[#e1d2f9] to-[#fad1e8] mb-4 md:mb-8">
                    Unlocking New Market Opportunities
                    <span class="block mt-2 text-xl md:text-3xl">Maximizing Sustainable and Profitable Returns</span>

                </h2>
                <p class=" text-[#fbfbfb] text-center max-w-4xl mx-auto">
                    Your ultimate trading companion, utilizing cutting-edge technology to unlock new market potentials
                    and
                    amplify your investment returns like never before.
                </p>
            </div>

            <div class="container mx-auto px-4 py-16">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <!-- Bullish or Bearish Section -->
                    <div class="relative p-0.5 rounded-xl bg-gradient-to-r from-[#4b149e]/50 to-[#ea2a97]/50"
                        style="clip-path: polygon(0% 0%, 85% 0%, 100% 15%, 100% 100%, 0% 100%);">
                        <!-- Inner container with original background -->
                        <div class="bg-[#250a4f] rounded-[calc(0.75rem-1px)] p-6 flex flex-col justify-between h-full"
                            style="clip-path: polygon(0% 0%, 85% 0%, 100% 15%, 100% 100%, 0% 100%);">
                            <div>
                                <div class="mb-4">
                                    <img src="{{ asset('/assets/templates/zyphor/images/automated-process.png') }}"
                                        alt="" class="w-20 mx-auto">
                                </div>
                                <h2 class="text-2xl font-bold mb-4 text-[#fbfbfb]">Bullish or Bearish</h2>
                                <p class="text-gray-300">Harnessing cutting-edge technology to navigate even the toughest
                                    market
                                    conditions, ensuring your financial goals remain within reach even in a bearish trend.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Automated Process Section -->
                    <div class="relative p-0.5 rounded-xl bg-gradient-to-r from-[#4b149e]/50 to-[#ea2a97]/50">
                        <!-- Inner container with original background -->
                        <div class="bg-[#250a4f] rounded-[calc(0.75rem-1px)] p-6 flex flex-col justify-between h-full">
                            <div>
                                <div class="mb-4">
                                    <img src="{{ asset('/assets/templates/zyphor/images/automated-process.png') }}"
                                        alt="" class="w-20 mx-auto">
                                </div>
                                <h2 class="text-2xl font-bold mb-4 text-[#fbfbfb]">Automated Process</h2>
                                <p class="text-gray-300">Our cutting-edge technology automates every step of the trading
                                    process, ensuring seamless market navigation and optimizing your strategy for maximum
                                    success.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Guaranteed Profit Section -->
                    <div class="relative p-0.5 rounded-xl bg-gradient-to-r from-[#4b149e]/50 to-[#ea2a97]/50"
                        style="clip-path: polygon(15% 0%, 100% 0%, 100% 100%, 0% 100%, 0% 15%);">
                        <!-- Inner container with original background -->
                        <div class="bg-[#250a4f] rounded-[calc(0.75rem-1px)] p-6 flex flex-col justify-between h-full"
                            style="clip-path: polygon(15% 0%, 100% 0%, 100% 100%, 0% 100%, 0% 15%);">
                            <div>
                                <div class="mb-4">
                                    <img src="{{ asset('/assets/templates/zyphor/images/guaranteed-profit.png') }}"
                                        alt="" class="w-20 mx-auto">
                                </div>
                                <h2 class="text-2xl font-bold mb-4 text-[#fbfbfb]">Guaranteed Profit</h2>
                                <p class="text-gray-300">Leverage our cutting-edge AI-driven approach to secure consistent
                                    profits. With intelligent automation and data-driven insights, we ensure your trading
                                    remains profitable and reliable.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    {{-- pricing section  --}}
    <section class="pt-8 md:pt-12 px-6 md:px-0">
        <h4 class="text-white text-center text-sm mx-auto uppercase px-12 py-1 rounded-2xl">
            Pricing
        </h4>
        <h2 class="text-white font-bold text-2xl md:text-3xl lg:text-4xl text-center mt-4 md:mt-6 lg:mb-20">
            AI-Trading Portfolios
        </h2>

        <!-- Cards Section -->
        <div class="w-full my-10">
            <div class="grid lg:grid-cols-3 grid-cols-1 gap-10 max-w-7xl mx-auto">

                @foreach ($bots as $bot)
                    <div
                        class="col-span-1 relative text-white p-6 rounded-4xl  overflow-hidden bg-[#250a4f] border border-[#ea2a97]/50 
                    {{ $loop->index == 1 ? 'bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] lg:scale-110' : '' }}">
                        <div class="flex gap-4 mb-4">
                            <img src="{{ asset('storage/bots/' . $bot->logo) }}" alt="icon"
                                class="rounded-full h-7 w-7">
                            <p class="{{ $loop->index == 1 ? 'text-black' : 'text-white' }}">{{ $bot->name }}</p>
                        </div>

                        <div class="flex text-white py-4 justify-start items-center gap-4">
                            <p
                                class="{{ $loop->index == 1 ? 'text-transparent bg-clip-text bg-gradient-to-r from-[#4b149e] to-[#ea2a97] text-3xl lg:text-5xl font-bold' : 'text-3xl lg:text-5xl font-bold ' }}">
                                {{ $bot->daily_min }}% -
                                {{ $bot->daily_max }}%</p>
                            <p class="{{ $loop->index == 1 ? 'text-black font-bold' : ' font-bold' }}">/day</p>
                        </div>

                        <div class="block lg:py-7 py-4 md:space-y-2">
                            <p class="flex justify-between">
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-left' : 'text-[#fbfbfb] block text-left' }}">Portfolio
                                    Range</span>
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-right font-semibold' : 'text-[#fbfbfb] block text-right font-semibold' }}">{{ site('currency_symbol') . $bot->min }}
                                    -
                                    {{ site('currency_symbol') . $bot->max }}</span>
                            </p>

                            <p class="flex justify-between">
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-left' : 'text-[#fbfbfb] block text-left' }}">Daily
                                    PNL</span>
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-right font-semibold' : 'text-[#fbfbfb] block text-right font-semibold' }}">{{ $bot->daily_min }}%
                                    -
                                    {{ $bot->daily_max }}%</span>
                            </p>

                            <p class="flex justify-between">
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-left' : 'text-[#fbfbfb] block text-left' }}">Trading
                                    Duration</span>
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-right font-semibold' : 'text-[#fbfbfb] block text-right font-semibold' }}">{{ $bot->duration }}
                                    {{ $bot->duration_type }}</span>
                            </p>

                            <p class="flex justify-between">
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-left' : 'text-[#fbfbfb] block text-left' }}">Capital
                                    Returned</span>
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-right font-semibold' : 'text-[#fbfbfb] block text-right font-semibold' }}">Yes</span>
                            </p>
                        </div>



                        <div class="block lg:py-7 py-4 {{ $loop->index == 1 ? 'text-black' : 'text-[#fbfbfb]' }}">
                            <p
                                class="{{ $loop->index == 1 ? 'text-black font-bold mb-3' : 'text-[#fbfbfb] font-bold mb-3' }}">
                                Tradings Days</p>
                            @php
                                $trading_days_display = [
                                    'monday' => in_array('monday', json_decode(site('trading_days'))),
                                    'tuesday' => in_array('tuesday', json_decode(site('trading_days'))),
                                    'wednesday' => in_array('wednesday', json_decode(site('trading_days'))),
                                    'thursday' => in_array('thursday', json_decode(site('trading_days'))),
                                    'friday' => in_array('friday', json_decode(site('trading_days'))),
                                    'saturday' => in_array('saturday', json_decode(site('trading_days'))),
                                    'sunday' => in_array('sunday', json_decode(site('trading_days'))),
                                ];
                            @endphp
                            @foreach ($trading_days_display as $day => $day_display)
                                <p
                                    class="flex flex-row-reverse justify-between items-center border-b-2 border-[#ffffff]/10 last:border-b-0 py-2">
                                    @if ($day_display)
                                        <img src="{{ asset('/assets/templates/zyphor/images/checkmark-icon.svg') }}"
                                            alt="">
                                    @else
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                            class="w-4 h-4 text-red-500" viewBox="0 0 16 16">
                                            <path
                                                d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                        </svg>
                                    @endif
                                    <span class="block text-left">{{ ucfirst($day) }}</span>
                                </p>
                            @endforeach
                        </div>

                        <div class="block text-center lg:py-7">
                            <a href="{{ route('user.bots.index') }}"
                                class="px-12 py-3 rounded-3xl transition duration-300 cursor-pointer bg-gradient-to-r {{ $loop->index == 1 ? '  from-[#4b149e] to-[#ea2a97]' : 'from-[#e1d2f9] to-[#fad1e8] text-black' }}">Activate</a>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </section>

    {{-- slider for coins --}}
    <section class="pt-8 md:pt-20 ">
        <div class="w-full bg-[#372e45] ">
            <div class="flex justify-center pt-5">
                <div class="livecoinwatch-widget-5" lcw-base="USD" lcw-color-tx="#fbfbfb" lcw-marquee-1="coins"
                    lcw-marquee-1="movers" lcw-marquee-items="10" lcw-width="100%">
                </div>
            </div>
        </div>

    </section>

    {{-- why choose rescron section  --}}
    <section class="pt-8 md:pt-20 px-6 mb-4 relative">


        <div class="max-w-7xl mx-auto bg-cover bg-no-repeat bg-center"
            style="background-image:  url('{{ asset('/assets/templates/zyphor/images/bg-supercharged.png') }}');">


            <div class="">
                <h4 class="text-[#fbfbfb] text-center text-sm uppercase mb-4 md:mb-8 ">
                    Supercharged AI
                </h4>
                <h2
                    class="text-3xl md:text-5xl mx-auto font-semibold text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] mt-2 py-2 w-fit mb-4 md:mb-8">
                    Why Choose {{ site('name') }}?
                </h2>
                <p class="text-sm md:text-xl text-center text-[#fbfbfb] p-1 md:leading-relaxed mb-4 md:mb-8">
                    {{ site('name') }} doesn't just follow trends - it pioneers them. It
                    empowers traders to navigate both bullish and bearish market
                    conditions with unwavering confidence. By leveraging sophisticated
                    algorithms and real-time data streams, {{ site('name') }} adapts to
                    ever-changing market dynamics, seizing opportunities while
                    minimizing risks.
                </p>

                <div class="max-w-7xl mx-auto flex flex-wrap gap-4 justify-center">
                    <!-- Row 1 -->
                    <div class="bg-white/10 rounded-4xl border border-white/50 px-4 py-2 flex items-center gap-3 w-auto">

                        <div class="text-[#fbfbfb] font-medium">Cutting-Edge Precision</div>
                    </div>

                    <div class="bg-white/10 rounded-4xl border border-white/50 px-4 py-2 flex items-center gap-3 w-auto">

                        <div class="text-[#fbfbfb] font-medium">Exclusive Trendsetter Advantage & Benefits</div>
                    </div>

                    <div class="bg-white/10 rounded-4xl border border-white/50 px-4 py-2 flex items-center gap-3 w-auto">

                        <div class="text-[#fbfbfb] font-medium">Adaptive Excellence</div>
                    </div>

                    <!-- Row 2 -->
                    <div class="bg-white/10 rounded-4xl border border-white/50 px-4 py-2 flex items-center gap-3 w-auto">

                        <div class="text-[#fbfbfb] font-medium">Seamless & Consistent Profit</div>
                    </div>

                    <div class="bg-white/10 rounded-4xl border border-white/50 px-4 py-2 flex items-center gap-3 w-auto">

                        <div class="text-[#fbfbfb] font-medium">Data-Driven Growth & Triumph</div>
                    </div>

                    <div class="bg-white/10 rounded-4xl border border-white/50 px-4 py-2 flex items-center gap-3 w-auto">

                        <div class="text-[#fbfbfb] font-medium">Trusted & Strategic Partner</div>
                    </div>

                    <!-- Row 3 -->
                    <div class="bg-white/10 rounded-4xl border border-white/50 px-4 py-2 flex items-center gap-3 w-auto">

                        <div class="text-[#fbfbfb] font-medium">Leading Market Innovator</div>
                    </div>

                    <div class="bg-white/10 rounded-4xl border border-white/50 px-4 py-2 flex items-center gap-3 w-auto">

                        <div class="text-[#fbfbfb] font-medium">Consistent Progress and Lasting Success</div>
                    </div>

                    <div class="bg-white/10 rounded-4xl border border-white/50 px-4 py-2 flex items-center gap-3 w-auto">

                        <div class="text-[#fbfbfb] font-medium">Automated Mastery</div>
                    </div>
                </div>

                <div class="flex justify-center space-x-4 md:gap-8 mt-8 md:mt-12">
                    @if (user())
                        <a href="{{ route('user.dashboard') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-gradient-to-r from-[#4b149e] to-[#ea2a97] hover:bg-gradient-to-l text-[#fbfbfb] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs  inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Dashboard</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                    @else
                        <a href="{{ route('user.register') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-gradient-to-r from-[#4b149e] to-[#ea2a97] hover:bg-gradient-to-l text-[#fbfbfb] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:shadow-xs  inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Sign Up</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                        <a href="{{ route('user.login') }}"
                            class="relative px-9 py-2 rounded-3xl text-base bg-[#ebd1f3] text-[#250a4f] hover:bg-[#250a4f] hover:text-[#ebd1f3] hover:bg-gradient-to-r from-[#4b149e] to-[#ea2a97]  inline-flex items-center cursor-pointer">
                            <span class="mr-2  font-semibold">Log in</span>
                            <img src="{{ asset('/assets/templates/zyphor/images/login-arrow.svg') }}" alt=""
                                class="absolute right-2 top-1/2 -translate-y-1/2 h-7 w-7">
                        </a>
                    @endif
                </div>

            </div>
        </div>
    </section>

    {{-- coin carousel --}}
    {{-- <section
        class="w-full px-5 md:px-20 py-4  bg-gradient-to-r from-[#f0f4ff]/30 to-[#ffffff] flex items-center backdrop-blur-sm">
        <div class="glide w-full">
            <div class="glide__track" data-glide-el="track">
                <ul class="glide__slides flex items-center">
                    @foreach ($logos as $logo)
                        <li class="glide__slide w-auto flex items-center">
                            <div class="w-16 h-16 flex items-center justify-center">
                                <img class="rounded-full h-8 w-8 cursor-pointer"
                                    src="{{ 'https://nowpayments.io' . $logo->logo_url }}" alt="">
                            </div>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </section> --}}

    {{-- trade from anywhere section  --}}
    <section class="pt-8 md:pt-20 px-6 mb-4 relative">

        <div class="max-w-7xl mx-auto">
            <h2
                class="text-3xl md:text-4xl w-fit mx-auto font-semibold text-transparent bg-clip-text bg-gradient-to-r  from-[#e1d2f9] to-[#fad1e8]  text-center mb-4 md:mb-8">
                Trade From Anywhere
            </h2>

            <p class="text-[#fbfbfb] text-sm md:text-xl text-center md:leading-relaxed">
                Whether you're at home or on the go, seize market opportunities anytime,
                anywhere, and secure your financial future effortlessly. Trade from any
                and every city
            </p>

            <div class="relative w-full mt-8">
                <!-- Background container -->
                <div class="absolute inset-0 bg-cover bg-center bg-no-repeat opacity-10"
                    style="background-image: url('{{ asset('/assets/templates/zyphor/images/bg-trade.png') }}')">
                </div>

                <!-- Content container with blur -->
                <div class="relative p-4 md:p-8 rounded-3xl ">
                    <div class="w-full px-2 md:px-10  text-white">
                        <div class="w-full">
                            <div class="w-full p-3">
                                <div class="w-full overflow-x-auto max-h-[50vh] overflow-y-auto"
                                    id="recentTradesContainer">
                                    <table class="w-full">
                                        <thead class="">
                                            <tr class="text-left bg-[#250a4f] text-[#fbfbfb]">
                                                <th class="p-4">Trading Pair</th>
                                                <th class="p-4 text-right">Amount</th>
                                                <th class="p-4 text-right">Time</th>
                                                <th class="p-4 text-right">Profit</th>
                                            </tr>
                                        </thead>
                                        <tbody class="w-full" id="recentTrades">
                                            <!-- Trades will be populated here -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    {{-- testimonial section  --}}
    <section class="pt-8 md:pt-20 px-6 mb-4 ">

        <div class="max-w-7xl mx-auto lg:py-10 px-3 relative">
            <div
                class="absolute right-20 md:right-60 lg:right-96 top-0 p-20 bg-gradient-to-r from-[#4b149e]/50 to-[#ea2a97]/50 rounded-full blur-3xl  -z-10">
            </div>
            <img class="absolute right-20 md:right-40 lg:right-20 top-0 -z-10"
                src="{{ asset('/assets/templates/zyphor/images/circle-group.svg') }}">
            />
            <h4 class="text-white text-center text-sm  font-semibold 
                ">
                Our Users Say
            </h4>

            <h2
                class="text-3xl md:text-5xl font-semibold  mt-2  p-2 text-center text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] w-fit mx-auto">
                Don't Just Take Our Word For It
            </h2>

            <h4 class="text-white text-center text-sm font-semibold mb-4 
             lg:mb-10 mt-2 ">
                Here is what our many users around the world are saying about our amazing product.
            </h4>

            <div class="w-full relative">
                <div class="max-w-6xl mx-auto">
                    <!-- Splide Slider -->
                    <div class="splide" id="testimonial-slider">
                        <div class="splide__track">
                            <ul class="splide__list">
                                @foreach ($reviews as $review)
                                    <li class="splide__slide px-2 md:px-4">
                                        <div
                                            class="bg-white/3 rounded-lg p-6 border border-[#ea2a97] min-h-60 md:min-h-40">
                                            <div class="flex items-center mb-4">
                                                {{-- <img src="{{ asset('/assets/templates/zyphor/images/' . $review['image']) }}"
                                                    alt="{{ $review['name'] }}" class="w-10 h-10 rounded-full mr-3"> --}}
                                                {{-- <div>
                                                    <p class="font-medium">{{ $review['name'] }}</p>
                                                </div> --}}
                                            </div>
                                            <p
                                                class="text-center text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] w-fit mx-auto mb-4">
                                                {{ $review['testimony'] }}</p>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- how it works  --}}
    <section class="pt-8 md:pt-20 px-6 mb-4 relative">


        <div class="max-w-7xl mx-auto gap-8 lg:gap-16 items-center">

            <div class="mb-4">
                <h4 class="text-white text-center text-sm  font-semibold 
                ">
                    Getting Started
                </h4>

                <h2
                    class="text-3xl md:text-5xl font-semibold  mt-2  p-2 text-center text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] w-fit mx-auto">
                    How It Works
                </h2>
                <p class="text-sm md:text-xl text-white p-1 md:leading-relaxed text-center">
                    Our user-friendly interface and intuitive features ensure that even newcomers can quickly grasp the
                    essentials and embark on a seamless journey into the world of efficient and profitable trading.
                </p>

            </div>

            <img src="{{ asset('assets/templates/zyphor/images/how-it-works-image.png') }}" alt=""
                class="w-full mx-auto">
        </div>





    </section>

    {{-- market heatmap section  --}}
    <section class="pt-8 md:pt-20 px-2 mb-4 relative">
        <div
            class="absolute right-20 md:right-60 lg:right-96 top-40 p-32 md:p-60 bg-gradient-to-l from-[#4b149e]/50 to-[#ea2a97]/50 rounded-full blur-3xl  -z-10">
        </div>
        <div class="max-w-7xl mx-auto">
            <h4 class="text-white text-center text-sm uppercase px-12 py-1 rounded-2xl font-semibold">
                Market Data
            </h4>

            <h2
                class="text-3xl md:text-5xl font-semibold text-transparent bg-clip-text bg-gradient-to-r  from-[#e1d2f9] to-[#fad1e8] mt-2 mb-4 p-2 w-fit mx-auto">
                Market Overview
            </h2>

            <div id="cryptoApp" class="p-4 relative">


                <div class="overflow-x-auto">
                    <table class="w-full bg-[#372e45]/60 rounded-3xl">
                        <thead class=" text-white border-b border-b-[#e1d2f9]/10">
                            <tr>
                                <th class="p-3 text-center">Logo</th>
                                <th class="p-3 text-start">Name</th>
                                <th class="p-3 text-start">Symbol</th>
                                <th class="p-3 text-start">Price (USD)</th>
                                <th class="p-3 text-start">24h Change</th>
                            </tr>
                        </thead>
                        <tbody id="cryptoTableBody" class=" text-[#ffffff]">
                            <!-- Table rows will be appended here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

    {{-- unlocking wealth section  --}}
    <section class="pt-8 md:pt-20 px-6 mb-4 md:mb-8 relative">
        <div
            class="absolute right-20 md:right-60 lg:right-96 top-0 p-32 md:p-60 bg-gradient-to-l from-[#4b149e]/50 to-[#ea2a97]/50 rounded-full blur-3xl  -z-10">
        </div>
        <img class="absolute right-20 md:right-40 lg:right-20 top-0 -z-10"
            src="{{ asset('/assets/templates/zyphor/images/circle-group.svg') }}">

        <div class="max-w-3xl mx-auto">
            <h2
                class="text-3xl md:text-5xl font-semibold text-transparent bg-clip-text bg-gradient-to-r  from-[#e1d2f9] to-[#fad1e8] mb-4 md:mb-8 p-2 w-fit mx-auto text-center">
                Unlocking Wealth
                with Simplicity
            </h2>

            <p class="text-white text-center text-base">Experience hassle-free trading with AI-driven precision,
                simplifying market navigation and making
                wealth-building more accessible, efficient, and rewarding for everyone.</p>
        </div>
    </section>
@endsection

@section('scripts')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            new Glide('.glide', {
                type: 'carousel',
                perView: Math.floor(window.innerWidth / 80), // Adjust based on screen width
                focusAt: 'center',
                autoplay: 2000, // Speed of slide
                hoverpause: true,
                gap: 20,
                animationDuration: 1000,
                rewind: false, // Disable rewind for continuous effect
                breakpoints: {
                    1024: {
                        perView: 6
                    },
                    768: {
                        perView: 4
                    },
                    480: {
                        perView: 2
                    }
                }
            }).mount();
        });
    </script>
    <script defer src="https://www.livecoinwatch.com/static/lcw-widget.js"></script>

    {{-- recent trades script --}}
    <script>
        let tradeData = @json(recentTrades());


        function updateTradeTable() {
            const tableBody = document.getElementById("recentTrades");
            tableBody.innerHTML = ""; // Clear existing rows

            tradeData.forEach((trade) => {
                const row = document.createElement("tr");
                row.className = ` mb-2 hover:bg-white/5 transition-colors ${
                trade.profit.startsWith("-") ? "text-[#EA0A0E]" : "text-[#00AA39]"
                }`;

                row.innerHTML = `
                    <td class="p-2">${trade.pair}</td>
                    <td class="p-2 text-right">${trade.amount}</td>
                    <td class="p-2 text-right"><span class="recent_trade_time"></span></td>
                    <td class="p-2 text-right">${trade.profit}</td>
                `;

                tableBody.appendChild(row);
            });
        }

        function updateTradeTimes() {
            const tradeTimeElements = document.querySelectorAll('.recent_trade_time');
            const currentTime = new Date().toLocaleTimeString();

            tradeTimeElements.forEach((element) => {
                element.textContent = currentTime;
            });
        }

        // Function to swap first row to last every 2 seconds
        function rotateRows() {
            if (tradeData.length > 1) {
                const firstRow = tradeData.shift(); // Remove first row
                tradeData.push(firstRow); // Add it to the end
                updateTradeTable(); // Refresh the table with new order
                updateTradeTimes();
            }
        }

        // Initial table setup
        updateTradeTable();

        // Start row rotation every 2 seconds
        setInterval(rotateRows, 1000);
    </script>

    {{-- splide js cdn  --}}
    <script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@3.6.1/dist/js/splide.min.js"></script>

    <!-- Initialize Splide -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            new Splide('#testimonial-slider', {
                type: 'loop',
                perPage: 2, // Adjust based on screen size
                perMove: 1,
                gap: '2rem',
                breakpoints: {
                    1024: {
                        perPage: 2
                    },
                    768: {
                        perPage: 1
                    }
                },
                autoplay: true,
                interval: 3000,
                pauseOnHover: true,
                pagination: true,
                arrows: true,
            }).mount();
        });
    </script>

    {{-- testimonial script  --}}
    <script>
        ////////////////////// testimonials customized button
        $(document).ready(function() {
            var splide = new Splide('#testimonial-slider', {
                type: 'loop',
                perPage: 2,
                perMove: 1,
                autoplay: true,
                interval: 4000, // Adjust autoplay speed
                pauseOnHover: true,
                pagination: false, // Hide default pagination
                arrows: false, // Hide default arrows
                breakpoints: {
                    1024: {
                        perPage: 1, // Display 1 slide at a time on smaller screens
                    },
                },
            }).mount();

            // Custom Buttons Functionality
            $('#prevBtn').on('click', function() {
                splide.go('-1');
            });

            $('#nextBtn').on('click', function() {
                splide.go('+1');
            });
        });
    </script>

    {{-- market heatmap script  --}}
    <script>
        $(document).ready(function() {
            const coins = [{
                    id: "bitcoin",
                    name: "Bitcoin",
                    logo: "{{ asset('/assets/templates/zyphor/images/bitcoin-btc-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "BTC",
                },
                {
                    id: "ethereum",
                    name: "Ethereum",
                    logo: "{{ asset('/assets/templates/zyphor/images/ethereum-eth-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "ETH",
                },
                {
                    id: "ripple",
                    name: "Ripple",
                    logo: "{{ asset('/assets/templates/zyphor/images/ripple-logo.webp') }}",
                    price: 0,
                    change: 0,
                    symbol: "XRP",
                },
                {
                    id: "binancecoin",
                    name: "Binance Coin",
                    logo: "{{ asset('/assets/templates/zyphor/images/binance-coin-bnb-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "BNB",
                },
                {
                    id: "solana",
                    name: "Solana",
                    logo: "{{ asset('/assets/templates/zyphor/images/solana-sol-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "SOL",
                },
                {
                    id: "dogecoin",
                    name: "Dogecoin",
                    logo: "{{ asset('/assets/templates/zyphor/images/dogecoin-doge-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "DOGE",
                },
                {
                    id: "cardano",
                    name: "Cardano",
                    logo: "{{ asset('/assets/templates/zyphor/images/cardano-ada-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "ADA",
                },
                {
                    id: "tron",
                    name: "Tron",
                    logo: "{{ asset('/assets/templates/zyphor/images/tron-trx-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "TRX",
                },
                {
                    id: "avalanche-2",
                    name: "Avalanche",
                    logo: "{{ asset('/assets/templates/zyphor/images/avalanche-avax-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "AVAX",
                },
                {
                    id: "sui",
                    name: "Sui",
                    logo: "{{ asset('/assets/templates/zyphor/images/sui-sui-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "SUI",
                },
                {
                    id: "pepe",
                    name: "Pepe",
                    logo: "{{ asset('/assets/templates/zyphor/images/pepe-pepe-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "PEPE",
                },
                {
                    id: "toncoin",
                    name: "Toncoin",
                    logo: "{{ asset('/assets/templates/zyphor/images/toncoin-ton-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "TON",
                },
                {
                    id: "stellar",
                    name: "Stellar",
                    logo: "{{ asset('/assets/templates/zyphor/images/stellar-xlm-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "XLM",
                },
                {
                    id: "chainlink",
                    name: "Chainlink",
                    logo: "{{ asset('/assets/templates/zyphor/images/chainlink-link-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "LINK",
                },
                {
                    id: "shiba-inu",
                    name: "Shiba Inu",
                    logo: "{{ asset('/assets/templates/zyphor/images/shiba-inu-shib-logo.png') }}",
                    price: 0,
                    change: 0,
                    symbol: "SHIB",
                },
            ];

            function fetchData() {
                const apiUrl =
                    `https://api.coingecko.com/api/v3/simple/price?ids=${coins.map(coin => coin.id).join(",")}&vs_currencies=usd&include_24hr_change=true`;

                $.ajax({
                    url: apiUrl,
                    type: "GET",
                    success: function(data) {
                        coins.forEach(coin => {
                            if (data[coin.id]) {
                                coin.price = parseFloat(data[coin.id].usd).toFixed(2);
                                coin.change = parseFloat(data[coin.id].usd_24h_change);
                            }
                        });
                        renderTable();
                    },
                    error: function(error) {
                        console.error("Error fetching cryptocurrency data:", error);
                    }
                });
            }

            function renderTable() {
                const tableBody = $('#cryptoTableBody');
                tableBody.empty(); // Clear previous data before appending new

                coins.forEach(coin => {
                    const row = `
                        <tr class="border-b border-b-[#e1d2f9]/10 hover:bg-[#372e45]/90">
                            <td class="p-3"><img src="${coin.logo}" alt="${coin.name}" class="w-8 h-8 mx-auto"></td>
                            <td class="p-3 font-medium">${coin.name}</td>
                            <td class="p-3">${coin.symbol}</td>
                            <td class="p-3 font-bold">$${coin.price}</td>
                            <td class="p-3 font-bold ${coin.change > 0 ? 'text-green-500' : 'text-red-500'}">
                                ${coin.change > 0 ? '+' : ''}${coin.change.toFixed(2)}%
                            </td>
                        </tr>
                    `;
                    tableBody.append(row);
                });
            }

            fetchData(); // Fetch data on page load
            setInterval(fetchData, 30000); // Refresh data every 30 seconds
        });
    </script>
@endsection
