@php

    use App\Models\DepositCoin;
    use App\Models\Bot;
    use Faker\Factory as Faker;

    $page_title = 'Pricing ' . site('name');
    $short_description =
        site('name') .
        ' uses advanced Ai robots trained on extensive trading data and algorithms to analyze market trends and execute profitable trades with high precision.';

    $faker = Faker::create();
    $logos = DepositCoin::inRandomOrder()->take(20)->get('logo_url');

    $bots = Bot::get();

@endphp

{{-- layout --}}
@extends('templates.' . site('template') . '.layouts.front')

@section('css')
@endsection


@section('contents')
    {{-- hero section  --}}
    <section class="pt-8 px-6 bg-cover bg-center max-w-[90rem] mx-auto rounded-3xl"
        style="background-image: url('{{ asset('/assets/templates/zyphor/images/hero-background-2.png') }}');">

        <div class="min-h-[600px] lg:min-h-[800px] flex justify-center items-center text-center relative overflow-y-hidden">
            <!-- Text Content -->
            <div class="flex flex-col justify-center items-center">
                <h1
                    class="text-3xl md:text-5xl font-[1000] text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] py-1.5">
                    AI Bot Pricing
                </h1>
                <p class="text-[#fbfbfb] my-8 text-sm md:text-base max-w-3xl">
                    We offer a diverse range of portfolio options for our advanced trading bots, ensuring that there is a
                    plan tailored to suit every budget and investment preference. Explore our selection and choose the
                    option that best aligns with your financial goals and comfort level.
                </p>
            </div>
        </div>
    </section>


    {{-- users deposits withdrawals countries section  --}}
    <section class="max-w-[90rem] mx-auto px-6 relative -top-40">
        <div
            class="bg-[#372e45] rounded-3xl flex flex-col md:flex-row justify-between items-center text-center text-white px-6 py-6 gap-6 md:gap-0">
            <!-- Users -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">3.5k+</h2>
                <p class="text-sm text-gray-300">Users</p>
            </div>

            <!-- Deposits -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 5.5M+</h2>
                <p class="text-sm text-gray-300">Deposits</p>
            </div>

            <!-- Withdrawals -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 10.2M+</h2>
                <p class="text-sm text-gray-300">Withdrawals</p>
            </div>

            <!-- Countries -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">200+</h2>
                <p class="text-sm text-gray-300">Countries Supported</p>
            </div>
        </div>
    </section>


    {{-- pricing section  --}}
    <section class="pt-8 md:pt-12 px-6 md:px-0 mb-4 md:mb-20 relative">
        <img class="absolute right-20 md:right-40 lg:right-80 top-0 -z-10"
            src="{{ asset('/assets/templates/zyphor/images/circle-group.svg') }}">
        <div
            class="absolute right-20 md:right-60 lg:right-96 top-10 md:top-40 p-32 md:p-60 bg-gradient-to-l from-[#4b149e]/50 to-[#ea2a97]/50 rounded-full blur-3xl  -z-10">
        </div>
        <h4 class="text-white text-center text-sm mx-auto uppercase px-12 py-1 rounded-2xl">
            Pricing
        </h4>
        <h2 class="text-white font-bold text-2xl md:text-3xl lg:text-4xl text-center mt-4 md:mt-6 lg:mb-20">
            AI-Trading Portfolios
        </h2>

        <!-- Cards Section -->
        <div class="w-full my-10">
            <div class="grid lg:grid-cols-3 grid-cols-1 gap-10 max-w-7xl mx-auto">

                @foreach ($bots as $bot)
                    <div
                        class="col-span-1 relative text-white p-6 rounded-4xl  overflow-hidden bg-[#250a4f] border border-[#ea2a97]/50 
                    {{ $loop->index == 1 ? 'bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] lg:scale-110' : '' }}">
                        <div class="flex gap-4 mb-4">
                            <img src="{{ asset('storage/bots/' . $bot->logo) }}" alt="icon"
                                class="rounded-full h-7 w-7">
                            <p class="{{ $loop->index == 1 ? 'text-black' : 'text-white' }}">{{ $bot->name }}</p>
                        </div>

                        <div class="flex text-white py-4 justify-start items-center gap-4">
                            <p
                                class="{{ $loop->index == 1 ? 'text-transparent bg-clip-text bg-gradient-to-r from-[#4b149e] to-[#ea2a97] text-3xl lg:text-5xl font-bold' : 'text-3xl lg:text-5xl font-bold ' }}">
                                {{ $bot->daily_min }}% -
                                {{ $bot->daily_max }}%</p>
                            <p class="{{ $loop->index == 1 ? 'text-black font-bold' : ' font-bold' }}">/day</p>
                        </div>

                        <div class="block lg:py-7 py-4 md:space-y-2">
                            <p class="flex justify-between">
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-left' : 'text-[#fbfbfb] block text-left' }}">Portfolio
                                    Range</span>
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-right font-semibold' : 'text-[#fbfbfb] block text-right font-semibold' }}">{{ site('currency_symbol') . $bot->min }}
                                    -
                                    {{ site('currency_symbol') . $bot->max }}</span>
                            </p>

                            <p class="flex justify-between">
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-left' : 'text-[#fbfbfb] block text-left' }}">Daily
                                    PNL</span>
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-right font-semibold' : 'text-[#fbfbfb] block text-right font-semibold' }}">{{ $bot->daily_min }}%
                                    -
                                    {{ $bot->daily_max }}%</span>
                            </p>

                            <p class="flex justify-between">
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-left' : 'text-[#fbfbfb] block text-left' }}">Trading
                                    Duration</span>
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-right font-semibold' : 'text-[#fbfbfb] block text-right font-semibold' }}">{{ $bot->duration }}
                                    {{ $bot->duration_type }}</span>
                            </p>

                            <p class="flex justify-between">
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-left' : 'text-[#fbfbfb] block text-left' }}">Capital
                                    Returned</span>
                                <span
                                    class="{{ $loop->index == 1 ? 'text-black block text-right font-semibold' : 'text-[#fbfbfb] block text-right font-semibold' }}">Yes</span>
                            </p>
                        </div>



                        <div class="block lg:py-7 py-4 {{ $loop->index == 1 ? 'text-black' : 'text-[#fbfbfb]' }}">
                            <p
                                class="{{ $loop->index == 1 ? 'text-black font-bold mb-3' : 'text-[#fbfbfb] font-bold mb-3' }}">
                                Tradings Days</p>
                            @php
                                $trading_days_display = [
                                    'monday' => in_array('monday', json_decode(site('trading_days'))),
                                    'tuesday' => in_array('tuesday', json_decode(site('trading_days'))),
                                    'wednesday' => in_array('wednesday', json_decode(site('trading_days'))),
                                    'thursday' => in_array('thursday', json_decode(site('trading_days'))),
                                    'friday' => in_array('friday', json_decode(site('trading_days'))),
                                    'saturday' => in_array('saturday', json_decode(site('trading_days'))),
                                    'sunday' => in_array('sunday', json_decode(site('trading_days'))),
                                ];
                            @endphp
                            @foreach ($trading_days_display as $day => $day_display)
                                <p
                                    class="flex flex-row-reverse justify-between items-center border-b-2 border-[#ffffff]/10 last:border-b-0 py-2">
                                    @if ($day_display)
                                        <img src="{{ asset('/assets/templates/zyphor/images/checkmark-icon.svg') }}"
                                            alt="">
                                    @else
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                            class="w-4 h-4 text-red-500" viewBox="0 0 16 16">
                                            <path
                                                d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                        </svg>
                                    @endif
                                    <span class="block text-left">{{ ucfirst($day) }}</span>
                                </p>
                            @endforeach
                        </div>

                        <div class="block text-center lg:py-7">
                            <a href="{{ route('user.bots.index') }}"
                                class="px-12 py-3 rounded-3xl transition duration-300 cursor-pointer bg-gradient-to-r {{ $loop->index == 1 ? '  from-[#4b149e] to-[#ea2a97]' : 'from-[#e1d2f9] to-[#fad1e8] text-black' }}">Activate</a>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </section>
@endsection

@section('scripts')
    <script defer src="https://www.livecoinwatch.com/static/lcw-widget.js"></script>
@endsection
