@php

    use App\Models\Bot;

    $page_title = 'Terms of Service';
    $short_description =
        'Prior to availing any of our services, we kindly request that you review and acknowledge our Acceptable Use Terms of Service. Your utilization of our services constitutes your agreement to abide by the terms and conditions outlined therein. We appreciate your understanding and compliance.';

@endphp

{{-- layout --}}
@extends('templates.' . site('template') . '.layouts.front')

@section('css')
    <style>
        .sidebar-item.active {
            color: #ff59ca;
            font-weight: 600;
        }

        .content-section:target {
            scroll-margin-top: 1rem;
        }
    </style>
@endsection


@section('contents')
    {{-- hero section  --}}
    <section class="pt-8 px-6 bg-cover bg-center max-w-[90rem] mx-auto rounded-3xl"
        style="background-image: url('{{ asset('/assets/templates/zyphor/images/hero-background-2.png') }}');">

        <div class="min-h-[600px] lg:min-h-[800px] flex justify-center items-center text-center relative overflow-y-hidden">
            <!-- Text Content -->
            <div class="flex flex-col justify-center items-center">
                <h1
                    class="text-3xl md:text-5xl font-[1000] text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] py-1.5">
                    Terms of Service
                </h1>
                <p class="text-[#fbfbfb] my-8 text-sm md:text-base max-w-3xl">
                    Prior to availing any of our services, we kindly request that you review and acknowledge our Acceptable
                    Use Terms of Service. Your utilization of our services constitutes your agreement to abide by the terms
                    and conditions outlined therein. We appreciate your understanding and compliance.

                </p>
            </div>
        </div>
    </section>


    {{-- users deposits withdrawals countries section  --}}
    <section class="max-w-[90rem] mx-auto px-6 relative -top-40">
        <div
            class="bg-[#372e45] rounded-3xl flex flex-col md:flex-row justify-between items-center text-center text-white px-6 py-6 gap-6 md:gap-0">
            <!-- Users -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">3.5k+</h2>
                <p class="text-sm text-gray-300">Users</p>
            </div>

            <!-- Deposits -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 5.5M+</h2>
                <p class="text-sm text-gray-300">Deposits</p>
            </div>

            <!-- Withdrawals -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 10.2M+</h2>
                <p class="text-sm text-gray-300">Withdrawals</p>
            </div>

            <!-- Countries -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">200+</h2>
                <p class="text-sm text-gray-300">Countries Supported</p>
            </div>
        </div>
    </section>



    {{-- terms section  --}}
    <section class="w-full mb-10 relative py-4 md:py-10">
        <div
            class="absolute right-20 md:right-60 lg:right-96 top-0 p-32 md:p-60 bg-gradient-to-l from-[#4b149e]/50 to-[#ea2a97]/50 rounded-full blur-3xl  -z-10">
        </div>
        <div class="w-[90%] mx-auto">
            <div
                class="max-w-screen-xl mx-auto relative flex flex-col lg:flex-row gap-8 bg-gradient-to-r from-white/10 to-white/5 backdrop-blur-xl border border-white/10 rounded-2xl p-6 shadow-lg">
                <!-- Sidebar -->
                <div
                    class="hidden lg:block w-full lg:w-1/4 sticky top-5 self-start  lg:h-[calc(100vh-4rem)] overflow-y-auto">
                    <h2 class="font-bold text-xl mb-4 text-[#fbfbfb]">Contents</h2>
                    <ul id="sidebar-nav" class="space-y-2">
                        <!-- Sidebar items will be added here by JS -->
                    </ul>
                </div>

                <!-- Content -->
                <div class="w-full lg:w-3/4">
                    <div id="terms-content" class="h-auto lg:h-[calc(100vh-4rem)] overflow-y-auto pr-4">
                        <div id="acceptance" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold" id="acceptance">Acceptance of Terms</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">
                                    Welcome to our site! By accessing or using our services, including but not limited to
                                    our website, trading platform, and any associated software or applications (collectively
                                    referred to as the "Services"), you agree to be bound by these Terms of Service
                                    ("Terms"). If you do not agree to these Terms, please do not use our Services.
                                </p>
                            </div>
                        </div>

                        <div id="description" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Description of Services</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">
                                    Our site provides a trading platform that utilizes advanced AI technology to analyze
                                    market trends and execute trades. Our Services are designed to facilitate trading
                                    activities, and we do not provide financial advice. You are solely responsible for your
                                    trading decisions.
                                </p>
                            </div>
                        </div>

                        <div id="eligibility" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Eligibility</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">You must be at least 18 years old and have the legal capacity to
                                    enter into this agreement to use our Services. By using our Services, you represent and
                                    warrant that you meet these eligibility criteria.</p>
                            </div>
                        </div>

                        <div id="registration" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Registration and Account Security</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">To access certain features of our Services, you may need to
                                    register for an account. You agree to provide accurate, current, and complete
                                    information during the registration process and to keep your account information
                                    updated. You are responsible for maintaining the confidentiality of your account
                                    credentials and for all activities that occur under your account. You must immediately
                                    notify us of any unauthorized use of your account.</p>
                            </div>
                        </div>

                        <div id="privacy" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Privacy Policy</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">Your use of our Services is also governed by our Privacy Policy.
                                    Please review our Privacy Policy to understand how we collect, use, and protect your
                                    personal information.</p>
                            </div>
                        </div>

                        <div id="prohibited" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Prohibited Activities</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb] mb-3">You agree not to engage in any of the following prohibited
                                    activities while using our Services:</p>
                                <ul class="list-disc text-sm text-[#fbfbfb] pl-8">
                                    <li>Violating any applicable laws or regulations.</li>
                                    <li>Impersonating any person or entity or providing false information.</li>
                                    <li>Attempting to gain unauthorized access to our Services or computer systems.</li>
                                    <li>Interfering with the proper functioning of our Services.</li>
                                    <li>Engaging in any activity that could harm, disable, or overburden our infrastructure.
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div id="termination" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Termination of Services</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">We reserve the right to terminate or suspend your access to our
                                    Services at our discretion, without notice, for any reason, including if we believe you
                                    have violated these Terms. You may also terminate your account at any time by
                                    discontinuing use of our Services.</p>
                            </div>
                        </div>

                        <div id="disclaimer" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Disclaimer of Warranties</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">Our Services are provided "as is" and "as available" without
                                    warranties of any kind, either express or implied. We do not guarantee the accuracy,
                                    reliability, or availability of our Services or the results obtained through their use.
                                    You use our Services at your own risk.</p>
                            </div>
                        </div>

                        <div id="limitation" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Limitation of Liability</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">To the fullest extent permitted by applicable law, our company and
                                    its affiliates, officers, directors, employees, and agents shall not be liable for any
                                    indirect, incidental, special, consequential, or punitive damages, or any loss of
                                    profits or revenues, whether incurred directly or indirectly, or any loss of data, use,
                                    goodwill, or other intangible losses, resulting from:</p>
                                <ol class="text-[#fbfbfb] text-sm list-alpha pl-8 pt-2">
                                    <li>your use or inability to use our Services,</li>
                                    <li>any unauthorized access to or use of our servers and/or any personal information
                                        stored therein,</li>
                                    <li>any interruption or cessation of our Services,</li>
                                    <li>any bugs, viruses, or other harmful code that may be transmitted to or through our
                                        Services, or</li>
                                    <li>any errors, inaccuracies, omissions, or any other aspect of our Services.</li>
                                </ol>
                            </div>
                        </div>

                        <div id="intellectual" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Intellectual Property</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">All content included in or made available through our Services,
                                    including text, graphics, logos, button icons, images, audio clips, digital downloads,
                                    and data compilations, is the property of our company or its content suppliers and is
                                    protected by United States and international copyright laws.</p>
                            </div>
                        </div>

                        <div id="changes" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Changes to Terms</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">We reserve the right to modify or revise these Terms at any time.
                                    The most current version of these Terms will be posted on our website. Your continued
                                    use of our Services following the posting of any changes constitutes your acceptance of
                                    those changes.</p>
                            </div>
                        </div>

                        <div id="governing" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Governing Law</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">These Terms are governed by and construed in accordance with the
                                    laws of the State, without regard to its conflict of law principles.</p>
                            </div>
                        </div>

                        <div id="contact" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Contact Information</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">If you have any questions about these Terms or our Services,
                                    please contact us at support@example.com.</p>
                            </div>
                        </div>

                        <div id="responsibilities" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">User Responsibilities</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">As a user of our Services, you agree to:</p>
                                <ul class="list-disc text-sm text-[#fbfbfb] pl-8 pt-2">
                                    <li>Comply with all applicable laws and regulations related to trading and financial
                                        transactions.</li>
                                    <li>Keep your account information, including passwords, secure and confidential.</li>
                                    <li>Use our Services only for lawful purposes.</li>
                                    <li>Refrain from attempting to disrupt or interfere with the proper functioning of our
                                        Services.</li>
                                    <li>Report any security breaches or unauthorized access to our Services promptly.</li>
                                </ul>
                            </div>
                        </div>

                        <div id="suspension" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Account Suspension and Termination</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">Our company reserves the right to suspend or terminate user
                                    accounts for violations of these Terms or for any other reason, at its sole discretion.
                                </p>
                            </div>
                        </div>

                        <div id="third-party" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Third-Party Links and Services</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">Our Services may contain links to third-party websites or
                                    services. Our company does not endorse or control these third-party websites or services
                                    and is not responsible for their content or practices. Use of third-party websites or
                                    services is at your own risk.</p>
                            </div>
                        </div>

                        <div id="indemnification" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Indemnification</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">You agree to indemnify and hold our company, its affiliates,
                                    officers, directors, employees, and agents harmless from any claims, losses, damages,
                                    liabilities, and expenses (including attorney's fees) arising from or related to your
                                    use of our Services or violation of these Terms.</p>
                            </div>
                        </div>

                        <div id="dispute" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Dispute Resolution</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">Any disputes arising from or relating to these Terms or your use
                                    of our Services shall be resolved through arbitration in accordance with the rules of
                                    the Arbitration Association. The arbitration shall take place in our city, and the
                                    decision of the arbitrator shall be final and binding.</p>
                            </div>
                        </div>

                        <div id="agreement" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Entire Agreement</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">These Terms constitute the entire agreement between you and our
                                    company with respect to the subject matter hereof and supersedes all prior or
                                    contemporaneous communications and proposals, whether oral or written, between the
                                    parties.</p>
                            </div>
                        </div>

                        <div id="assignment" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Assignment</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">You may not assign or transfer these Terms, in whole or in part,
                                    without the prior written consent of our company. Our company may freely assign these
                                    Terms without restriction.</p>
                            </div>
                        </div>

                        <div id="waiver" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Waiver and Severability</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">The failure of our company to enforce any right or provision of
                                    these Terms shall not constitute a waiver of such right or provision. If any provision
                                    of these Terms is found by a court of competent jurisdiction to be invalid, the parties
                                    nevertheless agree that the court should endeavor to give effect to the parties'
                                    intentions as reflected in the provision, and the other provisions of these Terms remain
                                    in full force and effect.</p>
                            </div>
                        </div>

                        <div id="beneficiaries" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">No Third-Party Beneficiaries</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">These Terms do not create any third-party beneficiary rights.</p>
                            </div>
                        </div>

                        <div id="contact-us" class="content-section mb-8">
                            <h3 class="text-lg text-[#fbfbfb] mb-4 font-semibold">Contact Us</h3>
                            <div class="w-full py-4 ">
                                <p class="text-[#fbfbfb]">If you have any questions or concerns about these Terms, please
                                    contact us at {{ site('email') }}.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // Populate sidebar with headings
            $('#terms-content .content-section').each(function() {
                const id = $(this).attr('id');
                const title = $(this).find('h3').text();
                $('#sidebar-nav').append(
                    `<li><a href="#${id}" class="sidebar-item text-[#fbfbfb] hover:text-[#ff59ca] transition-colors block py-1" data-section="${id}">${title}</a></li>`
                );
            });

            // Set up intersection observer
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const id = entry.target.id;
                        $('.sidebar-item').removeClass('active');
                        $(`.sidebar-item[data-section="${id}"]`).addClass('active');
                    }
                });
            }, {
                threshold: 0.2
            });

            // Observe all sections
            document.querySelectorAll('.content-section').forEach(section => {
                observer.observe(section);
            });

            // Smooth scroll for sidebar links
            $('.sidebar-item').on('click', function(e) {
                e.preventDefault();
                const targetId = $(this).attr('href');
                const target = $(targetId);

                if (target.length) {
                    $('html, body').animate({
                        scrollTop: target.offset().top - 20
                    }, 500);
                }
            });
        });
    </script>
@endsection
