@php

    use App\Models\DepositCoin;
    use App\Models\Bot;
    use Faker\Factory as Faker;

    $page_title = 'Live AI Trades ' . site('name');
    $short_description =
        site('name') .
        ' uses advanced Ai robots trained on extensive trading data and algorithms to analyze market trends and execute profitable trades with high precision.';

    $faker = Faker::create();
    $logos = DepositCoin::inRandomOrder()->take(20)->get('logo_url');

    $bots = Bot::get();

@endphp


{{-- layout --}}
@extends('templates.' . site('template') . '.layouts.front')

@section('css')
@endsection


@section('contents')
    {{-- hero section  --}}
    <section class="pt-8 px-6 bg-cover bg-center max-w-[90rem] mx-auto rounded-3xl"
        style="background-image: url('{{ asset('/assets/templates/zyphor/images/hero-background-2.png') }}');">

        <div class="min-h-[600px] lg:min-h-[800px] flex justify-center items-center text-center relative overflow-y-hidden">
            <!-- Text Content -->
            <div class="flex flex-col justify-center items-center">
                <h1
                    class="text-3xl md:text-5xl font-[1000] text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] py-1.5">
                    Live AI Trading
                </h1>
                <p class="text-[#fbfbfb] my-8 text-sm md:text-base max-w-3xl">
                    Our AI bots offer a diverse range of portfolio options, allowing you to choose the one that best aligns
                    with your budget and financial needs. Select the plan that suits you and start investing with
                    confidence.
                </p>
            </div>
        </div>
    </section>


    {{-- users deposits withdrawals countries section  --}}
    <section class="max-w-[90rem] mx-auto px-6 relative -top-40">
        <div
            class="bg-[#372e45] rounded-3xl flex flex-col md:flex-row justify-between items-center text-center text-white px-6 py-6 gap-6 md:gap-0">
            <!-- Users -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">3.5k+</h2>
                <p class="text-sm text-gray-300">Users</p>
            </div>

            <!-- Deposits -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 5.5M+</h2>
                <p class="text-sm text-gray-300">Deposits</p>
            </div>

            <!-- Withdrawals -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">USD 10.2M+</h2>
                <p class="text-sm text-gray-300">Withdrawals</p>
            </div>

            <!-- Countries -->
            <div class="w-full md:flex-1">
                <h2 class="text-xl md:text-2xl font-semibold text-[#dbc1e8]">200+</h2>
                <p class="text-sm text-gray-300">Countries Supported</p>
            </div>
        </div>
    </section>


    {{-- trade from anywhere section  --}}
    <section class="pt-8 md:pt-20 px-6 mb-4 relative">

        <div class="max-w-7xl mx-auto">
            <h2
                class="text-3xl md:text-4xl w-fit mx-auto font-semibold text-transparent bg-clip-text bg-gradient-to-r  from-[#e1d2f9] to-[#fad1e8]  text-center mb-4 md:mb-8">
                Trade From Anywhere
            </h2>

            <p class="text-[#fbfbfb] text-sm md:text-xl text-center md:leading-relaxed">
                Whether you're at home or on the go, seize market opportunities anytime,
                anywhere, and secure your financial future effortlessly. Trade from any
                and every city
            </p>

            <div class="relative w-full mt-8">
                <!-- Background container -->
                <div class="absolute inset-0 bg-cover bg-center bg-no-repeat opacity-10"
                    style="background-image: url('{{ asset('/assets/templates/zyphor/images/bg-trade.png') }}')">
                </div>

                <!-- Content container with blur -->
                <div class="relative p-4 md:p-8 rounded-3xl ">
                    <div class="w-full px-2 md:px-10  text-white">
                        <div class="w-full">
                            <div class="w-full p-3">
                                <div class="w-full overflow-x-auto max-h-[80vh] overflow-y-auto" id="recentTradesContainer">
                                    <table class="w-full">
                                        <thead class="">
                                            <tr class="text-left bg-[#250a4f] text-[#fbfbfb]">
                                                <th class="p-4">Current Time</th>
                                                <th class="p-4 text-start">Country</th>
                                                <th class="p-4 text-start">Exchange</th>
                                                <th class="p-4 text-right">Trading Pair</th>
                                                <th class="p-4 text-right">Amount</th>
                                                <th class="p-4 text-right">Time</th>
                                                <th class="p-4 text-right">Profit</th>
                                            </tr>
                                        </thead>
                                        <tbody class="w-full" id="recentTrades">
                                            <!-- Trades will be populated here -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('scripts')
    {{-- recent trades script --}}
    <script>
        let tradeData = @json(recentTradesAll());


        function updateTradeTable() {
            const tableBody = document.getElementById("recentTrades");
            tableBody.innerHTML = ""; // Clear existing rows
            const currentTime = new Date().toLocaleTimeString("en-US", {
                hour: "numeric",
                minute: "2-digit",
                second: "2-digit",
                hour12: true,
            });

            tradeData.forEach((trade) => {
                const row = document.createElement("tr");
                row.className = `border-b border-[#6366f1]/40 hover:bg-white/5 transition-colors ${
                trade.profit.startsWith("-") ? "text-[#EA0A0E]" : "text-[#00AA39]"
                }`;

                row.innerHTML = `
               <td class="p-2 text-start">${currentTime}</td>
               <td class="p-2 text-start">${trade.country}</td>
                    <td class="p-2 text-start">${trade.exchange}</td>
                    <td class="p-2 text-end">${trade.pair}</td>
                    <td class="p-2 text-right">${trade.amount}</td>
                    <td class="p-2 text-right"><span class="recent_trade_time"></span></td>
                    <td class="p-2 text-right">${trade.profit}</td>
                 
                `;

                tableBody.appendChild(row);
            });
        }

        function updateTradeTimes() {
            const tradeTimeElements = document.querySelectorAll('.recent_trade_time');
            const currentTime = new Date().toLocaleTimeString();

            tradeTimeElements.forEach((element) => {
                element.textContent = currentTime;
            });
        }

        // Function to swap first row to last every 2 seconds
        function rotateRows() {
            if (tradeData.length > 1) {
                const firstRow = tradeData.shift(); // Remove first row
                tradeData.push(firstRow); // Add it to the end
                updateTradeTable(); // Refresh the table with new order
                updateTradeTimes();
            }
        }

        // Initial table setup
        updateTradeTable();

        // Start row rotation every 2 seconds
        setInterval(rotateRows, 1000);
    </script>
@endsection
