<div class="flex justify-center items-center mt-4 gap-4">
    @if ($paginator->onFirstPage())
        <span class="p-2 bg-gray-500 border border-gray-600 rounded-md" aria-disabled="true">
            <img src="{{ asset('/assets/templates/zyphor/images/arrow-left.svg') }}" alt="">
        </span>
    @else
        <a href="{{ $paginator->previousPageUrl() }}" rel="prev"
            class="p-2 bg-gradient-to-r from-[#5823c1] to-[#ff8ac7] border border-gray-600 rounded-md paginator-link flex items-center justify-center"
            aria-disabled="true">
            <img src="{{ asset('/assets/templates/zyphor/images/arrow-left.svg') }}" alt="">
        </a>
    @endif

    <!-- Pagination Links -->
    {{-- @php
        $pageCount = $paginator->lastPage();
        $currentPage = $paginator->currentPage();
        $startIndex = $currentPage <= 2 ? 1 : max($currentPage - 2, 1);
        $endIndex = $currentPage <= 2 ? min($pageCount, 6) : min($currentPage + 2, $pageCount);
    @endphp --}}

    @php
        $pageCount = $paginator->lastPage();
        $currentPage = $paginator->currentPage();

        if ($currentPage <= 2) {
            $startIndex = 1;
            $endIndex = min(3, $pageCount);
        } else {
            $startIndex = $currentPage - 1;
            $endIndex = min($currentPage + 1, $pageCount);
        }
    @endphp

    @for ($i = $startIndex; $i <= $endIndex; $i++)
        @if ($i == $currentPage)
            <div
                class="p-2 text-white bg-gradient-to-r from-[#5823c1] to-[#ff8ac7] border border-gray-600 rounded-md paginator-link not-allowed-cursor">
                <span>{{ $i }}</span>
            </div>
        @else
            <a class="p-2 text-white  border border-gray-600 rounded-md paginator-link flex items-center justify-center"
                href="{{ $paginator->url($i) }}">{{ $i }}</a>
        @endif
    @endfor

    @if ($currentPage < $pageCount - 1)
        <div class="text-white"><span>...</span></div>
        <a href="{{ $paginator->url($pageCount) }}"
            class="p-2 text-white  border border-gray-600 rounded-md paginator-link flex items-center justify-center">
            {{ $pageCount }}
        </a>
    @endif


    @if ($paginator->hasMorePages())
        <a href="{{ $paginator->nextPageUrl() }}" rel="next"
            class=" paginator-link p-2  bg-gradient-to-r from-[#5823c1] to-[#ff8ac7] border border-gray-600 rounded-md paginator-link flex items-center justify-center">
            <img src="{{ asset('/assets/templates/zyphor/images/arrow-right.svg') }}" alt="">
        </a>
    @else
        <span class="p-2  bg-gray-500 border border-gray-600 rounded-md">
            <img src="{{ asset('/assets/templates/zyphor/images/arrow-right.svg') }}" alt="">
        </span>
    @endif

</div>
