@extends('templates.' . site('template') . '.layouts.auth')

@section('css')
@endsection

@section('contents')
    <div
        class="h-screen w-full flex gap-4 lg:gap-8 items-center bg-gradient-to-r from-[#6366f1]/10 to-[#ffffff]/5 justify-center relative">
        <div class="w-full max-w-lg lg:p-0 p-4 relative">
            <img class="absolute right-20 md:right-0 lg:right-0 -top-20 -z-10"
                src="{{ asset('/assets/templates/zyphor/images/circle-group.svg') }}">
            <div
                class="absolute right-20 md:right-0 lg:right-0 top-0 p-16 md:p-80 bg-[#ea2a97]/25 rounded-full blur-3xl -z-10">
            </div>

            <div class="bg-[#190735] backdrop-blur-md shadow-md rounded-2xl p-6 md:p-10 relative overflow-hidden">
                <a href="{{ route('home') }}">
                    <p class="text-[#ffffff] flex gap-2 items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                            style="fill: rgb(255, 255, 255);transform: ;msFilter:;">
                            <path d="M12.707 17.293 8.414 13H18v-2H8.414l4.293-4.293-1.414-1.414L4.586 12l6.707 6.707z">
                            </path>
                        </svg>
                        <span>Back</span>
                    </p>
                </a>

                <div class="px-4 lg:px-10 mt-6 space-y-6">
                    <p class="bg-[#a855f7] text-gray-300 p-1 rounded-lg text-xs text-center hidden noticeMsg" id="noticeMsg"
                        style="background: #a855f7; color:#fff; margin:10px 0px;"></p>
                </div>

                <div class="text-[#ffffff] mb-10 text-center">
                    <p
                        class="w-fit mx-auto text-4xl mb-4 font-semibold text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8]">
                        Sign Up
                    </p>
                    <p class="">Please enter your details</p>
                </div>

                <form action="{{ route('user.register-validate') }}" method="POST" class="" id="registerForm">
                    @csrf
                    <div class="w-full mb-10">
                        <div class="w-full text-[#fbfbfb]">
                            <div class="w-full">
                                <input type="email" id="email" name="email"
                                    class="w-full text-xl text-[#fbfbfb] border border-[#ea2a97]/30 py-4 px-3 rounded-lg focus:outline-none flex-1"
                                    placeholder="Email Address">
                            </div>
                        </div>
                        <span>
                            @error('email')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>

                    <div class="w-full mb-10">
                        <div class="w-full text-[#fbfbfb]">
                            <div class="w-full">
                                <input type="password" name="password" placeholder="Password" id="password"
                                    class="w-full text-xl text-[#fbfbfb] border border-[#ea2a97]/30 py-4 px-3 rounded-lg focus:outline-none flex-1">
                            </div>
                        </div>
                        <span>
                            @error('password')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>

                    <div class="w-full mb-10">
                        <div class="w-full text-[#fbfbfb]">
                            <div class="w-full">
                                <input type="password" name="password_confirmation" placeholder="Confirm Password"
                                    id="confirm-password"
                                    class="w-full text-xl text-[#fbfbfb] border border-[#ea2a97]/30 py-4 px-3 rounded-lg focus:outline-none flex-1">
                            </div>
                        </div>
                        <span>
                            @error('password-confirmation')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>

                    <div class="w-full mb-4">
                        <div class="text-center">
                            <button type="submit" id="registerBtn"
                                class="bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] hover:bg-linear-to-l text-[#250a4f] font-semibold rounded-3xl px-10 py-4 w-full transition delay-100 duration-200 ease-in-out flex items-center relative justify-center cursor-pointer">
                                Sign Up
                            </button>
                        </div>
                    </div>

                    <div class="w-full mb-4">
                        <p class="text-center text-[#B4B1B1]">Already have an account? <a href="{{ route('user.login') }}"
                                class="text-[#fbfbfb]">Login</a></p>
                    </div>
                </form>

                {{-- Verification form with updated styling --}}
                <form action="{{ route('user.register-verify') }}" method="POST" class="hidden" id="verifyForm">
                    @csrf
                    <div class="w-full mb-10 flex items-center justify-center">
                        <div class="flex lg:gap-10 gap-4 text-[#ffffff]">
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-[#fad1e8] focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-[#fad1e8] focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-[#fad1e8] focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-[#fad1e8] focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-[#fad1e8] focus:outline-none" />
                            <input type="number" maxlength="1" name="otp[]"
                                class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-[#fad1e8] focus:outline-none" />
                        </div>
                        <input type="hidden" name="otp" id="otp" value="">
                    </div>

                    <div class="w-full mb-4 pt-10">
                        <div class="text-center">
                            <button type="submit" id="verifyBtn"
                                class="bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8] hover:bg-linear-to-l text-[#250a4f] font-semibold rounded-3xl px-10 py-4 w-full transition delay-100 duration-200 ease-in-out flex items-center relative justify-center cursor-pointer">
                                Verify
                            </button>
                        </div>
                        <div class="text-center text-[#fbfbfb] py-5">
                            <a href="{{ route('user.register') }}" class="hover:font-semibold" id="resendBtn">Go Back</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $('#registerForm').submit(function(e) {
                e.preventDefault(); // Prevent default form submission

                var form = $(this);
                var formData = form.serialize(); // Serialize form data as JSON

                var clicked = $('#registerBtn');

                //disable the submit button
                clicked.addClass('relative disabled');
                clicked.append('<span class="button-spinner"></span>');
                clicked.prop('disabled', true);

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        var verifyText = response.message;
                        var verify = response.verify;

                        toastNotify('success', verifyText);
                        $('.noticeMsg').html(verifyText).show();

                        if (verify == 1) {
                            //hide register form and display verification form
                            $('#registerForm').hide();
                            $('#verifyForm').show();

                            //update page title
                            $('#page-title').html('Verify Email');
                        } else {
                            var url = '{{ route('user.dashboard') }}';
                            window.location.href = url;
                        }




                    },
                    error: function(xhr, status, error) {
                        $('#registerBtn').show();
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });


                                toastNotify('error', fieldErrors);

                                $('.noticeMsg').html(fieldErrors).show();


                            });
                        } else {
                            toastNotify('error', 'An error occured, please try again later');


                        }


                    },
                    complete: function() {
                        clicked.removeClass('disabled');
                        clicked.find('.button-spinner').remove();
                        clicked.prop('disabled', false);

                    }

                });
            });


            //otp form
            $('#verifyForm').submit(function(e) {
                e.preventDefault(); // Prevent default form submission

                var form = $(this);
                var formData = form.serialize(); // Serialize form data as JSON

                var clicked = $('#verifyBtn');

                //disable the submit button
                clicked.addClass('relative disabled');
                clicked.append('<span class="button-spinner"></span>');
                clicked.prop('disabled', true);

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        var verifyText = response.message;
                        $('#noticeMsg').html(verifyText).show();

                        toastNotify('success', verifyText);



                        var url = '{{ route('user.dashboard') }}';
                        window.location.href = url;

                    },
                    error: function(xhr, status, error) {
                        $('#registerBtn').show();
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });

                                toastNotify('error', fieldErrors);

                            });
                        } else {
                            toastNotify('error', 'An error occured, please try again later');

                        }


                    },

                    complete: function() {
                        clicked.removeClass('disabled');
                        clicked.find('.button-spinner').remove();
                        clicked.prop('disabled', false);

                    }

                });
            });
        });
    </script>

    <script>
        ////// Concatenate all input values
        $(document).ready(function() {
            $('.otp-input').on('input', function() {
                let otpValue = '';

                // Concatenate all input values
                $('.otp-input').each(function() {
                    otpValue += $(this).val();
                });

                // Set the hidden input value
                $('#otp').val(otpValue);
            });
        });


        $(document).ready(function() {
            const $inputs = $(".otp-input");

            $inputs.on("input", function(e) {
                const $this = $(this);
                const value = $this.val();

                // Allow only 1 character
                if (value.length > 1) {
                    $this.val(value.charAt(0)); // Keep only the first character
                }

                // Move focus to the next input if a character is entered
                if (value.length === 1) {
                    $this.next(".otp-input").focus();
                }
            });

            $inputs.on("keydown", function(e) {
                const $this = $(this);

                if (e.key === "Backspace" && !$this.val()) {
                    $this.prev(".otp-input").focus();
                }
            });

            $inputs.on("paste", function(e) {
                const pasteData = e.originalEvent.clipboardData.getData('text').slice(0, $inputs.length);

                // Fill inputs with pasted data, ensuring only one character per input
                $inputs.each(function(index) {
                    $(this).val(pasteData[index] || "");
                });

                // Focus on the next input after the last pasted character
                $inputs.eq(pasteData.length).focus();
                e.preventDefault();
            });
        });
    </script>
@endsection
