@extends('templates.' . site('template') . '.layouts.user')
{{-- @extends('templates.'. site('template') .'.layouts.user') --}}

@section('css')
    <style>
        .active {
            color: #E1D2F9;
            font-weight: bold;
        }


        .swal-responsive-container {
            padding: 0 15px;
        }

        .swal-responsive-popup {
            width: 95% !important;
            max-width: 1200px !important;
        }

        @media (min-width: 768px) {
            .swal-responsive-popup {
                width: 85% !important;
            }
        }

        @media (min-width: 1200px) {
            .swal-responsive-popup {
                width: 75% !important;
            }
        }
    </style>
@endsection

@section('contents')
    <!--my ai bot-->
    <section class="px-6 md:mt-28 w-full mx-auto lg:relative">


        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[50rem] h-[50rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-10 top-10 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute -left-10 top-1/2 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}



        <div class="w-full mx-auto p-4 mb-3 text-white">

            <div class="block mb-3">
                <h1 class="text-xl lg:text-3xl font-bold">AI Bots</h1>
            </div>

            <div class="lg:flex justify-between items-center mb-5 py-5">

                <div class="w-full mb-3 flex lg:flex-row flex-col justify-between gap-2">

                    <div class="flex items-center gap-4 font-thin bg-[#372E45] rounded-lg p-4 lg:text-lg text-xs">
                        <button id="myAiBotsBtn" class="text-center cursor-pointer hover:text-[#E1D2F9] active">
                            My AI Bots</button>
                        <button id="aiTradingHistoryBtn" class="text-center cursor-pointer hover:text-[#E1D2F9]">
                            Trading History</button>
                    </div>

                    <button id="openAiBotActivationModal"
                        class="rounded-2xl py-3 px-6 text-base  transition delay-100 duration-200 ease-in-out cursor-pointer bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)]">
                        <span
                            class="bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] bg-clip-text text-transparent font-medium">
                            Activate AI Bot
                        </span>
                    </button>

                </div>

            </div>

            <!--my ai bots table-->
            <div id="myAiBots">
                <div id="bots">

                    <div class="block bg-[#250A4F] px-6 py-5 rounded-t-2xl">
                        <span class="text-xl lg:text-3xl mr-10 mb-3">My AI Bots</span>
                    </div>
                    <div id=""
                        class="block overflow-auto w-full max-h-[60vh] bg-[#190735] px-6 py-3 rounded-b-2xl">
                        <table class="lg:w-[100%]" data-bot_count="{{ $activations->total() }}" id="botTable">

                            <tbody>
                                @forelse ($activations as $bot)
                                    <tr class="border-b border-[#f272d5]/25">
                                        <td class="p-3 min-w-[15rem]">
                                            <div class="flex flex-col justify-start">
                                                <div class="flex items-center gap-2 mb-3">
                                                    <img src="{{ asset('storage/bots/' . $bot->bot->logo) }}"
                                                        class="w-8 h-8 rounded-full" alt="bot">

                                                    <span>{{ $bot->bot->name }}</span>

                                                    @if ($bot->status == 'active')
                                                        <svg width="24" height="25" viewBox="0 0 24 25"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M10.6319 1.64199C10.9859 1.28847 11.4595 1.08045 11.9593 1.05897C12.4591 1.0375 12.9489 1.20413 13.3319 1.52599L13.4599 1.64299L15.3599 3.54199H18.0459C18.5503 3.54209 19.036 3.73277 19.4058 4.07583C19.7756 4.4189 20.002 4.88901 20.0399 5.39199L20.0459 5.54199V8.22799L21.9459 10.128C22.2997 10.482 22.5079 10.9559 22.5293 11.4559C22.5508 11.956 22.384 12.4459 22.0619 12.829L21.9449 12.956L20.0449 14.856V17.542C20.045 18.0466 19.8545 18.5326 19.5114 18.9025C19.1683 19.2725 18.698 19.4992 18.1949 19.537L18.0459 19.542H15.3609L13.4609 21.442C13.1068 21.7958 12.633 22.004 12.1329 22.0255C11.6329 22.0469 11.1429 21.8801 10.7599 21.558L10.6329 21.442L8.73287 19.542H6.04587C5.54129 19.5422 5.0553 19.3516 4.68532 19.0085C4.31534 18.6654 4.08871 18.1951 4.05087 17.692L4.04587 17.542V14.856L2.14587 12.956C1.79206 12.602 1.58387 12.1281 1.56239 11.6281C1.54091 11.128 1.70772 10.6381 2.02987 10.255L2.14587 10.128L4.04587 8.22799V5.54199C4.04596 5.03759 4.23664 4.55185 4.57971 4.18208C4.92277 3.81231 5.39289 3.58582 5.89587 3.54799L6.04587 3.54199H8.73187L10.6319 1.64199Z"
                                                                fill="#00AA39" />
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M15.1255 8.52497L10.8815 12.769L9.11345 11.001C8.92581 10.8135 8.67137 10.7082 8.4061 10.7083C8.14083 10.7084 7.88646 10.8138 7.69895 11.0015C7.51144 11.1891 7.40616 11.4436 7.40625 11.7088C7.40634 11.9741 7.51181 12.2285 7.69945 12.416L10.1035 14.82C10.2056 14.9222 10.3269 15.0032 10.4604 15.0586C10.5939 15.1139 10.737 15.1423 10.8815 15.1423C11.0259 15.1423 11.169 15.1139 11.3025 15.0586C11.436 15.0032 11.5573 14.9222 11.6595 14.82L16.5395 9.93897C16.7216 9.75037 16.8224 9.49777 16.8201 9.23557C16.8178 8.97338 16.7127 8.72256 16.5273 8.53716C16.3419 8.35175 16.0911 8.24658 15.8289 8.2443C15.5667 8.24202 15.3141 8.34282 15.1255 8.52497Z"
                                                                fill="#F0FCFF" />
                                                        </svg>
                                                    @else
                                                        <svg width="24" height="25" viewBox="0 0 24 25"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="01.3" fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M10.6319 1.64199C10.9859 1.28847 11.4595 1.08045 11.9593 1.05897C12.4591 1.0375 12.9489 1.20413 13.3319 1.52599L13.4599 1.64299L15.3599 3.54199H18.0459C18.5503 3.54209 19.036 3.73277 19.4058 4.07583C19.7756 4.4189 20.002 4.88901 20.0399 5.39199L20.0459 5.54199V8.22799L21.9459 10.128C22.2997 10.482 22.5079 10.9559 22.5293 11.4559C22.5508 11.956 22.384 12.4459 22.0619 12.829L21.9449 12.956L20.0449 14.856V17.542C20.045 18.0466 19.8545 18.5326 19.5114 18.9025C19.1683 19.2725 18.698 19.4992 18.1949 19.537L18.0459 19.542H15.3609L13.4609 21.442C13.1068 21.7958 12.633 22.004 12.1329 22.0255C11.6329 22.0469 11.1429 21.8801 10.7599 21.558L10.6329 21.442L8.73287 19.542H6.04587C5.54129 19.5422 5.0553 19.3516 4.68532 19.0085C4.31534 18.6654 4.08871 18.1951 4.05087 17.692L4.04587 17.542V14.856L2.14587 12.956C1.79206 12.602 1.58387 12.1281 1.56239 11.6281C1.54091 11.128 1.70772 10.6381 2.02987 10.255L2.14587 10.128L4.04587 8.22799V5.54199C4.04596 5.03759 4.23664 4.55185 4.57971 4.18208C4.92277 3.81231 5.39289 3.58582 5.89587 3.54799L6.04587 3.54199H8.73187L10.6319 1.64199Z"
                                                                fill="#6b7280" />
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M15.1255 8.52497L10.8815 12.769L9.11345 11.001C8.92581 10.8135 8.67137 10.7082 8.4061 10.7083C8.14083 10.7084 7.88646 10.8138 7.69895 11.0015C7.51144 11.1891 7.40616 11.4436 7.40625 11.7088C7.40634 11.9741 7.51181 12.2285 7.69945 12.416L10.1035 14.82C10.2056 14.9222 10.3269 15.0032 10.4604 15.0586C10.5939 15.1139 10.737 15.1423 10.8815 15.1423C11.0259 15.1423 11.169 15.1139 11.3025 15.0586C11.436 15.0032 11.5573 14.9222 11.6595 14.82L16.5395 9.93897C16.7216 9.75037 16.8224 9.49777 16.8201 9.23557C16.8178 8.97338 16.7127 8.72256 16.5273 8.53716C16.3419 8.35175 16.0911 8.24658 15.8289 8.2443C15.5667 8.24202 15.3141 8.34282 15.1255 8.52497Z"
                                                                fill="#000000" />
                                                        </svg>
                                                    @endif
                                                </div>

                                                <p class="flex items-center gap-4 mb-2 text-sm">
                                                    <span class="font-thin text-[#FF59CA]">Portfolio:</span>
                                                    <span class="text-white">{{ formatAmount($bot->capital) }}</span>
                                                </p>

                                                <p class="block items-center gap-4 mb-2 text-sm">
                                                    <span class="font-thin text-white">Activation Date:</span>
                                                    <span class="text-white">
                                                        {{ date('Y-m-d ', strtotime($bot->created_at)) }}</span>
                                                    <span class="text-white">
                                                        {{ date('H:i:s', strtotime($bot->created_at)) }}</span>
                                                </p>
                                            </div>
                                        </td>

                                        <td class="p-3 min-w-[15rem]">
                                            <div class="flex flex-col justify-end">
                                                <div class="flex items-center justify-end gap-2 mb-3">
                                                    <span>PNL</span>
                                                    @if ($bot->profit < 0)
                                                        <span class="text-[#EA0A0E] flex space-x-1">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="w-6 h-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M1.72 5.47a.75.75 0 011.06 0L9 11.69l3.756-3.756a.75.75 0 01.985-.066 12.698 12.698 0 014.575 6.832l.308 1.149 2.277-3.943a.75.75 0 111.299.75l-3.182 5.51a.75.75 0 01-1.025.275l-5.511-3.181a.75.75 0 01.75-1.3l3.943 2.277-.308-1.149a11.194 11.194 0 00-3.528-5.617l-3.809 3.81a.75.75 0 01-1.06 0L1.72 6.53a.75.75 0 010-1.061z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                            <span>{{ ($bot->profit / $bot->capital) * 100 }}%</span>
                                                        </span>
                                                    @else
                                                        <span class="text-[#00AA39] flex space-x-1">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="w-6 h-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M15.22 6.268a.75.75 0 01.968-.432l5.942 2.28a.75.75 0 01.431.97l-2.28 5.941a.75.75 0 11-1.4-.537l1.63-4.251-1.086.483a11.2 11.2 0 00-5.45 5.174.75.75 0 01-1.199.19L9 12.31l-6.22 6.22a.75.75 0 11-1.06-1.06l6.75-6.75a.75.75 0 011.06 0l3.606 3.605a12.694 12.694 0 015.68-4.973l1.086-.484-4.251-1.631a.75.75 0 01-.432-.97z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                            <span>+{{ ($bot->profit / $bot->capital) * 100 }}%</span>
                                                        </span>
                                                    @endif
                                                </div>

                                                <p class="flex items-center justify-end gap-4 mb-2 text-sm">
                                                    <span class="font-thin text-[#FF59CA]">Portfolio Balance:</span>
                                                    <span class="text-white">{{ formatAmount($bot->balance) }}</span>
                                                </p>

                                                <p class="flex items-center justify-end gap-4 mb-2 text-sm">
                                                    <span class="font-thin text-white">Ending In:</span>
                                                    <span
                                                        class="@if ($bot->expires_in < time()) text-[#EA0A0E] @else text-white @endif">
                                                        <a role="button" class="cursor-pointer"
                                                            id="{{ 'bot_timer_' . $loop->iteration }}">time
                                                        </a>
                                                    </span>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td
                                            class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                                fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                                viewBox="0 0 16 16">
                                                <path
                                                    d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                            </svg>
                                            <span>You have not activated any bot</span>
                                        </td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>

                    <div class="cursor-pointer simple-pagination" data-paginator="bots">
                        {{ $activations->links('templates.' . site('template') . '.paginations.simple') }}
                    </div>
                </div>
            </div>

            <!--ai trading history-->
            <div id="aiTradingHistory" class="hidden mb-10 w-full lg:px-6">

                <div id="bot-history">
                    <!--Al Trading View chart-->
                    <div class="px-6 py-6 mt-8 md:mb-20 mb-10 w-full mx-auto bg-white/5 rounded-lg">
                        <div class=" mx-auto mb-3 text-white">
                            <h2
                                class="text-sm md:text-base lg:text-2xl w-fit  mb-2 md:mb-6 text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8]">
                                AI Trading Overview (7 Day PNL)</h2>

                            <div class="block lg:flex items-center justify-between">
                                <div class="grid lg:grid-cols-4 grid-cols-2 gap-1 text-xs mb-3">
                                    <span class="bg-[#372E45] px-4 py-2 rounded-l-lg">12 months</span>
                                    <span class="bg-[#372E45] px-4 py-2">30 days</span>
                                    <span class="bg-[#372E45] px-4 py-2">7 days</span>
                                    <span class="bg-[#372E45] px-4 py-2 rounded-r-lg">24 hours</span>
                                </div>

                                <div class="flex gap-3 px-4 py-2 border border-white rounded-lg w-fit">
                                    <span
                                        class="w-4 h-4 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] rounded-full"></span>
                                    <span>PNL</span>
                                </div>
                            </div>

                            <div id="canvas-wrapper" class="w-full md:h-[50vh] relative overflow-hidden rounded-4xl">
                                <canvas id="canvas" class="w-full h-full block"></canvas>
                            </div>
                        </div>
                    </div>
                    <!--end ai tradeing view chart-->

                    {{-- trading and daily history --}}
                    <div class="lg:flex block gap-10">

                        <div id="bot-history-grid" class="w-full mb-10">

                            <div class="block bg-[#250A4F] px-6 py-5 rounded-t-2xl">
                                <span class="text-xl lg:text-3xl mr-10 mb-3">AI Trading History</span>
                            </div>
                            <div data-aos="zoom-in" id=""
                                class="block overflow-auto w-full h-[60vh] bg-[#190735] px-6 py-3 rounded-b-2xl">
                                <table class="w-full">

                                    <tbody>
                                        @forelse ($histories as $history)
                                            <tr class="border-b border-[#f272d5]/25">
                                                <td class="p-3 min-w-[15rem]">
                                                    <div class="flex flex-col justify-start">
                                                        <div class="flex items-center gap-4 ">
                                                            <img src="{{ asset('storage/bots/' . $history->botActivation->bot->logo) }}"
                                                                alt="bot" class="w-8 h-8 rounded-full">
                                                            <p class="font-bold">{{ $history->botActivation->bot->name }}
                                                            </p>
                                                        </div>

                                                        <p class="flex items-center gap-4 mb-2 text-sm">
                                                            <span class="font-thin text-[#FF59CA]">Entry Price:</span>
                                                            <span class="text-white">{{ $history->entry_price }}</span>
                                                        </p>

                                                        <p class=" text-gray-200 text-sm">
                                                            <span>{{ date('d-m-y', $history->timestamp) }}</span>
                                                            <span>{{ date('H:i:s', $history->timestamp) }}</span>
                                                        </p>
                                                    </div>
                                                </td>

                                                <td class="p-3 min-w-[15rem]">
                                                    <div class="flex flex-col justify-end">
                                                        <div class="flex items-center justify-end gap-2 mb-0">
                                                            <span>PNL</span>

                                                            @if ($history->profit < 0)
                                                                <p class="text-[#EA0A0E] flex space-x-1 text-sm">
                                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                                        viewBox="0 0 24 24" fill="currentColor"
                                                                        class="w-6 h-6">
                                                                        <path fill-rule="evenodd"
                                                                            d="M1.72 5.47a.75.75 0 011.06 0L9 11.69l3.756-3.756a.75.75 0 01.985-.066 12.698 12.698 0 014.575 6.832l.308 1.149 2.277-3.943a.75.75 0 111.299.75l-3.182 5.51a.75.75 0 01-1.025.275l-5.511-3.181a.75.75 0 01.75-1.3l3.943 2.277-.308-1.149a11.194 11.194 0 00-3.528-5.617l-3.809 3.81a.75.75 0 01-1.06 0L1.72 6.53a.75.75 0 010-1.061z"
                                                                            clip-rule="evenodd" />
                                                                    </svg>
                                                                    <span>
                                                                        -{{ formatAmount(str_replace('-', '', $history->profit)) }}
                                                                    </span>
                                                                    <span>
                                                                        {{ number_format((($history->exit_price - $history->entry_price) / $history->entry_price) * 100, 2) }}%
                                                                    </span>
                                                                </p>
                                                            @else
                                                                <p class="text-[#00AA39] flex space-x-1 text-sm">
                                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                                        viewBox="0 0 24 24" fill="currentColor"
                                                                        class="w-6 h-6">
                                                                        <path fill-rule="evenodd"
                                                                            d="M15.22 6.268a.75.75 0 01.968-.432l5.942 2.28a.75.75 0 01.431.97l-2.28 5.941a.75.75 0 11-1.4-.537l1.63-4.251-1.086.483a11.2 11.2 0 00-5.45 5.174.75.75 0 01-1.199.19L9 12.31l-6.22 6.22a.75.75 0 11-1.06-1.06l6.75-6.75a.75.75 0 011.06 0l3.606 3.605a12.694 12.694 0 015.68-4.973l1.086-.484-4.251-1.631a.75.75 0 01-.432-.97z"
                                                                            clip-rule="evenodd" />
                                                                    </svg>
                                                                    <span>
                                                                        +{{ formatAmount($history->profit) }}
                                                                    </span>
                                                                    <span>
                                                                        +{{ number_format((($history->exit_price - $history->entry_price) / $history->entry_price) * 100, 2) }}%
                                                                    </span>
                                                                </p>
                                                            @endif
                                                        </div>

                                                        <p class="flex items-center justify-end gap-4 mb-2 text-sm">
                                                            <span class="font-thin text-[#FF59CA]">Exit Price:</span>
                                                            <span class="text-white">{{ $history->exit_price }}</span>
                                                        </p>

                                                        <p class="flex items-center justify-end gap-4 mb-2 text-sm">
                                                            <span class="font-thin text-white">{{ $history->pair }}</span>
                                                            <span
                                                                class="text-white btn-gradient px-2 py-1 rounded-lg flex gap-2 text-xs view-chart cursor-pointer"
                                                                data-pair="{{ $history->pair }}">
                                                                <img src="{{ asset('/assets/templates/zyphor/images/view_eye.svg') }}"
                                                                    alt="">
                                                                View Chart
                                                            </span>
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td
                                                    class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        class="w-5 h-5 text-orange-500" fill="currentColor"
                                                        class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                                        <path
                                                            d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                    </svg>
                                                    <span>You have not activated any bot</span>
                                                </td>
                                            </tr>
                                        @endforelse

                                    </tbody>
                                </table>
                            </div>


                            <div class="cursor-pointer simple-pagination" data-paginator="bot-history-grid">
                                {{ $histories->links('templates.' . site('template') . '.paginations.simple') }}
                            </div>
                        </div>

                        <div id="daily_summary" class="w-full mb-10">

                            <div class="block bg-[#250A4F] px-6 py-5 rounded-t-2xl">
                                <span class="text-xl lg:text-3xl mr-10 mb-3">Daily History</span>
                            </div>
                            <div data-aos="zoom-in" id=""
                                class="block overflow-auto w-full h-[60vh] bg-[#190735] px-6 py-3 rounded-b-2xl">
                                <table class="w-full">
                                    <tbody>
                                        @foreach ($daily_data as $date => $summary)
                                            @if ($summary['profit'] != 0)
                                                <tr class="border-b border-[#f272d5]/25">
                                                    <td class="p-3 min-w-[6rem]">
                                                        <div class="flex flex-col justify-start">
                                                            <div class="flex items-center justify-start gap-2 mb-0">
                                                                <span>PNL</span>

                                                                @if ($summary['profit'] < 0)
                                                                    <p class="text-[#EA0A0E] flex space-x-1 text-sm">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            viewBox="0 0 24 24" fill="currentColor"
                                                                            class="w-6 h-6">
                                                                            <path fill-rule="evenodd"
                                                                                d="M1.72 5.47a.75.75 0 011.06 0L9 11.69l3.756-3.756a.75.75 0 01.985-.066 12.698 12.698 0 014.575 6.832l.308 1.149 2.277-3.943a.75.75 0 111.299.75l-3.182 5.51a.75.75 0 01-1.025.275l-5.511-3.181a.75.75 0 01.75-1.3l3.943 2.277-.308-1.149a11.194 11.194 0 00-3.528-5.617l-3.809 3.81a.75.75 0 01-1.06 0L1.72 6.53a.75.75 0 010-1.061z"
                                                                                clip-rule="evenodd" />
                                                                        </svg>
                                                                        <span>
                                                                            {{ number_format($summary['profit_percent'], 2) }}%
                                                                        </span>
                                                                    </p>
                                                                @else
                                                                    <p class="text-[#00AA39] flex space-x-1 text-sm">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            viewBox="0 0 24 24" fill="currentColor"
                                                                            class="w-6 h-6">
                                                                            <path fill-rule="evenodd"
                                                                                d="M15.22 6.268a.75.75 0 01.968-.432l5.942 2.28a.75.75 0 01.431.97l-2.28 5.941a.75.75 0 11-1.4-.537l1.63-4.251-1.086.483a11.2 11.2 0 00-5.45 5.174.75.75 0 01-1.199.19L9 12.31l-6.22 6.22a.75.75 0 11-1.06-1.06l6.75-6.75a.75.75 0 011.06 0l3.606 3.605a12.694 12.694 0 015.68-4.973l1.086-.484-4.251-1.631a.75.75 0 01-.432-.97z"
                                                                                clip-rule="evenodd" />
                                                                        </svg>
                                                                        <span>
                                                                            +{{ number_format($summary['profit_percent'], 2) }}%
                                                                        </span>
                                                                    </p>
                                                                @endif
                                                            </div>

                                                            <p class=" text-gray-200 text-sm">
                                                                <span>{{ $date }}</span>
                                                            </p>
                                                        </div>
                                                    </td>


                                                    <td class="p-3 min-w-[6rem]">
                                                        <div class="flex flex-col justify-start">
                                                            <p class="flex items-center justify-end gap-4 mb-2 text-sm">
                                                                <span class="font-thin text-[#FF59CA]">Amount:</span>
                                                                @if ($summary['profit'] < 0)
                                                                    <span class="text-white">
                                                                        -{{ formatAmount(str_replace('-', '', $summary['profit'])) }}
                                                                    </span>
                                                                @else
                                                                    <span class="text-white">
                                                                        <span>+{{ formatAmount($summary['profit']) }}</span>
                                                                    </span>
                                                                @endif
                                                            </p>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>

                </div>
            </div>

        </div>
    </section>
    <!--end my ai bot-->


    {{-- Ai Bot Activation Modal --}}

    <div id="aiBotActivationModal"
        class="fixed inset-0 bg-opacity-50 flex items-center justify-end lg:px-6 px-2 backdrop-blur-xs hidden"
        style="z-index: 50;">
        <div
            class="bg-[#0F0420] rounded-lg   w-full lg:w-[35vw]  lg:p-14 p-4 relative z-10  mx-auto backdrop-blur-lg max-h-[90vh] overflow-y-auto">

            <div class="flex justify-between items-center lg:mb-10 mb-4">
                <h2 class="text-xl font-semibold mb-4 text-white">Ai Bot Activation</h2>

                <button id="closeAiBotActivationModal" class="text-gray-400 hover:text-gray-600">
                    <img src="{{ asset('/assets/templates/zyphor/images/cancel-circle.svg') }}" alt="icon">
                </button>
            </div>

            <!-- Modal Content -->
            <div class="block">
                @forelse ($bots as $bot)
                    <div class="bg-[#372E45] rounded-2xl p-6 mb-6">
                        <div class="flex justify-between text-white">
                            <div class="block">
                                <div class="flex items-center gap-2">
                                    <img src="{{ asset('storage/bots/' . $bot->logo) }}" alt="icon"
                                        class="h-8 w-8 rounded-full">
                                    <span>{{ $bot->name }}</span>
                                </div>
                                <p class="text-sm">{{ $bot->duration . $bot->duration_type }} trading period</p>
                            </div>

                            <div class="block">
                                <p class="text-sm font-thin text-right mb-2">
                                    <span class="text-[#FAD1E8 ]">Avg. Daily PNL </span>
                                    <span
                                        class="text-[#3F9F03]">{{ $bot->daily_min . '% - ' . $bot->daily_max . '%' }}</span>
                                </p>
                                <p class="text-sm font-thin text-right mb-4">
                                    <span class="text-[#FF59CA]">Trading Portfolio</span>
                                    <span>{{ formatAmount($bot->min) . ' - ' . formatAmount($bot->max) }}</span>
                                </p>

                                <p class="text-right">
                                    <a role="button" data-bot_id="{{ $bot->id }}"
                                        data-bot_name="{{ $bot->name }}" data-bot_min="{{ formatAmount($bot->min) }}"
                                        data-bot_max="{{ formatAmount($bot->max) }}"
                                        class="bot rounded-xl py-2 px-4  text-sm cursor-pointer"
                                        style="background-color: #FAD1E8;">
                                        <span
                                            class="bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] bg-clip-text text-transparent">Activate</span></a>
                                </p>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="block lg:mb-10 mb-4 bg-[#372E45] rounded-2xl">
                        <div class="p-3 text-white">
                            <div class="flex justify-between items-center mb-4">
                                <div class="flex items-center gap-4">
                                    <span class="bg-yellow-600 text-black rounded-full px-4 py-2 font-bold">!</span>
                                    <span class="font-thin">No Bots</span>
                                </div>
                            </div>

                            <p class="text-lg font-thin text-center mb-4">
                                <span>Bots coming soon ...</span>
                            </p>

                        </div>
                    </div>
                @endforelse

            </div>

        </div>
    </div>
    {{--  --}}

    <div class="w-full">
        <div id="aiBotActivateModal"
            class="fixed inset-0 bg-opacity-50 flex items-center justify-end lg:px-6 px-2 backdrop-blur-xs hidden"
            style="z-index: 50;">
            <div id="modalDisplay"
                class="bg-[#0F0420] rounded-lg   w-full lg:w-[35vw]  lg:p-14 p-4 relative z-10  mx-auto backdrop-blur-lg max-h-[90vh] overflow-y-auto">


            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        //toggle for ai activation modal
        $(document).ready(function() {
            $('#openAiBotActivationModal').click(function() {
                $('#aiBotActivationModal').removeClass('hidden')
            });

            $('#aiBotActivationModal').on('click', '#closeAiBotActivationModal', function() {
                // You can add code to hide the modal here.
                $('#aiBotActivationModal').addClass('hidden');
            });

            $('#aiBotActiveModal').on('click', '#closeAiBotActiveModal', function() {
                // You can add code to hide the modal here.
                $('#aiBotActiveModal').addClass('hidden');
            });

            /////////////
            $('#aiBotActivateModal').on('click', '#closeAiBotActivateModal', function() {
                // You can add code to hide the modal here.
                $('#aiBotActivateModal').addClass('hidden');
            });
        });
    </script>

    {{-- chart --}}
    <script>
        ////////////////////// trading view chart
        var lineChartData = {
            labels: [], // This will be populated dynamically with date ranges
            datasets: [{
                label: "Profit",
                data: {!! json_encode($profits) !!}, // Random data for past 30 days (24 hours per day)
                pointBackgroundColor: "rgba(16,133,135,1)",
                pointBorderColor: "#fff",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(16,133,135,1)",
                tension: 0.4,
                fill: true,
            }],
        };

        // Generate day ranges for the past 30 days
        function generateDayLabels(days) {
            let labels = [];
            let now = new Date();

            for (let i = days - 1; i >= 0; i--) {
                let currentDate = new Date(now.getTime() - i * 24 * 60 * 60 * 1000); // Subtract i days from now

                // Format start and end days (the same for each day in this case)
                let startDay = String(currentDate.getDate()).padStart(2, "0");
                let endDay = String(currentDate.getDate()).padStart(2, "0");

                // Combine into (DD-DD)
                //labels.push(`(${startDay}-${endDay})`);
                labels.push(`${startDay}-${endDay}`);
            }
            return labels;
        }

        // Populate the labels with corresponding date ranges for the past 30 days
        lineChartData.labels = generateDayLabels(30); // 30 days

        // Ensure the DOM is fully loaded before executing the script
        window.addEventListener("load", function() {
            var canvas = document.getElementById("canvas");
            if (!canvas) {
                console.error("Canvas element not found!");
                return;
            }

            var ctx = canvas.getContext("2d");

            // Create a gradient for the first line (Profit)
            var gradientProfit = ctx.createLinearGradient(0, 0, canvas.width, 0); // Horizontal gradient
            gradientProfit.addColorStop(0, "rgba(16,133,135,1)");
            gradientProfit.addColorStop(1, "rgba(255,100,50,1)");

            // Assign the gradients to the datasets' borderColors
            lineChartData.datasets[0].borderColor = gradientProfit;

            // Create the chart
            new Chart(ctx, {
                type: "line",
                data: lineChartData,
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                stepSize: 1000, // Interval between steps
                                color: "#1ED6FF",
                            },
                        },
                        x: {
                            ticks: {
                                color: "#1ED6FF",
                                maxRotation: 90,
                                minRotation: 45,
                            },
                        },
                    },
                    plugins: {
                        legend: {
                            display: true,
                            position: "top",
                        },
                    },
                },
            });
        });
    </script>

    <script>
        function resizeCanvas() {
            const $wrapper = $('#canvas-wrapper');
            const $canvas = $('#canvas');
            const canvas = $canvas[0];
            const ctx = canvas.getContext('2d');

            // Set canvas size
            $canvas
                .attr('width', $wrapper.width())
                .attr('height', $wrapper.height());

            // Clear and redraw content
            drawContent(ctx, canvas.width, canvas.height);
        }

        function drawContent(ctx, width, height) {
            // Example drawing: Fill background
            ctx.fillStyle = '#f0f0f0';
            ctx.fillRect(0, 0, width, height);

            // Example drawing: Draw a centered circle
            ctx.beginPath();
            ctx.arc(width / 2, height / 2, Math.min(width, height) / 4, 0, Math.PI * 2);
            ctx.fillStyle = '#4f46e5'; // indigo-600
            ctx.fill();
        }

        $(window).on('resize', resizeCanvas);
        $(document).ready(resizeCanvas);
    </script>



    <script>
        $(document).ready(function() {
            $("#myAiBotsBtn").on("click", function() {
                $("#myAiBots").slideDown().removeClass('hidden');
                $("#aiTradingHistory, #dailySummary").slideUp().addClass('hidden');

                $("#aiTradingHistoryBtn, #dailySummaryBtn").removeClass('active');
                $("#myAiBotsBtn").addClass('active');
            });

            $("#aiTradingHistoryBtn").on("click", function() {
                $("#aiTradingHistory").slideDown().removeClass('hidden');
                $("#myAiBots, #dailySummary").slideUp().addClass('hidden');

                $("#myAiBotsBtn, #dailySummaryBtn").removeClass('active');
                $("#aiTradingHistoryBtn").addClass('active');
            });

            $("#dailySummaryBtn").on("click", function() {
                $("#dailySummary").slideDown().removeClass('hidden');
                $("#myAiBots, #aiTradingHistory").slideUp().addClass('hidden');

                $("#aiTradingHistoryBtn, #myAiBotsBtn").removeClass('active');
                $("#dailySummaryBtn").addClass('active');
            });
        });
    </script>

    @foreach ($activations as $item)
        <script>
            $(document).ready(function() {
                var target = "{{ 'bot_timer_' . $loop->iteration }}";
                var expires_in = {{ $item->expires_in }};

                // Get the current time in milliseconds
                var currentTime = new Date().getTime();

                // Calculate the remaining time in milliseconds
                var remainingTime = expires_in * 1000 - currentTime;

                // Calculate days, hours, minutes, and seconds
                var days = Math.floor(remainingTime / (1000 * 60 * 60 * 24));
                var hours = Math.floor((remainingTime % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((remainingTime % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((remainingTime % (1000 * 60)) / 1000);

                // Display the countdown
                var countdownElement = document.getElementById(target);
                countdownElement.innerHTML = days + "d " + hours + "h " + minutes + "m " + seconds + "s";

                // Update the countdown every second
                var countdownInterval = setInterval(function() {
                    if (remainingTime > 0) {
                        remainingTime -= 1000;

                        days = Math.floor(remainingTime / (1000 * 60 * 60 * 24));
                        hours = Math.floor((remainingTime % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        minutes = Math.floor((remainingTime % (1000 * 60 * 60)) / (1000 * 60));
                        seconds = Math.floor((remainingTime % (1000 * 60)) / 1000);

                        countdownElement.innerHTML = days + "d " + hours + "h " + minutes + "m " + seconds +
                            "s";
                    } else {
                        clearInterval(countdownInterval);
                        countdownElement.innerHTML = "Expired";
                    }
                }, 1000);
            });
        </script>
    @endforeach

    <script>
        let interval;


        // select the bot bot
        $(document).on('click', ".bot", function(e) {


            var bot_id = $(this).data('bot_id');
            var bot_name = $(this).data('bot_name');

            var bot_min = $(this).data('bot_min');
            var bot_max = $(this).data('bot_max');

            $('#aiBotActivationModal').addClass('hidden');
            // styling zuy
            var modalContent = `
            <div class="block">

                    <div class="flex justify-between items-center lg:mb-10 mb-4">
                        <h2 class="text-xl font-semibold mb-4 text-white">Ai Bot Activation</h2>

                        <button id="closeAiBotActivateModal" class="text-gray-400 hover:text-gray-600">
                            <img src="{{ asset('/assets/templates/zyphor/images/cancel-circle.svg') }}" alt="icon">
                        </button>
                    </div>

                    <!-- Modal Content -->
                    <form action="{{ route('user.bots.new') }}" method="post" id="botForm">
                        @csrf

                        <p class="mb-3 text-[#EA0A0E] text-xs text-center" id="errorMessage"></p>

                        <div class="w-full lg:mb-20 mb-10 lg:px-10">
                            <div class="bg-[#372E45] rounded-2xl p-6 mb-6">
                                <p class="mb-3 text-white font-thin text-sm">
                                    You have chosen to activate
                                    <span class="font-bold" id="dispay_bot_name"></span> Ai bot
                                </p>

                                <table class="w-full mb-3 text-sm">
                                    <tr>
                                        <td class="text-left">
                                            <span class="text-[#FAD1E8] font-thin">Minimum Capital:</span>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-white" id="dispay_bot_min"></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-left">
                                            <span class="text-[#FAD1E8] font-thin">Maximum Capital:</span>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-white" id="dispay_bot_max"></span>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>

                        <input type="hidden" name="bot_id" id="bot_id">

                        <div class="w-full lg:mb-20 mb-10 lg:px-10">
                            <label for="amount" class="text-white text-sm">Capital {{ site('currency') }}</label>
                            <div
                                class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                <span class="font-thin text-2xl ">{{ site('currency_symbol') }}</span>
                                <input type="number" placeholder="Capital ({{ site('currency') }})" id="capital"
                                    class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                    name="capital" value="0" required>
                            </div>
                        </div>

                        <div class="w-full lg:px-10">
                            <button type="submit" id="activateButton"
                                class="rounded-2xl w-full lg:px-10 lg:py-4 py-2 px-6 text-base transition delay-100 duration-200 ease-in-out cursor-pointer text-white btn-gradient flex items-center justify-center">
                                <span class="px-2">Activate Now</span>
                            </button>
                        </div>

                    </form>

                </div>
                `;



            $('#aiBotActivateModal').removeClass("hidden");
            $('#modalDisplay').html(modalContent);

            $('#dispay_bot_name').html(bot_name);
            $("#bot_id").val(bot_id);

            /////////my update
            $('#dispay_bot_min').html(bot_min);
            $('#dispay_bot_max').html(bot_max);

        });

        // handle bot form
        $(document).on('submit', '#botForm', function(e) {
            e.preventDefault();

            var form = $(this);
            var formData = new FormData(this);

            var submitButton = $(this).find('button[type="submit"]');
            submitButton.addClass('relative disabled');
            submitButton.append('<span class="button-spinner"></span>');
            submitButton.prop('disabled', true);

            // new modification
            submitButton.removeClass('btn-gradient');
            submitButton.addClass('not-allowed-cursor');

            $.ajax({
                url: form.attr('action'),
                method: 'POST',
                data: formData,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function(response) {
                    var link = window.location.href;
                    var targetDiv = '#bots';
                    $.ajax({
                        url: link,
                        method: 'GET',
                        success: function(response) {
                            $(targetDiv).html($(response).find(targetDiv).html());

                            var scrollTo = $(targetDiv).offset().top - 100;
                            $('.rescron-card').addClass('hidden');
                            $(targetDiv).removeClass('hidden');
                            $('html, body').animate({
                                scrollTop: scrollTo
                            }, 800);
                        }
                    });
                    toastNotify('success', 'Bot activated successfully');

                    // new modification
                    submitButton.addClass('btn-gradient');
                    submitButton.removeClass('not-allowed-cursor');

                    // var totalBotCount = {{ site('pagination') }};
                    // var targetTimersToUpdate = [];
                    // var i = 1;

                    // // Populate the targetTimersToUpdate array with bot timer IDs
                    // while (i <= totalBotCount) {
                    //     var bot_timer_id = "bot_timer_" + i;
                    //     targetTimersToUpdate.push(bot_timer_id);
                    //     i++;
                    // }

                    // // Loop through each target timer and apply the countdown logic
                    // targetTimersToUpdate.forEach(function(bot_timer_id) {
                    //     var target = bot_timer_id;

                    //     // Assuming you get the expiration time dynamically
                    //     var expires_in = parseInt(1740488192);

                    //     // Get the current time in milliseconds
                    //     var currentTime = new Date().getTime();

                    //     // Calculate the remaining time in milliseconds
                    //     var remainingTime = expires_in * 1000 - currentTime;

                    //     // Calculate days, hours, minutes, and seconds
                    //     var days = Math.floor(remainingTime / (1000 * 60 * 60 * 24));
                    //     var hours = Math.floor((remainingTime % (1000 * 60 * 60 * 24)) / (1000 *
                    //         60 * 60));
                    //     var minutes = Math.floor((remainingTime % (1000 * 60 * 60)) / (1000 *
                    //         60));
                    //     var seconds = Math.floor((remainingTime % (1000 * 60)) / 1000);

                    //     // Get the countdown element
                    //     var countdownElement = document.querySelector(`#${target}`);
                    //     var replace  = days + "d " + hours + "h " + minutes +
                    //     "m " + seconds + "s";

                    //     $("#testingDiv").text(replace);
                    //     $('#' + target).text(replace);
                    //     // console.log(replace);
                    //     console.log($('#' + target).text());
                    //     $('#' + target).hide();

                    //     // Initial countdown display
                    //     // countdownElement.innerHTML = replace;

                    //     // // Update the countdown every second
                    //     // var countdownInterval = setInterval(function() {
                    //     //     if (remainingTime > 0) {
                    //     //         remainingTime -= 1000;

                    //     //         days = Math.floor(remainingTime / (1000 * 60 * 60 *
                    //     //         24));
                    //     //         hours = Math.floor((remainingTime % (1000 * 60 * 60 *
                    //     //             24)) / (1000 * 60 * 60));
                    //     //         minutes = Math.floor((remainingTime % (1000 * 60 *
                    //     //             60)) / (1000 * 60));
                    //     //         seconds = Math.floor((remainingTime % (1000 * 60)) /
                    //     //             1000);

                    //     //         countdownElement.innerHTML = days + "d " + hours +
                    //     //             "h " + minutes + "m " + seconds + "s";
                    //     //     } else {
                    //     //         clearInterval(countdownInterval);
                    //     //         countdownElement.innerHTML = "Expired";
                    //     //     }
                    //     // }, 1000);

                    //     //console.log('executed');
                    // });

                    $('#aiBotActivateModal').addClass('hidden');
                },

                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;

                    if (errors) {
                        $.each(errors, function(field, messages) {
                            var fieldErrors = '';
                            $.each(messages, function(index, message) {
                                fieldErrors += message + '<br>';
                            });
                            $('#errorMessage').html(fieldErrors);
                        });
                    } else {
                        $('#errorMessage').html('error', 'An Error occured, try again later');
                    }


                },
                complete: function() {
                    submitButton.removeClass('disabled');
                    submitButton.find('.button-spinner').remove();
                    submitButton.prop('disabled', false);

                }
            });

        });
    </script>

    {{-- view trading history chart --}}
    <script src="https://s3.tradingview.com/tv.js"></script>
    <script>
        $(document).on('click', '.view-chart', function(e) {
            var pair = $(this).data('pair'); // BTCUSDT

            //fetch trading view chart for the pair

            Swal.fire({
                html: `
                    <div class="mt-5 w-full">
                        <div id="chart-container" class="w-full overflow-x-auto"></div>
                    </div>
                `,
                toast: false,
                background: 'rgb(7, 3, 12, 0)',
                showConfirmButton: false,
                showCloseButton: true,
                position: 'top-left',
                width: 'auto', // Auto width to adapt to content
                customClass: {
                    container: 'swal-responsive-container',
                    popup: 'swal-responsive-popup'
                },
                allowEscapeKey: false,
                allowOutsideClick: false,
                willClose: () => {
                    //delete the previously generated qrcode
                    // $('#single_wallet_qrcode').html('');
                }
            });

            new TradingView.widget({
                // Define the container element for the widget
                container_id: 'chart-container', // Replace 'chart-container' with your actual container ID

                // Specify the symbol (pair) you want to display
                symbol: pair,

                // Specify the interval for the chart (e.g., '1D' for 1 day)
                interval: '1D',

                // Choose the style of the chart (e.g., 'Line' or 'Candles')
                style: 'Candles',

                // Specify the timezone for the chart
                timezone: 'Etc/UTC',
                theme: 'Dark'

            });

        });
    </script>
@endsection
