@php
    use Illuminate\Support\Facades\DB;
    use App\Models\DepositCoin;
    use Illuminate\Support\Facades\Cache;

    function getCurrencyByCoin($id)
    {
        // Try to retrieve the coins from the cache
        $coins = Cache::get('coins');

        // If coins are not in the cache, retrieve them from the database and cache them
        if (!$coins) {
            $coins = DepositCoin::all();
            Cache::forever('coins', $coins);
        }

        // Find and return the coin by ID
        $coin = $coins->find($id);
        return $coin;
    }

    $days = array_slice($days, -7);
    $formated_days = [];
    $year = date('Y');

    foreach ($days as $day) {
        $formated_day = date('d M', strtotime($day . '-' . $year));
        array_push($formated_days, $formated_day);
    }
    $days = $formated_days;

    //////////////////////////////// merge deposit and wihdrawal
    // Merge both collections and sort by created_at

    $user_id = user()->id;
    $deposits_blade = DB::select("SELECT * FROM deposits WHERE user_id = $user_id ORDER BY id DESC LIMIT 5");
    $withdrawals_blade = DB::select("SELECT * FROM withdrawals WHERE user_id = $user_id ORDER BY id DESC LIMIT 5");

    $deposits_and_withdrawals = collect(array_merge((array) $deposits_blade, (array) $withdrawals_blade));

    // Sort the combined collection by 'created_at' in descending order
    $deposits_and_withdrawals = $deposits_and_withdrawals->sortByDesc('created_at');

    // Now $deposits_and_withdrawals contains a combined collection of deposits and withdrawals ordered by 'created_at'

    // Corrected dd() to dump the correct variables
    //dd($deposits_and_withdrawals, $deposits_blade, $withdrawals_blade);

    $pnlHistories = DB::select(
        "SELECT *
        FROM (
            SELECT *,
                @row_num := IF(@prev_date = DATE(created_at), @row_num + 1, 1) AS row_num,
                @prev_date := DATE(created_at) AS dummy
            FROM bot_histories, (SELECT @row_num := 0, @prev_date := NULL) AS vars
            WHERE user_id = $user_id
            ORDER BY DATE(created_at) DESC, id DESC
        ) AS ranked
        WHERE row_num = 1
        LIMIT 5;",
    );

@endphp



@extends('templates.' . site('template') . '.layouts.user')

@section('css')
    <style>
        .custom3xl\:grid-cols-3 {
            @media (width >=100rem

                /* 1024px */
            ) {
                grid-template-columns: repeat(3, minmax(0, 1fr));
            }
        }
    </style>
@endsection

@section('contents')
    {{-- Dashboard Cards  --}}
    <section class="lg:px-6 mt-20 md:mt-28 w-full mx-auto lg:relative">

        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[40rem] h-[40rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-10 top-20 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute left-10 top-80 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}


        <h1 class="text-white  text-3xl">{{ $page_title }}</h1>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 xl:grid-cols-3 custom3xl:grid-cols-3 gap-4 lg:gap-8">
            <!-- Account Card -->
            <div
                class="bg-white/5 border border-[#1a0f3a] text-white p-6 rounded-2xl shadow-lg w-full mx-auto relative overflow-hidden">

                <!-- Top row -->
                <div class="flex justify-between items-center">
                    <span class="text-lg font-medium">Account</span>

                    @if ($percentage_deposit_increase < 0)
                        <div class="flex items-center text-red-500 font-medium gap-1">
                            <img src="{{ asset('assets/templates/zyphor/images/dashboard-arrow-down.svg') }}"
                                alt="">
                            <span>{{ number_format($percentage_deposit_increase, 2) }}%</span>
                        </div>
                    @else
                        <div class="flex items-center text-green-400 font-medium gap-1">
                            <img src="{{ asset('assets/templates/zyphor/images/dashboard-arrow-up.svg') }}" alt=""
                                class="rotate-270">
                            <span>{{ number_format($percentage_deposit_increase, 2) }}%</span>
                        </div>
                    @endif
                </div>


                <!-- Bottom row -->
                <div class="mt-4">
                    <p class="text-2xl font-medium mb-2 md:mb-4">{{ formatAmount(user()->balance) }}</p>
                    <p class="text-md text-white/50 font-thin tracking-wide">{{ formatAmount($todays_deposits) }} today
                    </p>
                </div>
            </div>


            <!-- All Time PNL Card -->
            <div
                class="bg-white/5 text-white border border-[#1a0f3a] p-6 rounded-2xl shadow-lg w-full mx-auto relative overflow-hidden">

                <!-- Top row -->
                <div class="flex justify-between items-center">
                    <div class="flex items-center gap-3">

                        <span class="text-lg font-medium">All Time PNL</span>
                    </div>

                    @if ($profit_percent < 0)
                        <div class="flex items-center text-red-500 font-medium gap-1">
                            <img src="{{ asset('assets/templates/zyphor/images/dashboard-arrow-down.svg') }}"
                                alt="">
                            <span>{{ number_format($profit_percent, 2) }}%</span>
                        </div>
                    @else
                        <div class="flex items-center text-green-400 font-medium gap-1">
                            <img src="{{ asset('assets/templates/zyphor/images/dashboard-arrow-up.svg') }}" alt=""
                                class="rotate-270">
                            <span>{{ number_format($profit_percent, 2) }}%</span>
                        </div>
                    @endif
                </div>

                <!-- Bottom row -->
                <div class="mt-4">
                    <p class="text-2xl font-medium mb-2 md:mb-4">{{ formatAmount($profit_fig + $capital) }}</p>

                </div>
            </div>

            <!-- AI Bots Card -->
            <div
                class="bg-white/5 border border-[#1a0f3a] text-white p-6 rounded-2xl shadow-lg w-full mx-auto relative overflow-hidden">

                <!-- Top row -->
                <div class="flex justify-between items-center">
                    <span class="text-lg font-medium">AI Bots</span>

                    {{-- Right side placeholder (optional) --}}
                    {{-- <div class="flex items-center text-green-400 font-medium gap-1">
                        <img src="..." alt="">
                        <span>...</span>
                    </div> --}}
                </div>


                <!-- Bottom row -->
                <div class="mt-4">
                    <p class="text-2xl font-medium mb-2 md:mb-4">{{ user()->botActivations()->count() }}</p>

                    <p class="text-md text-white/50 font-thin tracking-wide">+{{ user()->botHistory()->count() }} trades
                    </p>

                </div>
            </div>

        </div>
    </section>


    {{-- pnl cards --}}
    <section class="lg:px-6 mt-20 md:mt-28 w-full mx-auto lg:relative text-white">
        <div class="grid grid-cols-1 gap-6 md:gap-10 lg:gap-16">
            <div class="block" id="pnlCardRefresh">
                <div class="block swiper mySwiper">
                    <div class="block swiper-wrapper py-5">

                        {{-- @forelse ($histories->take(5) as $pnlCard) --}}
                        @forelse ($pnlHistories as $pnlCard)
                            @php
                                $capital_card = $pnlCard->capital;
                                $entry_price_card = $pnlCard->entry_price;
                                $exit_price_card = $pnlCard->exit_price;
                                $profit_card =
                                    ($exit_price_card - $entry_price_card) * ($capital_card / $entry_price_card);
                                $profit_percent_card = ($profit_card / $capital_card) * 100;

                                // Cycle through 1 to 3
                                $imageIndex = ($loop->index % 3) + 1;
                            @endphp

                            <div class="swiper-slide rounded-lg p-6 min-h-[200px]"
                                style="background: url('{{ asset("/assets/templates/zyphor/images/pnl-image-$imageIndex.png") }}'); background-size: cover; background-position: center; background-repeat: no-repeat;">
                                <div class="block">
                                    {{-- content --}}
                                    <div class="block mb-1">
                                        <p class="text-sm">{{ site('name') }}</p>
                                        <h3 class="text-base font-semibold text-white">PNL</h3>
                                    </div>

                                    <div class="block mb-2">
                                        <p class="text-sm">Trade Summary for {{ date('Y-m-d H:i:s', $pnlCard->timestamp) }}
                                        </p>
                                    </div>

                                    <div class="block mb-6">
                                        <h3 class="text-2xl font-semibold">
                                            @if ($profit_percent_card > 0)
                                                <span
                                                    class="text-[#3f9f03]">+{{ number_format($profit_percent_card, 2) }}%</span>
                                            @else
                                                <span
                                                    class="text-[#ea0423]">{{ number_format($profit_percent_card, 2) }}%</span>
                                            @endif
                                        </h3>
                                    </div>

                                    <div class="lg:flex block gap-4 items-center justify-between mb-2 ">
                                        <div class="block w-full mb-2">
                                            <p>
                                                <span class="text-white text-sm">Trading Portfolio -
                                                </span>{{ formatAmount($capital_card) }}
                                            </p>
                                            <p>
                                                <span class="text-white text-sm">Profit Portfolio -
                                                </span>{{ formatAmount($capital_card + $profit_card) }}
                                            </p>
                                        </div>

                                        <div class="flex gap-2 items-center lg:ml-auto">
                                            <div class="block w-20 bg-[#424344] p-1 rounded-lg">
                                                <div class="referrealQrCode" data-ref="{{ $user->username ?? 'notset' }}">
                                                </div>
                                            </div>

                                            <div class="block">
                                                <p class="text-white text-xs mb-4">Referral Link</p>
                                                <p class="text-white font-bold mb-4">{{ user()->username }}</p>
                                            </div>
                                        </div>
                                    </div>


                                    <p class="text-white text-xs truncate lg:hidden">
                                        {{ route('user.register', ['ref' => user()->username ?? 'notset']) }}
                                    </p>
                                </div>
                            </div>
                        @empty
                            <div class="swiper-slide rounded-lg p-6 min-h-[200px]"
                                style="background: url('{{ asset('/assets/templates/zyphor/images/pnl-image-1.png') }}'); background-size: cover; background-position: center; background-repeat: no-repeat;">
                                <div class="block">
                                    {{-- content --}}
                                    <div class="block mb-1">
                                        <p class="text-sm">{{ site('name') }}</p>
                                        <h3 class="text-base font-semibold text-white">PNL</h3>
                                    </div>

                                    <div class="block mb-2">
                                        <p class="text-sm">Trade Summary for {{ date('Y-m-d H:i:s', time()) }}
                                        </p>
                                    </div>

                                    <div class="block mb-6">
                                        <h3 class="text-2xl font-semibold">
                                            <span class="text-[#ea0423]">{{ number_format(00, 2) }}%</span>
                                        </h3>
                                    </div>

                                    <div class="lg:flex block gap-4 items-center justify-between mb-2 ">
                                        <div class="block w-full mb-2">
                                            <p>
                                                <span class="text-white text-sm">Trading Portfolio -
                                                </span>{{ '00.00' }}
                                            </p>
                                            <p>
                                                <span class="text-white text-sm">Profit Portfolio -
                                                </span>{{ '00.00' }}
                                            </p>
                                        </div>

                                        <div class="flex gap-2 items-center lg:ml-auto">
                                            <div class="block w-20 bg-[#424344] p-1 rounded-lg">
                                                <div class="referrealQrCode" data-ref="{{ $user->username ?? 'notset' }}">
                                                </div>
                                            </div>

                                            <div class="block">
                                                <p class="text-white text-xs mb-4">Referral Link</p>
                                                <p class="text-white font-bold mb-4">{{ user()->username }}</p>
                                            </div>
                                        </div>
                                    </div>


                                    <p class="text-white text-xs truncate lg:hidden">
                                        {{ route('user.register', ['ref' => user()->username ?? 'notset']) }}
                                    </p>
                                </div>
                            </div>
                        @endforelse

                    </div>
                </div>
            </div>

            <div class="flex justify-center gap-2" style="margin-top: -20px">
                {{-- @if ($histories) --}}
                @if ($pnlHistories)
                    <div class="bg-[#ea2a97] rounded-full indicator" style="height:5px; width:24px;"></div>
                    <div class="bg-[#ea2a97] rounded-full indicator" style="height:5px; width:5px;"></div>
                    <div class="bg-[#ea2a97] rounded-full indicator" style="height:5px; width:5px;"></div>
                    <div class="bg-[#ea2a97] rounded-full indicator" style="height:5px; width:5px;"></div>
                    <div class="bg-[#ea2a97] rounded-full indicator lg:hidden" style="height:5px; width:5px;"></div>
                @endif
            </div>


        </div>
    </section>



    {{-- my bots and recent trades section  --}}
    <section class="lg:px-6 md:mt-20 w-full mx-auto  text-white">
        <div class="lg:grid grid-cols-2 gap-10">
            <!--my bots-->
            <div
                class="mb-8 lg:mb-0  col-span-1 shadow-[14px_16px_6px_-5px_rgba(0,_0,_0,_0.1)] bg-[#190735] p-4 rounded-4xl relative overflow-hidden">

                <div class="flex items-center justify-between  mb-4">
                    <h2 class="text-lg">My Bots</h2>
                    <a href="{{ route('user.bots.index') }}"
                        class="bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] bg-clip-text text-transparent">View
                        All</a>
                </div>
                <div class="block  rounded-xl  p-4 overflow-y-auto max-h-[50vh]">

                    @forelse ($activations as $bot)
                        <ul class="w-full  gap-2 mb-0">
                            <li class="text-left flex gap-2 items-center mb-3 w-full">
                                <img class="w-8 h-8 bg-white rounded-full"
                                    src="{{ asset('storage/bots/' . $bot->bot->logo) }}" alt="bots">
                                <div>
                                    <p class="flex text-white gap-2 items-center">
                                        {{ $bot->bot->name }}
                                        @if ($bot->status == 'active')
                                            <svg width="24" height="25" viewBox="0 0 24 25" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path opacity="0.3" fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M10.6319 1.64199C10.9859 1.28847 11.4595 1.08045 11.9593 1.05897C12.4591 1.0375 12.9489 1.20413 13.3319 1.52599L13.4599 1.64299L15.3599 3.54199H18.0459C18.5503 3.54209 19.036 3.73277 19.4058 4.07583C19.7756 4.4189 20.002 4.88901 20.0399 5.39199L20.0459 5.54199V8.22799L21.9459 10.128C22.2997 10.482 22.5079 10.9559 22.5293 11.4559C22.5508 11.956 22.384 12.4459 22.0619 12.829L21.9449 12.956L20.0449 14.856V17.542C20.045 18.0466 19.8545 18.5326 19.5114 18.9025C19.1683 19.2725 18.698 19.4992 18.1949 19.537L18.0459 19.542H15.3609L13.4609 21.442C13.1068 21.7958 12.633 22.004 12.1329 22.0255C11.6329 22.0469 11.1429 21.8801 10.7599 21.558L10.6329 21.442L8.73287 19.542H6.04587C5.54129 19.5422 5.0553 19.3516 4.68532 19.0085C4.31534 18.6654 4.08871 18.1951 4.05087 17.692L4.04587 17.542V14.856L2.14587 12.956C1.79206 12.602 1.58387 12.1281 1.56239 11.6281C1.54091 11.128 1.70772 10.6381 2.02987 10.255L2.14587 10.128L4.04587 8.22799V5.54199C4.04596 5.03759 4.23664 4.55185 4.57971 4.18208C4.92277 3.81231 5.39289 3.58582 5.89587 3.54799L6.04587 3.54199H8.73187L10.6319 1.64199Z"
                                                    fill="#00AA39" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M15.1255 8.52497L10.8815 12.769L9.11345 11.001C8.92581 10.8135 8.67137 10.7082 8.4061 10.7083C8.14083 10.7084 7.88646 10.8138 7.69895 11.0015C7.51144 11.1891 7.40616 11.4436 7.40625 11.7088C7.40634 11.9741 7.51181 12.2285 7.69945 12.416L10.1035 14.82C10.2056 14.9222 10.3269 15.0032 10.4604 15.0586C10.5939 15.1139 10.737 15.1423 10.8815 15.1423C11.0259 15.1423 11.169 15.1139 11.3025 15.0586C11.436 15.0032 11.5573 14.9222 11.6595 14.82L16.5395 9.93897C16.7216 9.75037 16.8224 9.49777 16.8201 9.23557C16.8178 8.97338 16.7127 8.72256 16.5273 8.53716C16.3419 8.35175 16.0911 8.24658 15.8289 8.2443C15.5667 8.24202 15.3141 8.34282 15.1255 8.52497Z"
                                                    fill="#F0FCFF" />
                                            </svg>
                                        @else
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="#6b7280"
                                                class="bi bi-patch-exclamation-fill" viewBox="0 0 16 16">
                                                <path
                                                    d="M10.067.87a2.89 2.89 0 0 0-4.134 0l-.622.638-.89-.011a2.89 2.89 0 0 0-2.924 2.924l.01.89-.636.622a2.89 2.89 0 0 0 0 4.134l.637.622-.011.89a2.89 2.89 0 0 0 2.924 2.924l.89-.01.622.636a2.89 2.89 0 0 0 4.134 0l.622-.637.89.011a2.89 2.89 0 0 0 2.924-2.924l-.01-.89.636-.622a2.89 2.89 0 0 0 0-4.134l-.637-.622.011-.89a2.89 2.89 0 0 0-2.924-2.924l-.89.01-.622-.636zM8 4c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995A.905.905 0 0 1 8 4zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                            </svg>
                                        @endif
                                    </p>

                                </div>
                            </li>
                        </ul>

                        <ul class="w-full grid grid-cols-2 gap-2 mb-3 border-b  border-[#f272d5]/25 pb-4">
                            <li class="text-left flex gap-2 items-center">
                                <span class="text-[#FF59CA] block">Portfolio Balance</span>
                            </li>

                            <li class="text-right flex items-center justify-end">
                                <span class="text-white">PNL</span>
                            </li>

                            <li class="text-left flex gap-2 items-center">
                                <span class="text-sm block"> {{ formatAmount($bot->balance) }}</span>
                            </li>

                            <li class="text-right flex items-center justify-end">
                                @if ($bot->profit < 0)
                                    <span class="text-red-500 flex space-x-1 flex justify-end">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                            class="w-6 h-6">
                                            <path fill-rule="evenodd"
                                                d="M1.72 5.47a.75.75 0 011.06 0L9 11.69l3.756-3.756a.75.75 0 01.985-.066 12.698 12.698 0 014.575 6.832l.308 1.149 2.277-3.943a.75.75 0 111.299.75l-3.182 5.51a.75.75 0 01-1.025.275l-5.511-3.181a.75.75 0 01.75-1.3l3.943 2.277-.308-1.149a11.194 11.194 0 00-3.528-5.617l-3.809 3.81a.75.75 0 01-1.06 0L1.72 6.53a.75.75 0 010-1.061z"
                                                clip-rule="evenodd" />
                                        </svg>
                                        <span>{{ round(($bot->profit / ($bot->capital + 0.0001)) * 100, 2) }}%</span>
                                    </span>
                                @else
                                    <span class="text-green-500 flex space-x-1 flex justify-end">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                            class="w-6 h-6">
                                            <path fill-rule="evenodd"
                                                d="M15.22 6.268a.75.75 0 01.968-.432l5.942 2.28a.75.75 0 01.431.97l-2.28 5.941a.75.75 0 11-1.4-.537l1.63-4.251-1.086.483a11.2 11.2 0 00-5.45 5.174.75.75 0 01-1.199.19L9 12.31l-6.22 6.22a.75.75 0 11-1.06-1.06l6.75-6.75a.75.75 0 011.06 0l3.606 3.605a12.694 12.694 0 015.68-4.973l1.086-.484-4.251-1.631a.75.75 0 01-.432-.97z"
                                                clip-rule="evenodd" />
                                        </svg>
                                        <span>+{{ round(($bot->profit / ($bot->capital + 0.0001)) * 100, 2) }}%</span>
                                    </span>
                                @endif
                            </li>
                        </ul>

                    @empty
                        <p
                            class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500" fill="currentColor"
                                class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                <path
                                    d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                            </svg>
                            <span>Empty Record. No Record found!</span>
                        </p>
                    @endforelse
                </div>
            </div>

            <!--recent trades-->
            <div
                class="mb-2 col-span-1 shadow-[14px_16px_6px_-5px_rgba(0,_0,_0,_0.1)] bg-[#190735] p-4 rounded-4xl relative overflow-hidden">

                <div class="flex items-center justify-between  mb-4">
                    <h2 class="text-lg">My Recent Trades</h2>
                    <a href="{{ route('user.bots.index') }}"
                        class="bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] bg-clip-text text-transparent">View
                        All</a>
                </div>


                <div class="block   rounded-2xl overflow-y-auto  max-h-[50vh]">
                    <table class="w-full">
                        {{-- <thead class="text-center">
                            <th class="px-6 py-2 text-left">AI Bots</th>
                            <th class="px-6 py-2 text-right">Trading Pairs</th>
                            <th class="px-6 py-2 text-left">Profit/Loss</th>
                        </thead> --}}
                        <tbody>
                            @forelse ($histories as $history)
                                <tr class="border-b  border-[#f272d5]/25">
                                    <td class="p-6 min-w-[200px]">
                                        <div class="block">
                                            <div class="flex gap-2">
                                                <img class="w-8 h-8 bg-white rounded-full"
                                                    src="{{ asset('storage/bots/' . $history->botActivation->bot->logo) }}"
                                                    alt="">
                                                <p class="">
                                                    {{ $history->botActivation->bot->name }}
                                                </p>
                                            </div>
                                            <div class="block">

                                                <p class="text-sm ">{{ date('d-m-y H:i:s', $history->timestamp) }}</p>
                                            </div>
                                        </div>
                                    </td>


                                    @if ($history->profit < 0)
                                        <td class="text-right p-6">
                                            <p class="text-xs md:text-sm font-bold text-[#EA0A0E]">
                                                -{{ formatAmount(str_replace('-', '', $history->profit)) }}</p>
                                        </td>

                                        <td class="text-right p-6">
                                            <p class="text-xs md:text-sm text-[#FF59CA]">{{ $history->pair }}
                                            </p>
                                            <p class="text-[#EA0A0E] text-xs md:text-sm">
                                                {{ number_format((($history->exit_price - $history->entry_price) / $history->entry_price) * 100, 2) }}%
                                            </p>

                                        </td>
                                    @else
                                        <td class="text-right p-6">
                                            <p class="text-xs md:text-sm font-bold text-white">
                                                {{ formatAmount(str_replace('-', '', $history->profit)) }}</p>
                                        </td>

                                        <td class="text-right p-6">
                                            <p class="text-xs md:text-sm text-[#FF59CA]">{{ $history->pair }}
                                            </p>
                                            <p class="text-[#00AA39] text-xs md:text-sm">
                                                +{{ number_format((($history->exit_price - $history->entry_price) / $history->entry_price) * 100, 2) }}%
                                            </p>

                                        </td>
                                    @endif
                                </tr>
                            @empty
                                <p
                                    class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                        fill="currentColor" class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                        <path
                                            d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                    </svg>
                                    <span>Empty Record. No Record found!</span>
                                </p>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>



    {{-- charts section  --}}
    <section class="lg:px-6 mt-8 md:mt-28 w-full mx-auto lg:relative">

        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute left-30 -top-28 w-[40rem] h-[40rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>
        </div>
        {{-- end gradient --}}



        <div class="bg-white/5 rounded-lg p-6">
            <div class="w-full py-6">
                <div class=" mx-auto mb-3 text-white">
                    <h2
                        class="text-sm md:text-base lg:text-2xl w-fit  mb-2 md:mb-6 text-transparent bg-clip-text bg-gradient-to-r from-[#e1d2f9] to-[#fad1e8]">
                        AI Trading Overview (7 Day PNL)</h2>

                    <div class="block lg:flex items-center justify-between">
                        <div class="flex gap-1 text-xs mb-3">
                            <span class="bg-[#372E45] px-4 py-2 rounded-l-lg">12 months</span>
                            <span class="bg-[#372E45] px-4 py-2">30 days</span>
                            <span class="bg-[#372E45] px-4 py-2">7 days</span>
                            <span class="bg-[#372E45] px-4 py-2 rounded-r-lg">24 hours</span>
                        </div>

                        <div class="flex gap-3 px-4 py-2 border border-white rounded-lg w-fit">
                            <span
                                class="w-4 h-4 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] rounded-full"></span>
                            <span>PNL</span>
                        </div>
                    </div>

                    <div id="canvas-wrapper" class="w-full md:h-[50vh] relative overflow-hidden rounded-4xl">
                        <canvas id="canvas" class="w-full h-full block"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </section>



    {{-- my history section  --}}
    <section class="lg:px-6 mt-8 md:mt-28 w-full mx-auto lg:relative">

        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[40rem] h-[40rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-56 -top-20 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute -left-10 -top-10 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}



        <div class="w-full mb-3 text-white rounded-t-lg">

            <div class="block bg-[#250A4F] px-6 py-3 rounded-t-2xl">
                <p class="text-xl lg:text-3xl font-bold mr-10 mb-3">My History</p>
                <div class="flex lg:gap-4 gap-2">
                    <button id="all_history_btn" class=" text-white px-6 py-2 rounded-xl gradient-tab">All</button>
                    <button id="withdrawal_history_btn" class=" text-white px-6 py-2 rounded-xl">Withdrawal</button>
                    <button id="deposit_history_btn" class=" text-white px-6 py-2 rounded-xl">Deposits</button>
                </div>
            </div>
            {{-- all history tab  --}}
            <div class="block bg-[#190735] px-6 py-3 rounded-b-2xl">
                <div id="all_history" class="block mb-10 rounded-4xl overflow-auto w-full relative max-h-[60vh]">

                    <table class="w-full">

                        <thead class="text-center text-[#FF59CA]">
                            <th class="p-6 text-left">AI Bots/ID</th>
                            <th class="p-6 text-right">Amount</th>
                            <th class="p-6 text-right gap-2">
                                <span id="status-dropdown-btn"
                                    class="w-full status-dropdown-btn flex gap-3 items-center justify-end">Status
                                </span>

                            </th>
                        </thead>
                        <tbody>
                            @forelse ($deposits_and_withdrawals as $allData)
                                <tr class="border-t  border-[#f272d5]/25">
                                    <td class="p-6">
                                        <div class="flex items-center gap-4 ">
                                            <img class="w-8 h-8"
                                                src="{{ 'https://nowpayments.io' . getCurrencyByCoin($allData->deposit_coin_id)->logo_url }}"
                                                alt="bitcoin" width="50px">
                                            <p class="text-base font-thin">
                                                {{ getCurrencyByCoin($allData->deposit_coin_id)->name }}
                                            </p>
                                        </div>
                                        <p class=" text-gray-400 text-sm"
                                            title="{{ $allData->wallet_address ?? $allData->payment_wallet }}">
                                            {{ $allData->wallet_address ?? $allData->payment_wallet }}
                                        </p>
                                    </td>
                                    <td class="text-right p-6">
                                        <p class="text-base font-thin">{{ formatAmount($allData->amount) }}</p>
                                        <p class=" text-gray-400">
                                            {{ $allData->converted_amount }}
                                            {{ getCurrencyByCoin($allData->deposit_coin_id)->code }}/
                                            <span
                                                class="text-[#EA0A0E]">{{ getCurrencyByCoin($allData->deposit_coin_id)->network ?? getCurrencyByCoin($allData->deposit_coin_id)->code }}</span>
                                        </p>
                                    </td>
                                    <td class="text-right p-6">
                                        <p class="flex justify-end items-center space-x-1 gap-2 text-end">

                                            @if ($allData->status == 'waiting')
                                                <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $allData->status }}</span>
                                            @elseif ($allData->status == 'approved' || $allData->status == 'finished')
                                                <img src="{{ asset('/assets/templates/zyphor/images/green_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $allData->status }}</span>
                                            @elseif ($allData->status == 'pending')
                                                <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $allData->status }}</span>
                                            @elseif ($allData->status == 'failed' || $allData->status == 'refunded')
                                                <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $allData->status }}</span>
                                            @elseif ($allData->status == 'rejected')
                                                <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $allData->status }}</span>
                                            @else
                                                <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                    alt="">

                                                <span class="text-white capitalize text-sm">{{ $allData->status }}</span>
                                            @endif
                                        </p>
                                        <p class="text-sm text-gray-400 text-end">
                                            {{ date('d-m-y  H:i:s A', strtotime($allData->created_at)) }}
                                        </p>
                                    </td>
                                </tr>
                            @empty
                                <tr class="border border-opacity-25 border-[#f272d5]/25 cursor-pointer">
                                    <td
                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                            fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                        </svg>
                                        <span>Empty Record. No Record found!</span>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div id="withdrawal_history" class="hidden mb-10 rounded-4xl overflow-auto w-full relative max-h-[60vh]">

                    <table class="w-full">
                        <thead class="text-center text-[#FF59CA]">
                            <th class="p-6 text-left">AI Bots/ID</th>
                            <th class="p-6 text-right">Amount</th>
                            <th class="p-6 text-right gap-2">
                                <span id="status-dropdown-btn"
                                    class="w-full status-dropdown-btn flex gap-3 items-center justify-end">Status
                                </span>

                            </th>
                        </thead>
                        <tbody>
                            @forelse ($withdrawals as $withdrawal)
                                <tr class="border-t border-[#f272d5]/25 ">
                                    <td class="p-6">
                                        <div class="flex items-center gap-4 ">
                                            <img class="w-8 h-8"
                                                src="{{ 'https://nowpayments.io' . $withdrawal->depositCoin->logo_url }}"alt=""
                                                sswidth="50px">
                                            <div class="block">
                                                <p class="text-xl font-thin">{{ $withdrawal->depositCoin->name }}</p>

                                            </div>
                                        </div>
                                        <p class=" text-gray-400 text-sm">{{ $withdrawal->wallet_address }}</p>
                                    </td>
                                    <td class="text-right p-6">
                                        <p class="text-base font-thin">
                                            {{ formatAmount($withdrawal->amount - $withdrawal->fee) }}</p>
                                        <p class=" text-gray-400">
                                            <span>{{ $withdrawal->converted_amount . ' ' . $withdrawal->depositCoin->code }}</span>
                                            <span
                                                class="text-[#EA0A0E]">{{ $withdrawal->depositCoin->network ?? $withdrawal->depositCoin->code }}</span>
                                        </p>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="flex justify-end items-center space-x-1 gap-4">

                                            @if ($withdrawal->status == 'waiting')
                                                <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                    alt="">
                                                <span
                                                    class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                            @elseif ($withdrawal->status == 'approved' || $withdrawal->status == 'finished')
                                                <img src="{{ asset('/assets/templates/zyphor/images/green_status_icon.svg') }}"
                                                    alt="">
                                                <span
                                                    class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                            @elseif ($withdrawal->status == 'pending')
                                                <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                    alt="">
                                                <span
                                                    class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                            @elseif ($withdrawal->status == 'failed' || $withdrawal->status == 'refunded')
                                                <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                    alt="">
                                                <span
                                                    class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                            @elseif ($withdrawal->status == 'rejected')
                                                <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                    alt="">
                                                <span
                                                    class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                            @else
                                                <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                    alt="">

                                                <span
                                                    class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                            @endif
                                        </p>

                                        <p class="text-sm text-gray-400 text-end">
                                            {{ date('d-m-y H:i:s A', strtotime($withdrawal->created_at)) }}
                                        </p>
                                    </td>
                                </tr>
                            @empty
                                <tr class="border border-opacity-25 border-blue-200 cursor-pointer">
                                    <td
                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                            fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                        </svg>
                                        <span>Empty Record. No withdrawal found!</span>
                                    </td>
                                </tr>
                            @endforelse

                        </tbody>
                    </table>
                </div>

                <div id="deposit_history" class="hidden mb-10 rounded-4xl overflow-auto w-full relative max-h-[60vh]">

                    <table class="w-full">
                        <thead class="text-center text-[#FF59CA]">
                            <th class="p-6 text-left">AI Bots/ID</th>
                            <th class="p-6 text-right">Amount</th>
                            <th class="p-6 text-right gap-2">
                                <span id="status-dropdown-btn"
                                    class="w-full status-dropdown-btn flex gap-3 items-center justify-end">Status
                                </span>

                            </th>
                        </thead>
                        <tbody>
                            @forelse ($deposits as $deposit)
                                <tr class="border-t border-[#f272d5]/25">
                                    <td class="p-6">
                                        <div class="flex items-center gap-4 ">
                                            <img class="w-8 h-8"
                                                src="{{ 'https://nowpayments.io' . $deposit->depositCoin->logo_url }}"alt=""
                                                sswidth="50px">
                                            <div class="block">
                                                <p class="text-base font-thin">{{ $deposit->depositCoin->name }}</p>

                                            </div>
                                        </div>
                                        <p class=" text-gray-400 text-sm">{{ $deposit->payment_wallet }}</p>
                                    </td>
                                    <td class="text-right p-6">
                                        <p class="text-base font-thin">
                                            {{ formatAmount($deposit->amount) }}</p>
                                        <p class=" text-gray-400">
                                            <span>{{ $deposit->converted_amount . ' ' . $deposit->depositCoin->code }}</span>
                                            <span
                                                class="text-[#EA0A0E]">{{ $deposit->depositCoin->network ?? $deposit->depositCoin->code }}</span>
                                        </p>
                                    </td>
                                    <td class="text-left p-6">
                                        <p class="flex justify-end items-center space-x-1 gap-4">

                                            @if ($deposit->status == 'waiting')
                                                <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                            @elseif ($deposit->status == 'approved' || $deposit->status == 'finished')
                                                <img src="{{ asset('/assets/templates/zyphor/images/green_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                            @elseif ($deposit->status == 'pending')
                                                <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                            @elseif ($deposit->status == 'failed' || $deposit->status == 'refunded')
                                                <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                            @elseif ($deposit->status == 'rejected')
                                                <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                    alt="">
                                                <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                            @else
                                                <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                    alt="">

                                                <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                            @endif
                                        </p>
                                        <p class="text-sm text-gray-400 text-end">
                                            {{ date('d-m-y H:i:s A', strtotime($deposit->created_at)) }}
                                        </p>
                                    </td>
                                </tr>
                            @empty
                                <tr class="border border-opacity-25 border-blue-200 cursor-pointer">
                                    <td
                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                            fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                        </svg>
                                        <span>Empty Record. No Deposit found!</span>
                                    </td>
                                </tr>
                            @endforelse

                        </tbody>
                    </table>
                </div>
            </div>

        </div>


        {{-- small gradient --}}
        <div
            class="absolute right-10 -bottom-20 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
        </div>
        </div>
        {{-- end gradient --}}
    </section>
@endsection

@section('scripts')
    {{-- chart script  --}}
    <script>
        var lineChartData = {
            labels: @json($days), // Pass PHP-generated days
            datasets: [{
                    label: "PNL",
                    data: @json($profits), // Pass PHP-generated profit data
                    pointBackgroundColor: "rgba(30,151,80,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(30,151,80,1)",
                    tension: 1,
                    fill: false,
                },

            ],
        };

        window.addEventListener("load", function() {
            var canvas = document.getElementById("canvas");
            if (!canvas) {
                console.error("Canvas element not found!");
                return;
            }

            var ctx = canvas.getContext("2d");

            var gradientProfit = ctx.createLinearGradient(0, 0, canvas.width, 0);
            gradientProfit.addColorStop(0, "rgba(30,151,80,1)");
            gradientProfit.addColorStop(1, "rgba(30,151,80,1)");
            lineChartData.datasets[0].borderColor = gradientProfit;



            new Chart(ctx, {
                type: "line",
                data: lineChartData,
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                stepSize: 1000,
                                color: "#1ED6FF",
                                callback: function(value) {
                                    return value + ' ' + `{{ site('currency') }}`;
                                }
                            },
                        },
                        x: {
                            beginAtZero: true,
                            ticks: {
                                color: "#1ED6FF",
                            },
                        },
                    },
                    plugins: {
                        legend: {
                            display: true,
                            position: "top",
                        },
                        tooltip: {
                            callbacks: {
                                title: function(tooltipItem) {
                                    return `Day: ${tooltipItem[0].label}`;
                                },
                                label: function(tooltipItem) {
                                    return `${tooltipItem.dataset.label}: ${tooltipItem.raw} {{ site('currency') }}`;
                                },
                            },
                        },
                    },
                },
            });
        });
    </script>

    <script>
        function resizeCanvas() {
            const $wrapper = $('#canvas-wrapper');
            const $canvas = $('#canvas');
            const canvas = $canvas[0];
            const ctx = canvas.getContext('2d');

            // Set canvas size
            $canvas
                .attr('width', $wrapper.width())
                .attr('height', $wrapper.height());

            // Clear and redraw content
            drawContent(ctx, canvas.width, canvas.height);
        }

        function drawContent(ctx, width, height) {
            // Example drawing: Fill background
            ctx.fillStyle = '#f0f0f0';
            ctx.fillRect(0, 0, width, height);

            // Example drawing: Draw a centered circle
            ctx.beginPath();
            ctx.arc(width / 2, height / 2, Math.min(width, height) / 4, 0, Math.PI * 2);
            ctx.fillStyle = '#4f46e5'; // indigo-600
            ctx.fill();
        }

        $(window).on('resize', resizeCanvas);
        $(document).ready(resizeCanvas);
    </script>


    <!-- jQuery Script for Sidebar Toggle and right dropdown-->
    <script>
        $(document).ready(function() {
            $("#all_history_btn").on("click", function() {
                $("#all_history").slideDown().removeClass('hidden');
                $("#withdrawal_history, #deposit_history").slideUp().addClass('hidden');

                $("#withdrawal_history_btn, #deposit_history_btn").removeClass('gradient-tab');
                $("#all_history_btn").addClass('gradient-tab');
            });

            $("#withdrawal_history_btn").on("click", function() {
                $("#withdrawal_history").slideDown().removeClass('hidden');
                $("#all_history, #deposit_history").slideUp().addClass('hidden');

                $("#all_history_btn, #deposit_history_btn").removeClass('gradient-tab');
                $("#withdrawal_history_btn").addClass('gradient-tab');
            });

            $("#deposit_history_btn").on("click", function() {
                $("#deposit_history").slideDown().removeClass('hidden');
                $("#all_history, #withdrawal_history").slideUp().addClass('hidden');

                $("#withdrawal_history_btn, #all_history_btn").removeClass('gradient-tab');
                $("#deposit_history_btn").addClass('gradient-tab');
            });
        });
    </script>

    {{-- swipper slide --}}

    <script>
        const swiper = new Swiper(".mySwiper", {
            slidesPerView: 3,
            spaceBetween: 20,
            loop: false,
            autoplay: true,
            navigation: false,
            pagination: false,
            grabCursor: true,
            touchMoveStopPropagation: true,
            // Add responsive breakpoints
            breakpoints: {
                // when window width is < 768px (typical mobile breakpoint)
                1240: {
                    slidesPerView: 3,
                    spaceBetween: 20
                },
                768: {
                    slidesPerView: 2,
                    spaceBetween: 20
                },
                // Mobile screens
                320: {
                    slidesPerView: 1,
                    spaceBetween: 10
                }
            },
            on: {
                slideChange: function() {
                    updateIndicator(swiper.realIndex);
                }
            }
        });



        function updateIndicator(index) {
            const indicators = document.querySelectorAll(".indicator");
            indicators.forEach((dot, i) => {
                if (i === index) {
                    dot.style.width = "24px";
                } else {
                    dot.style.width = "5px";
                }
            });
        }
    </script>

    {{-- qrcode --}}
    <script>
        $(document).ready(function() {
            $(".referrealQrCode").each(function() {
                var ref = $(this).data("ref"); // Get the ref value from data-ref attribute
                var qrcode = new QRCode(this, {
                    text: "{{ route('user.register', ['ref' => '__ref__']) }}".replace('__ref__',
                        ref),
                    width: 90,
                    height: 90
                });
            });
        });
    </script>
@endsection
