@extends('templates.' . site('template') . '.layouts.user')


@section('css')
@endsection

@section('contents')
    <!--my deposit-->
    <section class="px-6 md:mt-28 w-full mx-auto lg:relative">

        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[50rem] h-[50rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-10 top-10 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute -left-10 top-1/2 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}


        <div id="deposits" class="w-full p-4 mb-3 text-white">

            <div class="block mb-3">
                <h1 class="text-xl lg:text-3xl font-bold">My Deposits</h1>
            </div>

            <div class="md:flex justify-between  mb-5 py-5">


                <div class="w-full mb-3 flex lg:flex-row flex-col justify-between gap-2">
                    <button id="NewDepositModalBtn"
                        class="rounded-2xl py-3 px-6 text-base  transition delay-100 duration-200 ease-in-out cursor-pointer bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)]">
                        <span
                            class="bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] bg-clip-text text-transparent font-medium">
                            New Deposit
                        </span>
                    </button>

                    <div
                        class="flex items-center space-x-2 border border-[#ff8ac63e] text-white rounded-2xl py-1 px-2 text-sm lg:w-2/3">

                        <!-- Input Field -->
                        <input type="text" x-model="search" placeholder="Txn Ref" id="search-deposit-input"
                            class="bg-transparent focus:outline-none text-sm flex-grow placeholder-gray-500"
                            value="{{ request()->s }}" />

                        <!-- Search Button -->
                        <div class="simple-pagination" data-paginator="deposits">
                            <a id="search-deposit-button" data-link="{{ route('user.deposits.index') }}" href=""
                                class="paginator-link px-4 py-2 rounded-md text-sm bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] gap-2 flex items-center justify-center">
                                Search
                                <img src="{{ asset('/assets/templates/zyphor/images/search_icon.svg') }}" alt="">
                            </a>
                        </div>
                    </div>
                </div>



                {{-- new deposit Modal --}}
                <div id="NewDepositModal" class="fixed inset-0  flex  justify-end backdrop-blur-xs h-[100vh] hidden"
                    style="z-index: 50;">

                    <div
                        class="bg-[#0F0420] rounded-lg w-full lg:w-[35vw] lg:max-h-[100vh] max-h-[90vh]  lg:p-10 p-4 relative z-10  backdrop-blur-lg overflow-y-auto py-20">

                        <div class="h-full w-full flex items-center">
                            <div class="block w-full">
                                <div class="flex justify-between items-center lg:mb-16 mb-4 lg:px-10">
                                    <h2 class="text-xl font-semibold mb-4 text-white">New Deposit</h2>
                                    <button id="closeNewDepositModal" class="text-gray-400 hover:text-gray-600">
                                        <img src="{{ asset('/assets/templates/zyphor/images/cancel-circle.svg') }}"
                                            alt="icon">
                                    </button>
                                </div>

                                <!-- Modal Content -->
                                <form action="{{ route('user.deposits.new') }}" method="post" id="depositForm">
                                    @csrf


                                    <div class="w-full lg:mb-16 mb-4 lg:px-10 px-4">
                                        <div class="w-full px-6 py-4 bg-[#372E45] rounded-xl  text-sm">

                                            <div class="flex gap-2 mb-3">
                                                <img src="{{ asset('/assets/templates/zyphor/images/information-circle.svg') }}"
                                                    alt="icon">
                                                <p class="text-lg text-[#FF59CA]">Important Information</p>
                                            </div>

                                            <table class="mb-3 w-full">
                                                <tr>
                                                    <td>
                                                        <p
                                                            class="bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)] bg-clip-text text-transparent mb-2">
                                                            Minimum
                                                            Deposit:</p>
                                                    </td>
                                                    <td>
                                                        <p class="text-white mb-2 text-right">
                                                            {{ formatAmount(site('min_deposit')) }}
                                                        </p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p
                                                            class="bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)] bg-clip-text text-transparent mb-2">
                                                            Maximum
                                                            Deposit:</p>
                                                    </td>
                                                    <td>
                                                        <p class="text-white mb-2 text-right">
                                                            {{ formatAmount(site('max_deposit')) }}
                                                        </p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p
                                                            class="bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)] bg-clip-text text-transparent mb-2">
                                                            Maximum
                                                            Waiting Duration : </p>
                                                    </td>
                                                    <td>
                                                        <p class="text-white mb-2 text-right"> 7 Days</p>
                                                    </td>
                                                </tr>
                                            </table>
                                            <p class="text-sm">
                                            <p class="text-white font-bold block mb-3">Warning: </p>
                                            <p class="text-[#D8D8D8] block leading-6">
                                                After selecting your preferred payment
                                                method
                                                and
                                                entering the amount you want to deposit, a new wallet address will be
                                                generated
                                                for your deposit. Send only the specified token and network to the
                                                generated
                                                address or qrcode. Sending wrong token or sending to a wrong wallet
                                                address
                                                will
                                                lead to permanent
                                            </p>
                                            </p>
                                        </div>
                                    </div>



                                    <div class="w-full lg:mb-16 mb-10 lg:px-10">
                                        <label for="amount" class="text-white text-sm">Amount
                                            ( in {{ site('currency') }})</label>
                                        <div
                                            class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                            <img src="{{ asset('/assets/templates/zyphor/images/dollar-02.svg') }}"
                                                alt="" class="hidden">
                                            <span class="font-thin text-2xl ">{{ site('currency_symbol') }}</span>
                                            <input type="number" step="any"
                                                placeholder="Amount ({{ site('currency') }})" id="amount" name="amount"
                                                class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                                value="0" required>
                                        </div>
                                    </div>


                                    <!--Coin for deposit Dropdown -->
                                    <div class="w-full lg:mb-16 mb-10 lg:px-10">
                                        <label for="" class="text-white text-sm">Coin</label>

                                        <div
                                            class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                            <div class="relative w-full">
                                                <button id="coinForDepositDropdownButton"
                                                    class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1 flex gap-2"
                                                    type="button">
                                                    <div class="flex items-center w-full">
                                                        <img src="" class=" rounded-full mr-2"
                                                            id="selectedCoinImg" />
                                                        <span id="selectedCoinText">Select Coin</span>
                                                    </div>
                                                    <img src="{{ asset('/assets/templates/zyphor/images/arrow-down-round.svg') }}"
                                                        alt="icon">
                                                </button>

                                                <!-- Dropdown Menu -->
                                                <ul id="coinForDepositDropdownMenu"
                                                    class="absolute z-10 hidden mt-1 max-h-60 w-full overflow-auto rounded-md bg-[#0f042094] backdrop-blur-sm shadow-lg right-0">
                                                    @foreach ($coins as $coin)
                                                        <li class="flex items-center px-4 py-2 text-gray-900 cursor-pointer hover:bg-blue-600"
                                                            data-value="{{ $coin->code }}"
                                                            data-label="{{ $coin->name }}"
                                                            data-img="{{ 'https://nowpayments.io' . $coin->logo_url }}">
                                                            <img src="{{ 'https://nowpayments.io' . $coin->logo_url }}"
                                                                alt="coin" class="h-8 w-8 rounded-full mr-2" />
                                                            <p class="">
                                                                <span class="text-white"
                                                                    style="text-transform: uppercase;">
                                                                    @if ($coin->network)
                                                                        {{ $coin->network }}
                                                                    @endif
                                                                </span>
                                                                <span class="text-white"> {{ $coin->name }}</span>
                                                            </p>
                                                        </li>
                                                    @endforeach

                                                </ul>


                                            </div>
                                        </div>
                                        <!-- Hidden Input for selected coin -->
                                        <input type="hidden" value="" name="currency_code" id="currency_code" />
                                    </div>



                                    <div class="w-full lg:px-10">
                                        <button type="submit"
                                            class="rounded-2xl w-full lg:px-10 lg:py-4 py-2 px-6 text-base transition delay-100 duration-200 ease-in-out cursor-pointer btn-gradient flex items-center justify-center">
                                            <span class="px-2">Pay Now</span>
                                        </button>
                                    </div>

                                </form>
                            </div>
                        </div>

                    </div>
                </div>
                {{-- new deposit Modal --}}


                {{-- new deposit information Modal --}}
                <div id="NewDepositInformationModal"
                    class="fixed inset-0 bg-opacity-50 flex items-center justify-end lg:px-6 px-2 backdrop-blur-xs hidden"
                    style="z-index: 50;">
                    <div
                        class="bg-[#0F0420] rounded-lg w-full lg:w-[35vw]  lg:p-14 p-4 relative z-10  mx-auto backdrop-blur-lg max-h-[90vh] overflow-y-auto">

                        <div class="flex justify-between items-center lg:mb-10 mb-4">
                            <h2 class="text-xl font-semibold mb-4 text-white">New Deposit</h2>

                            <div id="paymentLink" class="hidden mt-5 mb-5 w-full flex items-center justify-center">
                                <a href="" id="paymentLinkHref" target="_blank" rel="noopener noreferrer"
                                    class="w-full bg-blue-500 px-5 py-1 rounded uppercase">Pay Now</a>
                            </div>


                            <button id="closeNewDepositInfoModal" class="text-gray-400 hover:text-gray-600">
                                <img src="{{ asset('/assets/templates/zyphor/images/cancel-circle.svg') }}"
                                    alt="icon">
                            </button>
                        </div>

                        <!-- Modal Content -->
                        <div class="bg-[#372E45] rounded-2xl p-6">

                            <div class="flex w-full justify-center mb-10">
                                <div class="bg-[#424344] rounded-xl bg-opacity-20 p-2 lg:mb-10 mb-4">
                                    <div id="wallet_qrcode" class="clipboard" data-copy=""></div>
                                </div>
                            </div>

                            <div class="w-full">
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Status </p>
                                    <p class="text-right text-white flex gap-3 justify-end items-center">
                                        <span class="w-4 h-4 bg-[#D8D8D8] rounded-full"></span>
                                        <span id="display_deposit_status"></span>
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Valid Until </p>
                                    <p class="text-right text-white">
                                        <span id="display_deposit_valid_until">

                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Amount </p>
                                    <p class="text-right text-white">{{ site('currency') }}<span
                                            id="display_deposit_amount"></p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Fee </p>
                                    <p class="text-right text-white">{{ site('currency') }}<span
                                            id="display_deposit_fee">
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Pay Amount </p>
                                    <p class="text-right text-white">
                                        <span id="display_deposit_converted_amount" class="clipboard cursor-pointer"
                                            data-copy=""> </span>
                                        <span id="display_deposit_currency"></span>
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Network </p>
                                    <p class="text-right text-white">
                                        <span id="display_deposit_network" class="clipboard cursor-pointer"
                                            data-copy=""></span>
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Wallet Address </p>
                                    <p class="text-right text-white flex gap-3 justify-end items-center">
                                        <span id="display_deposit_payment_wallet" class="clipboard cursor-pointer"
                                            data-copy=""></span>
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Txn Ref </p>
                                    <p class="text-right text-white">
                                        <span id="display_deposit_ref" class="clipboard cursor-pointer"
                                            data-copy=""></span>
                                    </p>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>
                {{-- new deposit information modal --}}


            </div>


            <div class="block bg-[#250A4F] px-6 py-5 rounded-t-2xl">
                <span class="text-xl lg:text-3xl mr-10 mb-3">Deposit History</span>
            </div>
            <div class="block overflow-auto w-full max-h-[60vh] bg-[#190735] px-6 py-3 rounded-b-2xl">
                <table class="w-full" id="depositTable">

                    <tbody>


                        @forelse ($deposits as $deposit)
                            <tr class="border-b border-[#f272d5]/25">
                                <td class="p-6">
                                    <div class="flex items-center gap-4 ">
                                        <img class="w-8 h-8"
                                            src="{{ 'https://nowpayments.io' . $deposit->depositCoin->logo_url }}"alt="">
                                        <p class="text-base font-thin">{{ $deposit->depositCoin->name }}</p>
                                    </div>
                                    <p class=" text-gray-400 text-sm">{{ $deposit->payment_wallet }}</p>
                                </td>
                                <td class="text-left p-6">
                                    <p class="text-base font-thin">
                                        {{ formatAmount($deposit->amount) }}</p>
                                    <p class=" text-gray-400 text-sm">
                                        <span>{{ $deposit->converted_amount . ' ' . $deposit->depositCoin->code }}</span>
                                        <span
                                            class="text-[#EA0A0E]">{{ $deposit->depositCoin->network ?? $deposit->depositCoin->code }}</span>
                                    </p>
                                </td>
                                <td class="text-right p-6">
                                    <p class="flex justify-end items-center space-x-1 gap-4">

                                        @if ($deposit->status == 'waiting')
                                            <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                alt="">
                                            <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                        @elseif ($deposit->status == 'approved' || $deposit->status == 'finished')
                                            <img src="{{ asset('/assets/templates/zyphor/images/green_status_icon.svg') }}"
                                                alt="">
                                            <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                        @elseif ($deposit->status == 'pending')
                                            <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                alt="">
                                            <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                        @elseif ($deposit->status == 'failed' || $deposit->status == 'refunded')
                                            <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                alt="">
                                            <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                        @elseif ($deposit->status == 'rejected')
                                            <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                alt="">
                                            <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                        @else
                                            <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                alt="">

                                            <span class="text-white capitalize text-sm">{{ $deposit->status }}</span>
                                        @endif
                                    </p>
                                    <p class="text-sm text-gray-400 text-end">
                                        {{ date('d-m-y H:i:s A', strtotime($deposit->created_at)) }}
                                    </p>
                                </td>

                                <td class="text-right px-6">
                                    <button data-link="{{ route('user.deposits.view', ['ref' => $deposit->ref]) }}"
                                        class="relative flex items-center justify-center rounded-full lg:w-auto w-30 py-2 px-4 cursor-pointer hover:bg-pink-400 view-single-deposit">
                                        <img src="{{ asset('/assets/templates/zyphor/images/view_eye.svg') }}"
                                            alt="" width="20px">
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr class="border border-opacity-25 border-blue-200 cursor-pointer">
                                <td
                                    class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg  border-slate-800 hover:border-slate-600 ">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                        fill="currentColor" class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                        <path
                                            d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                    </svg>
                                    <span>Empty Record. No Deposit found!</span>
                                </td>
                            </tr>
                        @endforelse


                    </tbody>
                </table>
            </div>


            <div class="cursor-pointer simple-pagination" data-paginator="deposits">
                {{ $deposits->links('templates.' . site('template') . '.paginations.simple') }}
            </div>

        </div>
    </section>

    <!--end my deposit-->

    {{-- modal content --}}
    <div class="w-full">
        <div class="fixed inset-0 bg-opacity-50 flex items-center justify-end lg:px-6 px-2 backdrop-blur-xs hidden"
            id="modalContent" style="z-index: 50;">
            <div class="bg-[#0F0420] rounded-lg   w-full lg:w-[35vw]  lg:p-14 p-4 relative z-10  mx-auto backdrop-blur-lg max-h-[90vh] overflow-y-auto"
                id="modalDisplay"></div>
        </div>
    </div>
@endsection





@section('scripts')
    {{-- show modal --}}
    <script>
        function initializeDepositModals() {

            // Open Deposit Modal
            $(document).off("click", "#NewDepositModalBtn").on("click", "#NewDepositModalBtn", function() {
                $('#NewDepositModal').removeClass('hidden opacity-0').addClass('opacity-100');
            });

            // Close Deposit Modal
            $(document).off("click", "#closeNewDepositModal").on("click", "#closeNewDepositModal", function() {
                $('#NewDepositModal').removeClass('opacity-100').addClass('opacity-0');
                setTimeout(function() {
                    $('#NewDepositModal').addClass('hidden');
                }, 300); // Matches transition duration
            });

            // Close Deposit Information Modal
            $(document).off("click", "#closeNewDepositInfoModal").on("click", "#closeNewDepositInfoModal", function() {
                $('#NewDepositInformationModal').addClass('hidden');
            });
        }

        // Run initialization on page load
        $(document).ready(function() {
            initializeDepositModals();
        });
    </script>


    <script>
        //# // search deposit
        $(document).on('input keyup', '#search-deposit-input', function(e) {
            var ref = $(this).val();
            var base_link = $('#search-deposit-button').data('link');
            var encodedRef = encodeURIComponent(ref);

            // Append the query parameter to the URL
            var link = base_link + '?s=' + encodedRef;
            $('#search-deposit-button').attr('href', link);
        });
    </script>

    <script>
        //////////////filter deposit table
        $(document).ready(function() {
            function filterTable() {
                var txnRef = $('#txnRef').val().toLowerCase(); // Get the input value

                // Filter table rows based on the data-deposit_tnx attribute
                $('#depositTable tbody tr').each(function() {
                    var rowTxnRef = $(this).find('td[data-deposit_tnx]').data('deposit_tnx').toString()
                        .toLowerCase(); // Get the Txn ref from the data attribute
                    if (rowTxnRef.indexOf(txnRef) !== -1) {
                        $(this).show(); // Show the row if it matches
                    } else {
                        $(this).hide(); // Hide the row if it doesn't match
                    }
                });
            }

            // Trigger filtering on form submission
            $('#filterForm').on('submit', function(e) {
                e.preventDefault(); // Prevent form submission
                filterTable();
            });

            // Trigger filtering on keyup
            $('#txnRef').on('keyup', function() {
                filterTable();
            });
        });




        //close dposit details modal
        $('#modalDisplay').on('click', '#closeDepositDetail', function() {
            // You can add code to hide the modal here.
            $('#modalContent').addClass('hidden');
        });



        let interval;
        //single deposit
        $(document).on('click', '.view-single-deposit', function(e) {
            var clicked = $(this);
            clicked.addClass('relative disabled');
            clicked.append('<span class="button-spinner"></span>');
            clicked.prop('disabled', true);
            var link = $(this).data('link');

            $('#modalContent').removeClass('hidden');
            var html = $('#single-display-new-deposit-information');

            $.ajax({
                url: link,
                method: 'GET',
                success: function(response) {
                    var deposit = response.deposit;

                    var modalContent = `
                    <div id="single-display-new-deposit-information"
                            class="">

                            <div class="flex justify-between items-center lg:mb-10 mb-4">
                                <h2 class="text-xl font-semibold mb-4 text-white">Transaction Details</h2>
                                <button id="closeDepositDetail"
                                    class="closeDepositDetail text-white hover:text-gray-600">
                                    <img src="{{ asset('/assets/templates/zyphor/images/cancel-circle.svg') }}" alt="icon">
                                </button>
                            </div>

                            <!-- Modal Content -->

                            <div class="bg-[#372E45] rounded-2xl p-6">

                            <div class="flex w-full justify-center mb-10">
                                <div class="bg-[#424344] rounded-xl bg-opacity-20 p-2 lg:mb-10 mb-4">
                                    <div id="single_wallet_qrcode" class="clipboard" data-copy=""></div>
                                </div>
                            </div>

                            <div class="w-full">
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Status </p>
                                    <p class="text-right text-white flex gap-3 justify-end items-center">
                                        <span class="w-4 h-4 bg-[#D8D8D8] rounded-full"></span><span
                                            id="single_display_deposit_status"></span>
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Valid Until </p>
                                    <p class="text-right text-white"><span id="single_display_deposit_valid_until"></span></p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Amount </p>
                                    <p class="text-right text-white">{{ site('currency') }}<span id="single_display_deposit_amount">
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Fee </p>
                                    <p class="text-right text-white">{{ site('currency') }}<span id="single_display_deposit_fee"> </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Pay Amount </p>
                                    <p class="text-right text-white">
                                        <span id="single_display_deposit_converted_amount" class="clipboard cursor-pointer"
                                            data-copy=""> </span>
                                        <span id="single_display_deposit_currency"></span>
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Network </p>
                                    <p class="text-right text-white">
                                        <span id="single_display_deposit_network" class="clipboard cursor-pointer" data-copy=""></span>
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Wallet Address </p>
                                    <p class="text-right text-white flex gap-3 justify-end items-center">
                                        <span id="wallet_address" class="wallet-address lg:text-md text-[12px] truncate">
                                            <span id="single_display_deposit_payment_wallet" class="wallet_address clipboard cursor-pointer"
                                                data-copy=""></span>
                                        </span>
                                        <img hidden src="{{ asset('/assets/templates/zyphor/images/copy-icon.svg') }}" alt="icon"
                                            class="clipboard" style="cursor: pointer;" data-copy="" id="single_display_deposit_payment_wallet_icon">
                                    </p>
                                </div>
                                <div class="grid grid-cols-2  py-3">
                                    <p class="text-left text-[#E1D2F9] font-thin">Txn Ref </p>
                                    <p class="text-right text-white"><span id="single_display_deposit_ref"
                                            class="clipboard cursor-pointer" data-copy=""></p>
                                </div>
                            </div>

                            </div>

                        </div>
                    `;

                    $('#modalContent').removeClass("hidden");
                    $('#modalDisplay').html(modalContent);

                    // Loop through the deposit object's properties
                    for (var key in deposit) {
                        if (deposit.hasOwnProperty(key)) {
                            var value = deposit[key];
                            var element = $('#single_display_deposit_' + key);
                            if (element.length > 0) {
                                element.text(value);
                            }


                            //update the copy attribute
                            if (element.hasClass('clipboard')) {
                                element.attr('data-copy', value);
                            }

                            // update clipboard attribute for only wallet view icon

                            if (key == 'payment_wallet') {
                                var walletViewIcon = $('#single_display_deposit_payment_wallet_icon');
                                walletViewIcon.attr('data-copy', deposit.payment_wallet);
                            }


                        }
                    }

                    // create qrcode
                    var qrCodeElement = document.getElementById('single_wallet_qrcode');
                    var qrCode = new QRCode(qrCodeElement, {
                        text: deposit.payment_wallet,
                        width: 200,
                        height: 200
                    });

                    var walletQrCodeDiv = document.getElementById('single_wallet_qrcode');
                    walletQrCodeDiv.setAttribute('data-copy', deposit.payment_wallet);
                    var imageElement = walletQrCodeDiv.querySelector('img');
                    imageElement.classList.add('rounded-lg', 'border', 'border-slate-800',
                        'hover:border-slate-600', 'cursor-pointer', 'p-1');
                    //imageElement.setAttribute('style', '');

                    //create a count down
                    var targetId = 'single_display_deposit_valid_until';
                    var targetDateString = deposit.valid_until;
                    if (interval) {
                        clearInterval(interval);
                    }

                    interval = setInterval(function() {
                        updateCountdown(targetId, targetDateString);
                    }, 1000);

                    // Check payment status
                    var ref = deposit.ref
                    setInterval(function() {
                        $.ajax({
                            url: "{{ url('/user/deposits/view') }}" + '/' + deposit
                                .ref,
                            method: 'GET',
                            success: function(response) {
                                var status = response.deposit.status;
                                $('#single_display_deposit_status').html(status);


                            }
                        });
                    }, 10000);


                },
                complete: function() {
                    clicked.removeClass('disabled');
                    clicked.find('.button-spinner').remove();
                    clicked.prop('disabled', false);

                }
            });

        });


        // select the deposit coin
        $(document).on('click', ".coin", function(e) {
            $('.coin_select').addClass('hidden');
            var target = '#' + $(this).data('target');
            $(target).toggleClass('hidden');

            var currency_code = $(this).data('currency_code');
            $("#currency_code").val(currency_code);

        });


        // filter the coins
        $(document).on('input keyup', '#coin-search-input', function() {
            var searchText = $(this).val().toLowerCase();

            $('.coin').hide().filter(function() {
                return $(this).text().toLowerCase().includes(searchText);
            }).show();
        });


        // handle deposit form
        $(document).on('submit', '#depositForm', function(e) {
            e.preventDefault();
            var amount = $('#amount').val() * 1;
            var currency_code = $('#currency_code').val();
            var min_deposit = "{{ site('min_deposit') }}" * 1;
            var max_deposit = "{{ site('max_deposit') }}" * 1;
            var currency = "{{ site('currency') }}";

            //check the currency code
            var error = null;
            if (!currency_code) {
                error = 'You have not selected a deposit method';
            }

            //check min and max deposit
            if (amount < min_deposit) {
                error = 'Minimum deposit amount is ' + currency + min_deposit;
            }

            if (amount > max_deposit) {
                error = 'Maximum deposit amount is ' + currency + max_deposit;
            }

            if (error === null) {
                var form = $(this);
                var formData = new FormData(this);

                var submitButton = $(this).find('button[type="submit"]');
                submitButton.addClass('relative disabled');
                submitButton.append('<span class="button-spinner"></span>');
                // new modification
                submitButton.removeClass('btn-gradient');
                submitButton.addClass('not-allowed-cursor');
                //
                submitButton.prop('disabled', true);
                $.ajax({
                    url: form.attr('action'),
                    method: 'POST',
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    success: function(response) {
                        $('#amount').val(0);
                        var deposit = response.deposit;
                        $('#NewDepositModal').toggleClass('hidden');
                        $('#NewDepositInformationModal').toggleClass('hidden');

                        submitButton.addClass(
                            'btn-gradient');
                        submitButton.removeClass('not-allowed-cursor');

                        if (deposit.link !== 'nill' && deposit.link !== 'undefined') {
                            // window.location.href = deposit.link;
                            // window.open(deposit.link, "_blank");
                            $("#paymentLink").removeClass('hidden');
                            $("#paymentLinkHref").attr('href', deposit.link);
                            window.location.href = deposit.link;
                        }

                        // Loop through the deposit object's properties
                        for (var key in deposit) {
                            if (deposit.hasOwnProperty(key)) {
                                var value = deposit[key];
                                var element = $('#display_deposit_' + key);
                                if (element.length > 0) {
                                    element.text(value);
                                }

                                //update the copy attribute
                                if (element.hasClass('clipboard')) {
                                    element.attr('data-copy', value);
                                }


                            }
                        }


                        //create a count down
                        var targetId = 'display_deposit_valid_until';
                        var targetDateString = deposit.valid_until;
                        const interval = setInterval(function() {
                            updateCountdown(targetId, targetDateString);
                        }, 1000);

                        // create qrcode
                        var qrCodeElement = document.getElementById('wallet_qrcode');
                        qrCodeElement.innerHTML = '';

                        var qrCode = new QRCode(qrCodeElement, {
                            text: deposit.payment_wallet,
                            width: 200,
                            height: 200
                        });

                        var walletQrCodeDiv = document.getElementById('wallet_qrcode');
                        walletQrCodeDiv.setAttribute('data-copy', deposit.payment_wallet);
                        var imageElement = walletQrCodeDiv.querySelector('img');
                        imageElement.classList.add('rounded-lg', 'border', 'border-slate-800',
                            'hover:border-slate-600', 'cursor-pointer', 'p-1');

                        $('html, body').animate({
                            scrollTop: 0 + 100
                        }, 800);
                        toastNotify('success', 'Deposit request initated successfully');

                        // Check payment status
                        var ref = deposit.ref
                        setInterval(function() {
                            $.ajax({
                                url: "{{ url('/user/deposits/view') }}" + '/' + deposit
                                    .ref,
                                method: 'GET',
                                success: function(response) {
                                    var status = response.deposit.status;
                                    $('#display_deposit_status').html(status);
                                }
                            });
                        }, 10000);

                        ///function to update deposit table
                        var link = window.location.href;
                        var clicked = false;
                        var targetDiv = "#depositTable"
                        loadPage(link, clicked, targetDiv);


                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });
                                toastNotify('error', fieldErrors);

                                submitButton.addClass(
                                    'btn-gradient'
                                );
                                submitButton.removeClass('not-allowed-cursor');

                            });
                        } else {
                            toastNotify('error', 'An Error occured, try again later');

                            submitButton.addClass(
                                'btn-gradient');
                            submitButton.removeClass('not-allowed-cursor');
                        }


                    },
                    complete: function() {
                        submitButton.removeClass('disabled');
                        submitButton.find('.button-spinner').remove();
                        submitButton.prop('disabled', false);

                    }
                });
            } else {

                toastNotify('error', error);

            }

        });
    </script>

    <script>
        $(document).ready(function() {

            //deposit information modal to be triggers if http status is 200
            var status = 404;
            if (status == 200) {
                $('#depositInfoModal').addClass('block').removeClass('hidden');
            }

            $("#closeNewDepositInfoModal").on("click", function() {
                $('#depositInfoModal').addClass('hidden').removeClass('block');
            });

        });

        $('#status-dropdown-btn').click(function() {
            $('#status-dropdown').toggleClass('hidden');
        });
    </script>

    <script>
        //select coin for deposit
        $(document).ready(function() {
            // Toggle dropdown visibility with animation
            $('#coinForDepositDropdownButton').on('click', function() {
                const coinForDepositDropdownMenu = $('#coinForDepositDropdownMenu');
                if (coinForDepositDropdownMenu.hasClass('hidden')) {
                    coinForDepositDropdownMenu
                        .removeClass('hidden')
                        .addClass('scale-100 opacity-100')
                        .hide()
                        .slideDown(200);
                } else {
                    coinForDepositDropdownMenu
                        .slideUp(200, function() {
                            $(this).addClass('hidden').removeClass('scale-100 opacity-100');
                        });
                }
            });

            // Close dropdown when clicking outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('#coinForDepositDropdownButton, #coinForDepositDropdownMenu')
                    .length) {
                    $('#coinForDepositDropdownMenu')
                        .slideUp(200, function() {
                            $(this).addClass('hidden').removeClass('scale-100 opacity-100');
                        });
                }
            });

            // Handle selection
            $('#coinForDepositDropdownMenu li').on('click', function() {
                const label = $(this).data('label');
                const imgSrc = $(this).data('img');
                const value = $(this).data('value');

                // Update the button with the selected coin
                $('#selectedCoinText').text(label);
                $('#selectedCoinImg').attr('src', imgSrc).addClass('w-8 h-8');;

                // Update the hidden input value
                $('#currency_code').val(value);

                // Hide the dropdown menu
                $('#coinForDepositDropdownMenu')
                    .slideUp(200, function() {
                        $(this).addClass('hidden').removeClass('scale-100 opacity-100');
                    });
            });
        });
    </script>
@endsection
