@extends('templates.' . site('template') . '.layouts.user')



@section('css')
@endsection


@section('contents')
    <!--p2p-->
    <section class="px-6 md:mt-28 w-full mx-auto lg:relative" id="pageContent">


        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[50rem] h-[50rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-10 top-10 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute -left-10 top-1/2 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}


        <div class="w-full mx-auto p-4 mb-3 text-white">

            <div class="block mb-3">
                <h1 class="text-xl lg:text-3xl font-bold">My P2P Transfers</h1>
            </div>

            <div class="lg:flex justify-between  mb-5 py-5">

                <div class="w-full mb-3 flex lg:flex-row flex-col justify-between gap-2">
                    <button id="openNewP2pModal"
                        class="rounded-2xl py-3 px-6 text-base  transition delay-100 duration-200 ease-in-out cursor-pointer bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)]">
                        <span
                            class="bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] bg-clip-text text-transparent font-medium">
                            New P2p
                        </span>
                    </button>

                    <div x-data="{ search: '' }"
                        class="flex items-center space-x-2 border border-[#ff8ac63e] text-white rounded-2xl py-1 px-2 text-sm lg:w-2/3">

                        <!-- Input Field -->
                        <input type="text" placeholder="Txn Ref" id="search-transfer-input"
                            class="bg-transparent focus:outline-none text-sm flex-grow placeholder-gray-500"
                            value="{{ request()->s }}" />

                        <!-- Search Button -->
                        <div class="simple-pagination" data-paginator="transfers">
                            <a id="search-transfer-button" data-link="{{ route('user.transfers.index') }}" href=""
                                class="paginator-link px-4 py-2 rounded-md text-sm bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] gap-2 flex items-center justify-center">
                                Search
                                <img src="{{ asset('/assets/templates/zyphor/images/search_icon.svg') }}" alt="">
                            </a>
                        </div>
                    </div>
                </div>



                <!-- new p2p Modal -->
                <div id="NewP2pModal" class="fixed inset-0  flex  justify-end backdrop-blur-xs h-[100vh] hidden"
                    style="z-index: 50;">

                    <div
                        class="bg-[#0F0420] rounded-lg w-full lg:w-[35vw] lg:max-h-[100vh] max-h-[90vh]  lg:p-10 p-4 relative z-10  backdrop-blur-lg overflow-y-auto py-20">

                        <div class="h-full w-full flex items-center">
                            <div class="block w-full">
                                <div class="flex justify-between items-center lg:mb-16 mb-4 lg:px-10">
                                    <h2 class="text-xl font-semibold mb-4 text-white">New Transfer</h2>
                                    <button id="closeNewP2pModal" class="text-gray-400 hover:text-gray-600">
                                        <img src="{{ asset('/assets/templates/zyphor/images/cancel-circle.svg') }}"
                                            alt="icon">
                                    </button>
                                </div>

                                <!-- Modal Content -->
                                <form action="{{ route('user.transfers.new') }}" method="post" id="transferForm">
                                    @csrf


                                    <div class="w-full lg:mb-16 mb-4 lg:px-10 px-4">


                                        <div class="w-full px-6 py-4 bg-[#372E45] rounded-xl  text-sm">

                                            <table class="mb-3 w-full">
                                                <tr>
                                                    <td>
                                                        <p
                                                            class="bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)] bg-clip-text text-transparent mb-2">
                                                            Minimum
                                                            Transfer: </p>
                                                    </td>
                                                    <td>
                                                        <p class="text-white mb-2 text-right">
                                                            {{ formatAmount(site('min_transfer')) }}</p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p
                                                            class="bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)] bg-clip-text text-transparent mb-2">
                                                            Maximum
                                                            Transfer: </p>
                                                    </td>
                                                    <td>
                                                        <p class="text-white mb-2 text-right">
                                                            {{ formatAmount(site('max_transfer')) }}</p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p
                                                            class="bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)] bg-clip-text text-transparent mb-2">
                                                            Fee: </p>
                                                    </td>
                                                    <td>
                                                        <p class="text-white mb-2 text-right">
                                                            {{ site('transfer_fee') }}%</p>
                                                    </td>
                                                </tr>
                                            </table>
                                            <p class="text-sm">
                                            <p class="text-white font-bold block mb-3">Warning: </p>
                                            <p class="text-[#D8D8D8] block leading-6">
                                                Confirm the receipient's full name before proceeding to make transfer
                                            </p>
                                            </p>
                                        </div>
                                    </div>



                                    <div class="w-full lg:mb-16 mb-10 lg:px-10">
                                        <label for="username" class="text-white text-sm">User Name</label>
                                        <div
                                            class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                            <input type="text" name="username" id="username"
                                                class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                                placeholder="Enter Username" required>
                                        </div>
                                    </div>

                                    <div class="w-full lg:mb-16 mb-10 lg:px-10">
                                        <label for="fullname" class="text-white text-sm">Full Name</label>
                                        <div
                                            class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                            <input type="text" name="fullname" id="fullname"
                                                class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                                placeholder="Enter Fullname" required>
                                        </div>
                                    </div>

                                    <div class="w-full lg:mb-16 mb-10 lg:px-10">
                                        <label for="amount" class="text-white text-sm">Amount
                                            ( in {{ site('currency') }})</label>
                                        <div
                                            class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                            <span class="font-thin text-2xl ">{{ site('currency_symbol') }}</span>
                                            <input type="number" step="any" name="amount" id="amount"
                                                class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                                placeholder="Amount ({{ site('currency') }})" value="0" required>
                                        </div>
                                    </div>




                                    <div class="w-full lg:px-10">
                                        <button type="submit"
                                            class="rounded-2xl w-full lg:px-10 lg:py-4 py-2 px-6 text-base transition delay-100 duration-200 ease-in-out cursor-pointer btn-gradient flex items-center justify-center">
                                            <span class="px-2">Transfer Now</span>
                                        </button>
                                    </div>

                                </form>
                            </div>
                        </div>

                    </div>
                </div>
                <!--new p2p modal-->


            </div>

            <div id="transfers">

                <div class="block bg-[#250A4F] px-6 py-5 rounded-t-2xl">
                    <span class="text-xl lg:text-3xl mr-10 mb-3">Transfer History</span>
                </div>
                <div class="block overflow-auto w-full max-h-[60vh] bg-[#190735] px-6 py-3 rounded-b-2xl">
                    <table class="w-full" id="p2pTable">

                        <tbody>
                            @forelse ($transfers as $transfer)
                                <tr class="border-b border-[#f272d5]/25">
                                    <td class="p-2 py-6" data-p2p_tnx="{{ $transfer->ref }}">
                                        <p class="px-4 mb-3">{{ date('d-m-y H:i:s', strtotime($transfer->created_at)) }}
                                        </p>
                                        <p class="px-4">
                                            @if ($transfer->sender_id == user()->id)
                                                <span class="text-[#FF59CA]">To: </span>
                                                <span class="text-white">{{ $transfer->receiver_name }}</span>
                                            @else
                                                <span class="text-[#FF59CA]">From: </span>
                                                <span class="text-white">{{ $transfer->receiver_name }}</span>
                                            @endif
                                        </p>
                                    </td>
                                    <td class="p-2 py-6 text-left">
                                        <p class="px-4 mb-3">{{ formatAmount($transfer->amount) }}</p>
                                        <p class="px-4">
                                            @if ($transfer->sender_id == user()->id)
                                                <span class=" text-green-500">Sent</span>
                                            @else
                                                <span
                                                    class=" text-[#ea0a0e] bg-[#ea0a0e]/10 rounded-full w-auto  py-1 px-3">Received</span>
                                            @endif
                                        </p>
                                    </td>
                                    <td class="p-2 py-6 text-right">
                                        <p class="px-4 mb-3">
                                            <span class="text-[#FF59CA]">Fee: </span>
                                            @if ($transfer->sender_id == user()->id)
                                                {{ formatAmount($transfer->fee) }}
                                            @endif
                                        </p>
                                        <p class="px-4">Ref: {{ $transfer->ref }}</p>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td
                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                            fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                        </svg>
                                        <span>Empty Record. No transfer found!</span>
                                    </td>
                                </tr>
                            @endforelse

                        </tbody>
                    </table>
                </div>

                <div class="cursor-pointer simple-pagination" data-paginator="transfers">
                    {{ $transfers->links('templates.' . site('template') . '.paginations.simple') }}
                </div>
            </div>

        </div>
    </section>
    <!--end p2p-->
@endsection

@section('scripts')
    <script>
        //# // search transfer
        $(document).on('input keyup', '#search-transfer-input', function(e) {
            var ref = $(this).val();
            var base_link = $('#search-transfer-button').data('link');
            var encodedRef = encodeURIComponent(ref);

            // Append the query parameter to the URL
            var link = base_link + '?s=' + encodedRef;
            $('#search-transfer-button').attr('href', link);
        });
    </script>




    <script>
        // handle user form
        $(document).on('submit', '#userForm', function(e) {
            e.preventDefault();
            var form = $(this);
            var formData = new FormData(this);
            $.ajax({
                url: form.attr('action'),
                method: 'POST',
                data: formData,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function(response) {
                    $('#fullname').val(response.name)

                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;

                    if (errors) {
                        $.each(errors, function(field, messages) {
                            var fieldErrors = '';
                            $.each(messages, function(index, message) {
                                fieldErrors += message + '<br>';
                            });
                            toastNotify('error', fieldErrors);
                        });
                    } else {
                        toastNotify('error', 'An Error occured, try again later');
                    }


                }
            });
        });


        // handle transfer form
        $(document).on('submit', '#transferForm', function(e) {
            e.preventDefault();
            var amount = $('#amount').val() * 1;
            var min_transfer = "{{ site('min_transfer') }}" * 1;
            var max_transfer = "{{ site('max_transfer') }}" * 1;
            var currency = "{{ site('currency') }}";

            //check the currency code
            var error = null;
            //check min and max transfer
            if (amount < min_transfer) {
                error = 'Minimum transfer amount is ' + currency + min_transfer;
            }

            if (amount > max_transfer) {
                error = 'Maximum transfer amount is ' + currency + max_transfer;
            }

            if (error === null) {
                var form = $(this);
                var formData = new FormData(this);

                var submitButton = $(this).find('button[type="submit"]');
                submitButton.addClass('relative disabled');
                submitButton.append('<span class="button-spinner"></span>');
                submitButton.prop('disabled', true);

                submitButton.removeClass('btn-gradient');
                submitButton.addClass('not-allowed-cursor');

                $.ajax({
                    url: form.attr('action'),
                    method: 'POST',
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    success: function(response) {


                        loadPage(form.attr('action'), submitButton, '#pageContent');

                        $('html, body').animate({
                            scrollTop: 0 + 100
                        }, 800);
                        toastNotify('success', response.message);




                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });
                                toastNotify('error', fieldErrors);
                            });
                        } else {
                            toastNotify('error', 'An Error occured, try again later');
                        }


                    },
                    complete: function() {
                        submitButton.removeClass('disabled');
                        submitButton.find('.button-spinner').remove();
                        submitButton.prop('disabled', false);

                        submitButton.addClass('btn-gradient');
                        submitButton.removeClass('not-allowed-cursor');

                    }
                });
            } else {

                toastNotify('error', error);

            }

        });


        //////////////// initiate p2p modal
        function initializeP2pModals() {
            // console.log("Modals Initialized");

            // Deposit modal toggle
            $(document).off("click", "#openNewP2pModal").on("click", "#openNewP2pModal", function() {
                $('#NewP2pModal').removeClass('hidden hide').addClass('show');
            });

            $(document).off("click", "#closeNewP2pModal").on("click", "#closeNewP2pModal", function() {
                $('#NewP2pModal').removeClass('show').addClass('hide hidden');
                setTimeout(function() {
                    $('#NewP2pModal').addClass('hidden');
                }, 300);
            });

        }

        // Run modal initialization on page load
        $(document).ready(function() {
            initializeP2pModals();
        });
    </script>
@endsection
