@extends('templates.' . site('template') . '.layouts.user')

@section('css')
    <style>
        .animate_card {
            display: grid;
            place-items: center;
            position: relative;
            background-color: #031A45;
            height: 50px;
            width: 100%;
            border-bottom-right-radius: 1.5rem
                /* 24px */
            ;
            border-bottom-left-radius: 1.5rem
                /* 24px */
            ;
        }



        .animate_card:hover::before {
            height: 55px;
            width: 100%;
            color: linear-gradient(45deg, #3F7DF2, #FFFFFF, #09C241);
        }

        @keyframes animate {
            0% {
                filter: hue-rotate(0deg);
            }

            50% {
                filter: hue-rotate(180deg);
            }

            100% {
                filter: hue-rotate(360deg);
            }
        }
    </style>
@endsection

@section('contents')
    <section class="px-6 md:mt-28 w-full mx-auto lg:relative" id="pageContent">


        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[50rem] h-[50rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-10 top-10 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute -left-10 top-1/2 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}



        {{-- main content --}}
        <div class="w-full mx-auto lg:p-4 mb-3 text-white">



            <div class="block mb-3">
                <h1 class="text-xl lg:text-3xl font-bold">Edit Profile</h1>
            </div>


            <!-- Tab section -->

            <div class="flex mb-5 py-5 mb-10">

                <div class="flex items-center gap-4 font-thin bg-[#372E45] rounded-lg p-4 lg:text-lg text-xs w-fit">
                    <a href="{{ route('user.profile.edit') }}" role="button"
                        class="text-center cursor-pointer hover:text-[#E1D2F9] text-[#E1D2F9] font-bold">
                        Edit Profile</a>
                    <a href="{{ route('user.kyc.index') }}" class="text-center cursor-pointer hover:text-[#E1D2F9]">
                        KYC</a>
                </div>
            </div>

            <!-- Profile Edit Section -->
            <div id="editProfile" class="lg:flex block gap-10 ">
                {{-- main edit profile --}}
                <div class="block lg:w-2/3 w-full bg-[#FFFFFF0D] rounded-2xl mb-10 p-6">

                    {{-- passport upload --}}
                    <div class="block lg:mb-20 mb-10">
                        <form action="{{ route('user.profile.photo') }}" method="POST" enctype="multipart/form-data"
                            class="mt-5 gen-form">
                            @csrf



                            <div class="flex gap-2 relative">
                                <div class="flex">
                                    <img id="profileImage" src="{{ asset('storage/profile/' . user()->photo) }}"
                                        alt="Profile Photo"
                                        class="w-[150px] h-[150px] rounded-full border-4 border-[#0040BC]/30">
                                </div>

                                <div class="flex flex-row gap-2 justify-center absolute top-0 left-40">
                                    <button type="button" id="selectProfilePhoto">
                                        <label class=" cursor-pointer transition-all px-3">
                                            <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                                alt="Edit Icon">
                                        </label>
                                    </button>

                                    <button type="submit" class="hidden transition-all">
                                        <p
                                            class="flex gap-1 items-center text-xs text-[#FAD1E8] bg-[#372E45] rounded px-3 py-1 cursor-pointer">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" style="fill: #FAD1E8;transform: ;msFilter:;">
                                                <path d="M11 15h2V9h3l-4-5-4 5h3z"></path>
                                                <path d="M20 18H4v-7H2v7c0 1.103.897 2 2 2h16c1.103 0 2-.897 2-2v-7h-2v7z">
                                                </path>
                                            </svg>

                                            <span>Save</span>
                                        </p>
                                    </button>
                                </div>

                            </div>


                            <input type="file" name="photo" id="profile_photo" accept="image/*" hidden>
                        </form>
                    </div>

                    {{-- update user --}}
                    <div class="block lg:mb-20 mb-10">
                        <form action="{{ route('user.profile.edit-validate') }}" class="gen-form">
                            @csrf

                            <div class="grid lg:grid-cols-2 grid-cols-1 gap-6">
                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">
                                        Name: {!! is_required('name') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center ">
                                        <input type="text" name="name" id="name"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="Enter Fullname" value="{{ old('name') ?? user()->name }}"
                                            {!! is_required('name', false) !!}>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">Date of Birth
                                        {!! is_required('dob') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center">
                                        <input type="date" name="dob" id="dob"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            value="{{ old('dob') ?? user()->dob }}" {!! is_required('dob', false) !!}>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">Username {!! is_required('username') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center">
                                        <input type="text" name="username" id="username"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="Username" value="{{ old('username') ?? user()->username }}"
                                            @if (user()->username) disabled @endif {!! is_required('username', false) !!}>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">Address {!! is_required('address') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center">
                                        <input type="text" name="address" id="address"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="City Address" value="{{ old('address') ?? user()->address }}"
                                            {!! is_required('address', false) !!}>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">
                                        Email {!! is_required('email') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center">
                                        <input type="email" name="email" id="email"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="user@user.com" value="{{ old('email') ?? user()->email }}"
                                            disabled {!! is_required('email', false) !!}>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">City {!! is_required('city') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center">
                                        <input type="text" name="city" id="city"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="City" value="{{ old('city') ?? user()->city }}"
                                            {!! is_required('city', false) !!}>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">Phone
                                        Number {!! is_required('phone') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center">
                                        <input type="number" name="phone" id="phone"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="4494895984" value="{{ old('phone') ?? user()->phone }}"
                                            {!! is_required('phone', false) !!}>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">State {!! is_required('state') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center">
                                        <input type="text" name="state" id="state"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="State" value="{{ old('state') ?? user()->state }}"
                                            {!! is_required('state', false) !!}>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">Gender {!! is_required('gender') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center">
                                        <select name="gender" id="gender"
                                            class="w-full p-2 bg-[#190735] text-white border-0 focus:outline-none flex-1"
                                            {!! is_required('gender', false) !!}>
                                            <option disabled @if (!old('gender') || !user()->gender) selected @endif>
                                                Select Gender
                                            </option>
                                            <option value="male" @if (old('gender') ?? user()->gender == 'male') selected @endif>
                                                Male
                                            </option>
                                            <option value="female" @if (old('gender') ?? user()->gender == 'female') selected @endif>
                                                Female
                                            </option>
                                            <option value="neutral" @if (old('gender') ?? user()->gender == 'neutral') selected @endif>
                                                Neutral
                                            </option>
                                        </select>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="col-span-1 block mb-6">
                                    <label class="text-white text-sm">Country {!! is_required('country') !!}</label>
                                    <div class="p-4 gradient-border mt-2 flex justify-between items-center">
                                        <select name="country" id="country"
                                            class="w-full p-2 bg-[#190735] text-white border-0 focus:outline-none flex-1"
                                            {!! is_required('country', false) !!}>
                                            <option disabled @if (!old('country') || !user()->country) selected @endif>
                                                Select Country</option>
                                            @foreach (countries() as $country)
                                                <option value="{{ $country->english_name }}"
                                                    @if (old('country') ?? user()->country == $country->english_name) selected @endif>
                                                    {{ $country->english_name }}</option>
                                            @endforeach
                                        </select>

                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                            alt="">
                                    </div>
                                </div>

                                <div class="lg:col-span-2 col-span-1  flex justify-end mb-6">
                                    <button type="submit" id="submitUpdateBtn"
                                        class="btn-gradient py-3 px-5 rounded-xl text-white">
                                        Save Changes</button>
                                </div>

                            </div>
                        </form>
                    </div>

                </div>

                {{-- update pass and status --}}
                <div class="block lg:w-1/3 w-full bg-[#0F0420] rounded-2xl mb-10 p-6 h-[50vh]">
                    <div class="w-full p-3 bg-[#372E45] rounded-xl mb-10">
                        <p class="block mb-4 text-lg font-thin">Referral Link</p>
                        <p class="block mb-4">
                            <span id="referral_link" class="text-sm cursor-pointer clipboard truncate"
                                data-copy="{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}">{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}</span>
                        </p>
                        <p class="flex justify-end mb-4 text-right">
                            <span class="clipboard cursor-pointer text-right"
                                data-copy="{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                    viewBox="0 0 20 21" fill="none">
                                    <path
                                        d="M7.5 13C7.5 10.643 7.5 9.4645 8.23223 8.73223C8.9645 8 10.143 8 12.5 8H13.3333C15.6903 8 16.8688 8 17.6011 8.73223C18.3333 9.4645 18.3333 10.643 18.3333 13V13.8333C18.3333 16.1903 18.3333 17.3688 17.6011 18.1011C16.8688 18.8333 15.6903 18.8333 13.3333 18.8333H12.5C10.143 18.8333 8.9645 18.8333 8.23223 18.1011C7.5 17.3688 7.5 16.1903 7.5 13.8333V13Z"
                                        stroke="url(#paint0_linear_348_2010)" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path
                                        d="M14.1669 7.99984C14.1649 5.5356 14.1277 4.25918 13.4103 3.3852C13.2718 3.21641 13.1171 3.06165 12.9483 2.92314C12.0263 2.1665 10.6566 2.1665 7.91699 2.1665C5.17743 2.1665 3.80764 2.1665 2.88568 2.92314C2.7169 3.06165 2.56214 3.21641 2.42363 3.3852C1.66699 4.30715 1.66699 5.67694 1.66699 8.4165C1.66699 11.1561 1.66699 12.5258 2.42363 13.4478C2.56213 13.6166 2.7169 13.7713 2.88568 13.9098C3.75967 14.6272 5.03608 14.6644 7.50033 14.6664"
                                        stroke="url(#paint1_linear_348_2010)" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <defs>
                                        <linearGradient id="paint0_linear_348_2010" x1="18.3333" y1="18.8333"
                                            x2="7.5" y2="8" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#E1D2F9"></stop>
                                            <stop offset="1" stop-color="#FAD1E8"></stop>
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_348_2010" x1="14.1669" y1="14.6664"
                                            x2="1.66699" y2="2.1665" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#E1D2F9"></stop>
                                            <stop offset="1" stop-color="#FAD1E8"></stop>
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </span>
                        </p>
                    </div>

                    <div class="w-full p-3 bg-[#190735] rounded-xl mb-10">
                        <p class="block mb-4 font-semibold">Additional Information</p>
                        <p class="block mb-4">
                        <ul>
                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_email_icon.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">Email</Span>
                                </p>
                                <p class="block">
                                    @if (user()->email_verified_at)
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>

                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_kyc_icon.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">KYC</Span>
                                </p>
                                <p class="block">
                                    @if (user()->kyc_verified_at)
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>

                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_1st_deposit.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">1st Deposit</Span>
                                </p>
                                <p class="block">
                                    @if (user()->deposits()->where('status', 'finished')->first())
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>

                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_1st_withdrawal.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">1st Withdrawal</Span>
                                </p>
                                <p class="block">
                                    @if (user()->withdrawals()->where('status', 'approved')->first())
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>

                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_1st_ai_bot.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">1st Ai Bot</Span>
                                </p>
                                <p class="block">
                                    @if (user()->botActivations()->first())
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>
                        </ul>
                        </p>
                    </div>

                    <div class="w-full p-3 bg-[#190735] rounded-xl mb-10">
                        <p class="block mb-4 font-semibold">Update Password</p>

                        <form action="{{ route('user.profile.password') }}" class="gen-form">
                            @csrf
                            <div class="block mb-4 py-4">
                                <div class="block rounded-xl p-0.5 bg-[linear-gradient(45deg,_#EA2A97,_#4B149E)] mb-6">
                                    <div class="flex gap-2 rounded-xl p-2 bg-[#190735]">
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_lock_icon.svg') }}"
                                            alt="">
                                        <input type="password" name="current_password" id="current_password"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="Current Password" required>
                                    </div>
                                </div>
                                <p class="text-sm text-[#EA0A0E]">
                                    @error('current_password')
                                        {{ $message }}
                                    @enderror
                                </p>

                                <div class="block rounded-xl p-0.5 bg-[linear-gradient(45deg,_#EA2A97,_#4B149E)] mb-6">
                                    <div class="flex gap-2 rounded-xl p-2 bg-[#190735]">
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_lock_icon.svg') }}"
                                            alt="">
                                        <input type="password" name="password" id="password"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="New Password" required>
                                    </div>
                                </div>
                                <p class="text-sm text-[#EA0A0E]">
                                    @error('password')
                                        {{ $message }}
                                    @enderror
                                </p>

                                <div class="block rounded-xl p-0.5 bg-[linear-gradient(45deg,_#EA2A97,_#4B149E)] mb-6">
                                    <div class="flex gap-2 rounded-xl p-2 bg-[#190735]">
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_lock_icon.svg') }}"
                                            alt="">
                                        <input type="password" name="password_confirmation" id="password_confirmation"
                                            class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                            placeholder="Confirm Password">
                                    </div>
                                </div>
                                <p class="text-sm text-[#EA0A0E]">
                                    @error('password_confirmation')
                                        {{ $message }}
                                    @enderror
                                </p>

                                <div class="block">
                                    <button type="submit"
                                        class="h-12 mt-auto w-full p-2 rounded-xl text-lg text-[#250A4F] bg-[#FAD1E8] transition delay-100 duration-200 ease-in-out">
                                        Save Changes
                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>

                </div>
            </div>

            {{-- 2fa section --}}
            <div id="editProfileSecurity" class="block">

                <div class="block lg:mb-20 mb-10 bg-[#372E45] rounded-xl p-6">
                    @if (user()->g2fa == 0)
                        <div id="enable_2fa_update" class="block">
                            <form action="{{ route('user.profile.g2fa') }}" class=" h-full gen-form"
                                data-action="reload">
                                @csrf

                                <div class="lg:flex block gap-6">
                                    <div class="block rounded-lg">
                                        <div id="wallet_qrcode" class="clipboard" data-copy=""></div>
                                    </div>

                                    <div class="block w-full">
                                        <p class="text-white mb-3 text-lg">
                                            Scan the QRCode above or copy the 2FA Code below to set up your 2fa
                                        </p>

                                        <p class="text-center flex items-center gap-1 mb-4">
                                            <span id="2fa_code"
                                                class="lg:text-lg text-[#FF59CA]">{{ user()->g2fa_secret }}</span>

                                            <span class="clipboard cursor-pointer text-right"
                                                data-copy="{{ user()->g2fa_secret }}">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                                    viewBox="0 0 20 21" fill="none">
                                                    <path
                                                        d="M7.5 13C7.5 10.643 7.5 9.4645 8.23223 8.73223C8.9645 8 10.143 8 12.5 8H13.3333C15.6903 8 16.8688 8 17.6011 8.73223C18.3333 9.4645 18.3333 10.643 18.3333 13V13.8333C18.3333 16.1903 18.3333 17.3688 17.6011 18.1011C16.8688 18.8333 15.6903 18.8333 13.3333 18.8333H12.5C10.143 18.8333 8.9645 18.8333 8.23223 18.1011C7.5 17.3688 7.5 16.1903 7.5 13.8333V13Z"
                                                        stroke="url(#paint0_linear_348_2010)" stroke-width="1.5"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                    <path
                                                        d="M14.1669 7.99984C14.1649 5.5356 14.1277 4.25918 13.4103 3.3852C13.2718 3.21641 13.1171 3.06165 12.9483 2.92314C12.0263 2.1665 10.6566 2.1665 7.91699 2.1665C5.17743 2.1665 3.80764 2.1665 2.88568 2.92314C2.7169 3.06165 2.56214 3.21641 2.42363 3.3852C1.66699 4.30715 1.66699 5.67694 1.66699 8.4165C1.66699 11.1561 1.66699 12.5258 2.42363 13.4478C2.56213 13.6166 2.7169 13.7713 2.88568 13.9098C3.75967 14.6272 5.03608 14.6644 7.50033 14.6664"
                                                        stroke="url(#paint1_linear_348_2010)" stroke-width="1.5"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                    <defs>
                                                        <linearGradient id="paint0_linear_348_2010" x1="18.3333"
                                                            y1="18.8333" x2="7.5" y2="8"
                                                            gradientUnits="userSpaceOnUse">
                                                            <stop stop-color="#E1D2F9"></stop>
                                                            <stop offset="1" stop-color="#FAD1E8"></stop>
                                                        </linearGradient>
                                                        <linearGradient id="paint1_linear_348_2010" x1="14.1669"
                                                            y1="14.6664" x2="1.66699" y2="2.1665"
                                                            gradientUnits="userSpaceOnUse">
                                                            <stop stop-color="#E1D2F9"></stop>
                                                            <stop offset="1" stop-color="#FAD1E8"></stop>
                                                        </linearGradient>
                                                    </defs>
                                                </svg>
                                            </span>
                                        </p>

                                        <div class="grid lg:grid-cols-2 grid-cols-1">
                                            <div
                                                class="flex items-center gap-2 rounded-xl p-2 border border-[#FAD1E8] w-full">
                                                <span>
                                                    <svg width="24" height="26" viewBox="0 0 14 16"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <g id="elements">
                                                            <path id="Vector"
                                                                d="M1.84553 12.5632C1.99545 13.6767 2.91774 14.549 4.0401 14.6006C4.98451 14.644 5.94386 14.6667 7.00032 14.6667C8.05679 14.6667 9.01614 14.644 9.96055 14.6006C11.0829 14.549 12.0052 13.6767 12.1551 12.5632C12.253 11.8365 12.3337 11.0917 12.3337 10.3333C12.3337 9.57492 12.253 8.83021 12.1551 8.1035C12.0052 6.99001 11.0829 6.11766 9.96055 6.06606C9.01614 6.02265 8.05679 6 7.00033 6C5.94386 6 4.98451 6.02265 4.0401 6.06606C2.91774 6.11766 1.99545 6.99001 1.84553 8.1035C1.74769 8.83021 1.66699 9.57492 1.66699 10.3333C1.66699 11.0917 1.74769 11.8365 1.84553 12.5632Z"
                                                                stroke="#190735" stroke-width="1.5" />
                                                            <path id="Vector 6658"
                                                                d="M4 6.00016V4.3335C4 2.67664 5.34315 1.3335 7 1.3335C8.65685 1.3335 10 2.67664 10 4.3335V6.00016"
                                                                stroke="#190735" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                            <path id="Vector_2" d="M6.99805 10.3335H7.00403"
                                                                stroke="#190735" stroke-width="2" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                        </g>
                                                    </svg>
                                                </span>
                                                <input type="text" name="one_time_password" id="one_time_password"
                                                    class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                                    placeholder="2FA Code" required>
                                            </div>

                                            <div class="flex justify-end">
                                                <button type="submit" class="py-4 px-6 rounded-xl btn-gradient">
                                                    Enable 2FA
                                                </button>
                                            </div>
                                        </div>

                                        <p class="text-sm text-[#EA0A0E]">
                                            @error('one_time_password')
                                                {{ $message }}
                                            @enderror
                                        </p>

                                    </div>
                                </div>

                            </form>
                        </div>
                    @else
                        <div id="disable_2fa_update" class="block">
                            <form action="{{ route('user.profile.g2fa') }}" class=" h-full gen-form"
                                data-action="reload">
                                @csrf

                                <div class="lg:flex block gap-6">
                                    <div class="block w-full">
                                        <p class="text-white font-bold text-lg mb-3">Disable 2FA</p>

                                        <p class="text-white mb-3 text-lg">
                                            Enter the One time passcode from your google authenticator app
                                            to disable your g2fa
                                        </p>


                                        <div class="grid lg:grid-cols-2 grid-cols-1">
                                            <div
                                                class="flex items-center gap-2 rounded-xl p-2 border border-[#FAD1E8] w-full">
                                                <span>
                                                    <svg width="24" height="26" viewBox="0 0 14 16"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <g id="elements">
                                                            <path id="Vector"
                                                                d="M1.84553 12.5632C1.99545 13.6767 2.91774 14.549 4.0401 14.6006C4.98451 14.644 5.94386 14.6667 7.00032 14.6667C8.05679 14.6667 9.01614 14.644 9.96055 14.6006C11.0829 14.549 12.0052 13.6767 12.1551 12.5632C12.253 11.8365 12.3337 11.0917 12.3337 10.3333C12.3337 9.57492 12.253 8.83021 12.1551 8.1035C12.0052 6.99001 11.0829 6.11766 9.96055 6.06606C9.01614 6.02265 8.05679 6 7.00033 6C5.94386 6 4.98451 6.02265 4.0401 6.06606C2.91774 6.11766 1.99545 6.99001 1.84553 8.1035C1.74769 8.83021 1.66699 9.57492 1.66699 10.3333C1.66699 11.0917 1.74769 11.8365 1.84553 12.5632Z"
                                                                stroke="#190735" stroke-width="1.5" />
                                                            <path id="Vector 6658"
                                                                d="M4 6.00016V4.3335C4 2.67664 5.34315 1.3335 7 1.3335C8.65685 1.3335 10 2.67664 10 4.3335V6.00016"
                                                                stroke="#190735" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                            <path id="Vector_2" d="M6.99805 10.3335H7.00403"
                                                                stroke="#190735" stroke-width="2" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                        </g>
                                                    </svg>
                                                </span>
                                                <input type="text" name="one_time_password" id="one_time_password"
                                                    class="w-full p-2 bg-transparent text-white border-0 focus:outline-none flex-1"
                                                    placeholder="2FA Code" required>
                                            </div>

                                            <div class="flex justify-end">
                                                <button type="submit" class="py-4 px-6 rounded-xl btn-gradient">
                                                    Disable 2FA
                                                </button>
                                            </div>
                                        </div>

                                        <p class="text-sm text-[#EA0A0E]">
                                            @error('one_time_password')
                                                {{ $message }}
                                            @enderror
                                        </p>

                                    </div>
                                </div>

                            </form>
                        </div>
                    @endif
                </div>
            </div>


        </div>
    </section>
@endsection

@section('scripts')
    @if (user()->g2fa == 0)
        <script>
            $(document).ready(function() {
                // create qrcode
                var qrCodeElement = document.getElementById('wallet_qrcode');
                var text = "{{ $qr_code_url }}";
                var qrCode = new QRCode(qrCodeElement, {
                    text: text,
                    width: 200,
                    height: 200
                });

                var walletQrCodeDiv = document.getElementById('wallet_qrcode');
                walletQrCodeDiv.classList.add('disabled');
                var imageElement = walletQrCodeDiv.querySelector('img');
                imageElement.classList.add('rounded-lg', 'border', 'border-slate-800',
                    'hover:border-slate-600', 'cursor-pointer');
            });
        </script>
    @endif

    <script>
        function initializeProfileTabs() {
            //console.log("Profile Tabs Initialized");

            // Handle Profile Tab Click
            $(document).off("click", "#editProfileBtn").on("click", "#editProfileBtn", function() {
                $("#editProfile").slideDown().removeClass("hidden");
                $("#editProfileSecurity").slideUp().addClass("hidden");
                $("#saveChangesBtn").slideDown().removeClass("hidden");

                $("#securityBtn").removeClass("border-l-4");
                $("#editProfileBtn").addClass("border-l-4");
            });

            // Handle Security Tab Click
            $(document).off("click", "#securityBtn").on("click", "#securityBtn", function() {
                $("#editProfileSecurity").slideDown().removeClass("hidden");
                $("#editProfile").slideUp().addClass("hidden");
                $("#saveChangesBtn").slideUp().addClass("hidden");

                $("#editProfileBtn").removeClass("border-l-4");
                $("#securityBtn").addClass("border-l-4");
            });
        }

        // Run profile tab initialization on page load
        $(document).ready(function() {
            initializeProfileTabs();
        });

        //////////// submit update
        $(document).on("click", "#saveChangesBtn", function() {
            $("#submitUpdateBtn").trigger("click"); // Triggers the submit button programmatically
        });
    </script>

    <script>
        $(document).ready(function() {
            // Open file input when clicking on the "Edit" button
            $("#selectProfilePhoto").on("click", function() {
                $("#profile_photo").trigger("click");
            });

            // When a new file is selected, update the profile image preview
            $("#profile_photo").on("change", function(event) {
                var input = event.target;

                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $("#profileImage").attr("src", e.target.result); // Update image preview
                        $("button[type='submit']").removeClass("hidden").fadeIn(); // Show Save button
                    };

                    reader.readAsDataURL(input.files[0]); // Read the selected image
                }
            });
        });
    </script>
@endsection
