@extends('templates.' . site('template') . '.layouts.user')

@section('contents')
    <section class="px-6 md:mt-28 w-full mx-auto lg:relative" id="pageContent">

        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[50rem] h-[50rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-10 top-10 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute -left-10 top-1/2 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}


        {{-- main content --}}
        <div class="w-full mx-auto lg:p-4 mb-3 text-white">



            <div class="block mb-3">
                <h1 class="text-xl lg:text-3xl font-bold">My Profile</h1>
            </div>


            <!-- Tab section -->

            <div class="flex py-5 mb-10">

                <div class="flex items-center gap-4 font-thin bg-[#372E45] rounded-lg p-4 lg:text-lg text-xs w-fit">
                    <a href="{{ route('user.profile.index') }}" role="button"
                        class="text-center cursor-pointer hover:text-[#E1D2F9] text-[#E1D2F9] font-bold">
                        My Profile</a>

                    <a href="{{ route('user.profile.edit') }}" role="button"
                        class="text-center cursor-pointer hover:text-[#E1D2F9] ">
                        Edit Profile</a>

                    <a href="{{ route('user.kyc.index') }}" class="text-center cursor-pointer hover:text-[#E1D2F9]">
                        KYC</a>
                </div>
            </div>

            <!-- Profile Edit Section -->
            <div id="editProfile" class="lg:flex block gap-10 ">
                {{-- main edit profile --}}
                <div class="block lg:w-2/3 w-full bg-[#FFFFFF0D] rounded-2xl mb-10 p-6">
                    <div class="block mb-10">
                        <img src="{{ asset('storage/profile/' . user()->photo) }}"
                            alt="{{ user()->username ?? 'Profile Photo' }}" class="w-[150px] h-[150px] rounded-full mb-2">

                        <p>Date joined:
                            <span class="text-gray-100 lg:text-[#7B7979]">
                                {{ date('M d, Y', strtotime(user()->created_at)) }}
                            </span>
                        </p>
                    </div>


                    <div class="block bg-[#372E45] rounded-2xl p-6">
                        <div class="flex justify-between items-center mb-10">
                            <p class="text-lg font-semibold">Personal Information</p>
                            <a href="{{ route('user.profile.edit') }}"
                                class="flex gap-2 items-center text-end rounded-full bg-[#2D3544] hover:bg-[#353F54] transition-all py-2 px-4 text-sm">
                                <img src="{{ asset('/assets/templates/zyphor/images/profile_pencil_edit_icon.svg') }}"
                                    alt="icon">
                                <span class="text-white">Edit</span>
                            </a>
                        </div>


                        <div class="lg:flex gap-6">

                            <div class="grid lg:grid-cols-3 grid-cols-1 gap-4 w-full">
                                <div class="text-left">
                                    <p class="block text-[#7B7979] mb-3 p-0 leading-none">Name:</p>
                                    <p class="block mb-3 p-0">{{ user()->name ?? 'Not Set' }}</p>
                                </div>

                                <div class="text-left">
                                    <p class="block text-[#7B7979] mb-3 p-0 leading-none">Email:</p>
                                    <p class="block mb-3 p-0">{{ user()->email ?? 'Not Set' }}</p>
                                </div>

                                <div class="text-left">
                                    <p class="block text-[#7B7979] mb-3 p-0 leading-none">Username:</p>
                                    <p class="block mb-3 p-0">{{ user()->username ?? 'Not Set' }}</p>
                                </div>
                                <!-------->
                                <div class="text-left">
                                    <p class="block text-[#7B7979] mb-3 p-0 leading-none">Phone:</p>
                                    <p class="block mb-3 p-0">{{ user()->phone ?? 'Not Set' }}</p>
                                </div>

                                <div class="text-left">
                                    <p class="block text-[#7B7979] mb-3 p-0 leading-none">Date Of Birth:</p>
                                    <p class="block mb-3 p-0">{{ user()->dob ?? 'Not Set' }}</p>
                                </div>

                                <div class="text-left">
                                    <p class="block text-[#7B7979] mb-3 p-0 leading-none">Address:</p>
                                    <p class="block mb-3 p-0">{{ user()->address ?? 'Not Set' }}</p>
                                </div>

                                <div class="text-left">
                                    <p class="block text-[#7B7979] mb-3 p-0 leading-none">City:</p>
                                    <p class="block mb-3 p-0">{{ user()->city ?? 'Not Set' }} </p>
                                </div>

                                <div class="text-left">
                                    <p class="block text-[#7B7979] mb-3 p-0 leading-none">State:</p>
                                    <p class="block mb-3 p-0">{{ user()->state ?? 'Not Set' }}</p>
                                </div>

                                <div class="text-left">
                                    <p class="block text-[#7B7979] mb-3 p-0 leading-none">Country:</p>
                                    <p class="block mb-3 p-0">{{ user()->country ?? 'Not Set' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>

                {{-- referal and status --}}
                <div class="block lg:w-1/3 w-full bg-[#0F0420] rounded-2xl mb-10 p-6 h-[50vh]">
                    <div class="w-full p-3 bg-[#372E45] rounded-xl mb-10">
                        <p class="block mb-4 text-lg font-thin">Referral Link</p>
                        <p class="block mb-4">
                            <span id="referral_link" class="text-sm cursor-pointer clipboard truncate"
                                data-copy="{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}">{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}</span>
                        </p>
                        <p class="flex justify-end mb-4 text-right">
                            <span class="clipboard cursor-pointer text-right"
                                data-copy="{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21"
                                    fill="none">
                                    <path
                                        d="M7.5 13C7.5 10.643 7.5 9.4645 8.23223 8.73223C8.9645 8 10.143 8 12.5 8H13.3333C15.6903 8 16.8688 8 17.6011 8.73223C18.3333 9.4645 18.3333 10.643 18.3333 13V13.8333C18.3333 16.1903 18.3333 17.3688 17.6011 18.1011C16.8688 18.8333 15.6903 18.8333 13.3333 18.8333H12.5C10.143 18.8333 8.9645 18.8333 8.23223 18.1011C7.5 17.3688 7.5 16.1903 7.5 13.8333V13Z"
                                        stroke="url(#paint0_linear_348_2010)" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path
                                        d="M14.1669 7.99984C14.1649 5.5356 14.1277 4.25918 13.4103 3.3852C13.2718 3.21641 13.1171 3.06165 12.9483 2.92314C12.0263 2.1665 10.6566 2.1665 7.91699 2.1665C5.17743 2.1665 3.80764 2.1665 2.88568 2.92314C2.7169 3.06165 2.56214 3.21641 2.42363 3.3852C1.66699 4.30715 1.66699 5.67694 1.66699 8.4165C1.66699 11.1561 1.66699 12.5258 2.42363 13.4478C2.56213 13.6166 2.7169 13.7713 2.88568 13.9098C3.75967 14.6272 5.03608 14.6644 7.50033 14.6664"
                                        stroke="url(#paint1_linear_348_2010)" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <defs>
                                        <linearGradient id="paint0_linear_348_2010" x1="18.3333" y1="18.8333"
                                            x2="7.5" y2="8" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#E1D2F9"></stop>
                                            <stop offset="1" stop-color="#FAD1E8"></stop>
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_348_2010" x1="14.1669" y1="14.6664"
                                            x2="1.66699" y2="2.1665" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#E1D2F9"></stop>
                                            <stop offset="1" stop-color="#FAD1E8"></stop>
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </span>
                        </p>
                    </div>

                    <div class="w-full p-3 bg-[#190735] rounded-xl mb-10">
                        <p class="block mb-4 font-semibold">Additional Information</p>
                        <p class="block mb-4">
                        <ul>
                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_email_icon.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">Email</Span>
                                </p>
                                <p class="block">
                                    @if (user()->email_verified_at)
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>

                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_kyc_icon.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">KYC</Span>
                                </p>
                                <p class="block">
                                    @if (user()->kyc_verified_at)
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>

                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_1st_deposit.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">1st Deposit</Span>
                                </p>
                                <p class="block">
                                    @if (user()->deposits()->where('status', 'finished')->first())
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>

                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_1st_withdrawal.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">1st Withdrawal</Span>
                                </p>
                                <p class="block">
                                    @if (user()->withdrawals()->where('status', 'approved')->first())
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>

                            <li class="flex justify-between items-center mb-4">
                                <p class="flex gap-2">
                                    <img src="{{ asset('/assets/templates/zyphor/images/profile_1st_ai_bot.svg') }}"
                                        alt="">
                                    <Span class="text-white font-thin">1st Ai Bot</Span>
                                </p>
                                <p class="block">
                                    @if (user()->botActivations()->first())
                                        <img src="{{ asset('/assets/templates/zyphor/images/profile_checked_icon.svg') }}"
                                            alt="">

                                    @else<svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    @endif
                                </p>
                            </li>
                        </ul>
                        </p>
                    </div>


                </div>
            </div>




        </div>


    </section>
@endsection
