@extends('templates.' . site('template') . '.layouts.user')

@section('contents')
    <!--my referral-->
    <section class="px-6 md:mt-28 w-fullmx-auto lg:relative" id="pageContent">


        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[50rem] h-[50rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-10 top-10 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute -left-10 top-1/2 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}


        <div class="w-full mx-auto p-4 mb-3 text-white">

            <div class="block mb-3">
                <h1 class="text-xl lg:text-3xl font-bold">My Referrals</h1>
            </div>



            <div class="block w-full py-10 mb-10">
                <!-- Referral Link Card -->
                <div class="col-span-2">
                    <div class="block border-[#1A0F3A] bg-[rgba(255,255,255,0.05)] p-6 rounded-xl">
                        <div class="mb-4 space-y-3">
                            <p class="font-medium text-white">Direct Referrals</p>
                            <p class="font-medium text-white text-xl">{{ user()->referredUsers->count() }}</p>

                            <div class="flex gap-2">
                                <span class="clipboard cursor-pointer"
                                    data-copy="{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                        viewBox="0 0 20 21" fill="none">
                                        <path
                                            d="M7.5 13C7.5 10.643 7.5 9.4645 8.23223 8.73223C8.9645 8 10.143 8 12.5 8H13.3333C15.6903 8 16.8688 8 17.6011 8.73223C18.3333 9.4645 18.3333 10.643 18.3333 13V13.8333C18.3333 16.1903 18.3333 17.3688 17.6011 18.1011C16.8688 18.8333 15.6903 18.8333 13.3333 18.8333H12.5C10.143 18.8333 8.9645 18.8333 8.23223 18.1011C7.5 17.3688 7.5 16.1903 7.5 13.8333V13Z"
                                            stroke="url(#paint0_linear_348_2010)" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                        <path
                                            d="M14.1669 7.99984C14.1649 5.5356 14.1277 4.25918 13.4103 3.3852C13.2718 3.21641 13.1171 3.06165 12.9483 2.92314C12.0263 2.1665 10.6566 2.1665 7.91699 2.1665C5.17743 2.1665 3.80764 2.1665 2.88568 2.92314C2.7169 3.06165 2.56214 3.21641 2.42363 3.3852C1.66699 4.30715 1.66699 5.67694 1.66699 8.4165C1.66699 11.1561 1.66699 12.5258 2.42363 13.4478C2.56213 13.6166 2.7169 13.7713 2.88568 13.9098C3.75967 14.6272 5.03608 14.6644 7.50033 14.6664"
                                            stroke="url(#paint1_linear_348_2010)" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                        <defs>
                                            <linearGradient id="paint0_linear_348_2010" x1="18.3333" y1="18.8333"
                                                x2="7.5" y2="8" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#E1D2F9" />
                                                <stop offset="1" stop-color="#FAD1E8" />
                                            </linearGradient>
                                            <linearGradient id="paint1_linear_348_2010" x1="14.1669" y1="14.6664"
                                                x2="1.66699" y2="2.1665" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#E1D2F9" />
                                                <stop offset="1" stop-color="#FAD1E8" />
                                            </linearGradient>
                                        </defs>
                                    </svg>
                                </span>
                                <p class="text-[#FF59CA] text-sm truncate flex-grow">
                                    {{ route('user.register', ['ref' => user()->username ?? 'notset']) }}
                                </p>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="block w-full py-10">
                <div class="block bg-[#250A4F] px-6 py-5 rounded-t-2xl">
                    <span class="text-xl lg:text-3xl mr-10 mb-3">My Referral Tree</span>
                </div>
                <div class="block overflow-auto w-full max-h-[60vh] bg-[#190735] px-6 py-3 rounded-b-2xl">

                    @php
                        function displayReferralTree($user, $level = 0, $maxLevels = 10)
                        {
                            if ($level >= $maxLevels) {
                                return;
                            }

                            $referredUsers = $user->referredUsers;

                            if ($referredUsers->count() > 0) {
                                echo '';
                                foreach ($referredUsers as $referredUser) {
                                    echo '<p class="border-b border-[#f272d5]/25 flex justify-between py-5 px-6">';
                                    echo '<span class="block capitalize py-3 px-3" style="border-left:4px solid #f272d5; margin-left:' .
                                        40 * $level .
                                        'px"> ' .
                                        $referredUser->username .
                                        ' </span>';
                                    echo '<span class="block"> ' . $referredUser->created_at . ' </span>';
                                    echo '</p>';
                                    displayReferralTree($referredUser, $level + 1, $maxLevels);
                                }
                                echo ' ';
                            }
                        }
                    @endphp

                    <div class="block w-full">
                        @php
                            displayReferralTree(user());
                        @endphp
                    </div>

                </div>
            </div>


        </div>
    </section>
    <!--end my referral-->
@endsection
