@extends('templates.' . site('template') . '.layouts.user')

@section('contents')
    <!--my transaction-->
    <section class="px-6 md:mt-28 w-full mx-auto lg:relative" id="pageContent">


        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[50rem] h-[50rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-10 top-10 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute -left-10 top-1/2 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}


        <div class="w-full mx-auto p-4 mb-3 text-white">

            {{-- <div class="block mb-3">
                <h1 class="text-xl lg:text-3xl font-bold">Transactions</h1>
            </div> --}}

            <div class="lg:flex justify-between items-center mb-5 py-5">

                <div class="block mb-3">
                    <h1 class="text-xl lg:text-3xl font-bold">My Transactions</h1>
                </div>

            </div>


            <div class="block w-full mb-10">
                <!-- Referral Link Card -->
                <div class="col-span-2">
                    <div class="block border-[#1A0F3A] bg-[rgba(255,255,255,0.05)] p-6 rounded-xl">
                        <div class="mb-4 space-y-3">
                            <p class="font-medium text-white text-xl">Total Transactions</p>
                            <p class="font-medium text-white text-5xl"> {{ $transactions->total() }} </p>
                        </div>

                    </div>
                </div>
            </div>


            <div class="w-full mb-10 flex lg:flex-row flex-col justify-end gap-2">

                <div x-data="{ search: '' }"
                    class="flex items-center space-x-2 border border-[#ff8ac63e] text-white rounded-2xl py-1 px-2 text-sm lg:w-2/3">

                    <!-- Input Field -->
                    <input type="text" placeholder="Txn Ref" id="search-transaction-input"
                        class="bg-transparent focus:outline-none text-sm flex-grow placeholder-gray-500"
                        value="{{ request()->s }}" />

                    <!-- Search Button -->
                    <div class="simple-pagination" data-paginator="transactions">
                        <a href="" id="search-transaction-button" data-link="{{ route('user.transactions.index') }}"
                            class="paginator-link px-4 py-2 rounded-md text-sm bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] gap-2 flex items-center justify-center">
                            Search
                            <img src="{{ asset('/assets/templates/zyphor/images/search_icon.svg') }}" alt="">
                        </a>
                    </div>
                </div>
            </div>


            <div class="block w-full">

                <div class="lg:grid  gap-10" id="transactions">
                    <div class="col-span-3 mb-10" data-aos="zoom-in">
                        <div class="block bg-[#250A4F] px-6 py-5 rounded-t-2xl">
                            <span class="text-xl lg:text-3xl mr-10 mb-3">My Referral Tree</span>
                        </div>
                        <div class="block overflow-auto w-full max-h-[60vh] bg-[#190735] px-6 py-3 rounded-b-2xl">
                            <table class="w-full" id="transactionsTable">
                                <tbody>
                                    @forelse ($transactions as $transaction)
                                        <tr class="border-b border-[#f272d5]/25 ">
                                            <td class="py-6">
                                                <p class="mb-3">{{ formatAmount($transaction->amount) }}</p>
                                                <p>
                                                    Ref: <span class="clipboard cursor-pointer"
                                                        data-copy="{{ $transaction->ref }}"> {{ $transaction->ref }} </span>
                                                </p>
                                            </td>

                                            <td class="py-6">
                                                <p class="cursor-pointer text-center"
                                                    data-copy="{{ $transaction->description }}">
                                                    {{ $transaction->description }}</p>
                                            </td>

                                            <td class="py-6 px-4">
                                                <p class="text-right mb-3">
                                                    {{ date('d-m-y H:i:s', strtotime($transaction->created_at)) }}</p>
                                                <p class="text-right capitalize">
                                                    @if ($transaction->type == 'debit')
                                                        <span
                                                            class="text-sm text-[#EA0A0E]">{{ $transaction->type }}</span>
                                                    @else
                                                        <span
                                                            class="text-sm text-[#00aa39]">{{ $transaction->type }}</span>
                                                    @endif
                                                </p>
                                            </td>
                                        </tr>
                                    @empty
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="cursor-pointer simple-pagination" data-paginator="transactions">
                            {{ $transactions->links('templates.' . site('template') . '.paginations.simple') }}
                        </div>

                    </div>



                </div>

            </div>
    </section>
    <!--end my transaction-->
@endsection

@section('scripts')
    <script>
        // search transaction
        $(document).on('input keyup', '#search-transaction-input', function(e) {
            var ref = $(this).val();
            var base_link = $('#search-transaction-button').data('link');
            var encodedRef = encodeURIComponent(ref);

            // Append the query parameter to the URL
            var link = base_link + '?s=' + encodedRef;
            $('#search-transaction-button').attr('href', link);
        });
    </script>
@endsection
