@extends('templates.' . site('template') . '.layouts.user')

@section('css')
@endsection


@section('contents')


    {{-- withdrawal --}}
    <section class="px-6 md:mt-28 w-full mx-auto lg:relative" id="pageContent">



        {{-- big gradient --}}
        <div id="gradient">
            <div class="lg:absolute right-30 -top-28 w-[50rem] h-[50rem] rounded-full blur-3xl hidden lg:block -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)]"
                style="opacity: 0.3;">
            </div>

            {{-- small gradient --}}
            <div
                class="absolute right-10 top-10 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>

            <div
                class="absolute -left-10 top-1/2 -z-50 bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] w-[120px] h-[120px] rounded-full">
            </div>
        </div>
        {{-- end gradient --}}



        <div class="w-full mx-auto lg:p-4 mb-3 text-white" id="refresh">


            <div class="block mb-3">
                <h1 class="text-xl lg:text-3xl font-bold">Withdrawal</h1>
            </div>


            <div class="md:flex justify-between mb-5 py-5">

                <div class="w-full mb-3 flex lg:flex-row flex-col justify-between gap-2">
                    <button id="openWithdrawalModal"
                        class="rounded-2xl py-3 px-6 text-base  transition delay-100 duration-200 ease-in-out cursor-pointer bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)]">
                        <span
                            class="bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] bg-clip-text text-transparent font-medium">
                            New Withdrawal
                        </span>
                    </button>

                    <div x-data="{ search: '' }"
                        class="flex items-center space-x-2 border border-[#ff8ac63e] text-white rounded-2xl py-1 px-2 text-sm lg:w-2/3">

                        <!-- Input Field -->
                        <input type="text" placeholder="Txn Ref" id="search-withdrawal-input"
                            class="bg-transparent focus:outline-none text-sm flex-grow placeholder-gray-500"
                            value="{{ request()->s }}" />

                        <!-- Search Button -->
                        <div class="simple-pagination" data-paginator="withdrawals">
                            <a id="search-withdrawal-button" data-link="{{ route('user.withdrawals.index') }}"
                                href=""
                                class="paginator-link px-4 py-2 rounded-md text-sm bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] gap-2 flex items-center justify-center">
                                Search
                                <img src="{{ asset('/assets/templates/zyphor/images/search_icon.svg') }}" alt="">
                            </a>
                        </div>
                    </div>
                </div>


                <!-- new withdrawal Modal -->
                <div id="NewWithdrawalModal" class="fixed inset-0  flex  justify-end backdrop-blur-xs h-[100vh] hidden"
                    style="z-index: 50;">

                    <div
                        class="bg-[#0F0420] rounded-lg w-full lg:w-[35vw] lg:max-h-[100vh] max-h-[90vh]  lg:p-10 p-4 relative z-10  backdrop-blur-lg overflow-y-auto py-20">

                        <div class="h-full w-full flex items-center">
                            <div class="block w-full">
                                <div class="flex justify-between items-center lg:mb-16 mb-4 lg:px-10">
                                    <h2 class="text-xl font-semibold mb-4 text-white">New Withdrawal</h2>
                                    <button id="closeWithdrawalModal" class="text-gray-400 hover:text-gray-600">
                                        <img src="{{ asset('/assets/templates/zyphor/images/cancel-circle.svg') }}"
                                            alt="icon">
                                    </button>
                                </div>

                                <!-- Modal Content -->
                                <form action="{{ route('user.withdrawals.new') }}" method="post" id="withdrawalForm"
                                    {{-- class="gen-form"  --}} data-action="reload">
                                    @csrf


                                    <div class="w-full lg:mb-16 mb-4 lg:px-10 px-4">


                                        <div class="w-full px-6 py-4 bg-[#372E45] rounded-xl  text-sm">

                                            <div class="flex gap-2 mb-3">
                                                <img src="{{ asset('/assets/templates/zyphor/images/information-circle.svg') }}"
                                                    alt="icon">
                                                <p class="text-lg text-[#FF59CA]">Important Information</p>
                                            </div>

                                            <table class="mb-3 w-full">
                                                <tr>
                                                    <td>
                                                        <p
                                                            class="bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)] bg-clip-text text-transparent mb-2">
                                                            Minimum
                                                            Withdrawal: </p>
                                                    </td>
                                                    <td>
                                                        <p class="text-white mb-2 text-right">
                                                            {{ formatAmount(site('min_withdrawal')) }}</p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <p
                                                            class="bg-[linear-gradient(315deg,_#E1D2F9_0%,_#FAD1E8_100%)] bg-clip-text text-transparent mb-2">
                                                            Maximum
                                                            Withdrawal: </p>
                                                    </td>
                                                    <td>
                                                        <p class="text-white mb-2 text-right">
                                                            {{ formatAmount(site('max_withdrawal')) }}</p>
                                                    </td>
                                                </tr>
                                            </table>
                                            <p class="text-sm">
                                            <p class="text-white font-bold block mb-3">Warning: </p>
                                            <p class="text-[#D8D8D8] block leading-6">
                                                Ensure your wallet address is valid. Withdrawals to
                                                wrong or invalid wallet address are not reversible
                                            </p>
                                            </p>
                                        </div>
                                    </div>



                                    <div class="w-full lg:mb-16 mb-10 lg:px-10">
                                        <label for="amount" class="text-white text-sm">Amount
                                            ( in {{ site('currency') }})</label>
                                        <div
                                            class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                            <span class="font-thin text-2xl ">{{ site('currency_symbol') }}</span>
                                            <input type="number" step="any"
                                                placeholder="Amount ({{ site('currency') }})" id="amount" name="amount"
                                                class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                                value="0" required>
                                        </div>
                                    </div>


                                    <!--Coin for deposit Dropdown -->
                                    <div class="w-full lg:mb-16 mb-10 lg:px-10">
                                        @if (site('auto_withdraw') == 1)
                                            @if ($auto_wallets->count() > 0)
                                                <label for="" class="text-white text-sm">Coin</label>

                                                <div
                                                    class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">

                                                    <div class="relative w-full">
                                                        <button id="coinForDepositDropdownButton"
                                                            class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1 flex gap-2"
                                                            type="button">
                                                            <div class="flex items-center w-full">
                                                                <img src="" class=" rounded-full mr-2"
                                                                    id="selectedCoinImg" />
                                                                <span id="selectedCoinText">Select Coin</span>
                                                            </div>
                                                            <img src="{{ asset('/assets/templates/zyphor/images/arrow-down-round.svg') }}"
                                                                alt="icon">
                                                        </button>

                                                        <!-- Dropdown Menu -->
                                                        <ul id="coinForDepositDropdownMenu"
                                                            class="absolute z-10 hidden mt-1 max-h-60 w-full overflow-auto rounded-md bg-[#0f042094] backdrop-blur-sm shadow-lg right-0">
                                                            @foreach ($coins as $coin)
                                                                @if (array_key_exists($coin->code, $auto_wallets_array))
                                                                    <li class="flex items-center px-4 py-2 text-gray-900 cursor-pointer hover:bg-blue-600"
                                                                        data-target="{{ $coin->code }}"
                                                                        data-wallet="{{ $auto_wallets_array[$coin->code] }}"
                                                                        data-currency_code="{{ $coin->code }}"
                                                                        data-img="{{ 'https://nowpayments.io' . $coin->logo_url }}">
                                                                        <img src="{{ 'https://nowpayments.io' . $coin->logo_url }}"
                                                                            alt="coin"
                                                                            class="h-8 w-8 rounded-full mr-2" />
                                                                        <p class="" id="{{ $coin->code }}">
                                                                            <span class="text-white"
                                                                                style="text-transform: uppercase;">
                                                                                @if ($coin->network)
                                                                                    {{ $coin->network }}
                                                                                @endif
                                                                            </span>
                                                                            <span class="text-white">
                                                                                {{ $coin->name }}</span>
                                                                        </p>
                                                                    </li>
                                                                @endif
                                                            @endforeach

                                                        </ul>


                                                    </div>
                                                    <!-- Hidden Input for selected coin -->
                                                    <input type="hidden" value="" name="currency_code"
                                                        id="currency_code" />
                                                </div>
                                            @else
                                                <div
                                                    class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        class="w-5 h-5 text-orange-500" fill="currentColor"
                                                        class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                                        <path
                                                            d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                    </svg>
                                                    <span>You have not added any withdrawal wallet!</span>
                                                </div>
                                            @endif
                                        @else
                                            <label for="" class="text-white text-sm">Coin</label>

                                            <div
                                                class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                                <div class="relative w-full">
                                                    <button id="coinForDepositDropdownButton"
                                                        class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1 flex gap-2"
                                                        type="button">
                                                        <div class="flex items-center w-full">
                                                            <img src="" class=" rounded-full mr-2"
                                                                id="selectedCoinImg" />
                                                            <span id="selectedCoinText">Select Coin</span>
                                                        </div>
                                                        <img src="{{ asset('/assets/templates/zyphor/images/arrow-down-round.svg') }}"
                                                            alt="icon">
                                                    </button>

                                                    <!-- Dropdown Menu -->
                                                    <ul id="coinForDepositDropdownMenu"
                                                        class="absolute z-10 hidden mt-1 max-h-60 w-full overflow-auto rounded-md bg-[#0f042094] backdrop-blur-sm shadow-lg right-0">
                                                        @foreach ($coins as $coin)
                                                            <li class="flex items-center px-4 py-2 text-gray-900 cursor-pointer hover:bg-blue-600"
                                                                data-value="{{ $coin->code }}"
                                                                data-label="{{ $coin->name }}"
                                                                data-img="{{ 'https://nowpayments.io' . $coin->logo_url }}">
                                                                <img src="{{ 'https://nowpayments.io' . $coin->logo_url }}"
                                                                    alt="coin" class="h-8 w-8 rounded-full mr-2" />
                                                                <p class="">
                                                                    <span class="text-white"
                                                                        style="text-transform: uppercase;">
                                                                        @if ($coin->network)
                                                                            {{ $coin->network }}
                                                                        @endif
                                                                    </span>
                                                                    <span class="text-white"> {{ $coin->name }}</span>
                                                                </p>
                                                            </li>
                                                        @endforeach

                                                    </ul>


                                                </div>
                                                <!-- Hidden Input for selected coin -->
                                                <input type="hidden" value="" name="currency_code"
                                                    id="currency_code" />
                                            </div>
                                        @endif
                                    </div>

                                    <div class="w-full lg:mb-16 mb-10 lg:px-10">
                                        <label for="wallet_address" class="text-white text-sm">Wallet Address</label>
                                        <div
                                            class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                            <input type="text" id="wallet_address" name="wallet_address"
                                                value="" @if (site('auto_withdraw') == 1) readonly @endif
                                                class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                                placeholder="Wallet address" required>
                                        </div>
                                    </div>



                                    <div class="w-full lg:px-10">
                                        <button type="submit"
                                            class="rounded-2xl w-full lg:px-10 lg:py-4 py-2 px-6 text-base transition delay-100 duration-200 ease-in-out cursor-pointer btn-gradient flex items-center justify-center">
                                            <span class="px-2">Withdraw Now</span>
                                        </button>
                                    </div>

                                </form>
                            </div>
                        </div>

                    </div>
                </div>

                <!--new withdrawal modal-->

                {{-- add wallet modal  --}}
                <div id="NewAddWalletModal"
                    class="fixed inset-0 bg-opacity-50 flex items-center justify-end lg:px-6 px-2 backdrop-blur-xs hidden"
                    style="z-index: 50;">
                    <div
                        class="bg-[#0F0420] rounded-lg   w-full lg:w-[35vw]  lg:p-14 p-4 relative z-10  mx-auto backdrop-blur-lg max-h-[90vh] overflow-y-auto">

                        <div class="flex justify-between items-center lg:mb-10 mb-4">
                            <h2 class="text-xl font-semibold mb-4 text-white">Add Wallet Address</h2>

                            <button id="closeAddWalletModal" class="text-gray-400 hover:text-gray-600">
                                <img src="{{ asset('/assets/templates/zyphor/images/cancel-circle.svg') }}"
                                    alt="icon">
                            </button>
                        </div>

                        <!-- Modal Content -->
                        <div class="bg-[#372E45] rounded-2xl p-6">

                            <form action="{{ route('user.auto-wallets.new') }}" method="post" id="addWalletForm"
                                class="dgen-form" data-action="reload">
                                @csrf


                                <div class="w-full lg:mb-10 mb-4">
                                    <div class="flex gap-2 mb-3">
                                        <img src="{{ asset('/assets/templates/zyphor/images/information-circle.svg') }}"
                                            alt="icon">
                                        <p class="text-lg text-[#FF59CA]">Important Information</p>
                                    </div>

                                    <div class="w-full px-6 py-4 bg-[#0F0420] rounded-xl bg-opacity-20 text-sm">
                                        <p class="text-sm">
                                            <span class="text-white font-bold">Warning: </span>
                                            <span class="text-[#D8D8D8]">For security reasons, newly added wallet
                                                address will be on security lock until the address is whitelisted.
                                                During this period, you wouldn't be able to use them for
                                                withdrawal.</span>
                                        </p>
                                    </div>
                                </div>



                                <div class="w-full lg:mb-20 mb-10">
                                    <label for="wallet_address2" class="text-white text-sm">Coin</label>
                                    <div
                                        class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                        <div class="relative w-full">
                                            <button id="coinForDepositDropdownButton_2"
                                                class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1 flex gap-2"
                                                type="button">
                                                <div class="flex items-center w-full">
                                                    <img src="" class=" rounded-full mr-2"
                                                        id="selectedCoinImg_2" />
                                                    <span id="selectedCoinText_2">Select Coin</span>
                                                </div>
                                                <img src="{{ asset('/assets/templates/zyphor/images/arrow-down-round.svg') }}"
                                                    alt="icon">
                                            </button>

                                            <!-- Dropdown Menu -->
                                            <ul id="coinForDepositDropdownMenu_2"
                                                class="absolute z-10 hidden mt-1 max-h-60 w-full overflow-auto rounded-md bg-[#0f042094] backdrop-blur-sm shadow-lg right-0">
                                                @foreach ($coins as $coin)
                                                    @if (!array_key_exists($coin->code, $auto_wallets_array))
                                                        <li class="flex items-center px-4 py-2 text-gray-900 cursor-pointer hover:bg-blue-600"
                                                            data-value="{{ $coin->code }}"
                                                            data-label="{{ $coin->name }}"
                                                            data-target="{{ $coin->code . 2 }}"
                                                            data-currency_code="{{ $coin->code }}"
                                                            data-img="{{ 'https://nowpayments.io' . $coin->logo_url }}">
                                                            <img src="{{ 'https://nowpayments.io' . $coin->logo_url }}"
                                                                alt="coin" class="h-8 w-8 rounded-full mr-2" />
                                                            <p class="" id="{{ $coin->code . 2 }}">
                                                                <span class="text-white"
                                                                    style="text-transform: uppercase;">
                                                                    @if ($coin->network)
                                                                        {{ $coin->network }}
                                                                    @endif
                                                                </span>
                                                                <span class="text-white">
                                                                    {{ $coin->name }}</span>
                                                            </p>
                                                        </li>
                                                    @endif
                                                @endforeach
                                            </ul>
                                        </div>

                                        <!-- Hidden Input for selected coin -->
                                        <input type="hidden" value="" name="currency_code"
                                            id="currency_code_2" />
                                    </div>
                                </div>


                                <div class="w-full lg:mb-20 mb-10">
                                    <label for="wallet_address2" class="text-white text-sm">Wallet Address</label>
                                    <div
                                        class="w-full text-white flex gap-4 items-center border border-[#f18bd1] rounded-2xl px-4 py-2 mt-3">
                                        <input type="text" id="wallet_address2" name="wallet_address"
                                            class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                            placeholder="Wallet address" required>
                                    </div>
                                </div>


                                <div class="w-full">
                                    <button type="submit"
                                        class="rounded-2xl w-full lg:px-10 lg:py-4 py-2 px-6 text-base transition delay-100 duration-200 ease-in-out cursor-pointer btn-gradient flex items-center justify-center">
                                        <span class="px-2">Pay Now</span>
                                    </button>
                                </div>
                            </form>

                        </div>

                    </div>
                </div>
                {{--  --}}

            </div>

            <div class="lg:flex block gap-10 justify-between">
                <!--withdrawal history-->
                <div id="myWithdrawalHistory" class="block lg:w-2/3 w-full mb-10">

                    <div class="block bg-[#250A4F] px-6 py-5 rounded-t-2xl">
                        <span class="text-xl lg:text-3xl mr-10 mb-3">Withdrawal History</span>
                    </div>

                    <div id="withdrawals">
                        <div id="history"
                            class="block overflow-auto w-full max-h-[60vh] bg-[#190735] px-6 py-3 rounded-b-2xl">
                            <table class="w-full" id="withdrawalTable">

                                <tbody>

                                    @forelse ($withdrawals as $withdrawal)
                                        <tr class="border-b border-[#f272d5]/25">
                                            <td class="py-6 px-3 w-20">
                                                <div class="flex">
                                                    <img src="{{ asset('/assets/templates/zyphor/images/view_eye.svg') }}"
                                                        alt="" width="20px">
                                                </div>
                                            </td>
                                            <td class="py-6" data-withdrawal_tnx="{{ $withdrawal->ref }}">
                                                <div class="flex items-center gap-4 ">
                                                    <img src="{{ 'https://nowpayments.io' . $withdrawal->depositCoin->logo_url }}"
                                                        alt="coin" class="w-8 h-8">
                                                    <p class="text-base font-thin">{{ $withdrawal->depositCoin->name }}
                                                    </p>
                                                </div>
                                                <div class="block">
                                                    <p class="clipboard cursor-pointer text-gray-400 text-sm"
                                                        data-copy="{{ $withdrawal->wallet_address }}">
                                                        {{ $withdrawal->wallet_address }}</p>

                                                    <p class="clipboard cursor-pointer text-[#FF59CA] font-thin text-sm"
                                                        data-copy="{{ $withdrawal->ref }}">
                                                        Txn Ref: {{ $withdrawal->ref }}</p>
                                                </div>
                                            </td>
                                            <td class="text-right p-6">
                                                <p class="font-bold">
                                                    {{ formatAmount($withdrawal->amount - $withdrawal->fee) }}</p>
                                                <p class=" text-gray-400 text-sm">
                                                    <span>{{ $withdrawal->converted_amount . ' ' . $withdrawal->depositCoin->code }}</span>
                                                    <span class="text-xs text-[#EA0A0E]">
                                                        /{{ $withdrawal->depositCoin->network ?? $withdrawal->depositCoin->code }}</span>
                                                </p>
                                            </td>
                                            <td class="text-left p-6">
                                                <p class="flex justify-end items-center space-x-1 gap-4">

                                                    @if ($withdrawal->status == 'waiting')
                                                        <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                            alt="">
                                                        <span
                                                            class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                                    @elseif ($withdrawal->status == 'approved' || $withdrawal->status == 'finished')
                                                        <img src="{{ asset('/assets/templates/zyphor/images/green_status_icon.svg') }}"
                                                            alt="">
                                                        <span
                                                            class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                                    @elseif ($withdrawal->status == 'pending')
                                                        <img src="{{ asset('/assets/templates/zyphor/images/gray_status_icon.svg') }}"
                                                            alt="">
                                                        <span
                                                            class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                                    @elseif ($withdrawal->status == 'failed' || $withdrawal->status == 'refunded')
                                                        <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                            alt="">
                                                        <span
                                                            class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                                    @elseif ($withdrawal->status == 'rejected')
                                                        <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                            alt="">
                                                        <span
                                                            class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                                    @else
                                                        <img src="{{ asset('/assets/templates/zyphor/images/red_status_icon.svg') }}"
                                                            alt="">

                                                        <span
                                                            class="text-white capitalize text-sm">{{ $withdrawal->status }}</span>
                                                    @endif
                                                </p>

                                                <p class="text-sm text-gray-400 text-end">
                                                    {{ date('d-m-y H:i:s A', strtotime($withdrawal->created_at)) }}
                                                </p>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td
                                                class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                                    fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                </svg>
                                                <span>Empty Record. No withdrawal found!</span>
                                            </td>
                                        </tr>
                                    @endforelse

                                </tbody>
                            </table>
                        </div>

                        <div class="cursor-pointer simple-pagination" data-paginator="withdrawals">
                            {{ $withdrawals->links('templates.' . site('template') . '.paginations.simple') }}
                        </div>
                    </div>
                </div>

                {{-- wallets address --}}
                <div id="myWithdrawalWallets" class="block lg:w-1/3 w-full mb-10">
                    <div class="block px-6 py-5 bg-[#0F0420] rounded-2xl" id="withdrawal-wallets">
                        <div id="wallets" class="block w-full h-full overflow-y-auto">

                            <div class="flex justify-between items-center lg:mb-10 mb-4">
                                <h2 class="text-xl font-semibold mb-4 text-white">Wallets</h2>

                                <button id="openAddWalletModal" class="cursor-pointer">
                                    <div
                                        class="bg-gray-700 hover:bg-white h-8 w-8 rounded-full flex items-center justify-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" style="fill: #FF59CA;transform: ;msFilter:;">
                                            <path d="M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4z"></path>
                                            <path
                                                d="M12 2C6.486 2 2 6.486 2 12s4.486 10 10 10 10-4.486 10-10S17.514 2 12 2zm0 18c-4.411 0-8-3.589-8-8s3.589-8 8-8 8 3.589 8 8-3.589 8-8 8z">
                                            </path>
                                        </svg>
                                    </div>
                                </button>
                            </div>


                            <div
                                class="flex items-center space-x-2 border border-[#ff8ac63e] text-white rounded-2xl py-1 px-2 text-sm lg:mb-10 mb-4">

                                <!-- Input Field -->
                                <input type="text" placeholder="Search" id="search-wallets-input"
                                    class="bg-transparent focus:outline-none text-sm flex-grow placeholder-gray-500" />

                                <!-- Search Button -->
                                <a id="search-wallets" href=""
                                    class="paginator-link px-4 py-2 rounded-md text-sm bg-[linear-gradient(315deg,_#4B149E_0%,_#EA2A97_100%)] gap-2 flex items-center justify-center">
                                    Search
                                    <img src="{{ asset('/assets/templates/zyphor/images/search_icon.svg') }}"
                                        alt="">

                                </a>
                            </div>

                            <div class="block lg:mb-10 mb-4 bg-[#190735] rounded-2xl">
                                <p class="p-3">
                                    <span class="block font-bold text-[#FF59CA] mb-3">Warning: </span>
                                    <span class="block font-thin text-[#FBFBFB] text-sm">
                                        For security reasons, newly added wallet address will be on security lock until the
                                        address is whitelisted. During this period, you wouldn't be able to use them for
                                        withdrawal.
                                    </span>
                                </p>
                            </div>

                            <div id="wallet-list">
                                @forelse ($auto_wallets as $wallet)
                                    <div class="block lg:mb-10 mb-4 bg-[#372E45] rounded-2xl"
                                        data-wallet="{{ $wallet->wallet_address }}">
                                        <div class="p-3">
                                            <div class="flex justify-between items-center mb-4">
                                                <div class="flex items-center gap-2">
                                                    <img src="{{ 'https://nowpayments.io' . $wallet->depositCoin->logo_url }}"
                                                        class="w-8 h-8" alt="">
                                                    <span class="font-thin">{{ $wallet->depositCoin->name }}</span>
                                                </div>
                                                @if ($wallet->whitelisted == 1)
                                                    <p class="bg-[#190735] rounded-xl p-2 text-sm text-red-500">Locked</p>
                                                @else
                                                    <p class="bg-[#190735] rounded-xl p-2 text-sm">Not Locked</p>
                                                @endif
                                            </div>

                                            <p class="text-xs font-thin text-center mb-4 clipboard cursor-pointer truncate"
                                                data-copy="{{ $wallet->wallet_address }}">{{ $wallet->wallet_address }}
                                            </p>

                                            <div class="flex justify-end">
                                                <img src="{{ asset('/assets/templates/zyphor/images/copy-icon.svg') }}"
                                                    alt="" class="clipboard cursor-pointer"
                                                    data-copy="{{ $wallet->wallet_address }}">
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <div
                                        class="block
                                                lg:mb-10 mb-4 bg-[#372E45] rounded-2xl">
                                        <div class="p-3">
                                            <div class="flex justify-between items-center mb-4">
                                                <div class="flex gap-4">
                                                    <img src="" alt="">
                                                    <span class="font-thin">No Wallet</span>
                                                </div>

                                                <p class="bg-[#a00707] rounded-xl p-2 text-sm">Empty</p>
                                            </div>

                                            <p class="text-lg font-thin text-center mb-4">
                                                <span
                                                    class="bg-yellow-600 text-black rounded-full px-4 py-2 font-bold">!</span>
                                                <span>Empty Record!</span>
                                            </p>

                                        </div>
                                    </div>
                                @endforelse
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
@endsection

@section('scripts')
    {{-- search withdrawal list --}}
    <script>
        // search withdrawal
        $(document).on('input keyup', '#search-withdrawal-input', function(e) {
            var ref = $(this).val();
            var base_link = $('#search-withdrawal-button').data('link');
            var encodedRef = encodeURIComponent(ref);

            // Append the query parameter to the URL
            var link = base_link + '?s=' + encodedRef;
            $('#search-withdrawal-button').attr('href', link);
        });
    </script>

    {{-- search wallet list --}}
    <script>
        //search wallet list
        $(document).ready(function() {
            // When search button is clicked
            $("#search-wallets").on("click", function(e) {
                e.preventDefault(); // Prevent the default anchor behavior

                // Get the search input value and trim whitespace
                const searchTerm = $("#search-wallets-input").val().trim().toLowerCase();

                // If search is empty, show all wallets
                if (searchTerm === "") {
                    $("#wallet-list > div").show();
                    return;
                }

                // Hide all wallet items first
                $("#wallet-list > div").hide();

                // Show only wallets that match the search term in their address
                $("#wallet-list > div").each(function() {
                    const walletAddress = $(this).data("wallet") || "";

                    if (walletAddress.toLowerCase().includes(searchTerm)) {
                        $(this).show();
                    }
                });
            });
        });
    </script>

    {{-- withdrawal form --}}
    <script>
        let interval;

        // handle withdrawal form
        $(document).on('submit', '#withdrawalForm', function(e) {
            e.preventDefault();
            var amount = $('#amount').val() * 1;
            var currency_code = $('#currency_code').val();
            var min_withdrawal = "{{ site('min_withdrawal') }}" * 1;
            var max_withdrawal = "{{ site('max_withdrawal') }}" * 1;
            var currency = "{{ site('currency') }}";

            //check the currency code
            var error = null;
            if (!currency_code) {
                error = 'You have not selected a withdrawal method';
            }

            //check min and max withdrawal
            if (amount < min_withdrawal) {
                error = 'Minimum withdrawal amount is ' + currency + min_withdrawal;
            }

            if (amount > max_withdrawal) {
                error = 'Maximum withdrawal amount is ' + currency + max_withdrawal;
            }

            if (error === null) {
                var form = $(this);
                var formData = new FormData(this);

                var submitButton = $(this).find('button[type="submit"]');
                submitButton.addClass('relative disabled');
                submitButton.append('<span class="button-spinner"></span>');
                submitButton.prop('disabled', true);

                submitButton.removeClass('btn-gradient');
                submitButton.addClass('not-allowed-cursor');

                $.ajax({
                    url: form.attr('action'),
                    method: 'POST',
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    success: function(response) {


                        loadPage(window.location.href, submitButton, '#pageContent');

                        $('html, body').animate({
                            scrollTop: 0 + 100
                        }, 800);
                        toastNotify('success', 'withdrawal request initated successfully');

                        submitButton.addClass(
                            'btn-gradient');
                        submitButton.removeClass('not-allowed-cursor');




                    },
                    error: function(xhr, status, error) {

                        if (xhr.status == 422) {
                            var errors = xhr.responseJSON.errors;

                            if (errors) {
                                $.each(errors, function(field, messages) {
                                    var fieldErrors = '';
                                    $.each(messages, function(index, message) {
                                        fieldErrors += message + '<br>';
                                    });

                                    toastNotify('error', fieldErrors);
                                });
                            } else {
                                toastNotify('error', 'An Error occured, try again later');

                                submitButton.addClass(
                                    'btn-gradient');
                                submitButton.removeClass('not-allowed-cursor');
                            }
                        } else {
                            toastNotify('error', 'Server Error occured, try again later');

                            submitButton.addClass(
                                'btn-gradient');
                            submitButton.removeClass('not-allowed-cursor');
                        }



                    },
                    complete: function() {
                        submitButton.removeClass('disabled');
                        submitButton.find('.button-spinner').remove();
                        submitButton.prop('disabled', false);

                    }
                });
            } else {

                toastNotify('error', error);

            }

        });
    </script>


    {{-- add wallet --}}
    <script>
        /////////////////////--ADD WALLET ADDRESS--///////////////////////////////
        $(document).on('submit', '#addWalletForm', function(e) {
            e.preventDefault();

            var form = $(this);
            var successAction = form.data('action');
            var redirectUrl = form.data('url');
            var formData = new FormData(this);

            var submitButton = form.find('button[type="submit"]');
            submitButton.addClass('relative disabled').prop('disabled', true);
            submitButton.append('<span class="button-spinner"></span>');
            var passwordInputs = form.find('input[type="password"]');

            submitButton.removeClass('btn-gradient');
            submitButton.addClass('not-allowed-cursor');

            $.ajax({
                url: form.attr('action'),
                method: 'POST',
                data: formData,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function(response) {
                    var message = response.message;

                    // Clear password fields after success
                    if (successAction !== 'none' && passwordInputs.length > 0) {
                        passwordInputs.val('');
                    }

                    /////////////////// notification
                    toastNotify('success', message);

                    if (successAction === 'reload') {
                        $.ajax({
                            url: window.location.href,
                            method: 'GET',
                            success: function(response) {
                                $('#refresh').html($(response).find('#refresh').html());

                                // Reinitialize func after reload
                                initializeDropdown();
                                initializeTabsSlide();
                            },
                            error: function() {
                                //console.error('Error fetching new content');
                            }
                        });
                    } else if (successAction === 'redirect' && redirectUrl) {
                        window.location.href = redirectUrl;
                    } else if (successAction === 'reset') {
                        form.find('input[type!="hidden"]').val('');
                    }
                },
                error: function(xhr) {
                    var errors = xhr.responseJSON ? xhr.responseJSON.errors : null;
                    var errorMessage = 'An error occurred. Please try again later.';

                    if (errors) {
                        errorMessage = '';
                        $.each(errors, function(field, messages) {
                            $.each(messages, function(index, message) {
                                errorMessage += message + '<br>';
                            });
                        });
                    }

                    /////////////////// notification
                    toastNotify('error', errorMessage);
                },
                complete: function() {
                    submitButton.removeClass('disabled').prop('disabled', false);
                    submitButton.find('.button-spinner').remove();

                    submitButton.addClass('btn-gradient');
                    submitButton.removeClass('not-allowed-cursor');
                }
            });
        });

        function initializeDropdown() {

            // Toggle dropdown visibility
            $(document).off('click', '#coinForDepositDropdownButton_2').on('click', '#coinForDepositDropdownButton_2',
                function() {
                    const menu = $('#coinForDepositDropdownMenu_2');
                    if (menu.hasClass('hidden')) {
                        menu.removeClass('hidden').hide().slideDown(200);
                    } else {
                        menu.slideUp(200, function() {
                            $(this).addClass('hidden');
                        });
                    }
                });

            // Close dropdown when clicking outside
            $(document).off('click', 'body').on('click', 'body', function(e) {
                if (!$(e.target).closest('#coinForDepositDropdownButton_2, #coinForDepositDropdownMenu_2').length) {
                    $('#coinForDepositDropdownMenu_2').slideUp(200, function() {
                        $(this).addClass('hidden');
                    });
                }
            });

            // Handle dropdown item selection
            $(document).off('click', '#coinForDepositDropdownMenu_2 li').on('click', '#coinForDepositDropdownMenu_2 li',
                function() {
                    const label = $(this).data('label');
                    const imgSrc = $(this).data('img');
                    const value = $(this).data('value');

                    // Update the button with the selected coin
                    $('#selectedCoinText_2').text(label);
                    $('#selectedCoinImg_2').attr('src', imgSrc).addClass('w-8 h-8');

                    // Update the hidden input value
                    $('#currency_code_2').val(value);

                    // Hide the dropdown menu
                    $('#coinForDepositDropdownMenu_2').slideUp(200, function() {
                        $(this).addClass('hidden');
                    });
                });
        }

        // Run dropdown initialization on page load
        $(document).ready(function() {
            initializeDropdown();
        });

        // Run tab slide initialization on page load
        function initializeTabsSlide() {

            // Toggle modal
            $(document).off("click", "#myWithdrawalWalletsBtn").on("click", "#myWithdrawalWalletsBtn", function() {
                $("#myWithdrawalWallets").slideDown().removeClass('hidden');
                $("#myWithdrawalHistory").slideUp().addClass('hidden');

                $("#myWithdrawalHistoryBtn").removeClass('border-l-4');
                $("#myWithdrawalWalletsBtn").addClass('border-l-4');
            });

            // Swap between tabs
            $(document).off("click", "#myWithdrawalHistoryBtn").on("click", "#myWithdrawalHistoryBtn", function() {
                $("#myWithdrawalHistory").slideDown().removeClass('hidden');
                $("#myWithdrawalWallets").slideUp().addClass('hidden');

                $("#myWithdrawalWalletsBtn").removeClass('border-l-4');
                $("#myWithdrawalHistoryBtn").addClass('border-l-4');
            });
        }

        // Run tabs initialization on page load
        $(document).ready(function() {
            initializeTabsSlide();
        });
    </script>

    {{-- init modal --}}
    <script>
        function initializeWithdrawalModals() {
            // console.log("Modals Initialized");

            // withdrawal modal toggle
            $(document).off("click", "#openWithdrawalModal").on("click", "#openWithdrawalModal", function() {
                $('#NewWithdrawalModal').removeClass('hidden hide').addClass('show');
            });

            $(document).off("click", "#closeWithdrawalModal").on("click", "#closeWithdrawalModal", function() {
                $('#NewWithdrawalModal').removeClass('show').addClass('hide hidden');
                setTimeout(function() {
                    $('#NewWithdrawalModal').addClass('hidden');
                }, 300);
            });

            // add wallet modal toggle
            $(document).off("click", "#openAddWalletModal").on("click", "#openAddWalletModal", function() {
                $('#NewAddWalletModal').removeClass('hidden hide').addClass('show');

            });

            $(document).off("click", "#closeAddWalletModal").on("click", "#closeAddWalletModal", function() {
                $('#NewAddWalletModal').removeClass('show').addClass('hide hidden');
                setTimeout(function() {
                    $('#NewAddWalletModal').addClass('hidden');
                }, 300);
            });
        }

        // Run modal initialization on page load
        $(document).ready(function() {
            initializeWithdrawalModals();
        });


        //select coin for deposit
        function initializeDepositDropdown() {
            //console.log("Dropdown Initialized");

            // Toggle dropdown visibility with animation
            $(document).off("click", "#coinForDepositDropdownButton").on("click", "#coinForDepositDropdownButton",
                function() {
                    const coinForDepositDropdownMenu = $("#coinForDepositDropdownMenu");
                    if (coinForDepositDropdownMenu.hasClass("hidden")) {
                        coinForDepositDropdownMenu
                            .removeClass("hidden")
                            .addClass("scale-100 opacity-100")
                            .hide()
                            .slideDown(200);
                    } else {
                        coinForDepositDropdownMenu
                            .slideUp(200, function() {
                                $(this).addClass("hidden").removeClass("scale-100 opacity-100");
                            });
                    }
                });

            // Close dropdown when clicking outside
            $(document).off("click", "body").on("click", "body", function(e) {
                if (!$(e.target).closest("#coinForDepositDropdownButton, #coinForDepositDropdownMenu").length) {
                    $("#coinForDepositDropdownMenu")
                        .slideUp(200, function() {
                            $(this).addClass("hidden").removeClass("scale-100 opacity-100");
                        });
                }
            });

            // Handle selection
            $(document).off("click", "#coinForDepositDropdownMenu li").on("click", "#coinForDepositDropdownMenu li",
                function() {
                    const label = $(this).data("label");
                    const imgSrc = $(this).data("img");
                    const value = $(this).data("value");

                    // Update the button with the selected coin
                    $("#selectedCoinText").text(label);
                    $("#selectedCoinImg").attr("src", imgSrc).addClass("w-8 h-8");

                    // Update the hidden input value
                    $("#currency_code").val(value);

                    // Hide the dropdown menu
                    $("#coinForDepositDropdownMenu").slideUp(200, function() {
                        $(this).addClass("hidden").removeClass("scale-100 opacity-100");
                    });
                });
        }

        // Run dropdown initialization on page load
        $(document).ready(function() {
            initializeDepositDropdown();
        });
    </script>
@endsection
